/*****************************************************************************
 * Copyright (C) 2019 VLC authors and VideoLAN
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * ( at your option ) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston MA 02110-1301, USA.
 *****************************************************************************/

#ifndef MLPLAYLIST_HPP
#define MLPLAYLIST_HPP

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

// MediaLibrary includes
#include "mlqmltypes.hpp"

class VLCDuration;

class MLPlaylist : public MLItem
{
public:
    MLPlaylist(const vlc_ml_playlist_t * data);

public: // Interface
    QString getName() const;
    void setName(const QString & name);

    VLCDuration getDuration() const;

    unsigned int getCount() const;

private:
    QString m_name;

    int64_t m_duration;

    unsigned int m_count;
};

#endif
