// This file was generated by qtwaylandscanner
// source file is tablet-v2.xml

#include "qwayland-server-tablet-v2.h"

QT_BEGIN_NAMESPACE
QT_WARNING_PUSH
QT_WARNING_DISABLE_GCC("-Wmissing-field-initializers")

namespace QtWaylandServer {

    int zwp_tablet_manager_v2::deferred_destroy_global_func(void *data) {
        auto object = static_cast<zwp_tablet_manager_v2 *>(data);
        wl_global_destroy(object->m_global);
        object->m_global = nullptr;
        wl_event_source_remove(object->m_globalRemovedEvent);
        object->m_globalRemovedEvent = nullptr;
        wl_list_remove(&object->m_displayDestroyedListener.link);
        object->zwp_tablet_manager_v2_destroy_global();
        return 0;
    }

    zwp_tablet_manager_v2::zwp_tablet_manager_v2(struct ::wl_client *client, int id, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
        init(client, id, version);
    }

    zwp_tablet_manager_v2::zwp_tablet_manager_v2(struct ::wl_display *display, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
        init(display, version);
    }

    zwp_tablet_manager_v2::zwp_tablet_manager_v2(struct ::wl_resource *resource)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
        init(resource);
    }

    zwp_tablet_manager_v2::zwp_tablet_manager_v2()
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
    }

    zwp_tablet_manager_v2::~zwp_tablet_manager_v2()
    {
        for (auto resource : std::as_const(m_resource_map))
            resource->zwp_tablet_manager_v2_object = nullptr;

        if (m_resource)
            m_resource->zwp_tablet_manager_v2_object = nullptr;

        if (m_global) {
            if (m_globalRemovedEvent)
                wl_event_source_remove(m_globalRemovedEvent);
            wl_global_destroy(m_global);
            wl_list_remove(&m_displayDestroyedListener.link);
        }
    }

    void zwp_tablet_manager_v2::init(struct ::wl_client *client, int id, int version)
    {
        m_resource = bind(client, id, version);
    }

    void zwp_tablet_manager_v2::init(struct ::wl_resource *resource)
    {
        m_resource = bind(resource);
    }

    zwp_tablet_manager_v2::Resource *zwp_tablet_manager_v2::add(struct ::wl_client *client, int version)
    {
        Resource *resource = bind(client, 0, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    zwp_tablet_manager_v2::Resource *zwp_tablet_manager_v2::add(struct ::wl_client *client, int id, int version)
    {
        Resource *resource = bind(client, id, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    void zwp_tablet_manager_v2::init(struct ::wl_display *display, int version)
    {
        m_display = display;
        m_global = wl_global_create(display, &::zwp_tablet_manager_v2_interface, version, this, bind_func);
        m_displayDestroyedListener.notify = zwp_tablet_manager_v2::display_destroy_func;
        m_displayDestroyedListener.parent = this;
        wl_display_add_destroy_listener(display, &m_displayDestroyedListener);
    }

    const struct wl_interface *zwp_tablet_manager_v2::interface()
    {
        return &::zwp_tablet_manager_v2_interface;
    }

    zwp_tablet_manager_v2::Resource *zwp_tablet_manager_v2::zwp_tablet_manager_v2_allocate()
    {
        return new Resource;
    }

    void zwp_tablet_manager_v2::zwp_tablet_manager_v2_destroy_global()
    {
    }

    void zwp_tablet_manager_v2::zwp_tablet_manager_v2_bind_resource(Resource *)
    {
    }

    void zwp_tablet_manager_v2::zwp_tablet_manager_v2_destroy_resource(Resource *)
    {
    }

    void zwp_tablet_manager_v2::bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id)
    {
        zwp_tablet_manager_v2 *that = static_cast<zwp_tablet_manager_v2 *>(data);
        that->add(client, id, version);
    }

    void zwp_tablet_manager_v2::display_destroy_func(struct ::wl_listener *listener, void *data)
    {
        Q_UNUSED(data);
        zwp_tablet_manager_v2 *that = static_cast<zwp_tablet_manager_v2::DisplayDestroyedListener *>(listener)->parent;
        that->m_global = nullptr;
        that->m_globalRemovedEvent = nullptr;
    }

    void zwp_tablet_manager_v2::destroy_func(struct ::wl_resource *client_resource)
    {
        Resource *resource = Resource::fromResource(client_resource);
        Q_ASSERT(resource);
        zwp_tablet_manager_v2 *that = resource->zwp_tablet_manager_v2_object;
        if (Q_LIKELY(that)) {
            that->m_resource_map.remove(resource->client(), resource);
            that->zwp_tablet_manager_v2_destroy_resource(resource);

            that = resource->zwp_tablet_manager_v2_object;
            if (that && that->m_resource == resource)
                that->m_resource = nullptr;
        }
        delete resource;
    }


    void zwp_tablet_manager_v2::globalRemove()
    {
        if (!m_global || m_globalRemovedEvent)
            return;

        wl_global_remove(m_global);

        struct wl_event_loop *event_loop = wl_display_get_event_loop(m_display);
        m_globalRemovedEvent = wl_event_loop_add_timer(event_loop, deferred_destroy_global_func, this);
        wl_event_source_timer_update(m_globalRemovedEvent, 300000);
    }

    zwp_tablet_manager_v2::Resource *zwp_tablet_manager_v2::bind(struct ::wl_client *client, uint32_t id, int version)
    {
        Q_ASSERT_X(!wl_client_get_object(client, id), "QWaylandObject bind", QStringLiteral("binding to object %1 more than once").arg(id).toLocal8Bit().constData());
        struct ::wl_resource *handle = wl_resource_create(client, &::zwp_tablet_manager_v2_interface, version, id);
        return bind(handle);
    }

    zwp_tablet_manager_v2::Resource *zwp_tablet_manager_v2::bind(struct ::wl_resource *handle)
    {
        Resource *resource = zwp_tablet_manager_v2_allocate();
        resource->zwp_tablet_manager_v2_object = this;

        wl_resource_set_implementation(handle, &m_zwp_tablet_manager_v2_interface, resource, destroy_func);
        resource->handle = handle;
        zwp_tablet_manager_v2_bind_resource(resource);
        return resource;
    }
    zwp_tablet_manager_v2::Resource *zwp_tablet_manager_v2::Resource::fromResource(struct ::wl_resource *resource)
    {
        if (Q_UNLIKELY(!resource))
            return nullptr;
        if (wl_resource_instance_of(resource, &::zwp_tablet_manager_v2_interface, &m_zwp_tablet_manager_v2_interface))
            return static_cast<Resource *>(wl_resource_get_user_data(resource));
        return nullptr;
    }

    const struct ::zwp_tablet_manager_v2_interface zwp_tablet_manager_v2::m_zwp_tablet_manager_v2_interface = {
        zwp_tablet_manager_v2::handle_get_tablet_seat,
        zwp_tablet_manager_v2::handle_destroy
    };

    void zwp_tablet_manager_v2::zwp_tablet_manager_v2_get_tablet_seat(Resource *, uint32_t, struct ::wl_resource *)
    {
    }

    void zwp_tablet_manager_v2::zwp_tablet_manager_v2_destroy(Resource *)
    {
    }


    void zwp_tablet_manager_v2::handle_get_tablet_seat(
        ::wl_client *client,
        struct wl_resource *resource,
        uint32_t tablet_seat,
        struct ::wl_resource *seat)
    {
        Q_UNUSED(client);
        Resource *qtResource = Resource::fromResource(resource);
        if (Q_UNLIKELY(!qtResource->zwp_tablet_manager_v2_object)) {
            return;
        }
        static_cast<zwp_tablet_manager_v2 *>(qtResource->zwp_tablet_manager_v2_object)->zwp_tablet_manager_v2_get_tablet_seat(
            qtResource,
            tablet_seat,
            seat);
    }

    void zwp_tablet_manager_v2::handle_destroy(
        ::wl_client *client,
        struct wl_resource *resource)
    {
        Q_UNUSED(client);
        Resource *qtResource = Resource::fromResource(resource);
        if (Q_UNLIKELY(!qtResource->zwp_tablet_manager_v2_object)) {
            wl_resource_destroy(resource);
            return;
        }
        static_cast<zwp_tablet_manager_v2 *>(qtResource->zwp_tablet_manager_v2_object)->zwp_tablet_manager_v2_destroy(
            qtResource);
    }


    int zwp_tablet_seat_v2::deferred_destroy_global_func(void *data) {
        auto object = static_cast<zwp_tablet_seat_v2 *>(data);
        wl_global_destroy(object->m_global);
        object->m_global = nullptr;
        wl_event_source_remove(object->m_globalRemovedEvent);
        object->m_globalRemovedEvent = nullptr;
        wl_list_remove(&object->m_displayDestroyedListener.link);
        object->zwp_tablet_seat_v2_destroy_global();
        return 0;
    }

    zwp_tablet_seat_v2::zwp_tablet_seat_v2(struct ::wl_client *client, int id, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
        init(client, id, version);
    }

    zwp_tablet_seat_v2::zwp_tablet_seat_v2(struct ::wl_display *display, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
        init(display, version);
    }

    zwp_tablet_seat_v2::zwp_tablet_seat_v2(struct ::wl_resource *resource)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
        init(resource);
    }

    zwp_tablet_seat_v2::zwp_tablet_seat_v2()
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
    }

    zwp_tablet_seat_v2::~zwp_tablet_seat_v2()
    {
        for (auto resource : std::as_const(m_resource_map))
            resource->zwp_tablet_seat_v2_object = nullptr;

        if (m_resource)
            m_resource->zwp_tablet_seat_v2_object = nullptr;

        if (m_global) {
            if (m_globalRemovedEvent)
                wl_event_source_remove(m_globalRemovedEvent);
            wl_global_destroy(m_global);
            wl_list_remove(&m_displayDestroyedListener.link);
        }
    }

    void zwp_tablet_seat_v2::init(struct ::wl_client *client, int id, int version)
    {
        m_resource = bind(client, id, version);
    }

    void zwp_tablet_seat_v2::init(struct ::wl_resource *resource)
    {
        m_resource = bind(resource);
    }

    zwp_tablet_seat_v2::Resource *zwp_tablet_seat_v2::add(struct ::wl_client *client, int version)
    {
        Resource *resource = bind(client, 0, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    zwp_tablet_seat_v2::Resource *zwp_tablet_seat_v2::add(struct ::wl_client *client, int id, int version)
    {
        Resource *resource = bind(client, id, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    void zwp_tablet_seat_v2::init(struct ::wl_display *display, int version)
    {
        m_display = display;
        m_global = wl_global_create(display, &::zwp_tablet_seat_v2_interface, version, this, bind_func);
        m_displayDestroyedListener.notify = zwp_tablet_seat_v2::display_destroy_func;
        m_displayDestroyedListener.parent = this;
        wl_display_add_destroy_listener(display, &m_displayDestroyedListener);
    }

    const struct wl_interface *zwp_tablet_seat_v2::interface()
    {
        return &::zwp_tablet_seat_v2_interface;
    }

    zwp_tablet_seat_v2::Resource *zwp_tablet_seat_v2::zwp_tablet_seat_v2_allocate()
    {
        return new Resource;
    }

    void zwp_tablet_seat_v2::zwp_tablet_seat_v2_destroy_global()
    {
    }

    void zwp_tablet_seat_v2::zwp_tablet_seat_v2_bind_resource(Resource *)
    {
    }

    void zwp_tablet_seat_v2::zwp_tablet_seat_v2_destroy_resource(Resource *)
    {
    }

    void zwp_tablet_seat_v2::bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id)
    {
        zwp_tablet_seat_v2 *that = static_cast<zwp_tablet_seat_v2 *>(data);
        that->add(client, id, version);
    }

    void zwp_tablet_seat_v2::display_destroy_func(struct ::wl_listener *listener, void *data)
    {
        Q_UNUSED(data);
        zwp_tablet_seat_v2 *that = static_cast<zwp_tablet_seat_v2::DisplayDestroyedListener *>(listener)->parent;
        that->m_global = nullptr;
        that->m_globalRemovedEvent = nullptr;
    }

    void zwp_tablet_seat_v2::destroy_func(struct ::wl_resource *client_resource)
    {
        Resource *resource = Resource::fromResource(client_resource);
        Q_ASSERT(resource);
        zwp_tablet_seat_v2 *that = resource->zwp_tablet_seat_v2_object;
        if (Q_LIKELY(that)) {
            that->m_resource_map.remove(resource->client(), resource);
            that->zwp_tablet_seat_v2_destroy_resource(resource);

            that = resource->zwp_tablet_seat_v2_object;
            if (that && that->m_resource == resource)
                that->m_resource = nullptr;
        }
        delete resource;
    }


    void zwp_tablet_seat_v2::globalRemove()
    {
        if (!m_global || m_globalRemovedEvent)
            return;

        wl_global_remove(m_global);

        struct wl_event_loop *event_loop = wl_display_get_event_loop(m_display);
        m_globalRemovedEvent = wl_event_loop_add_timer(event_loop, deferred_destroy_global_func, this);
        wl_event_source_timer_update(m_globalRemovedEvent, 300000);
    }

    zwp_tablet_seat_v2::Resource *zwp_tablet_seat_v2::bind(struct ::wl_client *client, uint32_t id, int version)
    {
        Q_ASSERT_X(!wl_client_get_object(client, id), "QWaylandObject bind", QStringLiteral("binding to object %1 more than once").arg(id).toLocal8Bit().constData());
        struct ::wl_resource *handle = wl_resource_create(client, &::zwp_tablet_seat_v2_interface, version, id);
        return bind(handle);
    }

    zwp_tablet_seat_v2::Resource *zwp_tablet_seat_v2::bind(struct ::wl_resource *handle)
    {
        Resource *resource = zwp_tablet_seat_v2_allocate();
        resource->zwp_tablet_seat_v2_object = this;

        wl_resource_set_implementation(handle, &m_zwp_tablet_seat_v2_interface, resource, destroy_func);
        resource->handle = handle;
        zwp_tablet_seat_v2_bind_resource(resource);
        return resource;
    }
    zwp_tablet_seat_v2::Resource *zwp_tablet_seat_v2::Resource::fromResource(struct ::wl_resource *resource)
    {
        if (Q_UNLIKELY(!resource))
            return nullptr;
        if (wl_resource_instance_of(resource, &::zwp_tablet_seat_v2_interface, &m_zwp_tablet_seat_v2_interface))
            return static_cast<Resource *>(wl_resource_get_user_data(resource));
        return nullptr;
    }

    const struct ::zwp_tablet_seat_v2_interface zwp_tablet_seat_v2::m_zwp_tablet_seat_v2_interface = {
        zwp_tablet_seat_v2::handle_destroy
    };

    void zwp_tablet_seat_v2::zwp_tablet_seat_v2_destroy(Resource *)
    {
    }


    void zwp_tablet_seat_v2::handle_destroy(
        ::wl_client *client,
        struct wl_resource *resource)
    {
        Q_UNUSED(client);
        Resource *qtResource = Resource::fromResource(resource);
        if (Q_UNLIKELY(!qtResource->zwp_tablet_seat_v2_object)) {
            wl_resource_destroy(resource);
            return;
        }
        static_cast<zwp_tablet_seat_v2 *>(qtResource->zwp_tablet_seat_v2_object)->zwp_tablet_seat_v2_destroy(
            qtResource);
    }

    void zwp_tablet_seat_v2::send_tablet_added(struct ::wl_resource *id)
    {
        Q_ASSERT_X(m_resource, "zwp_tablet_seat_v2::tablet_added", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call zwp_tablet_seat_v2::tablet_added as it's not initialised");
            return;
        }
        send_tablet_added(
            m_resource->handle,
            id);
    }

    void zwp_tablet_seat_v2::send_tablet_added(struct ::wl_resource *resource, struct ::wl_resource *id)
    {
        zwp_tablet_seat_v2_send_tablet_added(
            resource,
            id);
    }


    void zwp_tablet_seat_v2::send_tool_added(struct ::wl_resource *id)
    {
        Q_ASSERT_X(m_resource, "zwp_tablet_seat_v2::tool_added", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call zwp_tablet_seat_v2::tool_added as it's not initialised");
            return;
        }
        send_tool_added(
            m_resource->handle,
            id);
    }

    void zwp_tablet_seat_v2::send_tool_added(struct ::wl_resource *resource, struct ::wl_resource *id)
    {
        zwp_tablet_seat_v2_send_tool_added(
            resource,
            id);
    }


    void zwp_tablet_seat_v2::send_pad_added(struct ::wl_resource *id)
    {
        Q_ASSERT_X(m_resource, "zwp_tablet_seat_v2::pad_added", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call zwp_tablet_seat_v2::pad_added as it's not initialised");
            return;
        }
        send_pad_added(
            m_resource->handle,
            id);
    }

    void zwp_tablet_seat_v2::send_pad_added(struct ::wl_resource *resource, struct ::wl_resource *id)
    {
        zwp_tablet_seat_v2_send_pad_added(
            resource,
            id);
    }



    int zwp_tablet_tool_v2::deferred_destroy_global_func(void *data) {
        auto object = static_cast<zwp_tablet_tool_v2 *>(data);
        wl_global_destroy(object->m_global);
        object->m_global = nullptr;
        wl_event_source_remove(object->m_globalRemovedEvent);
        object->m_globalRemovedEvent = nullptr;
        wl_list_remove(&object->m_displayDestroyedListener.link);
        object->zwp_tablet_tool_v2_destroy_global();
        return 0;
    }

    zwp_tablet_tool_v2::zwp_tablet_tool_v2(struct ::wl_client *client, int id, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
        init(client, id, version);
    }

    zwp_tablet_tool_v2::zwp_tablet_tool_v2(struct ::wl_display *display, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
        init(display, version);
    }

    zwp_tablet_tool_v2::zwp_tablet_tool_v2(struct ::wl_resource *resource)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
        init(resource);
    }

    zwp_tablet_tool_v2::zwp_tablet_tool_v2()
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
    }

    zwp_tablet_tool_v2::~zwp_tablet_tool_v2()
    {
        for (auto resource : std::as_const(m_resource_map))
            resource->zwp_tablet_tool_v2_object = nullptr;

        if (m_resource)
            m_resource->zwp_tablet_tool_v2_object = nullptr;

        if (m_global) {
            if (m_globalRemovedEvent)
                wl_event_source_remove(m_globalRemovedEvent);
            wl_global_destroy(m_global);
            wl_list_remove(&m_displayDestroyedListener.link);
        }
    }

    void zwp_tablet_tool_v2::init(struct ::wl_client *client, int id, int version)
    {
        m_resource = bind(client, id, version);
    }

    void zwp_tablet_tool_v2::init(struct ::wl_resource *resource)
    {
        m_resource = bind(resource);
    }

    zwp_tablet_tool_v2::Resource *zwp_tablet_tool_v2::add(struct ::wl_client *client, int version)
    {
        Resource *resource = bind(client, 0, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    zwp_tablet_tool_v2::Resource *zwp_tablet_tool_v2::add(struct ::wl_client *client, int id, int version)
    {
        Resource *resource = bind(client, id, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    void zwp_tablet_tool_v2::init(struct ::wl_display *display, int version)
    {
        m_display = display;
        m_global = wl_global_create(display, &::zwp_tablet_tool_v2_interface, version, this, bind_func);
        m_displayDestroyedListener.notify = zwp_tablet_tool_v2::display_destroy_func;
        m_displayDestroyedListener.parent = this;
        wl_display_add_destroy_listener(display, &m_displayDestroyedListener);
    }

    const struct wl_interface *zwp_tablet_tool_v2::interface()
    {
        return &::zwp_tablet_tool_v2_interface;
    }

    zwp_tablet_tool_v2::Resource *zwp_tablet_tool_v2::zwp_tablet_tool_v2_allocate()
    {
        return new Resource;
    }

    void zwp_tablet_tool_v2::zwp_tablet_tool_v2_destroy_global()
    {
    }

    void zwp_tablet_tool_v2::zwp_tablet_tool_v2_bind_resource(Resource *)
    {
    }

    void zwp_tablet_tool_v2::zwp_tablet_tool_v2_destroy_resource(Resource *)
    {
    }

    void zwp_tablet_tool_v2::bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id)
    {
        zwp_tablet_tool_v2 *that = static_cast<zwp_tablet_tool_v2 *>(data);
        that->add(client, id, version);
    }

    void zwp_tablet_tool_v2::display_destroy_func(struct ::wl_listener *listener, void *data)
    {
        Q_UNUSED(data);
        zwp_tablet_tool_v2 *that = static_cast<zwp_tablet_tool_v2::DisplayDestroyedListener *>(listener)->parent;
        that->m_global = nullptr;
        that->m_globalRemovedEvent = nullptr;
    }

    void zwp_tablet_tool_v2::destroy_func(struct ::wl_resource *client_resource)
    {
        Resource *resource = Resource::fromResource(client_resource);
        Q_ASSERT(resource);
        zwp_tablet_tool_v2 *that = resource->zwp_tablet_tool_v2_object;
        if (Q_LIKELY(that)) {
            that->m_resource_map.remove(resource->client(), resource);
            that->zwp_tablet_tool_v2_destroy_resource(resource);

            that = resource->zwp_tablet_tool_v2_object;
            if (that && that->m_resource == resource)
                that->m_resource = nullptr;
        }
        delete resource;
    }


    void zwp_tablet_tool_v2::globalRemove()
    {
        if (!m_global || m_globalRemovedEvent)
            return;

        wl_global_remove(m_global);

        struct wl_event_loop *event_loop = wl_display_get_event_loop(m_display);
        m_globalRemovedEvent = wl_event_loop_add_timer(event_loop, deferred_destroy_global_func, this);
        wl_event_source_timer_update(m_globalRemovedEvent, 300000);
    }

    zwp_tablet_tool_v2::Resource *zwp_tablet_tool_v2::bind(struct ::wl_client *client, uint32_t id, int version)
    {
        Q_ASSERT_X(!wl_client_get_object(client, id), "QWaylandObject bind", QStringLiteral("binding to object %1 more than once").arg(id).toLocal8Bit().constData());
        struct ::wl_resource *handle = wl_resource_create(client, &::zwp_tablet_tool_v2_interface, version, id);
        return bind(handle);
    }

    zwp_tablet_tool_v2::Resource *zwp_tablet_tool_v2::bind(struct ::wl_resource *handle)
    {
        Resource *resource = zwp_tablet_tool_v2_allocate();
        resource->zwp_tablet_tool_v2_object = this;

        wl_resource_set_implementation(handle, &m_zwp_tablet_tool_v2_interface, resource, destroy_func);
        resource->handle = handle;
        zwp_tablet_tool_v2_bind_resource(resource);
        return resource;
    }
    zwp_tablet_tool_v2::Resource *zwp_tablet_tool_v2::Resource::fromResource(struct ::wl_resource *resource)
    {
        if (Q_UNLIKELY(!resource))
            return nullptr;
        if (wl_resource_instance_of(resource, &::zwp_tablet_tool_v2_interface, &m_zwp_tablet_tool_v2_interface))
            return static_cast<Resource *>(wl_resource_get_user_data(resource));
        return nullptr;
    }

    const struct ::zwp_tablet_tool_v2_interface zwp_tablet_tool_v2::m_zwp_tablet_tool_v2_interface = {
        zwp_tablet_tool_v2::handle_set_cursor,
        zwp_tablet_tool_v2::handle_destroy
    };

    void zwp_tablet_tool_v2::zwp_tablet_tool_v2_set_cursor(Resource *, uint32_t , struct ::wl_resource *, int32_t , int32_t )
    {
    }

    void zwp_tablet_tool_v2::zwp_tablet_tool_v2_destroy(Resource *)
    {
    }


    void zwp_tablet_tool_v2::handle_set_cursor(
        ::wl_client *client,
        struct wl_resource *resource,
        uint32_t serial,
        struct ::wl_resource *surface,
        int32_t hotspot_x,
        int32_t hotspot_y)
    {
        Q_UNUSED(client);
        Resource *qtResource = Resource::fromResource(resource);
        if (Q_UNLIKELY(!qtResource->zwp_tablet_tool_v2_object)) {
            return;
        }
        static_cast<zwp_tablet_tool_v2 *>(qtResource->zwp_tablet_tool_v2_object)->zwp_tablet_tool_v2_set_cursor(
            qtResource,
            serial,
            surface,
            hotspot_x,
            hotspot_y);
    }

    void zwp_tablet_tool_v2::handle_destroy(
        ::wl_client *client,
        struct wl_resource *resource)
    {
        Q_UNUSED(client);
        Resource *qtResource = Resource::fromResource(resource);
        if (Q_UNLIKELY(!qtResource->zwp_tablet_tool_v2_object)) {
            wl_resource_destroy(resource);
            return;
        }
        static_cast<zwp_tablet_tool_v2 *>(qtResource->zwp_tablet_tool_v2_object)->zwp_tablet_tool_v2_destroy(
            qtResource);
    }

    void zwp_tablet_tool_v2::send_type(uint32_t tool_type)
    {
        Q_ASSERT_X(m_resource, "zwp_tablet_tool_v2::type", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call zwp_tablet_tool_v2::type as it's not initialised");
            return;
        }
        send_type(
            m_resource->handle,
            tool_type);
    }

    void zwp_tablet_tool_v2::send_type(struct ::wl_resource *resource, uint32_t tool_type)
    {
        zwp_tablet_tool_v2_send_type(
            resource,
            tool_type);
    }


    void zwp_tablet_tool_v2::send_hardware_serial(uint32_t hardware_serial_hi, uint32_t hardware_serial_lo)
    {
        Q_ASSERT_X(m_resource, "zwp_tablet_tool_v2::hardware_serial", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call zwp_tablet_tool_v2::hardware_serial as it's not initialised");
            return;
        }
        send_hardware_serial(
            m_resource->handle,
            hardware_serial_hi,
            hardware_serial_lo);
    }

    void zwp_tablet_tool_v2::send_hardware_serial(struct ::wl_resource *resource, uint32_t hardware_serial_hi, uint32_t hardware_serial_lo)
    {
        zwp_tablet_tool_v2_send_hardware_serial(
            resource,
            hardware_serial_hi,
            hardware_serial_lo);
    }


    void zwp_tablet_tool_v2::send_hardware_id_wacom(uint32_t hardware_id_hi, uint32_t hardware_id_lo)
    {
        Q_ASSERT_X(m_resource, "zwp_tablet_tool_v2::hardware_id_wacom", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call zwp_tablet_tool_v2::hardware_id_wacom as it's not initialised");
            return;
        }
        send_hardware_id_wacom(
            m_resource->handle,
            hardware_id_hi,
            hardware_id_lo);
    }

    void zwp_tablet_tool_v2::send_hardware_id_wacom(struct ::wl_resource *resource, uint32_t hardware_id_hi, uint32_t hardware_id_lo)
    {
        zwp_tablet_tool_v2_send_hardware_id_wacom(
            resource,
            hardware_id_hi,
            hardware_id_lo);
    }


    void zwp_tablet_tool_v2::send_capability(uint32_t capability)
    {
        Q_ASSERT_X(m_resource, "zwp_tablet_tool_v2::capability", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call zwp_tablet_tool_v2::capability as it's not initialised");
            return;
        }
        send_capability(
            m_resource->handle,
            capability);
    }

    void zwp_tablet_tool_v2::send_capability(struct ::wl_resource *resource, uint32_t capability)
    {
        zwp_tablet_tool_v2_send_capability(
            resource,
            capability);
    }


    void zwp_tablet_tool_v2::send_done()
    {
        Q_ASSERT_X(m_resource, "zwp_tablet_tool_v2::done", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call zwp_tablet_tool_v2::done as it's not initialised");
            return;
        }
        send_done(
            m_resource->handle);
    }

    void zwp_tablet_tool_v2::send_done(struct ::wl_resource *resource)
    {
        zwp_tablet_tool_v2_send_done(
            resource);
    }


    void zwp_tablet_tool_v2::send_removed()
    {
        Q_ASSERT_X(m_resource, "zwp_tablet_tool_v2::removed", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call zwp_tablet_tool_v2::removed as it's not initialised");
            return;
        }
        send_removed(
            m_resource->handle);
    }

    void zwp_tablet_tool_v2::send_removed(struct ::wl_resource *resource)
    {
        zwp_tablet_tool_v2_send_removed(
            resource);
    }


    void zwp_tablet_tool_v2::send_proximity_in(uint32_t serial, struct ::wl_resource *tablet, struct ::wl_resource *surface)
    {
        Q_ASSERT_X(m_resource, "zwp_tablet_tool_v2::proximity_in", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call zwp_tablet_tool_v2::proximity_in as it's not initialised");
            return;
        }
        send_proximity_in(
            m_resource->handle,
            serial,
            tablet,
            surface);
    }

    void zwp_tablet_tool_v2::send_proximity_in(struct ::wl_resource *resource, uint32_t serial, struct ::wl_resource *tablet, struct ::wl_resource *surface)
    {
        zwp_tablet_tool_v2_send_proximity_in(
            resource,
            serial,
            tablet,
            surface);
    }


    void zwp_tablet_tool_v2::send_proximity_out()
    {
        Q_ASSERT_X(m_resource, "zwp_tablet_tool_v2::proximity_out", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call zwp_tablet_tool_v2::proximity_out as it's not initialised");
            return;
        }
        send_proximity_out(
            m_resource->handle);
    }

    void zwp_tablet_tool_v2::send_proximity_out(struct ::wl_resource *resource)
    {
        zwp_tablet_tool_v2_send_proximity_out(
            resource);
    }


    void zwp_tablet_tool_v2::send_down(uint32_t serial)
    {
        Q_ASSERT_X(m_resource, "zwp_tablet_tool_v2::down", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call zwp_tablet_tool_v2::down as it's not initialised");
            return;
        }
        send_down(
            m_resource->handle,
            serial);
    }

    void zwp_tablet_tool_v2::send_down(struct ::wl_resource *resource, uint32_t serial)
    {
        zwp_tablet_tool_v2_send_down(
            resource,
            serial);
    }


    void zwp_tablet_tool_v2::send_up()
    {
        Q_ASSERT_X(m_resource, "zwp_tablet_tool_v2::up", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call zwp_tablet_tool_v2::up as it's not initialised");
            return;
        }
        send_up(
            m_resource->handle);
    }

    void zwp_tablet_tool_v2::send_up(struct ::wl_resource *resource)
    {
        zwp_tablet_tool_v2_send_up(
            resource);
    }


    void zwp_tablet_tool_v2::send_motion(wl_fixed_t x, wl_fixed_t y)
    {
        Q_ASSERT_X(m_resource, "zwp_tablet_tool_v2::motion", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call zwp_tablet_tool_v2::motion as it's not initialised");
            return;
        }
        send_motion(
            m_resource->handle,
            x,
            y);
    }

    void zwp_tablet_tool_v2::send_motion(struct ::wl_resource *resource, wl_fixed_t x, wl_fixed_t y)
    {
        zwp_tablet_tool_v2_send_motion(
            resource,
            x,
            y);
    }


    void zwp_tablet_tool_v2::send_pressure(uint32_t pressure)
    {
        Q_ASSERT_X(m_resource, "zwp_tablet_tool_v2::pressure", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call zwp_tablet_tool_v2::pressure as it's not initialised");
            return;
        }
        send_pressure(
            m_resource->handle,
            pressure);
    }

    void zwp_tablet_tool_v2::send_pressure(struct ::wl_resource *resource, uint32_t pressure)
    {
        zwp_tablet_tool_v2_send_pressure(
            resource,
            pressure);
    }


    void zwp_tablet_tool_v2::send_distance(uint32_t distance)
    {
        Q_ASSERT_X(m_resource, "zwp_tablet_tool_v2::distance", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call zwp_tablet_tool_v2::distance as it's not initialised");
            return;
        }
        send_distance(
            m_resource->handle,
            distance);
    }

    void zwp_tablet_tool_v2::send_distance(struct ::wl_resource *resource, uint32_t distance)
    {
        zwp_tablet_tool_v2_send_distance(
            resource,
            distance);
    }


    void zwp_tablet_tool_v2::send_tilt(wl_fixed_t tilt_x, wl_fixed_t tilt_y)
    {
        Q_ASSERT_X(m_resource, "zwp_tablet_tool_v2::tilt", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call zwp_tablet_tool_v2::tilt as it's not initialised");
            return;
        }
        send_tilt(
            m_resource->handle,
            tilt_x,
            tilt_y);
    }

    void zwp_tablet_tool_v2::send_tilt(struct ::wl_resource *resource, wl_fixed_t tilt_x, wl_fixed_t tilt_y)
    {
        zwp_tablet_tool_v2_send_tilt(
            resource,
            tilt_x,
            tilt_y);
    }


    void zwp_tablet_tool_v2::send_rotation(wl_fixed_t degrees)
    {
        Q_ASSERT_X(m_resource, "zwp_tablet_tool_v2::rotation", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call zwp_tablet_tool_v2::rotation as it's not initialised");
            return;
        }
        send_rotation(
            m_resource->handle,
            degrees);
    }

    void zwp_tablet_tool_v2::send_rotation(struct ::wl_resource *resource, wl_fixed_t degrees)
    {
        zwp_tablet_tool_v2_send_rotation(
            resource,
            degrees);
    }


    void zwp_tablet_tool_v2::send_slider(int32_t position)
    {
        Q_ASSERT_X(m_resource, "zwp_tablet_tool_v2::slider", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call zwp_tablet_tool_v2::slider as it's not initialised");
            return;
        }
        send_slider(
            m_resource->handle,
            position);
    }

    void zwp_tablet_tool_v2::send_slider(struct ::wl_resource *resource, int32_t position)
    {
        zwp_tablet_tool_v2_send_slider(
            resource,
            position);
    }


    void zwp_tablet_tool_v2::send_wheel(wl_fixed_t degrees, int32_t clicks)
    {
        Q_ASSERT_X(m_resource, "zwp_tablet_tool_v2::wheel", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call zwp_tablet_tool_v2::wheel as it's not initialised");
            return;
        }
        send_wheel(
            m_resource->handle,
            degrees,
            clicks);
    }

    void zwp_tablet_tool_v2::send_wheel(struct ::wl_resource *resource, wl_fixed_t degrees, int32_t clicks)
    {
        zwp_tablet_tool_v2_send_wheel(
            resource,
            degrees,
            clicks);
    }


    void zwp_tablet_tool_v2::send_button(uint32_t serial, uint32_t button, uint32_t state)
    {
        Q_ASSERT_X(m_resource, "zwp_tablet_tool_v2::button", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call zwp_tablet_tool_v2::button as it's not initialised");
            return;
        }
        send_button(
            m_resource->handle,
            serial,
            button,
            state);
    }

    void zwp_tablet_tool_v2::send_button(struct ::wl_resource *resource, uint32_t serial, uint32_t button, uint32_t state)
    {
        zwp_tablet_tool_v2_send_button(
            resource,
            serial,
            button,
            state);
    }


    void zwp_tablet_tool_v2::send_frame(uint32_t time)
    {
        Q_ASSERT_X(m_resource, "zwp_tablet_tool_v2::frame", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call zwp_tablet_tool_v2::frame as it's not initialised");
            return;
        }
        send_frame(
            m_resource->handle,
            time);
    }

    void zwp_tablet_tool_v2::send_frame(struct ::wl_resource *resource, uint32_t time)
    {
        zwp_tablet_tool_v2_send_frame(
            resource,
            time);
    }



    int zwp_tablet_v2::deferred_destroy_global_func(void *data) {
        auto object = static_cast<zwp_tablet_v2 *>(data);
        wl_global_destroy(object->m_global);
        object->m_global = nullptr;
        wl_event_source_remove(object->m_globalRemovedEvent);
        object->m_globalRemovedEvent = nullptr;
        wl_list_remove(&object->m_displayDestroyedListener.link);
        object->zwp_tablet_v2_destroy_global();
        return 0;
    }

    zwp_tablet_v2::zwp_tablet_v2(struct ::wl_client *client, int id, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
        init(client, id, version);
    }

    zwp_tablet_v2::zwp_tablet_v2(struct ::wl_display *display, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
        init(display, version);
    }

    zwp_tablet_v2::zwp_tablet_v2(struct ::wl_resource *resource)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
        init(resource);
    }

    zwp_tablet_v2::zwp_tablet_v2()
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
    }

    zwp_tablet_v2::~zwp_tablet_v2()
    {
        for (auto resource : std::as_const(m_resource_map))
            resource->zwp_tablet_v2_object = nullptr;

        if (m_resource)
            m_resource->zwp_tablet_v2_object = nullptr;

        if (m_global) {
            if (m_globalRemovedEvent)
                wl_event_source_remove(m_globalRemovedEvent);
            wl_global_destroy(m_global);
            wl_list_remove(&m_displayDestroyedListener.link);
        }
    }

    void zwp_tablet_v2::init(struct ::wl_client *client, int id, int version)
    {
        m_resource = bind(client, id, version);
    }

    void zwp_tablet_v2::init(struct ::wl_resource *resource)
    {
        m_resource = bind(resource);
    }

    zwp_tablet_v2::Resource *zwp_tablet_v2::add(struct ::wl_client *client, int version)
    {
        Resource *resource = bind(client, 0, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    zwp_tablet_v2::Resource *zwp_tablet_v2::add(struct ::wl_client *client, int id, int version)
    {
        Resource *resource = bind(client, id, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    void zwp_tablet_v2::init(struct ::wl_display *display, int version)
    {
        m_display = display;
        m_global = wl_global_create(display, &::zwp_tablet_v2_interface, version, this, bind_func);
        m_displayDestroyedListener.notify = zwp_tablet_v2::display_destroy_func;
        m_displayDestroyedListener.parent = this;
        wl_display_add_destroy_listener(display, &m_displayDestroyedListener);
    }

    const struct wl_interface *zwp_tablet_v2::interface()
    {
        return &::zwp_tablet_v2_interface;
    }

    zwp_tablet_v2::Resource *zwp_tablet_v2::zwp_tablet_v2_allocate()
    {
        return new Resource;
    }

    void zwp_tablet_v2::zwp_tablet_v2_destroy_global()
    {
    }

    void zwp_tablet_v2::zwp_tablet_v2_bind_resource(Resource *)
    {
    }

    void zwp_tablet_v2::zwp_tablet_v2_destroy_resource(Resource *)
    {
    }

    void zwp_tablet_v2::bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id)
    {
        zwp_tablet_v2 *that = static_cast<zwp_tablet_v2 *>(data);
        that->add(client, id, version);
    }

    void zwp_tablet_v2::display_destroy_func(struct ::wl_listener *listener, void *data)
    {
        Q_UNUSED(data);
        zwp_tablet_v2 *that = static_cast<zwp_tablet_v2::DisplayDestroyedListener *>(listener)->parent;
        that->m_global = nullptr;
        that->m_globalRemovedEvent = nullptr;
    }

    void zwp_tablet_v2::destroy_func(struct ::wl_resource *client_resource)
    {
        Resource *resource = Resource::fromResource(client_resource);
        Q_ASSERT(resource);
        zwp_tablet_v2 *that = resource->zwp_tablet_v2_object;
        if (Q_LIKELY(that)) {
            that->m_resource_map.remove(resource->client(), resource);
            that->zwp_tablet_v2_destroy_resource(resource);

            that = resource->zwp_tablet_v2_object;
            if (that && that->m_resource == resource)
                that->m_resource = nullptr;
        }
        delete resource;
    }


    void zwp_tablet_v2::globalRemove()
    {
        if (!m_global || m_globalRemovedEvent)
            return;

        wl_global_remove(m_global);

        struct wl_event_loop *event_loop = wl_display_get_event_loop(m_display);
        m_globalRemovedEvent = wl_event_loop_add_timer(event_loop, deferred_destroy_global_func, this);
        wl_event_source_timer_update(m_globalRemovedEvent, 300000);
    }

    zwp_tablet_v2::Resource *zwp_tablet_v2::bind(struct ::wl_client *client, uint32_t id, int version)
    {
        Q_ASSERT_X(!wl_client_get_object(client, id), "QWaylandObject bind", QStringLiteral("binding to object %1 more than once").arg(id).toLocal8Bit().constData());
        struct ::wl_resource *handle = wl_resource_create(client, &::zwp_tablet_v2_interface, version, id);
        return bind(handle);
    }

    zwp_tablet_v2::Resource *zwp_tablet_v2::bind(struct ::wl_resource *handle)
    {
        Resource *resource = zwp_tablet_v2_allocate();
        resource->zwp_tablet_v2_object = this;

        wl_resource_set_implementation(handle, &m_zwp_tablet_v2_interface, resource, destroy_func);
        resource->handle = handle;
        zwp_tablet_v2_bind_resource(resource);
        return resource;
    }
    zwp_tablet_v2::Resource *zwp_tablet_v2::Resource::fromResource(struct ::wl_resource *resource)
    {
        if (Q_UNLIKELY(!resource))
            return nullptr;
        if (wl_resource_instance_of(resource, &::zwp_tablet_v2_interface, &m_zwp_tablet_v2_interface))
            return static_cast<Resource *>(wl_resource_get_user_data(resource));
        return nullptr;
    }

    const struct ::zwp_tablet_v2_interface zwp_tablet_v2::m_zwp_tablet_v2_interface = {
        zwp_tablet_v2::handle_destroy
    };

    void zwp_tablet_v2::zwp_tablet_v2_destroy(Resource *)
    {
    }


    void zwp_tablet_v2::handle_destroy(
        ::wl_client *client,
        struct wl_resource *resource)
    {
        Q_UNUSED(client);
        Resource *qtResource = Resource::fromResource(resource);
        if (Q_UNLIKELY(!qtResource->zwp_tablet_v2_object)) {
            wl_resource_destroy(resource);
            return;
        }
        static_cast<zwp_tablet_v2 *>(qtResource->zwp_tablet_v2_object)->zwp_tablet_v2_destroy(
            qtResource);
    }

    void zwp_tablet_v2::send_name(const QString &name)
    {
        Q_ASSERT_X(m_resource, "zwp_tablet_v2::name", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call zwp_tablet_v2::name as it's not initialised");
            return;
        }
        send_name(
            m_resource->handle,
            name);
    }

    void zwp_tablet_v2::send_name(struct ::wl_resource *resource, const QString &name)
    {
        zwp_tablet_v2_send_name(
            resource,
            name.toUtf8().constData());
    }


    void zwp_tablet_v2::send_id(uint32_t vid, uint32_t pid)
    {
        Q_ASSERT_X(m_resource, "zwp_tablet_v2::id", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call zwp_tablet_v2::id as it's not initialised");
            return;
        }
        send_id(
            m_resource->handle,
            vid,
            pid);
    }

    void zwp_tablet_v2::send_id(struct ::wl_resource *resource, uint32_t vid, uint32_t pid)
    {
        zwp_tablet_v2_send_id(
            resource,
            vid,
            pid);
    }


    void zwp_tablet_v2::send_path(const QString &path)
    {
        Q_ASSERT_X(m_resource, "zwp_tablet_v2::path", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call zwp_tablet_v2::path as it's not initialised");
            return;
        }
        send_path(
            m_resource->handle,
            path);
    }

    void zwp_tablet_v2::send_path(struct ::wl_resource *resource, const QString &path)
    {
        zwp_tablet_v2_send_path(
            resource,
            path.toUtf8().constData());
    }


    void zwp_tablet_v2::send_done()
    {
        Q_ASSERT_X(m_resource, "zwp_tablet_v2::done", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call zwp_tablet_v2::done as it's not initialised");
            return;
        }
        send_done(
            m_resource->handle);
    }

    void zwp_tablet_v2::send_done(struct ::wl_resource *resource)
    {
        zwp_tablet_v2_send_done(
            resource);
    }


    void zwp_tablet_v2::send_removed()
    {
        Q_ASSERT_X(m_resource, "zwp_tablet_v2::removed", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call zwp_tablet_v2::removed as it's not initialised");
            return;
        }
        send_removed(
            m_resource->handle);
    }

    void zwp_tablet_v2::send_removed(struct ::wl_resource *resource)
    {
        zwp_tablet_v2_send_removed(
            resource);
    }


    void zwp_tablet_v2::send_bustype(uint32_t bustype)
    {
        Q_ASSERT_X(m_resource, "zwp_tablet_v2::bustype", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call zwp_tablet_v2::bustype as it's not initialised");
            return;
        }
        send_bustype(
            m_resource->handle,
            bustype);
    }

    void zwp_tablet_v2::send_bustype(struct ::wl_resource *resource, uint32_t bustype)
    {
        zwp_tablet_v2_send_bustype(
            resource,
            bustype);
    }



    int zwp_tablet_pad_ring_v2::deferred_destroy_global_func(void *data) {
        auto object = static_cast<zwp_tablet_pad_ring_v2 *>(data);
        wl_global_destroy(object->m_global);
        object->m_global = nullptr;
        wl_event_source_remove(object->m_globalRemovedEvent);
        object->m_globalRemovedEvent = nullptr;
        wl_list_remove(&object->m_displayDestroyedListener.link);
        object->zwp_tablet_pad_ring_v2_destroy_global();
        return 0;
    }

    zwp_tablet_pad_ring_v2::zwp_tablet_pad_ring_v2(struct ::wl_client *client, int id, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
        init(client, id, version);
    }

    zwp_tablet_pad_ring_v2::zwp_tablet_pad_ring_v2(struct ::wl_display *display, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
        init(display, version);
    }

    zwp_tablet_pad_ring_v2::zwp_tablet_pad_ring_v2(struct ::wl_resource *resource)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
        init(resource);
    }

    zwp_tablet_pad_ring_v2::zwp_tablet_pad_ring_v2()
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
    }

    zwp_tablet_pad_ring_v2::~zwp_tablet_pad_ring_v2()
    {
        for (auto resource : std::as_const(m_resource_map))
            resource->zwp_tablet_pad_ring_v2_object = nullptr;

        if (m_resource)
            m_resource->zwp_tablet_pad_ring_v2_object = nullptr;

        if (m_global) {
            if (m_globalRemovedEvent)
                wl_event_source_remove(m_globalRemovedEvent);
            wl_global_destroy(m_global);
            wl_list_remove(&m_displayDestroyedListener.link);
        }
    }

    void zwp_tablet_pad_ring_v2::init(struct ::wl_client *client, int id, int version)
    {
        m_resource = bind(client, id, version);
    }

    void zwp_tablet_pad_ring_v2::init(struct ::wl_resource *resource)
    {
        m_resource = bind(resource);
    }

    zwp_tablet_pad_ring_v2::Resource *zwp_tablet_pad_ring_v2::add(struct ::wl_client *client, int version)
    {
        Resource *resource = bind(client, 0, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    zwp_tablet_pad_ring_v2::Resource *zwp_tablet_pad_ring_v2::add(struct ::wl_client *client, int id, int version)
    {
        Resource *resource = bind(client, id, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    void zwp_tablet_pad_ring_v2::init(struct ::wl_display *display, int version)
    {
        m_display = display;
        m_global = wl_global_create(display, &::zwp_tablet_pad_ring_v2_interface, version, this, bind_func);
        m_displayDestroyedListener.notify = zwp_tablet_pad_ring_v2::display_destroy_func;
        m_displayDestroyedListener.parent = this;
        wl_display_add_destroy_listener(display, &m_displayDestroyedListener);
    }

    const struct wl_interface *zwp_tablet_pad_ring_v2::interface()
    {
        return &::zwp_tablet_pad_ring_v2_interface;
    }

    zwp_tablet_pad_ring_v2::Resource *zwp_tablet_pad_ring_v2::zwp_tablet_pad_ring_v2_allocate()
    {
        return new Resource;
    }

    void zwp_tablet_pad_ring_v2::zwp_tablet_pad_ring_v2_destroy_global()
    {
    }

    void zwp_tablet_pad_ring_v2::zwp_tablet_pad_ring_v2_bind_resource(Resource *)
    {
    }

    void zwp_tablet_pad_ring_v2::zwp_tablet_pad_ring_v2_destroy_resource(Resource *)
    {
    }

    void zwp_tablet_pad_ring_v2::bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id)
    {
        zwp_tablet_pad_ring_v2 *that = static_cast<zwp_tablet_pad_ring_v2 *>(data);
        that->add(client, id, version);
    }

    void zwp_tablet_pad_ring_v2::display_destroy_func(struct ::wl_listener *listener, void *data)
    {
        Q_UNUSED(data);
        zwp_tablet_pad_ring_v2 *that = static_cast<zwp_tablet_pad_ring_v2::DisplayDestroyedListener *>(listener)->parent;
        that->m_global = nullptr;
        that->m_globalRemovedEvent = nullptr;
    }

    void zwp_tablet_pad_ring_v2::destroy_func(struct ::wl_resource *client_resource)
    {
        Resource *resource = Resource::fromResource(client_resource);
        Q_ASSERT(resource);
        zwp_tablet_pad_ring_v2 *that = resource->zwp_tablet_pad_ring_v2_object;
        if (Q_LIKELY(that)) {
            that->m_resource_map.remove(resource->client(), resource);
            that->zwp_tablet_pad_ring_v2_destroy_resource(resource);

            that = resource->zwp_tablet_pad_ring_v2_object;
            if (that && that->m_resource == resource)
                that->m_resource = nullptr;
        }
        delete resource;
    }


    void zwp_tablet_pad_ring_v2::globalRemove()
    {
        if (!m_global || m_globalRemovedEvent)
            return;

        wl_global_remove(m_global);

        struct wl_event_loop *event_loop = wl_display_get_event_loop(m_display);
        m_globalRemovedEvent = wl_event_loop_add_timer(event_loop, deferred_destroy_global_func, this);
        wl_event_source_timer_update(m_globalRemovedEvent, 300000);
    }

    zwp_tablet_pad_ring_v2::Resource *zwp_tablet_pad_ring_v2::bind(struct ::wl_client *client, uint32_t id, int version)
    {
        Q_ASSERT_X(!wl_client_get_object(client, id), "QWaylandObject bind", QStringLiteral("binding to object %1 more than once").arg(id).toLocal8Bit().constData());
        struct ::wl_resource *handle = wl_resource_create(client, &::zwp_tablet_pad_ring_v2_interface, version, id);
        return bind(handle);
    }

    zwp_tablet_pad_ring_v2::Resource *zwp_tablet_pad_ring_v2::bind(struct ::wl_resource *handle)
    {
        Resource *resource = zwp_tablet_pad_ring_v2_allocate();
        resource->zwp_tablet_pad_ring_v2_object = this;

        wl_resource_set_implementation(handle, &m_zwp_tablet_pad_ring_v2_interface, resource, destroy_func);
        resource->handle = handle;
        zwp_tablet_pad_ring_v2_bind_resource(resource);
        return resource;
    }
    zwp_tablet_pad_ring_v2::Resource *zwp_tablet_pad_ring_v2::Resource::fromResource(struct ::wl_resource *resource)
    {
        if (Q_UNLIKELY(!resource))
            return nullptr;
        if (wl_resource_instance_of(resource, &::zwp_tablet_pad_ring_v2_interface, &m_zwp_tablet_pad_ring_v2_interface))
            return static_cast<Resource *>(wl_resource_get_user_data(resource));
        return nullptr;
    }

    const struct ::zwp_tablet_pad_ring_v2_interface zwp_tablet_pad_ring_v2::m_zwp_tablet_pad_ring_v2_interface = {
        zwp_tablet_pad_ring_v2::handle_set_feedback,
        zwp_tablet_pad_ring_v2::handle_destroy
    };

    void zwp_tablet_pad_ring_v2::zwp_tablet_pad_ring_v2_set_feedback(Resource *, const QString &, uint32_t )
    {
    }

    void zwp_tablet_pad_ring_v2::zwp_tablet_pad_ring_v2_destroy(Resource *)
    {
    }


    void zwp_tablet_pad_ring_v2::handle_set_feedback(
        ::wl_client *client,
        struct wl_resource *resource,
        const char *description,
        uint32_t serial)
    {
        Q_UNUSED(client);
        Resource *qtResource = Resource::fromResource(resource);
        if (Q_UNLIKELY(!qtResource->zwp_tablet_pad_ring_v2_object)) {
            return;
        }
        static_cast<zwp_tablet_pad_ring_v2 *>(qtResource->zwp_tablet_pad_ring_v2_object)->zwp_tablet_pad_ring_v2_set_feedback(
            qtResource,
            QString::fromUtf8(description),
            serial);
    }

    void zwp_tablet_pad_ring_v2::handle_destroy(
        ::wl_client *client,
        struct wl_resource *resource)
    {
        Q_UNUSED(client);
        Resource *qtResource = Resource::fromResource(resource);
        if (Q_UNLIKELY(!qtResource->zwp_tablet_pad_ring_v2_object)) {
            wl_resource_destroy(resource);
            return;
        }
        static_cast<zwp_tablet_pad_ring_v2 *>(qtResource->zwp_tablet_pad_ring_v2_object)->zwp_tablet_pad_ring_v2_destroy(
            qtResource);
    }

    void zwp_tablet_pad_ring_v2::send_source(uint32_t source)
    {
        Q_ASSERT_X(m_resource, "zwp_tablet_pad_ring_v2::source", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call zwp_tablet_pad_ring_v2::source as it's not initialised");
            return;
        }
        send_source(
            m_resource->handle,
            source);
    }

    void zwp_tablet_pad_ring_v2::send_source(struct ::wl_resource *resource, uint32_t source)
    {
        zwp_tablet_pad_ring_v2_send_source(
            resource,
            source);
    }


    void zwp_tablet_pad_ring_v2::send_angle(wl_fixed_t degrees)
    {
        Q_ASSERT_X(m_resource, "zwp_tablet_pad_ring_v2::angle", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call zwp_tablet_pad_ring_v2::angle as it's not initialised");
            return;
        }
        send_angle(
            m_resource->handle,
            degrees);
    }

    void zwp_tablet_pad_ring_v2::send_angle(struct ::wl_resource *resource, wl_fixed_t degrees)
    {
        zwp_tablet_pad_ring_v2_send_angle(
            resource,
            degrees);
    }


    void zwp_tablet_pad_ring_v2::send_stop()
    {
        Q_ASSERT_X(m_resource, "zwp_tablet_pad_ring_v2::stop", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call zwp_tablet_pad_ring_v2::stop as it's not initialised");
            return;
        }
        send_stop(
            m_resource->handle);
    }

    void zwp_tablet_pad_ring_v2::send_stop(struct ::wl_resource *resource)
    {
        zwp_tablet_pad_ring_v2_send_stop(
            resource);
    }


    void zwp_tablet_pad_ring_v2::send_frame(uint32_t time)
    {
        Q_ASSERT_X(m_resource, "zwp_tablet_pad_ring_v2::frame", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call zwp_tablet_pad_ring_v2::frame as it's not initialised");
            return;
        }
        send_frame(
            m_resource->handle,
            time);
    }

    void zwp_tablet_pad_ring_v2::send_frame(struct ::wl_resource *resource, uint32_t time)
    {
        zwp_tablet_pad_ring_v2_send_frame(
            resource,
            time);
    }



    int zwp_tablet_pad_strip_v2::deferred_destroy_global_func(void *data) {
        auto object = static_cast<zwp_tablet_pad_strip_v2 *>(data);
        wl_global_destroy(object->m_global);
        object->m_global = nullptr;
        wl_event_source_remove(object->m_globalRemovedEvent);
        object->m_globalRemovedEvent = nullptr;
        wl_list_remove(&object->m_displayDestroyedListener.link);
        object->zwp_tablet_pad_strip_v2_destroy_global();
        return 0;
    }

    zwp_tablet_pad_strip_v2::zwp_tablet_pad_strip_v2(struct ::wl_client *client, int id, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
        init(client, id, version);
    }

    zwp_tablet_pad_strip_v2::zwp_tablet_pad_strip_v2(struct ::wl_display *display, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
        init(display, version);
    }

    zwp_tablet_pad_strip_v2::zwp_tablet_pad_strip_v2(struct ::wl_resource *resource)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
        init(resource);
    }

    zwp_tablet_pad_strip_v2::zwp_tablet_pad_strip_v2()
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
    }

    zwp_tablet_pad_strip_v2::~zwp_tablet_pad_strip_v2()
    {
        for (auto resource : std::as_const(m_resource_map))
            resource->zwp_tablet_pad_strip_v2_object = nullptr;

        if (m_resource)
            m_resource->zwp_tablet_pad_strip_v2_object = nullptr;

        if (m_global) {
            if (m_globalRemovedEvent)
                wl_event_source_remove(m_globalRemovedEvent);
            wl_global_destroy(m_global);
            wl_list_remove(&m_displayDestroyedListener.link);
        }
    }

    void zwp_tablet_pad_strip_v2::init(struct ::wl_client *client, int id, int version)
    {
        m_resource = bind(client, id, version);
    }

    void zwp_tablet_pad_strip_v2::init(struct ::wl_resource *resource)
    {
        m_resource = bind(resource);
    }

    zwp_tablet_pad_strip_v2::Resource *zwp_tablet_pad_strip_v2::add(struct ::wl_client *client, int version)
    {
        Resource *resource = bind(client, 0, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    zwp_tablet_pad_strip_v2::Resource *zwp_tablet_pad_strip_v2::add(struct ::wl_client *client, int id, int version)
    {
        Resource *resource = bind(client, id, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    void zwp_tablet_pad_strip_v2::init(struct ::wl_display *display, int version)
    {
        m_display = display;
        m_global = wl_global_create(display, &::zwp_tablet_pad_strip_v2_interface, version, this, bind_func);
        m_displayDestroyedListener.notify = zwp_tablet_pad_strip_v2::display_destroy_func;
        m_displayDestroyedListener.parent = this;
        wl_display_add_destroy_listener(display, &m_displayDestroyedListener);
    }

    const struct wl_interface *zwp_tablet_pad_strip_v2::interface()
    {
        return &::zwp_tablet_pad_strip_v2_interface;
    }

    zwp_tablet_pad_strip_v2::Resource *zwp_tablet_pad_strip_v2::zwp_tablet_pad_strip_v2_allocate()
    {
        return new Resource;
    }

    void zwp_tablet_pad_strip_v2::zwp_tablet_pad_strip_v2_destroy_global()
    {
    }

    void zwp_tablet_pad_strip_v2::zwp_tablet_pad_strip_v2_bind_resource(Resource *)
    {
    }

    void zwp_tablet_pad_strip_v2::zwp_tablet_pad_strip_v2_destroy_resource(Resource *)
    {
    }

    void zwp_tablet_pad_strip_v2::bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id)
    {
        zwp_tablet_pad_strip_v2 *that = static_cast<zwp_tablet_pad_strip_v2 *>(data);
        that->add(client, id, version);
    }

    void zwp_tablet_pad_strip_v2::display_destroy_func(struct ::wl_listener *listener, void *data)
    {
        Q_UNUSED(data);
        zwp_tablet_pad_strip_v2 *that = static_cast<zwp_tablet_pad_strip_v2::DisplayDestroyedListener *>(listener)->parent;
        that->m_global = nullptr;
        that->m_globalRemovedEvent = nullptr;
    }

    void zwp_tablet_pad_strip_v2::destroy_func(struct ::wl_resource *client_resource)
    {
        Resource *resource = Resource::fromResource(client_resource);
        Q_ASSERT(resource);
        zwp_tablet_pad_strip_v2 *that = resource->zwp_tablet_pad_strip_v2_object;
        if (Q_LIKELY(that)) {
            that->m_resource_map.remove(resource->client(), resource);
            that->zwp_tablet_pad_strip_v2_destroy_resource(resource);

            that = resource->zwp_tablet_pad_strip_v2_object;
            if (that && that->m_resource == resource)
                that->m_resource = nullptr;
        }
        delete resource;
    }


    void zwp_tablet_pad_strip_v2::globalRemove()
    {
        if (!m_global || m_globalRemovedEvent)
            return;

        wl_global_remove(m_global);

        struct wl_event_loop *event_loop = wl_display_get_event_loop(m_display);
        m_globalRemovedEvent = wl_event_loop_add_timer(event_loop, deferred_destroy_global_func, this);
        wl_event_source_timer_update(m_globalRemovedEvent, 300000);
    }

    zwp_tablet_pad_strip_v2::Resource *zwp_tablet_pad_strip_v2::bind(struct ::wl_client *client, uint32_t id, int version)
    {
        Q_ASSERT_X(!wl_client_get_object(client, id), "QWaylandObject bind", QStringLiteral("binding to object %1 more than once").arg(id).toLocal8Bit().constData());
        struct ::wl_resource *handle = wl_resource_create(client, &::zwp_tablet_pad_strip_v2_interface, version, id);
        return bind(handle);
    }

    zwp_tablet_pad_strip_v2::Resource *zwp_tablet_pad_strip_v2::bind(struct ::wl_resource *handle)
    {
        Resource *resource = zwp_tablet_pad_strip_v2_allocate();
        resource->zwp_tablet_pad_strip_v2_object = this;

        wl_resource_set_implementation(handle, &m_zwp_tablet_pad_strip_v2_interface, resource, destroy_func);
        resource->handle = handle;
        zwp_tablet_pad_strip_v2_bind_resource(resource);
        return resource;
    }
    zwp_tablet_pad_strip_v2::Resource *zwp_tablet_pad_strip_v2::Resource::fromResource(struct ::wl_resource *resource)
    {
        if (Q_UNLIKELY(!resource))
            return nullptr;
        if (wl_resource_instance_of(resource, &::zwp_tablet_pad_strip_v2_interface, &m_zwp_tablet_pad_strip_v2_interface))
            return static_cast<Resource *>(wl_resource_get_user_data(resource));
        return nullptr;
    }

    const struct ::zwp_tablet_pad_strip_v2_interface zwp_tablet_pad_strip_v2::m_zwp_tablet_pad_strip_v2_interface = {
        zwp_tablet_pad_strip_v2::handle_set_feedback,
        zwp_tablet_pad_strip_v2::handle_destroy
    };

    void zwp_tablet_pad_strip_v2::zwp_tablet_pad_strip_v2_set_feedback(Resource *, const QString &, uint32_t )
    {
    }

    void zwp_tablet_pad_strip_v2::zwp_tablet_pad_strip_v2_destroy(Resource *)
    {
    }


    void zwp_tablet_pad_strip_v2::handle_set_feedback(
        ::wl_client *client,
        struct wl_resource *resource,
        const char *description,
        uint32_t serial)
    {
        Q_UNUSED(client);
        Resource *qtResource = Resource::fromResource(resource);
        if (Q_UNLIKELY(!qtResource->zwp_tablet_pad_strip_v2_object)) {
            return;
        }
        static_cast<zwp_tablet_pad_strip_v2 *>(qtResource->zwp_tablet_pad_strip_v2_object)->zwp_tablet_pad_strip_v2_set_feedback(
            qtResource,
            QString::fromUtf8(description),
            serial);
    }

    void zwp_tablet_pad_strip_v2::handle_destroy(
        ::wl_client *client,
        struct wl_resource *resource)
    {
        Q_UNUSED(client);
        Resource *qtResource = Resource::fromResource(resource);
        if (Q_UNLIKELY(!qtResource->zwp_tablet_pad_strip_v2_object)) {
            wl_resource_destroy(resource);
            return;
        }
        static_cast<zwp_tablet_pad_strip_v2 *>(qtResource->zwp_tablet_pad_strip_v2_object)->zwp_tablet_pad_strip_v2_destroy(
            qtResource);
    }

    void zwp_tablet_pad_strip_v2::send_source(uint32_t source)
    {
        Q_ASSERT_X(m_resource, "zwp_tablet_pad_strip_v2::source", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call zwp_tablet_pad_strip_v2::source as it's not initialised");
            return;
        }
        send_source(
            m_resource->handle,
            source);
    }

    void zwp_tablet_pad_strip_v2::send_source(struct ::wl_resource *resource, uint32_t source)
    {
        zwp_tablet_pad_strip_v2_send_source(
            resource,
            source);
    }


    void zwp_tablet_pad_strip_v2::send_position(uint32_t position)
    {
        Q_ASSERT_X(m_resource, "zwp_tablet_pad_strip_v2::position", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call zwp_tablet_pad_strip_v2::position as it's not initialised");
            return;
        }
        send_position(
            m_resource->handle,
            position);
    }

    void zwp_tablet_pad_strip_v2::send_position(struct ::wl_resource *resource, uint32_t position)
    {
        zwp_tablet_pad_strip_v2_send_position(
            resource,
            position);
    }


    void zwp_tablet_pad_strip_v2::send_stop()
    {
        Q_ASSERT_X(m_resource, "zwp_tablet_pad_strip_v2::stop", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call zwp_tablet_pad_strip_v2::stop as it's not initialised");
            return;
        }
        send_stop(
            m_resource->handle);
    }

    void zwp_tablet_pad_strip_v2::send_stop(struct ::wl_resource *resource)
    {
        zwp_tablet_pad_strip_v2_send_stop(
            resource);
    }


    void zwp_tablet_pad_strip_v2::send_frame(uint32_t time)
    {
        Q_ASSERT_X(m_resource, "zwp_tablet_pad_strip_v2::frame", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call zwp_tablet_pad_strip_v2::frame as it's not initialised");
            return;
        }
        send_frame(
            m_resource->handle,
            time);
    }

    void zwp_tablet_pad_strip_v2::send_frame(struct ::wl_resource *resource, uint32_t time)
    {
        zwp_tablet_pad_strip_v2_send_frame(
            resource,
            time);
    }



    int zwp_tablet_pad_group_v2::deferred_destroy_global_func(void *data) {
        auto object = static_cast<zwp_tablet_pad_group_v2 *>(data);
        wl_global_destroy(object->m_global);
        object->m_global = nullptr;
        wl_event_source_remove(object->m_globalRemovedEvent);
        object->m_globalRemovedEvent = nullptr;
        wl_list_remove(&object->m_displayDestroyedListener.link);
        object->zwp_tablet_pad_group_v2_destroy_global();
        return 0;
    }

    zwp_tablet_pad_group_v2::zwp_tablet_pad_group_v2(struct ::wl_client *client, int id, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
        init(client, id, version);
    }

    zwp_tablet_pad_group_v2::zwp_tablet_pad_group_v2(struct ::wl_display *display, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
        init(display, version);
    }

    zwp_tablet_pad_group_v2::zwp_tablet_pad_group_v2(struct ::wl_resource *resource)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
        init(resource);
    }

    zwp_tablet_pad_group_v2::zwp_tablet_pad_group_v2()
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
    }

    zwp_tablet_pad_group_v2::~zwp_tablet_pad_group_v2()
    {
        for (auto resource : std::as_const(m_resource_map))
            resource->zwp_tablet_pad_group_v2_object = nullptr;

        if (m_resource)
            m_resource->zwp_tablet_pad_group_v2_object = nullptr;

        if (m_global) {
            if (m_globalRemovedEvent)
                wl_event_source_remove(m_globalRemovedEvent);
            wl_global_destroy(m_global);
            wl_list_remove(&m_displayDestroyedListener.link);
        }
    }

    void zwp_tablet_pad_group_v2::init(struct ::wl_client *client, int id, int version)
    {
        m_resource = bind(client, id, version);
    }

    void zwp_tablet_pad_group_v2::init(struct ::wl_resource *resource)
    {
        m_resource = bind(resource);
    }

    zwp_tablet_pad_group_v2::Resource *zwp_tablet_pad_group_v2::add(struct ::wl_client *client, int version)
    {
        Resource *resource = bind(client, 0, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    zwp_tablet_pad_group_v2::Resource *zwp_tablet_pad_group_v2::add(struct ::wl_client *client, int id, int version)
    {
        Resource *resource = bind(client, id, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    void zwp_tablet_pad_group_v2::init(struct ::wl_display *display, int version)
    {
        m_display = display;
        m_global = wl_global_create(display, &::zwp_tablet_pad_group_v2_interface, version, this, bind_func);
        m_displayDestroyedListener.notify = zwp_tablet_pad_group_v2::display_destroy_func;
        m_displayDestroyedListener.parent = this;
        wl_display_add_destroy_listener(display, &m_displayDestroyedListener);
    }

    const struct wl_interface *zwp_tablet_pad_group_v2::interface()
    {
        return &::zwp_tablet_pad_group_v2_interface;
    }

    zwp_tablet_pad_group_v2::Resource *zwp_tablet_pad_group_v2::zwp_tablet_pad_group_v2_allocate()
    {
        return new Resource;
    }

    void zwp_tablet_pad_group_v2::zwp_tablet_pad_group_v2_destroy_global()
    {
    }

    void zwp_tablet_pad_group_v2::zwp_tablet_pad_group_v2_bind_resource(Resource *)
    {
    }

    void zwp_tablet_pad_group_v2::zwp_tablet_pad_group_v2_destroy_resource(Resource *)
    {
    }

    void zwp_tablet_pad_group_v2::bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id)
    {
        zwp_tablet_pad_group_v2 *that = static_cast<zwp_tablet_pad_group_v2 *>(data);
        that->add(client, id, version);
    }

    void zwp_tablet_pad_group_v2::display_destroy_func(struct ::wl_listener *listener, void *data)
    {
        Q_UNUSED(data);
        zwp_tablet_pad_group_v2 *that = static_cast<zwp_tablet_pad_group_v2::DisplayDestroyedListener *>(listener)->parent;
        that->m_global = nullptr;
        that->m_globalRemovedEvent = nullptr;
    }

    void zwp_tablet_pad_group_v2::destroy_func(struct ::wl_resource *client_resource)
    {
        Resource *resource = Resource::fromResource(client_resource);
        Q_ASSERT(resource);
        zwp_tablet_pad_group_v2 *that = resource->zwp_tablet_pad_group_v2_object;
        if (Q_LIKELY(that)) {
            that->m_resource_map.remove(resource->client(), resource);
            that->zwp_tablet_pad_group_v2_destroy_resource(resource);

            that = resource->zwp_tablet_pad_group_v2_object;
            if (that && that->m_resource == resource)
                that->m_resource = nullptr;
        }
        delete resource;
    }


    void zwp_tablet_pad_group_v2::globalRemove()
    {
        if (!m_global || m_globalRemovedEvent)
            return;

        wl_global_remove(m_global);

        struct wl_event_loop *event_loop = wl_display_get_event_loop(m_display);
        m_globalRemovedEvent = wl_event_loop_add_timer(event_loop, deferred_destroy_global_func, this);
        wl_event_source_timer_update(m_globalRemovedEvent, 300000);
    }

    zwp_tablet_pad_group_v2::Resource *zwp_tablet_pad_group_v2::bind(struct ::wl_client *client, uint32_t id, int version)
    {
        Q_ASSERT_X(!wl_client_get_object(client, id), "QWaylandObject bind", QStringLiteral("binding to object %1 more than once").arg(id).toLocal8Bit().constData());
        struct ::wl_resource *handle = wl_resource_create(client, &::zwp_tablet_pad_group_v2_interface, version, id);
        return bind(handle);
    }

    zwp_tablet_pad_group_v2::Resource *zwp_tablet_pad_group_v2::bind(struct ::wl_resource *handle)
    {
        Resource *resource = zwp_tablet_pad_group_v2_allocate();
        resource->zwp_tablet_pad_group_v2_object = this;

        wl_resource_set_implementation(handle, &m_zwp_tablet_pad_group_v2_interface, resource, destroy_func);
        resource->handle = handle;
        zwp_tablet_pad_group_v2_bind_resource(resource);
        return resource;
    }
    zwp_tablet_pad_group_v2::Resource *zwp_tablet_pad_group_v2::Resource::fromResource(struct ::wl_resource *resource)
    {
        if (Q_UNLIKELY(!resource))
            return nullptr;
        if (wl_resource_instance_of(resource, &::zwp_tablet_pad_group_v2_interface, &m_zwp_tablet_pad_group_v2_interface))
            return static_cast<Resource *>(wl_resource_get_user_data(resource));
        return nullptr;
    }

    const struct ::zwp_tablet_pad_group_v2_interface zwp_tablet_pad_group_v2::m_zwp_tablet_pad_group_v2_interface = {
        zwp_tablet_pad_group_v2::handle_destroy
    };

    void zwp_tablet_pad_group_v2::zwp_tablet_pad_group_v2_destroy(Resource *)
    {
    }


    void zwp_tablet_pad_group_v2::handle_destroy(
        ::wl_client *client,
        struct wl_resource *resource)
    {
        Q_UNUSED(client);
        Resource *qtResource = Resource::fromResource(resource);
        if (Q_UNLIKELY(!qtResource->zwp_tablet_pad_group_v2_object)) {
            wl_resource_destroy(resource);
            return;
        }
        static_cast<zwp_tablet_pad_group_v2 *>(qtResource->zwp_tablet_pad_group_v2_object)->zwp_tablet_pad_group_v2_destroy(
            qtResource);
    }

    void zwp_tablet_pad_group_v2::send_buttons(const QByteArray &buttons)
    {
        Q_ASSERT_X(m_resource, "zwp_tablet_pad_group_v2::buttons", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call zwp_tablet_pad_group_v2::buttons as it's not initialised");
            return;
        }
        send_buttons(
            m_resource->handle,
            buttons);
    }

    void zwp_tablet_pad_group_v2::send_buttons(struct ::wl_resource *resource, const QByteArray &buttons)
    {
        struct wl_array buttons_data;
        buttons_data.size = buttons.size();
        buttons_data.data = static_cast<void *>(const_cast<char *>(buttons.constData()));
        buttons_data.alloc = 0;

        zwp_tablet_pad_group_v2_send_buttons(
            resource,
            &buttons_data);
    }


    void zwp_tablet_pad_group_v2::send_ring(struct ::wl_resource *ring)
    {
        Q_ASSERT_X(m_resource, "zwp_tablet_pad_group_v2::ring", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call zwp_tablet_pad_group_v2::ring as it's not initialised");
            return;
        }
        send_ring(
            m_resource->handle,
            ring);
    }

    void zwp_tablet_pad_group_v2::send_ring(struct ::wl_resource *resource, struct ::wl_resource *ring)
    {
        zwp_tablet_pad_group_v2_send_ring(
            resource,
            ring);
    }


    void zwp_tablet_pad_group_v2::send_strip(struct ::wl_resource *strip)
    {
        Q_ASSERT_X(m_resource, "zwp_tablet_pad_group_v2::strip", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call zwp_tablet_pad_group_v2::strip as it's not initialised");
            return;
        }
        send_strip(
            m_resource->handle,
            strip);
    }

    void zwp_tablet_pad_group_v2::send_strip(struct ::wl_resource *resource, struct ::wl_resource *strip)
    {
        zwp_tablet_pad_group_v2_send_strip(
            resource,
            strip);
    }


    void zwp_tablet_pad_group_v2::send_modes(uint32_t modes)
    {
        Q_ASSERT_X(m_resource, "zwp_tablet_pad_group_v2::modes", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call zwp_tablet_pad_group_v2::modes as it's not initialised");
            return;
        }
        send_modes(
            m_resource->handle,
            modes);
    }

    void zwp_tablet_pad_group_v2::send_modes(struct ::wl_resource *resource, uint32_t modes)
    {
        zwp_tablet_pad_group_v2_send_modes(
            resource,
            modes);
    }


    void zwp_tablet_pad_group_v2::send_done()
    {
        Q_ASSERT_X(m_resource, "zwp_tablet_pad_group_v2::done", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call zwp_tablet_pad_group_v2::done as it's not initialised");
            return;
        }
        send_done(
            m_resource->handle);
    }

    void zwp_tablet_pad_group_v2::send_done(struct ::wl_resource *resource)
    {
        zwp_tablet_pad_group_v2_send_done(
            resource);
    }


    void zwp_tablet_pad_group_v2::send_mode_switch(uint32_t time, uint32_t serial, uint32_t mode)
    {
        Q_ASSERT_X(m_resource, "zwp_tablet_pad_group_v2::mode_switch", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call zwp_tablet_pad_group_v2::mode_switch as it's not initialised");
            return;
        }
        send_mode_switch(
            m_resource->handle,
            time,
            serial,
            mode);
    }

    void zwp_tablet_pad_group_v2::send_mode_switch(struct ::wl_resource *resource, uint32_t time, uint32_t serial, uint32_t mode)
    {
        zwp_tablet_pad_group_v2_send_mode_switch(
            resource,
            time,
            serial,
            mode);
    }


    void zwp_tablet_pad_group_v2::send_dial(struct ::wl_resource *dial)
    {
        Q_ASSERT_X(m_resource, "zwp_tablet_pad_group_v2::dial", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call zwp_tablet_pad_group_v2::dial as it's not initialised");
            return;
        }
        send_dial(
            m_resource->handle,
            dial);
    }

    void zwp_tablet_pad_group_v2::send_dial(struct ::wl_resource *resource, struct ::wl_resource *dial)
    {
        zwp_tablet_pad_group_v2_send_dial(
            resource,
            dial);
    }



    int zwp_tablet_pad_v2::deferred_destroy_global_func(void *data) {
        auto object = static_cast<zwp_tablet_pad_v2 *>(data);
        wl_global_destroy(object->m_global);
        object->m_global = nullptr;
        wl_event_source_remove(object->m_globalRemovedEvent);
        object->m_globalRemovedEvent = nullptr;
        wl_list_remove(&object->m_displayDestroyedListener.link);
        object->zwp_tablet_pad_v2_destroy_global();
        return 0;
    }

    zwp_tablet_pad_v2::zwp_tablet_pad_v2(struct ::wl_client *client, int id, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
        init(client, id, version);
    }

    zwp_tablet_pad_v2::zwp_tablet_pad_v2(struct ::wl_display *display, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
        init(display, version);
    }

    zwp_tablet_pad_v2::zwp_tablet_pad_v2(struct ::wl_resource *resource)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
        init(resource);
    }

    zwp_tablet_pad_v2::zwp_tablet_pad_v2()
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
    }

    zwp_tablet_pad_v2::~zwp_tablet_pad_v2()
    {
        for (auto resource : std::as_const(m_resource_map))
            resource->zwp_tablet_pad_v2_object = nullptr;

        if (m_resource)
            m_resource->zwp_tablet_pad_v2_object = nullptr;

        if (m_global) {
            if (m_globalRemovedEvent)
                wl_event_source_remove(m_globalRemovedEvent);
            wl_global_destroy(m_global);
            wl_list_remove(&m_displayDestroyedListener.link);
        }
    }

    void zwp_tablet_pad_v2::init(struct ::wl_client *client, int id, int version)
    {
        m_resource = bind(client, id, version);
    }

    void zwp_tablet_pad_v2::init(struct ::wl_resource *resource)
    {
        m_resource = bind(resource);
    }

    zwp_tablet_pad_v2::Resource *zwp_tablet_pad_v2::add(struct ::wl_client *client, int version)
    {
        Resource *resource = bind(client, 0, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    zwp_tablet_pad_v2::Resource *zwp_tablet_pad_v2::add(struct ::wl_client *client, int id, int version)
    {
        Resource *resource = bind(client, id, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    void zwp_tablet_pad_v2::init(struct ::wl_display *display, int version)
    {
        m_display = display;
        m_global = wl_global_create(display, &::zwp_tablet_pad_v2_interface, version, this, bind_func);
        m_displayDestroyedListener.notify = zwp_tablet_pad_v2::display_destroy_func;
        m_displayDestroyedListener.parent = this;
        wl_display_add_destroy_listener(display, &m_displayDestroyedListener);
    }

    const struct wl_interface *zwp_tablet_pad_v2::interface()
    {
        return &::zwp_tablet_pad_v2_interface;
    }

    zwp_tablet_pad_v2::Resource *zwp_tablet_pad_v2::zwp_tablet_pad_v2_allocate()
    {
        return new Resource;
    }

    void zwp_tablet_pad_v2::zwp_tablet_pad_v2_destroy_global()
    {
    }

    void zwp_tablet_pad_v2::zwp_tablet_pad_v2_bind_resource(Resource *)
    {
    }

    void zwp_tablet_pad_v2::zwp_tablet_pad_v2_destroy_resource(Resource *)
    {
    }

    void zwp_tablet_pad_v2::bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id)
    {
        zwp_tablet_pad_v2 *that = static_cast<zwp_tablet_pad_v2 *>(data);
        that->add(client, id, version);
    }

    void zwp_tablet_pad_v2::display_destroy_func(struct ::wl_listener *listener, void *data)
    {
        Q_UNUSED(data);
        zwp_tablet_pad_v2 *that = static_cast<zwp_tablet_pad_v2::DisplayDestroyedListener *>(listener)->parent;
        that->m_global = nullptr;
        that->m_globalRemovedEvent = nullptr;
    }

    void zwp_tablet_pad_v2::destroy_func(struct ::wl_resource *client_resource)
    {
        Resource *resource = Resource::fromResource(client_resource);
        Q_ASSERT(resource);
        zwp_tablet_pad_v2 *that = resource->zwp_tablet_pad_v2_object;
        if (Q_LIKELY(that)) {
            that->m_resource_map.remove(resource->client(), resource);
            that->zwp_tablet_pad_v2_destroy_resource(resource);

            that = resource->zwp_tablet_pad_v2_object;
            if (that && that->m_resource == resource)
                that->m_resource = nullptr;
        }
        delete resource;
    }


    void zwp_tablet_pad_v2::globalRemove()
    {
        if (!m_global || m_globalRemovedEvent)
            return;

        wl_global_remove(m_global);

        struct wl_event_loop *event_loop = wl_display_get_event_loop(m_display);
        m_globalRemovedEvent = wl_event_loop_add_timer(event_loop, deferred_destroy_global_func, this);
        wl_event_source_timer_update(m_globalRemovedEvent, 300000);
    }

    zwp_tablet_pad_v2::Resource *zwp_tablet_pad_v2::bind(struct ::wl_client *client, uint32_t id, int version)
    {
        Q_ASSERT_X(!wl_client_get_object(client, id), "QWaylandObject bind", QStringLiteral("binding to object %1 more than once").arg(id).toLocal8Bit().constData());
        struct ::wl_resource *handle = wl_resource_create(client, &::zwp_tablet_pad_v2_interface, version, id);
        return bind(handle);
    }

    zwp_tablet_pad_v2::Resource *zwp_tablet_pad_v2::bind(struct ::wl_resource *handle)
    {
        Resource *resource = zwp_tablet_pad_v2_allocate();
        resource->zwp_tablet_pad_v2_object = this;

        wl_resource_set_implementation(handle, &m_zwp_tablet_pad_v2_interface, resource, destroy_func);
        resource->handle = handle;
        zwp_tablet_pad_v2_bind_resource(resource);
        return resource;
    }
    zwp_tablet_pad_v2::Resource *zwp_tablet_pad_v2::Resource::fromResource(struct ::wl_resource *resource)
    {
        if (Q_UNLIKELY(!resource))
            return nullptr;
        if (wl_resource_instance_of(resource, &::zwp_tablet_pad_v2_interface, &m_zwp_tablet_pad_v2_interface))
            return static_cast<Resource *>(wl_resource_get_user_data(resource));
        return nullptr;
    }

    const struct ::zwp_tablet_pad_v2_interface zwp_tablet_pad_v2::m_zwp_tablet_pad_v2_interface = {
        zwp_tablet_pad_v2::handle_set_feedback,
        zwp_tablet_pad_v2::handle_destroy
    };

    void zwp_tablet_pad_v2::zwp_tablet_pad_v2_set_feedback(Resource *, uint32_t , const QString &, uint32_t )
    {
    }

    void zwp_tablet_pad_v2::zwp_tablet_pad_v2_destroy(Resource *)
    {
    }


    void zwp_tablet_pad_v2::handle_set_feedback(
        ::wl_client *client,
        struct wl_resource *resource,
        uint32_t button,
        const char *description,
        uint32_t serial)
    {
        Q_UNUSED(client);
        Resource *qtResource = Resource::fromResource(resource);
        if (Q_UNLIKELY(!qtResource->zwp_tablet_pad_v2_object)) {
            return;
        }
        static_cast<zwp_tablet_pad_v2 *>(qtResource->zwp_tablet_pad_v2_object)->zwp_tablet_pad_v2_set_feedback(
            qtResource,
            button,
            QString::fromUtf8(description),
            serial);
    }

    void zwp_tablet_pad_v2::handle_destroy(
        ::wl_client *client,
        struct wl_resource *resource)
    {
        Q_UNUSED(client);
        Resource *qtResource = Resource::fromResource(resource);
        if (Q_UNLIKELY(!qtResource->zwp_tablet_pad_v2_object)) {
            wl_resource_destroy(resource);
            return;
        }
        static_cast<zwp_tablet_pad_v2 *>(qtResource->zwp_tablet_pad_v2_object)->zwp_tablet_pad_v2_destroy(
            qtResource);
    }

    void zwp_tablet_pad_v2::send_group(struct ::wl_resource *pad_group)
    {
        Q_ASSERT_X(m_resource, "zwp_tablet_pad_v2::group", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call zwp_tablet_pad_v2::group as it's not initialised");
            return;
        }
        send_group(
            m_resource->handle,
            pad_group);
    }

    void zwp_tablet_pad_v2::send_group(struct ::wl_resource *resource, struct ::wl_resource *pad_group)
    {
        zwp_tablet_pad_v2_send_group(
            resource,
            pad_group);
    }


    void zwp_tablet_pad_v2::send_path(const QString &path)
    {
        Q_ASSERT_X(m_resource, "zwp_tablet_pad_v2::path", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call zwp_tablet_pad_v2::path as it's not initialised");
            return;
        }
        send_path(
            m_resource->handle,
            path);
    }

    void zwp_tablet_pad_v2::send_path(struct ::wl_resource *resource, const QString &path)
    {
        zwp_tablet_pad_v2_send_path(
            resource,
            path.toUtf8().constData());
    }


    void zwp_tablet_pad_v2::send_buttons(uint32_t buttons)
    {
        Q_ASSERT_X(m_resource, "zwp_tablet_pad_v2::buttons", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call zwp_tablet_pad_v2::buttons as it's not initialised");
            return;
        }
        send_buttons(
            m_resource->handle,
            buttons);
    }

    void zwp_tablet_pad_v2::send_buttons(struct ::wl_resource *resource, uint32_t buttons)
    {
        zwp_tablet_pad_v2_send_buttons(
            resource,
            buttons);
    }


    void zwp_tablet_pad_v2::send_done()
    {
        Q_ASSERT_X(m_resource, "zwp_tablet_pad_v2::done", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call zwp_tablet_pad_v2::done as it's not initialised");
            return;
        }
        send_done(
            m_resource->handle);
    }

    void zwp_tablet_pad_v2::send_done(struct ::wl_resource *resource)
    {
        zwp_tablet_pad_v2_send_done(
            resource);
    }


    void zwp_tablet_pad_v2::send_button(uint32_t time, uint32_t button, uint32_t state)
    {
        Q_ASSERT_X(m_resource, "zwp_tablet_pad_v2::button", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call zwp_tablet_pad_v2::button as it's not initialised");
            return;
        }
        send_button(
            m_resource->handle,
            time,
            button,
            state);
    }

    void zwp_tablet_pad_v2::send_button(struct ::wl_resource *resource, uint32_t time, uint32_t button, uint32_t state)
    {
        zwp_tablet_pad_v2_send_button(
            resource,
            time,
            button,
            state);
    }


    void zwp_tablet_pad_v2::send_enter(uint32_t serial, struct ::wl_resource *tablet, struct ::wl_resource *surface)
    {
        Q_ASSERT_X(m_resource, "zwp_tablet_pad_v2::enter", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call zwp_tablet_pad_v2::enter as it's not initialised");
            return;
        }
        send_enter(
            m_resource->handle,
            serial,
            tablet,
            surface);
    }

    void zwp_tablet_pad_v2::send_enter(struct ::wl_resource *resource, uint32_t serial, struct ::wl_resource *tablet, struct ::wl_resource *surface)
    {
        zwp_tablet_pad_v2_send_enter(
            resource,
            serial,
            tablet,
            surface);
    }


    void zwp_tablet_pad_v2::send_leave(uint32_t serial, struct ::wl_resource *surface)
    {
        Q_ASSERT_X(m_resource, "zwp_tablet_pad_v2::leave", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call zwp_tablet_pad_v2::leave as it's not initialised");
            return;
        }
        send_leave(
            m_resource->handle,
            serial,
            surface);
    }

    void zwp_tablet_pad_v2::send_leave(struct ::wl_resource *resource, uint32_t serial, struct ::wl_resource *surface)
    {
        zwp_tablet_pad_v2_send_leave(
            resource,
            serial,
            surface);
    }


    void zwp_tablet_pad_v2::send_removed()
    {
        Q_ASSERT_X(m_resource, "zwp_tablet_pad_v2::removed", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call zwp_tablet_pad_v2::removed as it's not initialised");
            return;
        }
        send_removed(
            m_resource->handle);
    }

    void zwp_tablet_pad_v2::send_removed(struct ::wl_resource *resource)
    {
        zwp_tablet_pad_v2_send_removed(
            resource);
    }



    int zwp_tablet_pad_dial_v2::deferred_destroy_global_func(void *data) {
        auto object = static_cast<zwp_tablet_pad_dial_v2 *>(data);
        wl_global_destroy(object->m_global);
        object->m_global = nullptr;
        wl_event_source_remove(object->m_globalRemovedEvent);
        object->m_globalRemovedEvent = nullptr;
        wl_list_remove(&object->m_displayDestroyedListener.link);
        object->zwp_tablet_pad_dial_v2_destroy_global();
        return 0;
    }

    zwp_tablet_pad_dial_v2::zwp_tablet_pad_dial_v2(struct ::wl_client *client, int id, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
        init(client, id, version);
    }

    zwp_tablet_pad_dial_v2::zwp_tablet_pad_dial_v2(struct ::wl_display *display, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
        init(display, version);
    }

    zwp_tablet_pad_dial_v2::zwp_tablet_pad_dial_v2(struct ::wl_resource *resource)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
        init(resource);
    }

    zwp_tablet_pad_dial_v2::zwp_tablet_pad_dial_v2()
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
    }

    zwp_tablet_pad_dial_v2::~zwp_tablet_pad_dial_v2()
    {
        for (auto resource : std::as_const(m_resource_map))
            resource->zwp_tablet_pad_dial_v2_object = nullptr;

        if (m_resource)
            m_resource->zwp_tablet_pad_dial_v2_object = nullptr;

        if (m_global) {
            if (m_globalRemovedEvent)
                wl_event_source_remove(m_globalRemovedEvent);
            wl_global_destroy(m_global);
            wl_list_remove(&m_displayDestroyedListener.link);
        }
    }

    void zwp_tablet_pad_dial_v2::init(struct ::wl_client *client, int id, int version)
    {
        m_resource = bind(client, id, version);
    }

    void zwp_tablet_pad_dial_v2::init(struct ::wl_resource *resource)
    {
        m_resource = bind(resource);
    }

    zwp_tablet_pad_dial_v2::Resource *zwp_tablet_pad_dial_v2::add(struct ::wl_client *client, int version)
    {
        Resource *resource = bind(client, 0, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    zwp_tablet_pad_dial_v2::Resource *zwp_tablet_pad_dial_v2::add(struct ::wl_client *client, int id, int version)
    {
        Resource *resource = bind(client, id, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    void zwp_tablet_pad_dial_v2::init(struct ::wl_display *display, int version)
    {
        m_display = display;
        m_global = wl_global_create(display, &::zwp_tablet_pad_dial_v2_interface, version, this, bind_func);
        m_displayDestroyedListener.notify = zwp_tablet_pad_dial_v2::display_destroy_func;
        m_displayDestroyedListener.parent = this;
        wl_display_add_destroy_listener(display, &m_displayDestroyedListener);
    }

    const struct wl_interface *zwp_tablet_pad_dial_v2::interface()
    {
        return &::zwp_tablet_pad_dial_v2_interface;
    }

    zwp_tablet_pad_dial_v2::Resource *zwp_tablet_pad_dial_v2::zwp_tablet_pad_dial_v2_allocate()
    {
        return new Resource;
    }

    void zwp_tablet_pad_dial_v2::zwp_tablet_pad_dial_v2_destroy_global()
    {
    }

    void zwp_tablet_pad_dial_v2::zwp_tablet_pad_dial_v2_bind_resource(Resource *)
    {
    }

    void zwp_tablet_pad_dial_v2::zwp_tablet_pad_dial_v2_destroy_resource(Resource *)
    {
    }

    void zwp_tablet_pad_dial_v2::bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id)
    {
        zwp_tablet_pad_dial_v2 *that = static_cast<zwp_tablet_pad_dial_v2 *>(data);
        that->add(client, id, version);
    }

    void zwp_tablet_pad_dial_v2::display_destroy_func(struct ::wl_listener *listener, void *data)
    {
        Q_UNUSED(data);
        zwp_tablet_pad_dial_v2 *that = static_cast<zwp_tablet_pad_dial_v2::DisplayDestroyedListener *>(listener)->parent;
        that->m_global = nullptr;
        that->m_globalRemovedEvent = nullptr;
    }

    void zwp_tablet_pad_dial_v2::destroy_func(struct ::wl_resource *client_resource)
    {
        Resource *resource = Resource::fromResource(client_resource);
        Q_ASSERT(resource);
        zwp_tablet_pad_dial_v2 *that = resource->zwp_tablet_pad_dial_v2_object;
        if (Q_LIKELY(that)) {
            that->m_resource_map.remove(resource->client(), resource);
            that->zwp_tablet_pad_dial_v2_destroy_resource(resource);

            that = resource->zwp_tablet_pad_dial_v2_object;
            if (that && that->m_resource == resource)
                that->m_resource = nullptr;
        }
        delete resource;
    }


    void zwp_tablet_pad_dial_v2::globalRemove()
    {
        if (!m_global || m_globalRemovedEvent)
            return;

        wl_global_remove(m_global);

        struct wl_event_loop *event_loop = wl_display_get_event_loop(m_display);
        m_globalRemovedEvent = wl_event_loop_add_timer(event_loop, deferred_destroy_global_func, this);
        wl_event_source_timer_update(m_globalRemovedEvent, 300000);
    }

    zwp_tablet_pad_dial_v2::Resource *zwp_tablet_pad_dial_v2::bind(struct ::wl_client *client, uint32_t id, int version)
    {
        Q_ASSERT_X(!wl_client_get_object(client, id), "QWaylandObject bind", QStringLiteral("binding to object %1 more than once").arg(id).toLocal8Bit().constData());
        struct ::wl_resource *handle = wl_resource_create(client, &::zwp_tablet_pad_dial_v2_interface, version, id);
        return bind(handle);
    }

    zwp_tablet_pad_dial_v2::Resource *zwp_tablet_pad_dial_v2::bind(struct ::wl_resource *handle)
    {
        Resource *resource = zwp_tablet_pad_dial_v2_allocate();
        resource->zwp_tablet_pad_dial_v2_object = this;

        wl_resource_set_implementation(handle, &m_zwp_tablet_pad_dial_v2_interface, resource, destroy_func);
        resource->handle = handle;
        zwp_tablet_pad_dial_v2_bind_resource(resource);
        return resource;
    }
    zwp_tablet_pad_dial_v2::Resource *zwp_tablet_pad_dial_v2::Resource::fromResource(struct ::wl_resource *resource)
    {
        if (Q_UNLIKELY(!resource))
            return nullptr;
        if (wl_resource_instance_of(resource, &::zwp_tablet_pad_dial_v2_interface, &m_zwp_tablet_pad_dial_v2_interface))
            return static_cast<Resource *>(wl_resource_get_user_data(resource));
        return nullptr;
    }

    const struct ::zwp_tablet_pad_dial_v2_interface zwp_tablet_pad_dial_v2::m_zwp_tablet_pad_dial_v2_interface = {
        zwp_tablet_pad_dial_v2::handle_set_feedback,
        zwp_tablet_pad_dial_v2::handle_destroy
    };

    void zwp_tablet_pad_dial_v2::zwp_tablet_pad_dial_v2_set_feedback(Resource *, const QString &, uint32_t )
    {
    }

    void zwp_tablet_pad_dial_v2::zwp_tablet_pad_dial_v2_destroy(Resource *)
    {
    }


    void zwp_tablet_pad_dial_v2::handle_set_feedback(
        ::wl_client *client,
        struct wl_resource *resource,
        const char *description,
        uint32_t serial)
    {
        Q_UNUSED(client);
        Resource *qtResource = Resource::fromResource(resource);
        if (Q_UNLIKELY(!qtResource->zwp_tablet_pad_dial_v2_object)) {
            return;
        }
        static_cast<zwp_tablet_pad_dial_v2 *>(qtResource->zwp_tablet_pad_dial_v2_object)->zwp_tablet_pad_dial_v2_set_feedback(
            qtResource,
            QString::fromUtf8(description),
            serial);
    }

    void zwp_tablet_pad_dial_v2::handle_destroy(
        ::wl_client *client,
        struct wl_resource *resource)
    {
        Q_UNUSED(client);
        Resource *qtResource = Resource::fromResource(resource);
        if (Q_UNLIKELY(!qtResource->zwp_tablet_pad_dial_v2_object)) {
            wl_resource_destroy(resource);
            return;
        }
        static_cast<zwp_tablet_pad_dial_v2 *>(qtResource->zwp_tablet_pad_dial_v2_object)->zwp_tablet_pad_dial_v2_destroy(
            qtResource);
    }

    void zwp_tablet_pad_dial_v2::send_delta(int32_t value120)
    {
        Q_ASSERT_X(m_resource, "zwp_tablet_pad_dial_v2::delta", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call zwp_tablet_pad_dial_v2::delta as it's not initialised");
            return;
        }
        send_delta(
            m_resource->handle,
            value120);
    }

    void zwp_tablet_pad_dial_v2::send_delta(struct ::wl_resource *resource, int32_t value120)
    {
        zwp_tablet_pad_dial_v2_send_delta(
            resource,
            value120);
    }


    void zwp_tablet_pad_dial_v2::send_frame(uint32_t time)
    {
        Q_ASSERT_X(m_resource, "zwp_tablet_pad_dial_v2::frame", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call zwp_tablet_pad_dial_v2::frame as it's not initialised");
            return;
        }
        send_frame(
            m_resource->handle,
            time);
    }

    void zwp_tablet_pad_dial_v2::send_frame(struct ::wl_resource *resource, uint32_t time)
    {
        zwp_tablet_pad_dial_v2_send_frame(
            resource,
            time);
    }

}

QT_WARNING_POP
QT_END_NAMESPACE
