// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkAffineTypeFloat32Array
 * @brief   affine implicit array of vtkTypeFloat32.
 *
 * vtkAffineTypeFloat32Array is an affine implicit array of values of type vtkTypeFloat32.
 * see vtkAffineArray, vtkAffineImplicitBackend
 *
 * This file is generated by vtkTypeArrays.cmake
 */

#ifndef vtkAffineTypeFloat32Array_h
#define vtkAffineTypeFloat32Array_h

#include "vtkAffineArray.h"      // Real Superclass
#include "vtkCommonCoreModule.h" // For export macro
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkAffineArray<vtkTypeFloat32>
#endif
VTK_ABI_NAMESPACE_BEGIN
class VTKCOMMONCORE_EXPORT  vtkAffineTypeFloat32Array : public vtkDataArray
{
public:
  vtkImplicitArrayTypeMacro(vtkAffineTypeFloat32Array, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  static vtkAffineTypeFloat32Array* New();
  static vtkAffineTypeFloat32Array* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkImplicitArray, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateReadOnlyWrappedArrayInterface(vtkTypeFloat32);
#endif

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkAffineTypeFloat32Array* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkAffineTypeFloat32Array*>(Superclass::FastDownCast(source));
  }

  /**
   * Set the parameters for the affine backend.
   * slope is the unit variation and intercept is the value at 0.
   * Value at index is:
   *   value = slope * index + intercept
   */
  void ConstructBackend(vtkTypeFloat32 slope, vtkTypeFloat32 intercept);

protected:
  vtkAffineTypeFloat32Array();
  ~vtkAffineTypeFloat32Array() override;

private:
  typedef vtkAffineArray<vtkTypeFloat32> RealSuperclass;

  vtkAffineTypeFloat32Array(const vtkAffineTypeFloat32Array&) = delete;
  void operator=(const vtkAffineTypeFloat32Array&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkAffineTypeFloat32Array);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
