/*
 * Decompiled with CFR 0.152.
 */
package com.virtuslab.using_directives.custom.utils;

import com.virtuslab.using_directives.custom.Tokens;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class TokenUtils {
    private static Map<Integer, Tokens> tokensMap = Arrays.stream(Tokens.values()).collect(Collectors.toMap(Enum::ordinal, t -> t));
    public static Set<Tokens> alphaKeywords = new HashSet<Tokens>(TokenUtils.tokenRange(Tokens.USING, Tokens.END));
    public static Set<Tokens> symbolicKeywords = new HashSet<Tokens>(TokenUtils.tokenRange(Tokens.USCORE, Tokens.CTXARROW));
    public static Set<Tokens> identifierTokens = TokenUtils.identifierTokens();
    public static Set<Tokens> keywords = TokenUtils.keywords();
    public static Set<Tokens> literalTokens = TokenUtils.literalTokens();
    public static Set<Tokens> openParensTokens = TokenUtils.openParensTokens();
    public static Set<Tokens> canStartExprTokens3 = TokenUtils.canStartExprTokens3();
    public static Set<Tokens> canEndStatTokens = TokenUtils.canEndStatTokens();
    public static Set<Tokens> closingRegionTokens = TokenUtils.closingRegionTokens();
    public static Set<Tokens> canStartIndentTokens = TokenUtils.canStartIndentTokens();
    public static Set<Tokens> canStartStatTokens3 = TokenUtils.canStartStatTokens3();
    public static Map<String, Tokens> keywordMap = TokenUtils.keywordMap();

    private static Collection<Tokens> tokenRange(Tokens start, Tokens end) {
        return Arrays.stream(Tokens.values()).filter(t -> t.ordinal() >= start.ordinal() && t.ordinal() <= end.ordinal()).collect(Collectors.toList());
    }

    private static Set<Tokens> identifierTokens() {
        HashSet<Tokens> set = new HashSet<Tokens>();
        set.add(Tokens.IDENTIFIER);
        set.add(Tokens.BACKQUOTED_IDENT);
        return set;
    }

    public static Tokens tokenFromInt(int value) {
        return tokensMap.get(value);
    }

    public static boolean isIdentifier(Tokens token) {
        return token.ordinal() >= Tokens.IDENTIFIER.ordinal() && token.ordinal() <= Tokens.BACKQUOTED_IDENT.ordinal();
    }

    public static boolean isValidUsingDirectiveStart(Tokens token) {
        return token == Tokens.USING;
    }

    public static Map<String, Tokens> keywordMap() {
        HashMap<String, Tokens> map = new HashMap<String, Tokens>();
        TokenUtils.keywords().forEach(t -> map.put(t.str, (Tokens)((Object)t)));
        return map;
    }

    private static Set<Tokens> keywords() {
        HashSet<Tokens> set = new HashSet<Tokens>();
        set.addAll(alphaKeywords);
        set.addAll(symbolicKeywords);
        return set;
    }

    private static Set<Tokens> simpleLiteralTokens() {
        HashSet<Tokens> set = new HashSet<Tokens>(TokenUtils.tokenRange(Tokens.CHARLIT, Tokens.STRINGLIT));
        set.add(Tokens.TRUE);
        set.add(Tokens.FALSE);
        return set;
    }

    private static Set<Tokens> literalTokens() {
        HashSet<Tokens> set = new HashSet<Tokens>(TokenUtils.simpleLiteralTokens());
        set.add(Tokens.QUOTEID);
        set.add(Tokens.NULL);
        return set;
    }

    private static Set<Tokens> atomicExprTokens() {
        HashSet<Tokens> set = new HashSet<Tokens>(TokenUtils.literalTokens());
        set.add(Tokens.USCORE);
        set.add(Tokens.NULL);
        set.add(Tokens.TRUE);
        set.add(Tokens.FALSE);
        set.add(Tokens.QUOTEID);
        return set;
    }

    private static Set<Tokens> openParensTokens() {
        HashSet<Tokens> set = new HashSet<Tokens>();
        set.add(Tokens.LBRACE);
        set.add(Tokens.LPAREN);
        set.add(Tokens.LBRACKET);
        return set;
    }

    private static Set<Tokens> canStartExprTokens3() {
        HashSet<Tokens> set = new HashSet<Tokens>(TokenUtils.atomicExprTokens());
        set.addAll(TokenUtils.openParensTokens());
        set.add(Tokens.INDENT);
        set.add(Tokens.QUOTE);
        return set;
    }

    private static Set<Tokens> canEndStatTokens() {
        HashSet<Tokens> set = new HashSet<Tokens>(TokenUtils.atomicExprTokens());
        set.add(Tokens.RPAREN);
        set.add(Tokens.RBRACE);
        set.add(Tokens.RBRACKET);
        set.add(Tokens.OUTDENT);
        return set;
    }

    private static Set<Tokens> closingRegionTokens() {
        HashSet<Tokens> set = new HashSet<Tokens>();
        set.add(Tokens.RBRACE);
        set.add(Tokens.RPAREN);
        set.add(Tokens.RBRACKET);
        return set;
    }

    private static Set<Tokens> canStartIndentTokens() {
        HashSet<Tokens> set = new HashSet<Tokens>();
        set.add(Tokens.USING);
        set.add(Tokens.COLONEOL);
        set.add(Tokens.EQUALS);
        set.add(Tokens.CTXARROW);
        return set;
    }

    private static Set<Tokens> canStartStatTokens3() {
        HashSet<Tokens> set = new HashSet<Tokens>(TokenUtils.canStartExprTokens3());
        set.add(Tokens.USING);
        set.add(Tokens.AT);
        set.add(Tokens.END);
        return set;
    }
}

