/*
 * Decompiled with CFR 0.152.
 */
package com.virtuslab.using_directives.custom;

import com.virtuslab.using_directives.custom.utils.Chars;
import java.util.function.BiConsumer;
import java.util.function.Supplier;

public class CustomCharArrayReader {
    public char[] buf;
    public int startFrom = 0;
    public boolean decodeUni = false;
    public BiConsumer<String, Integer> error;
    public char ch;
    public int charOffset = this.startFrom;
    public int lastCharOffset = this.startFrom;
    public int lineStartOffset = this.startFrom;

    public boolean isUnicodeEscape() {
        return this.charOffset == this.lastCharOffset;
    }

    public void nextChar() {
        int idx;
        this.lastCharOffset = idx = this.charOffset;
        this.charOffset = idx + 1;
        if (idx >= this.buf.length) {
            this.ch = (char)26;
        } else {
            char c;
            this.ch = c = this.buf[idx];
            if (c == '\\') {
                this.potentialUnicode();
            } else if (c < ' ') {
                this.skipCR();
                this.potentialLineEnd();
            }
        }
    }

    public char getc() {
        this.nextChar();
        return this.ch;
    }

    public void nextRawChar() {
        int idx;
        this.lastCharOffset = idx = this.charOffset;
        this.charOffset = idx + 1;
        if (idx >= this.buf.length) {
            this.ch = (char)26;
        } else {
            char c;
            this.ch = c = this.buf[idx];
            if (c == '\\') {
                this.potentialUnicode();
            }
        }
    }

    private void potentialUnicode() {
        Supplier<Boolean> evenSlashPrefix = () -> {
            int p;
            for (p = this.charOffset - 2; p >= 0 && this.buf[p] == '\\'; --p) {
            }
            return (this.charOffset - p) % 2 == 0;
        };
        Supplier<Integer> udigit = () -> {
            if (this.charOffset >= this.buf.length) {
                this.error.accept("incomplete unicode escape", this.charOffset - 1);
                return 26;
            }
            return Chars.digitToInt(this.buf[this.charOffset], 16);
        };
        if (this.charOffset < this.buf.length && this.buf[this.charOffset] == 'u' && this.decodeUni && evenSlashPrefix.get().booleanValue()) {
            ++this.charOffset;
            while (this.charOffset + 1 < this.buf.length && this.buf[this.charOffset + 1] == 'u') {
                ++this.charOffset;
            }
            int code = udigit.get() << 12 | udigit.get() << 8 | udigit.get() << 4 | udigit.get();
            this.ch = (char)code;
        }
    }

    private void skipCR() {
        if (this.ch == '\r' && this.charOffset < this.buf.length && this.buf[this.charOffset] == '\n') {
            ++this.charOffset;
            this.ch = (char)10;
        }
    }

    private void potentialLineEnd() {
        if (this.ch == '\n' || this.ch == '\f') {
            this.lineStartOffset = this.charOffset;
        }
    }

    public boolean isAtEnd() {
        return this.lastCharOffset >= this.buf.length;
    }

    public CustomCharArrayReader getLookaheadCharArrayReader() {
        CustomCharArrayReader lcar = new CustomCharArrayReader(this.buf, this.error);
        lcar.charOffset = this.charOffset;
        lcar.ch = this.ch;
        lcar.decodeUni = this.decodeUni;
        return lcar;
    }

    public char lookaheadChar() {
        return this.getLookaheadCharArrayReader().getc();
    }

    public CustomCharArrayReader(char[] buf, BiConsumer<String, Integer> error) {
        this.buf = buf;
        this.error = error;
    }
}

