/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import java.io.Serializable;
import java.util.NoSuchElementException;
import scala.collection.immutable.Range;
import scala.runtime.ModuleSerializationProxy;

public final class Range$
implements Serializable {
    public static final Range$ MODULE$ = new Range$();

    public int count(int start, int end, int step, boolean isInclusive) {
        if (step == 0) {
            throw new IllegalArgumentException("step cannot be 0.");
        }
        boolean bl = start == end ? !isInclusive : (start < end ? step < 0 : step > 0);
        if (bl) {
            return 0;
        }
        int stepSign = step >> 31;
        int gap = (end - start ^ stepSign) - stepSign;
        int absStep = (step ^ stepSign) - stepSign;
        int div = Integer.divideUnsigned(gap, absStep);
        if (isInclusive) {
            if (div == -1) {
                return -1;
            }
            return div + 1;
        }
        if (absStep * div != gap) {
            return div + 1;
        }
        return div;
    }

    public int count(int start, int end, int step) {
        return this.count(start, end, step, false);
    }

    public Range.Exclusive apply(int start, int end, int step) {
        return new Range.Exclusive(start, end, step);
    }

    public Range.Exclusive apply(int start, int end) {
        return new Range.Exclusive(start, end, 1);
    }

    public Range.Inclusive inclusive(int start, int end, int step) {
        return new Range.Inclusive(start, end, step);
    }

    public Range.Inclusive inclusive(int start, int end) {
        return new Range.Inclusive(start, end, 1);
    }

    public Throwable scala$collection$immutable$Range$$emptyRangeError(String what) {
        return new NoSuchElementException(what + " on empty Range");
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Range$.class);
    }

    private Range$() {
    }
}

