# The PEP 484 type hints stub file for the _3d_p module.
#
# Generated by SIP 6.14.0


import collections, re, typing, enum

try:
    from warnings import deprecated
except ImportError:
    pass

import PyQt6.sip

from PyQt6 import QtCore
from PyQt6 import QtXml
from PyQt6 import QtNetwork
from PyQt6 import QtGui
from PyQt6 import QtWidgets
from PyQt6 import QtSql
from PyQt6 import QtPrintSupport
from PyQt6 import QtPositioning
from PyQt6 import QtSerialPort
from qgis import _core

# Support for QDate, QDateTime and QTime.
import datetime

# Convenient type aliases.
PYQT_SIGNAL = typing.Union[QtCore.pyqtSignal, QtCore.pyqtBoundSignal]
PYQT_SLOT = typing.Union[collections.abc.Callable[..., Any], QtCore.pyqtBoundSignal]


class QgsMaterialSettingsRenderingTechnique(enum.IntEnum):
    Triangles = ... # type: QgsMaterialSettingsRenderingTechnique
    Lines = ... # type: QgsMaterialSettingsRenderingTechnique
    InstancedPoints = ... # type: QgsMaterialSettingsRenderingTechnique
    Points = ... # type: QgsMaterialSettingsRenderingTechnique
    TrianglesWithFixedTexture = ... # type: QgsMaterialSettingsRenderingTechnique
    TrianglesFromModel = ... # type: QgsMaterialSettingsRenderingTechnique
    TrianglesDataDefined = ... # type: QgsMaterialSettingsRenderingTechnique


class Qgs3DAlgorithms(_core.QgsProcessingProvider):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def loadAlgorithms(self) -> None: ...
    def supportsNonFileBasedOutput(self) -> bool: ...
    def name(self) -> str: ...
    def helpId(self) -> str: ...
    def id(self) -> str: ...
    def svgIconPath(self) -> str: ...
    def icon(self) -> QtGui.QIcon: ...


class Qgs3D(PyQt6.sip.wrapper):

    @staticmethod
    def terrainRegistry() -> typing.Optional['Qgs3DTerrainRegistry']: ...
    @staticmethod
    def materialRegistry() -> typing.Optional['QgsMaterialRegistry']: ...
    @staticmethod
    def initialize() -> None: ...
    @staticmethod
    def instance() -> typing.Optional['Qgs3D']: ...


class Qgs3DMapScene(QtCore.QObject):

    class SceneState(enum.IntEnum):
        Ready = ... # type: Qgs3DMapScene.SceneState
        Updating = ... # type: Qgs3DMapScene.SceneState

    def updateTemporal(self) -> None: ...
    gpuMemoryLimitReached: typing.ClassVar[QtCore.pyqtSignal]
    viewed2DExtentFrom3DChanged: typing.ClassVar[QtCore.pyqtSignal]
    fpsCounterEnabledChanged: typing.ClassVar[QtCore.pyqtSignal]
    fpsCountChanged: typing.ClassVar[QtCore.pyqtSignal]
    sceneStateChanged: typing.ClassVar[QtCore.pyqtSignal]
    totalPendingJobsCountChanged: typing.ClassVar[QtCore.pyqtSignal]
    terrainEntityChanged: typing.ClassVar[QtCore.pyqtSignal]
    def clipPlaneEquations(self) -> list[QtGui.QVector4D]: ...
    def disableClipping(self) -> None: ...
    def enableClipping(self, clipPlaneEquations: collections.abc.Iterable[QtGui.QVector4D]) -> None: ...
    @staticmethod
    @deprecated("""""")
    def openScenes() -> typing.Any: ...
    def setSceneOriginShiftEnabled(self, enabled: bool) -> None: ...
    def hasSceneOriginShiftEnabled(self) -> bool: ...
    def setSceneUpdatesEnabled(self, enabled: bool) -> None: ...
    def hasSceneUpdatesEnabled(self) -> bool: ...
    def mapSettings(self) -> typing.Optional['Qgs3DMapSettings']: ...
    def elevationRange(self, ignoreTerrain: bool = ...) -> _core.QgsDoubleRange: ...
    def sceneExtent(self) -> _core.QgsRectangle: ...
    def exportScene(self, exportSettings: 'Qgs3DMapExportSettings') -> bool: ...
    def worldSpaceError(self, epsilon: float, distance: float) -> float: ...
    def sceneState(self) -> 'Qgs3DMapScene.SceneState': ...
    def totalPendingJobsCount(self) -> int: ...
    def viewFrustum2DExtent(self) -> list[_core.QgsPointXY]: ...
    def setViewFrom2DExtent(self, extent: _core.QgsRectangle) -> None: ...
    def viewZoomFull(self) -> None: ...
    def cameraController(self) -> typing.Optional['QgsCameraController']: ...


class Qgs3DMapSettings(QtCore.QObject, _core.QgsTemporalRangeObject):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'Qgs3DMapSettings') -> None: ...

    originChanged: typing.ClassVar[QtCore.pyqtSignal]
    showDebugPanelChanged: typing.ClassVar[QtCore.pyqtSignal]
    showExtentIn2DViewChanged: typing.ClassVar[QtCore.pyqtSignal]
    extentChanged: typing.ClassVar[QtCore.pyqtSignal]
    debugOverlayEnabledChanged: typing.ClassVar[QtCore.pyqtSignal]
    axisSettingsChanged: typing.ClassVar[QtCore.pyqtSignal]
    viewFrustumVisualizationEnabledChanged: typing.ClassVar[QtCore.pyqtSignal]
    fpsCounterEnabledChanged: typing.ClassVar[QtCore.pyqtSignal]
    ambientOcclusionSettingsChanged: typing.ClassVar[QtCore.pyqtSignal]
    shadowSettingsChanged: typing.ClassVar[QtCore.pyqtSignal]
    skyboxSettingsChanged: typing.ClassVar[QtCore.pyqtSignal]
    cameraMovementSpeedChanged: typing.ClassVar[QtCore.pyqtSignal]
    cameraNavigationModeChanged: typing.ClassVar[QtCore.pyqtSignal]
    projectionTypeChanged: typing.ClassVar[QtCore.pyqtSignal]
    fieldOfViewChanged: typing.ClassVar[QtCore.pyqtSignal]
    directionalLightsChanged: typing.ClassVar[QtCore.pyqtSignal]
    lightSourcesChanged: typing.ClassVar[QtCore.pyqtSignal]
    pointLightsChanged: typing.ClassVar[QtCore.pyqtSignal]
    debugDepthMapSettingsChanged: typing.ClassVar[QtCore.pyqtSignal]
    debugShadowMapSettingsChanged: typing.ClassVar[QtCore.pyqtSignal]
    eyeDomeLightingDistanceChanged: typing.ClassVar[QtCore.pyqtSignal]
    eyeDomeLightingStrengthChanged: typing.ClassVar[QtCore.pyqtSignal]
    eyeDomeLightingEnabledChanged: typing.ClassVar[QtCore.pyqtSignal]
    stopUpdatesChanged: typing.ClassVar[QtCore.pyqtSignal]
    showLabelsChanged: typing.ClassVar[QtCore.pyqtSignal]
    showLightSourceOriginsChanged: typing.ClassVar[QtCore.pyqtSignal]
    showCameraRotationCenterChanged: typing.ClassVar[QtCore.pyqtSignal]
    showCameraViewCenterChanged: typing.ClassVar[QtCore.pyqtSignal]
    showTerrainTilesInfoChanged: typing.ClassVar[QtCore.pyqtSignal]
    showTerrainBoundingBoxesChanged: typing.ClassVar[QtCore.pyqtSignal]
    renderersChanged: typing.ClassVar[QtCore.pyqtSignal]
    terrainMapThemeChanged: typing.ClassVar[QtCore.pyqtSignal]
    terrainShadingChanged: typing.ClassVar[QtCore.pyqtSignal]
    terrainElevationOffsetChanged: typing.ClassVar[QtCore.pyqtSignal]
    maxTerrainGroundErrorChanged: typing.ClassVar[QtCore.pyqtSignal]
    maxTerrainScreenErrorChanged: typing.ClassVar[QtCore.pyqtSignal]
    mapTileResolutionChanged: typing.ClassVar[QtCore.pyqtSignal]
    terrainVerticalScaleChanged: typing.ClassVar[QtCore.pyqtSignal]
    terrainSettingsChanged: typing.ClassVar[QtCore.pyqtSignal]
    terrainGeneratorChanged: typing.ClassVar[QtCore.pyqtSignal]
    layersChanged: typing.ClassVar[QtCore.pyqtSignal]
    selectionColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    backgroundColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    settingsChanged: typing.ClassVar[QtCore.pyqtSignal]
    def showDebugPanel(self) -> bool: ...
    def setShowDebugPanel(self, enabled: bool) -> None: ...
    def setShowExtentIn2DView(self, show: bool) -> None: ...
    def showExtentIn2DView(self) -> bool: ...
    def setIsDebugOverlayEnabled(self, debugOverlayEnabled: bool) -> None: ...
    def isDebugOverlayEnabled(self) -> bool: ...
    def setViewFrustumVisualizationEnabled(self, enabled: bool) -> None: ...
    def viewFrustumVisualizationEnabled(self) -> bool: ...
    def setViewSyncMode(self, mode: _core.Qgis.ViewSyncModeFlag) -> None: ...
    def viewSyncMode(self) -> _core.Qgis.ViewSyncModeFlag: ...
    def setRendererUsage(self, rendererUsage: _core.Qgis.RendererUsage) -> None: ...
    def rendererUsage(self) -> _core.Qgis.RendererUsage: ...
    def setTerrainRenderingEnabled(self, terrainRenderingEnabled: bool) -> None: ...
    def terrainRenderingEnabled(self) -> bool: ...
    def setIsFpsCounterEnabled(self, fpsCounterEnabled: bool) -> None: ...
    def isFpsCounterEnabled(self) -> bool: ...
    def setIsSkyboxEnabled(self, enabled: bool) -> None: ...
    def isSkyboxEnabled(self) -> bool: ...
    def outputDpi(self) -> float: ...
    def setOutputDpi(self, dpi: float) -> None: ...
    def setCameraMovementSpeed(self, movementSpeed: float) -> None: ...
    def cameraMovementSpeed(self) -> float: ...
    def setFieldOfView(self, fieldOfView: float) -> None: ...
    def fieldOfView(self) -> float: ...
    def setLightSources(self, lights: collections.abc.Iterable['QgsLightSource']) -> None: ...
    def lightSources(self) -> list['QgsLightSource']: ...
    def debugDepthMapSize(self) -> float: ...
    def debugDepthMapCorner(self) -> QtCore.Qt.Corner: ...
    def debugDepthMapEnabled(self) -> bool: ...
    def setDebugDepthMapSettings(self, enabled: bool, corner: QtCore.Qt.Corner, size: float) -> None: ...
    def debugShadowMapSize(self) -> float: ...
    def debugShadowMapCorner(self) -> QtCore.Qt.Corner: ...
    def debugShadowMapEnabled(self) -> bool: ...
    def setDebugShadowMapSettings(self, enabled: bool, corner: QtCore.Qt.Corner, size: float) -> None: ...
    def stopUpdates(self) -> bool: ...
    def setStopUpdates(self, enabled: bool) -> None: ...
    def eyeDomeLightingDistance(self) -> int: ...
    def setEyeDomeLightingDistance(self, distance: int) -> None: ...
    def eyeDomeLightingStrength(self) -> float: ...
    def setEyeDomeLightingStrength(self, strength: float) -> None: ...
    def eyeDomeLightingEnabled(self) -> bool: ...
    def setEyeDomeLightingEnabled(self, enabled: bool) -> None: ...
    def showLabels(self) -> bool: ...
    def setShowLabels(self, enabled: bool) -> None: ...
    def showLightSourceOrigins(self) -> bool: ...
    def setShowLightSourceOrigins(self, enabled: bool) -> None: ...
    def showCameraRotationCenter(self) -> bool: ...
    def setShowCameraRotationCenter(self, enabled: bool) -> None: ...
    def showCameraViewCenter(self) -> bool: ...
    def setShowCameraViewCenter(self, enabled: bool) -> None: ...
    def showTerrainTilesInfo(self) -> bool: ...
    def setShowTerrainTilesInfo(self, enabled: bool) -> None: ...
    def showTerrainBoundingBoxes(self) -> bool: ...
    def setShowTerrainBoundingBoxes(self, enabled: bool) -> None: ...
    def terrainMapTheme(self) -> str: ...
    def setTerrainMapTheme(self, theme: typing.Optional[str]) -> None: ...
    def terrainShadingMaterial(self) -> 'QgsPhongMaterialSettings': ...
    def setTerrainShadingMaterial(self, material: 'QgsPhongMaterialSettings') -> None: ...
    def isTerrainShadingEnabled(self) -> bool: ...
    def setTerrainShadingEnabled(self, enabled: bool) -> None: ...
    @deprecated("""""")
    def terrainElevationOffset(self) -> float: ...
    @deprecated("""""")
    def setTerrainElevationOffset(self, offset: float) -> None: ...
    @deprecated("""""")
    def maxTerrainGroundError(self) -> float: ...
    @deprecated("""""")
    def setMaxTerrainGroundError(self, error: float) -> None: ...
    @deprecated("""""")
    def maxTerrainScreenError(self) -> float: ...
    @deprecated("""""")
    def setMaxTerrainScreenError(self, error: float) -> None: ...
    @deprecated("""""")
    def mapTileResolution(self) -> int: ...
    @deprecated("""""")
    def setMapTileResolution(self, res: int) -> None: ...
    @deprecated("""""")
    def terrainVerticalScale(self) -> float: ...
    @deprecated("""""")
    def setTerrainVerticalScale(self, zScale: float) -> None: ...
    def setTerrainSettings(self, settings: typing.Optional['QgsAbstractTerrainSettings']) -> None: ...
    def terrainSettings(self) -> typing.Optional['QgsAbstractTerrainSettings']: ...
    def layers(self) -> list[_core.QgsMapLayer]: ...
    def setLayers(self, layers: collections.abc.Iterable[_core.QgsMapLayer]) -> None: ...
    def selectionColor(self) -> QtGui.QColor: ...
    def setSelectionColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, int]) -> None: ...
    def backgroundColor(self) -> QtGui.QColor: ...
    def setBackgroundColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, int]) -> None: ...
    def setMapThemeCollection(self, mapThemes: typing.Optional[_core.QgsMapThemeCollection]) -> None: ...
    def mapThemeCollection(self) -> typing.Optional[_core.QgsMapThemeCollection]: ...
    def setPathResolver(self, resolver: _core.QgsPathResolver) -> None: ...
    def pathResolver(self) -> _core.QgsPathResolver: ...
    def setTransformContext(self, context: _core.QgsCoordinateTransformContext) -> None: ...
    def transformContext(self) -> _core.QgsCoordinateTransformContext: ...
    def sceneMode(self) -> _core.Qgis.SceneMode: ...
    def crs(self) -> _core.QgsCoordinateReferenceSystem: ...
    def setCrs(self, crs: _core.QgsCoordinateReferenceSystem) -> None: ...
    def worldToMapCoordinates(self, worldCoords: _core.QgsVector3D) -> _core.QgsVector3D: ...
    def mapToWorldCoordinates(self, mapCoords: _core.QgsVector3D) -> _core.QgsVector3D: ...
    def origin(self) -> _core.QgsVector3D: ...
    def setOrigin(self, origin: _core.QgsVector3D) -> None: ...
    def setExtent(self, extent: _core.QgsRectangle) -> None: ...
    def extent(self) -> _core.QgsRectangle: ...
    def resolveReferences(self, project: _core.QgsProject) -> None: ...
    def writeXml(self, doc: QtXml.QDomDocument, context: _core.QgsReadWriteContext) -> QtXml.QDomElement: ...
    def readXml(self, elem: QtXml.QDomElement, context: _core.QgsReadWriteContext) -> None: ...


class Qgs3DTypes(PyQt6.sip.wrapper):

    class Flag3DRenderer(enum.IntEnum):
        Main3DRenderer = ... # type: Qgs3DTypes.Flag3DRenderer
        Selected3DRenderer = ... # type: Qgs3DTypes.Flag3DRenderer

    class CullingMode(enum.IntEnum):
        NoCulling = ... # type: Qgs3DTypes.CullingMode
        Front = ... # type: Qgs3DTypes.CullingMode
        Back = ... # type: Qgs3DTypes.CullingMode
        FrontAndBack = ... # type: Qgs3DTypes.CullingMode

    PROP_NAME_3D_RENDERER_FLAG = ... # type: str

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'Qgs3DTypes') -> None: ...


class Qgs3DMapCanvas(QtGui.QWindow):

    def __init__(self) -> None: ...

    def eventFilter(self, watched: typing.Optional[QtCore.QObject], event: typing.Optional[QtCore.QEvent]) -> bool: ...
    def resizeEvent(self, a0: typing.Optional[QtGui.QResizeEvent]) -> None: ...
    def showEvent(self, e: typing.Optional[QtGui.QShowEvent]) -> None: ...
    def cameraController(self) -> typing.Optional['QgsCameraController']: ...
    def scene(self) -> typing.Optional[Qgs3DMapScene]: ...
    def mapSettings(self) -> typing.Optional[Qgs3DMapSettings]: ...


class QgsVectorLayer3DTilingSettings(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsVectorLayer3DTilingSettings') -> None: ...

    def readXml(self, elem: QtXml.QDomElement) -> None: ...
    def writeXml(self, elem: QtXml.QDomElement) -> None: ...
    def showBoundingBoxes(self) -> bool: ...
    def setShowBoundingBoxes(self, enabled: bool) -> None: ...
    def setZoomLevelsCount(self, count: int) -> None: ...
    def zoomLevelsCount(self) -> int: ...


class QgsAbstractVectorLayer3DRenderer(_core.QgsAbstract3DRenderer):

    def __init__(self) -> None: ...

    def readXmlBaseProperties(self, elem: QtXml.QDomElement, context: _core.QgsReadWriteContext) -> None: ...
    def writeXmlBaseProperties(self, elem: QtXml.QDomElement, context: _core.QgsReadWriteContext) -> None: ...
    def copyBaseProperties(self, r: typing.Optional['QgsAbstractVectorLayer3DRenderer']) -> None: ...
    def resolveReferences(self, project: _core.QgsProject) -> None: ...
    def tilingSettings(self) -> QgsVectorLayer3DTilingSettings: ...
    def setTilingSettings(self, settings: QgsVectorLayer3DTilingSettings) -> None: ...
    def layer(self) -> typing.Optional[_core.QgsVectorLayer]: ...
    def setLayer(self, layer: typing.Optional[_core.QgsVectorLayer]) -> None: ...


class QgsCameraController(QtCore.QObject):

    cameraRotationCenterChanged: typing.ClassVar[QtCore.pyqtSignal]
    requestDepthBufferCapture: typing.ClassVar[QtCore.pyqtSignal]
    setCursorPosition: typing.ClassVar[QtCore.pyqtSignal]
    cameraMovementSpeedChanged: typing.ClassVar[QtCore.pyqtSignal]
    navigationModeChanged: typing.ClassVar[QtCore.pyqtSignal]
    cameraChanged: typing.ClassVar[QtCore.pyqtSignal]
    def depthBufferCaptured(self, depthImage: QtGui.QImage) -> None: ...
    def setCameraNavigationMode(self, navigationMode: _core.Qgis.NavigationMode) -> None: ...
    def rotateCameraToBottom(self) -> None: ...
    def rotateCameraToWest(self) -> None: ...
    def rotateCameraToSouth(self) -> None: ...
    def rotateCameraToEast(self) -> None: ...
    def rotateCameraToNorth(self) -> None: ...
    def rotateCameraToTop(self) -> None: ...
    def rotateCameraToHome(self) -> None: ...
    def origin(self) -> _core.QgsVector3D: ...
    def resetGlobe(self, distance: float, lat: float = ..., lon: float = ...) -> None: ...
    def globeUpdateHeadingAngle(self, angleDiff: float) -> None: ...
    def globeUpdatePitchAngle(self, angleDiff: float) -> None: ...
    def globeZoom(self, factor: float) -> None: ...
    def globeMoveCenterPoint(self, latDiff: float, lonDiff: float) -> None: ...
    def hasInputHandlersEnabled(self) -> bool: ...
    def setInputHandlersEnabled(self, enable: bool) -> None: ...
    def setOrigin(self, origin: _core.QgsVector3D) -> None: ...
    def keyboardEventFilter(self, event: typing.Optional[QtGui.QKeyEvent]) -> bool: ...
    @typing.overload
    @deprecated("""""")
    def zoomCameraAroundPivot(self, oldCameraPosition: QtGui.QVector3D, zoomFactor: float, pivotPoint: QtGui.QVector3D) -> None: ...
    @typing.overload
    def zoomCameraAroundPivot(self, oldCameraPosition: QtGui.QVector3D, oldDistanceFromCenterPoint: float, zoomFactor: float, pivotPoint: QtGui.QVector3D) -> None: ...
    def rotateCameraAroundPivot(self, newPitch: float, newHeading: float, pivotPoint: QtGui.QVector3D) -> None: ...
    def rotateCamera(self, diffPitch: float, diffYaw: float) -> None: ...
    def walkView(self, tx: float, ty: float, tz: float) -> None: ...
    def moveView(self, tx: float, ty: float) -> None: ...
    def setCameraHeadingAngle(self, angle: float) -> None: ...
    def rotateAroundViewCenter(self, deltaYaw: float) -> None: ...
    def tiltUpAroundViewCenter(self, deltaPitch: float) -> None: ...
    def zoom(self, factor: float) -> None: ...
    def readXml(self, elem: QtXml.QDomElement, savedOrigin: _core.QgsVector3D) -> None: ...
    def writeXml(self, doc: QtXml.QDomDocument) -> QtXml.QDomElement: ...
    def yaw(self) -> float: ...
    def pitch(self) -> float: ...
    def distance(self) -> float: ...
    def cameraPose(self) -> 'QgsCameraPose': ...
    def setCameraPose(self, camPose: 'QgsCameraPose', force: bool = ...) -> None: ...
    def setLookingAtMapPoint(self, point: _core.QgsVector3D, distance: float, pitch: float, yaw: float) -> None: ...
    def lookingAtMapPoint(self) -> _core.QgsVector3D: ...
    def setLookingAtPoint(self, point: _core.QgsVector3D, distance: float, pitch: float, yaw: float) -> None: ...
    def lookingAtPoint(self) -> _core.QgsVector3D: ...
    def setViewFromTop(self, worldX: float, worldY: float, distance: float, yaw: float = ...) -> None: ...
    def resetView(self, distance: float) -> None: ...
    def frameTriggered(self, dt: float) -> None: ...
    def setVerticalAxisInversion(self, inversion: _core.Qgis.VerticalAxisInversion) -> None: ...
    def verticalAxisInversion(self) -> _core.Qgis.VerticalAxisInversion: ...
    def setCameraMovementSpeed(self, movementSpeed: float) -> None: ...
    def cameraMovementSpeed(self) -> float: ...
    def cameraNavigationMode(self) -> _core.Qgis.NavigationMode: ...


class QgsCameraPose(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsCameraPose') -> None: ...

    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...
    def readXml(self, elem: QtXml.QDomElement) -> None: ...
    def writeXml(self, doc: QtXml.QDomDocument) -> QtXml.QDomElement: ...
    def setHeadingAngle(self, heading: float) -> None: ...
    def headingAngle(self) -> float: ...
    def setPitchAngle(self, pitch: float) -> None: ...
    def pitchAngle(self) -> float: ...
    def setDistanceFromCenterPoint(self, distance: float) -> None: ...
    def distanceFromCenterPoint(self) -> float: ...
    def setCenterPoint(self, point: _core.QgsVector3D) -> None: ...
    def centerPoint(self) -> _core.QgsVector3D: ...


class QgsLayoutItem3DMap(_core.QgsLayoutItem, _core.QgsTemporalRangeObject):

    def __init__(self, layout: typing.Optional[_core.QgsLayout]) -> None: ...

    def readPropertiesFromElement(self, element: QtXml.QDomElement, document: QtXml.QDomDocument, context: _core.QgsReadWriteContext) -> bool: ...
    def writePropertiesToElement(self, element: QtXml.QDomElement, document: QtXml.QDomDocument, context: _core.QgsReadWriteContext) -> bool: ...
    def draw(self, context: _core.QgsLayoutItemRenderContext) -> None: ...
    def refresh(self) -> None: ...
    def finalizeRestoreFromXml(self) -> None: ...
    def displayName(self) -> str: ...
    def assignFreeId(self) -> None: ...
    def mapSettings(self) -> typing.Optional[Qgs3DMapSettings]: ...
    def setMapSettings(self, settings: typing.Optional[Qgs3DMapSettings]) -> None: ...
    def cameraPose(self) -> QgsCameraPose: ...
    def setCameraPose(self, pose: QgsCameraPose) -> None: ...
    def icon(self) -> QtGui.QIcon: ...
    def type(self) -> int: ...
    @staticmethod
    def create(layout: typing.Optional[_core.QgsLayout]) -> typing.Optional['QgsLayoutItem3DMap']: ...


class QgsRuleBased3DRendererMetadata(_core.Qgs3DRendererAbstractMetadata):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsRuleBased3DRendererMetadata') -> None: ...

    def createRenderer(self, elem: QtXml.QDomElement, context: _core.QgsReadWriteContext) -> typing.Optional[_core.QgsAbstract3DRenderer]: ...


class QgsRuleBased3DRenderer(QgsAbstractVectorLayer3DRenderer):

    class Rule(PyQt6.sip.wrapper):

        class RegisterResult(enum.IntEnum):
            Filtered = ... # type: QgsRuleBased3DRenderer.Rule.RegisterResult
            Inactive = ... # type: QgsRuleBased3DRenderer.Rule.RegisterResult
            Registered = ... # type: QgsRuleBased3DRenderer.Rule.RegisterResult

        def __init__(self, symbol: typing.Optional[_core.QgsAbstract3DSymbol], filterExp: typing.Optional[str] = ..., description: typing.Optional[str] = ..., elseRule: bool = ...) -> None: ...

        def save(self, doc: QtXml.QDomDocument, context: _core.QgsReadWriteContext) -> QtXml.QDomElement: ...
        @staticmethod
        def create(ruleElem: QtXml.QDomElement, context: _core.QgsReadWriteContext) -> typing.Optional['QgsRuleBased3DRenderer.Rule']: ...
        def clone(self) -> typing.Optional['QgsRuleBased3DRenderer.Rule']: ...
        def findRuleByKey(self, key: typing.Optional[str]) -> typing.Optional['QgsRuleBased3DRenderer.Rule']: ...
        def removeChildAt(self, i: int) -> None: ...
        def insertChild(self, i: int, rule: typing.Optional['QgsRuleBased3DRenderer.Rule']) -> None: ...
        def appendChild(self, rule: typing.Optional['QgsRuleBased3DRenderer.Rule']) -> None: ...
        def parent(self) -> typing.Optional['QgsRuleBased3DRenderer.Rule']: ...
        def descendants(self) -> list['QgsRuleBased3DRenderer.Rule']: ...
        def children(self) -> list['QgsRuleBased3DRenderer.Rule']: ...
        def setRuleKey(self, key: typing.Optional[str]) -> None: ...
        def setIsElse(self, iselse: bool) -> None: ...
        def setActive(self, state: bool) -> None: ...
        def setDescription(self, description: typing.Optional[str]) -> None: ...
        def setFilterExpression(self, filterExp: typing.Optional[str]) -> None: ...
        def setSymbol(self, symbol: typing.Optional[_core.QgsAbstract3DSymbol]) -> None: ...
        def ruleKey(self) -> str: ...
        def isElse(self) -> bool: ...
        def active(self) -> bool: ...
        def description(self) -> str: ...
        def filterExpression(self) -> str: ...
        def symbol(self) -> typing.Optional[_core.QgsAbstract3DSymbol]: ...

    def __init__(self, root: typing.Optional['QgsRuleBased3DRenderer.Rule']) -> None: ...

    def readXml(self, elem: QtXml.QDomElement, context: _core.QgsReadWriteContext) -> None: ...
    def writeXml(self, elem: QtXml.QDomElement, context: _core.QgsReadWriteContext) -> None: ...
    def clone(self) -> typing.Optional['QgsRuleBased3DRenderer']: ...
    def type(self) -> str: ...
    def rootRule(self) -> typing.Optional['QgsRuleBased3DRenderer.Rule']: ...


class QgsTiledSceneLayer3DRendererMetadata(_core.Qgs3DRendererAbstractMetadata):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsTiledSceneLayer3DRendererMetadata') -> None: ...

    def createRenderer(self, elem: QtXml.QDomElement, context: _core.QgsReadWriteContext) -> typing.Optional[_core.QgsAbstract3DRenderer]: ...


class QgsTiledSceneLayer3DRenderer(_core.QgsAbstract3DRenderer):

    def __init__(self) -> None: ...

    def resolveReferences(self, project: _core.QgsProject) -> None: ...
    def readXml(self, elem: QtXml.QDomElement, context: _core.QgsReadWriteContext) -> None: ...
    def writeXml(self, elem: QtXml.QDomElement, context: _core.QgsReadWriteContext) -> None: ...
    def clone(self) -> typing.Optional[_core.QgsAbstract3DRenderer]: ...
    def type(self) -> str: ...
    def setShowBoundingBoxes(self, showBoundingBoxes: bool) -> None: ...
    def showBoundingBoxes(self) -> bool: ...
    def setMaximumScreenError(self, error: float) -> None: ...
    def maximumScreenError(self) -> float: ...
    def layer(self) -> typing.Optional[_core.QgsTiledSceneLayer]: ...
    def setLayer(self, layer: typing.Optional[_core.QgsTiledSceneLayer]) -> None: ...


class QgsVectorLayer3DRendererMetadata(_core.Qgs3DRendererAbstractMetadata):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsVectorLayer3DRendererMetadata') -> None: ...

    def createRenderer(self, elem: QtXml.QDomElement, context: _core.QgsReadWriteContext) -> typing.Optional[_core.QgsAbstract3DRenderer]: ...


class QgsVectorLayer3DRenderer(QgsAbstractVectorLayer3DRenderer):

    def __init__(self, s: typing.Optional[_core.QgsAbstract3DSymbol] = ...) -> None: ...

    def readXml(self, elem: QtXml.QDomElement, context: _core.QgsReadWriteContext) -> None: ...
    def writeXml(self, elem: QtXml.QDomElement, context: _core.QgsReadWriteContext) -> None: ...
    def clone(self) -> typing.Optional['QgsVectorLayer3DRenderer']: ...
    def type(self) -> str: ...
    def symbol(self) -> typing.Optional[_core.QgsAbstract3DSymbol]: ...
    def setSymbol(self, symbol: typing.Optional[_core.QgsAbstract3DSymbol]) -> None: ...


class QgsPointCloudLayer3DRenderer(_core.QgsAbstractPointCloud3DRenderer):

    def __init__(self) -> None: ...

    def zoomOutBehavior(self) -> _core.Qgis.PointCloudZoomOutRenderBehavior: ...
    def setZoomOutBehavior(self, behavior: _core.Qgis.PointCloudZoomOutRenderBehavior) -> None: ...
    def convertFrom2DRenderer(self, renderer: typing.Optional[_core.QgsPointCloudRenderer]) -> bool: ...
    def setPointRenderingBudget(self, budget: int) -> None: ...
    def pointRenderingBudget(self) -> int: ...
    def setShowBoundingBoxes(self, showBoundingBoxes: bool) -> None: ...
    def showBoundingBoxes(self) -> bool: ...
    def setMaximumScreenError(self, error: float) -> None: ...
    def maximumScreenError(self) -> float: ...
    def resolveReferences(self, project: _core.QgsProject) -> None: ...
    def readXml(self, elem: QtXml.QDomElement, context: _core.QgsReadWriteContext) -> None: ...
    def writeXml(self, elem: QtXml.QDomElement, context: _core.QgsReadWriteContext) -> None: ...
    def symbol(self) -> typing.Optional['QgsPointCloud3DSymbol']: ...
    def setSymbol(self, symbol: typing.Optional['QgsPointCloud3DSymbol']) -> None: ...
    def clone(self) -> typing.Optional['QgsPointCloudLayer3DRenderer']: ...
    def type(self) -> str: ...
    def layer(self) -> typing.Optional[_core.QgsPointCloudLayer]: ...
    def setLayer(self, layer: typing.Optional[_core.QgsPointCloudLayer]) -> None: ...


class QgsLightSource(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsLightSource') -> None: ...

    @staticmethod
    def createFromXml(element: QtXml.QDomElement, context: _core.QgsReadWriteContext) -> typing.Optional['QgsLightSource']: ...
    def resolveReferences(self, project: _core.QgsProject) -> None: ...
    def readXml(self, elem: QtXml.QDomElement, context: _core.QgsReadWriteContext = ...) -> None: ...
    def writeXml(self, doc: QtXml.QDomDocument, context: _core.QgsReadWriteContext = ...) -> QtXml.QDomElement: ...
    def clone(self) -> typing.Optional['QgsLightSource']: ...
    def type(self) -> _core.Qgis.LightSourceType: ...


class QgsDirectionalLightSettings(QgsLightSource):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsDirectionalLightSettings') -> None: ...

    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...
    def setIntensity(self, intensity: float) -> None: ...
    def intensity(self) -> float: ...
    def setColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, int]) -> None: ...
    def color(self) -> QtGui.QColor: ...
    def setDirection(self, direction: _core.QgsVector3D) -> None: ...
    def direction(self) -> _core.QgsVector3D: ...
    def readXml(self, elem: QtXml.QDomElement, context: _core.QgsReadWriteContext = ...) -> None: ...
    def writeXml(self, doc: QtXml.QDomDocument, context: _core.QgsReadWriteContext = ...) -> QtXml.QDomElement: ...
    def clone(self) -> typing.Optional['QgsDirectionalLightSettings']: ...
    def type(self) -> _core.Qgis.LightSourceType: ...


class QgsPointLightSettings(QgsLightSource):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsPointLightSettings') -> None: ...

    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...
    def setQuadraticAttenuation(self, value: float) -> None: ...
    def quadraticAttenuation(self) -> float: ...
    def setLinearAttenuation(self, value: float) -> None: ...
    def linearAttenuation(self) -> float: ...
    def setConstantAttenuation(self, value: float) -> None: ...
    def constantAttenuation(self) -> float: ...
    def setIntensity(self, intensity: float) -> None: ...
    def intensity(self) -> float: ...
    def setColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, int]) -> None: ...
    def color(self) -> QtGui.QColor: ...
    def setPosition(self, pos: _core.QgsVector3D) -> None: ...
    def position(self) -> _core.QgsVector3D: ...
    def readXml(self, elem: QtXml.QDomElement, context: _core.QgsReadWriteContext = ...) -> None: ...
    def writeXml(self, doc: QtXml.QDomDocument, context: _core.QgsReadWriteContext = ...) -> QtXml.QDomElement: ...
    def clone(self) -> typing.Optional['QgsPointLightSettings']: ...
    def type(self) -> _core.Qgis.LightSourceType: ...


class QgsMaterialContext(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsMaterialContext') -> None: ...

    def setSelectionColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, int]) -> None: ...
    def selectionColor(self) -> QtGui.QColor: ...
    def setIsSelected(self, isSelected: bool) -> None: ...
    def isSelected(self) -> bool: ...


class QgsAbstractMaterialSettings(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsAbstractMaterialSettings') -> None: ...

    def equals(self, other: typing.Optional['QgsAbstractMaterialSettings']) -> bool: ...
    def writeXml(self, element: QtXml.QDomElement, a1: _core.QgsReadWriteContext) -> None: ...
    def readXml(self, element: QtXml.QDomElement, a1: _core.QgsReadWriteContext) -> None: ...
    def clone(self) -> typing.Optional['QgsAbstractMaterialSettings']: ...
    def type(self) -> str: ...


class QgsGoochMaterialSettings(QgsAbstractMaterialSettings):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsGoochMaterialSettings') -> None: ...

    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...
    def toExportParameters(self) -> dict[str, str]: ...
    def writeXml(self, elem: QtXml.QDomElement, context: _core.QgsReadWriteContext) -> None: ...
    def readXml(self, elem: QtXml.QDomElement, context: _core.QgsReadWriteContext) -> None: ...
    def setBeta(self, beta: float) -> None: ...
    def setAlpha(self, alpha: float) -> None: ...
    def setShininess(self, shininess: float) -> None: ...
    def setSpecular(self, specular: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, int]) -> None: ...
    def setDiffuse(self, diffuse: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, int]) -> None: ...
    def setCool(self, cool: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, int]) -> None: ...
    def setWarm(self, warm: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, int]) -> None: ...
    def beta(self) -> float: ...
    def alpha(self) -> float: ...
    def shininess(self) -> float: ...
    def specular(self) -> QtGui.QColor: ...
    def diffuse(self) -> QtGui.QColor: ...
    def cool(self) -> QtGui.QColor: ...
    def warm(self) -> QtGui.QColor: ...
    def equals(self, other: typing.Optional[QgsAbstractMaterialSettings]) -> bool: ...
    def clone(self) -> typing.Optional['QgsGoochMaterialSettings']: ...
    @staticmethod
    def supportsTechnique(technique: QgsMaterialSettingsRenderingTechnique) -> bool: ...
    @staticmethod
    def create() -> typing.Optional[QgsAbstractMaterialSettings]: ...
    def type(self) -> str: ...


class QgsMaterialSettingsAbstractMetadata(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self, type: typing.Optional[str], visibleName: typing.Optional[str], icon: QtGui.QIcon = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsMaterialSettingsAbstractMetadata') -> None: ...

    def supportsTechnique(self, technique: QgsMaterialSettingsRenderingTechnique) -> bool: ...
    def create(self) -> typing.Optional[QgsAbstractMaterialSettings]: ...
    def icon(self) -> QtGui.QIcon: ...
    def visibleName(self) -> str: ...
    def type(self) -> str: ...


class QgsMaterialRegistry(PyQt6.sip.wrapper):

    def __init__(self) -> None: ...

    def createMaterialSettings(self, type: typing.Optional[str]) -> typing.Optional[QgsAbstractMaterialSettings]: ...
    def addMaterialSettingsType(self, metadata: typing.Optional[QgsMaterialSettingsAbstractMetadata]) -> bool: ...
    def materialSettingsTypes(self) -> list[str]: ...
    def materialSettingsMetadata(self, type: typing.Optional[str]) -> typing.Optional[QgsMaterialSettingsAbstractMetadata]: ...


class QgsMetalRoughMaterialSettings(QgsAbstractMaterialSettings):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsMetalRoughMaterialSettings') -> None: ...

    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...
    def writeXml(self, elem: QtXml.QDomElement, context: _core.QgsReadWriteContext) -> None: ...
    def readXml(self, elem: QtXml.QDomElement, context: _core.QgsReadWriteContext) -> None: ...
    def setRoughness(self, roughness: float) -> None: ...
    def setMetalness(self, metalness: float) -> None: ...
    def setBaseColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, int]) -> None: ...
    def toExportParameters(self) -> dict[str, str]: ...
    def roughness(self) -> float: ...
    def metalness(self) -> float: ...
    def baseColor(self) -> QtGui.QColor: ...
    def equals(self, other: typing.Optional[QgsAbstractMaterialSettings]) -> bool: ...
    def clone(self) -> typing.Optional['QgsMetalRoughMaterialSettings']: ...
    @staticmethod
    def create() -> typing.Optional[QgsAbstractMaterialSettings]: ...
    @staticmethod
    def supportsTechnique(technique: QgsMaterialSettingsRenderingTechnique) -> bool: ...
    def type(self) -> str: ...


class QgsNullMaterialSettings(QgsAbstractMaterialSettings):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsNullMaterialSettings') -> None: ...

    def toExportParameters(self) -> dict[str, str]: ...
    def equals(self, other: typing.Optional[QgsAbstractMaterialSettings]) -> bool: ...
    def clone(self) -> typing.Optional['QgsNullMaterialSettings']: ...
    @staticmethod
    def create() -> typing.Optional[QgsAbstractMaterialSettings]: ...
    @staticmethod
    def supportsTechnique(technique: QgsMaterialSettingsRenderingTechnique) -> bool: ...
    def type(self) -> str: ...


class QgsPhongMaterialSettings(QgsAbstractMaterialSettings):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsPhongMaterialSettings') -> None: ...

    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...
    def writeXml(self, elem: QtXml.QDomElement, context: _core.QgsReadWriteContext) -> None: ...
    def readXml(self, elem: QtXml.QDomElement, context: _core.QgsReadWriteContext) -> None: ...
    def setSpecularCoefficient(self, coefficient: float) -> None: ...
    def setDiffuseCoefficient(self, coefficient: float) -> None: ...
    def setAmbientCoefficient(self, coefficient: float) -> None: ...
    def setOpacity(self, opacity: float) -> None: ...
    def setShininess(self, shininess: float) -> None: ...
    def setSpecular(self, specular: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, int]) -> None: ...
    def setDiffuse(self, diffuse: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, int]) -> None: ...
    def setAmbient(self, ambient: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, int]) -> None: ...
    def toExportParameters(self) -> dict[str, str]: ...
    def specularCoefficient(self) -> float: ...
    def diffuseCoefficient(self) -> float: ...
    def ambientCoefficient(self) -> float: ...
    def opacity(self) -> float: ...
    def shininess(self) -> float: ...
    def specular(self) -> QtGui.QColor: ...
    def diffuse(self) -> QtGui.QColor: ...
    def ambient(self) -> QtGui.QColor: ...
    def equals(self, other: typing.Optional[QgsAbstractMaterialSettings]) -> bool: ...
    def clone(self) -> typing.Optional['QgsPhongMaterialSettings']: ...
    @staticmethod
    def create() -> typing.Optional[QgsAbstractMaterialSettings]: ...
    @staticmethod
    def supportsTechnique(technique: QgsMaterialSettingsRenderingTechnique) -> bool: ...
    def type(self) -> str: ...


class QgsPhongTexturedMaterialSettings(QgsAbstractMaterialSettings):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsPhongTexturedMaterialSettings') -> None: ...

    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...
    def writeXml(self, elem: QtXml.QDomElement, context: _core.QgsReadWriteContext) -> None: ...
    def readXml(self, elem: QtXml.QDomElement, context: _core.QgsReadWriteContext) -> None: ...
    def setOpacity(self, opacity: float) -> None: ...
    def setTextureRotation(self, rotation: float) -> None: ...
    def setTextureScale(self, scale: float) -> None: ...
    def setDiffuseTexturePath(self, path: typing.Optional[str]) -> None: ...
    def setShininess(self, shininess: float) -> None: ...
    def setSpecular(self, specular: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, int]) -> None: ...
    def setAmbient(self, ambient: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, int]) -> None: ...
    def opacity(self) -> float: ...
    def textureRotation(self) -> float: ...
    def requiresTextureCoordinates(self) -> bool: ...
    def textureScale(self) -> float: ...
    def diffuseTexturePath(self) -> str: ...
    def toExportParameters(self) -> dict[str, str]: ...
    def shininess(self) -> float: ...
    def specular(self) -> QtGui.QColor: ...
    def ambient(self) -> QtGui.QColor: ...
    def equals(self, other: typing.Optional[QgsAbstractMaterialSettings]) -> bool: ...
    def clone(self) -> typing.Optional['QgsPhongTexturedMaterialSettings']: ...
    @staticmethod
    def create() -> typing.Optional[QgsAbstractMaterialSettings]: ...
    @staticmethod
    def supportsTechnique(technique: QgsMaterialSettingsRenderingTechnique) -> bool: ...
    def type(self) -> str: ...


class QgsSimpleLineMaterialSettings(QgsAbstractMaterialSettings):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsSimpleLineMaterialSettings') -> None: ...

    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...
    def writeXml(self, elem: QtXml.QDomElement, context: _core.QgsReadWriteContext) -> None: ...
    def readXml(self, elem: QtXml.QDomElement, context: _core.QgsReadWriteContext) -> None: ...
    def toExportParameters(self) -> dict[str, str]: ...
    def setAmbient(self, ambient: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, int]) -> None: ...
    def ambient(self) -> QtGui.QColor: ...
    def equals(self, other: typing.Optional[QgsAbstractMaterialSettings]) -> bool: ...
    def clone(self) -> typing.Optional['QgsSimpleLineMaterialSettings']: ...
    @staticmethod
    def create() -> typing.Optional[QgsAbstractMaterialSettings]: ...
    @staticmethod
    def supportsTechnique(technique: QgsMaterialSettingsRenderingTechnique) -> bool: ...
    def type(self) -> str: ...


class QgsLine3DSymbol(_core.QgsAbstract3DSymbol):

    def __init__(self) -> None: ...

    def setMaterialSettings(self, materialSettings: typing.Optional[QgsAbstractMaterialSettings]) -> None: ...
    def materialSettings(self) -> typing.Optional[QgsAbstractMaterialSettings]: ...
    def setRenderAsSimpleLines(self, enabled: bool) -> None: ...
    def renderAsSimpleLines(self) -> bool: ...
    def setExtrusionHeight(self, extrusionHeight: float) -> None: ...
    def extrusionHeight(self) -> float: ...
    def setOffset(self, offset: float) -> None: ...
    def offset(self) -> float: ...
    @deprecated("""""")
    def setHeight(self, height: float) -> None: ...
    @deprecated("""""")
    def height(self) -> float: ...
    def setWidth(self, width: float) -> None: ...
    def width(self) -> float: ...
    def setAltitudeBinding(self, altBinding: _core.Qgis.AltitudeBinding) -> None: ...
    def altitudeBinding(self) -> _core.Qgis.AltitudeBinding: ...
    def setAltitudeClamping(self, altClamping: _core.Qgis.AltitudeClamping) -> None: ...
    def altitudeClamping(self) -> _core.Qgis.AltitudeClamping: ...
    def setDefaultPropertiesFromLayer(self, layer: typing.Optional[_core.QgsVectorLayer]) -> None: ...
    def compatibleGeometryTypes(self) -> list[_core.Qgis.GeometryType]: ...
    def readXml(self, elem: QtXml.QDomElement, context: _core.QgsReadWriteContext) -> None: ...
    def writeXml(self, elem: QtXml.QDomElement, context: _core.QgsReadWriteContext) -> None: ...
    def clone(self) -> typing.Optional[_core.QgsAbstract3DSymbol]: ...
    def type(self) -> str: ...
    @staticmethod
    def create() -> typing.Optional[_core.QgsAbstract3DSymbol]: ...


class QgsMesh3DSymbol(_core.QgsAbstract3DSymbol):

    class ZValueType(enum.IntEnum):
        VerticesZValue = ... # type: QgsMesh3DSymbol.ZValueType
        ScalarDatasetZvalue = ... # type: QgsMesh3DSymbol.ZValueType

    class RenderingStyle(enum.IntEnum):
        SingleColor = ... # type: QgsMesh3DSymbol.RenderingStyle
        ColorRamp = ... # type: QgsMesh3DSymbol.RenderingStyle
        ColorRamp2DRendering = ... # type: QgsMesh3DSymbol.RenderingStyle

    def __init__(self) -> None: ...

    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...
    def setLevelOfDetailIndex(self, lod: int) -> None: ...
    def levelOfDetailIndex(self) -> int: ...
    def setArrowsFixedSize(self, arrowsFixedSize: bool) -> None: ...
    def arrowsFixedSize(self) -> bool: ...
    def setMaximumTextureSize(self, maximumTextureSize: int) -> None: ...
    def maximumTextureSize(self) -> int: ...
    def setArrowsSpacing(self, arrowsSpacing: float) -> None: ...
    def arrowsSpacing(self) -> float: ...
    def setArrowsEnabled(self, arrowsEnabled: bool) -> None: ...
    def arrowsEnabled(self) -> bool: ...
    def setIsVerticalMagnitudeRelative(self, isVerticalMagnitudeRelative: bool) -> None: ...
    def isVerticalMagnitudeRelative(self) -> bool: ...
    def setVerticalDatasetGroupIndex(self, verticalDatasetGroupIndex: int) -> None: ...
    def verticalDatasetGroupIndex(self) -> int: ...
    def setRenderingStyle(self, textureType: 'QgsMesh3DSymbol.RenderingStyle') -> None: ...
    def renderingStyle(self) -> 'QgsMesh3DSymbol.RenderingStyle': ...
    def setSingleMeshColor(self, singleMeshColor: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, int]) -> None: ...
    def singleMeshColor(self) -> QtGui.QColor: ...
    def setColorRampShader(self, colorRampShader: _core.QgsColorRampShader) -> None: ...
    def colorRampShader(self) -> _core.QgsColorRampShader: ...
    def setVerticalScale(self, verticalScale: float) -> None: ...
    def verticalScale(self) -> float: ...
    def setWireframeLineColor(self, wireframeLineColor: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, int]) -> None: ...
    def wireframeLineColor(self) -> QtGui.QColor: ...
    def setWireframeLineWidth(self, wireframeLineWidth: float) -> None: ...
    def wireframeLineWidth(self) -> float: ...
    def setWireframeEnabled(self, wireframeEnabled: bool) -> None: ...
    def wireframeEnabled(self) -> bool: ...
    def setSmoothedTriangles(self, smoothTriangles: bool) -> None: ...
    def smoothedTriangles(self) -> bool: ...
    def setAddBackFaces(self, add: bool) -> None: ...
    def addBackFaces(self) -> bool: ...
    def setMaterialSettings(self, materialSettings: typing.Optional[QgsAbstractMaterialSettings]) -> None: ...
    def materialSettings(self) -> typing.Optional[QgsAbstractMaterialSettings]: ...
    def setHeight(self, height: float) -> None: ...
    def height(self) -> float: ...
    def setAltitudeClamping(self, altClamping: _core.Qgis.AltitudeClamping) -> None: ...
    def altitudeClamping(self) -> _core.Qgis.AltitudeClamping: ...
    def setCullingMode(self, mode: Qgs3DTypes.CullingMode) -> None: ...
    def cullingMode(self) -> Qgs3DTypes.CullingMode: ...
    def setEnabled(self, enabled: bool) -> None: ...
    def isEnabled(self) -> bool: ...
    def readXml(self, elem: QtXml.QDomElement, context: _core.QgsReadWriteContext) -> None: ...
    def writeXml(self, elem: QtXml.QDomElement, context: _core.QgsReadWriteContext) -> None: ...
    def clone(self) -> typing.Optional['QgsMesh3DSymbol']: ...
    def type(self) -> str: ...


class QgsPoint3DSymbol(_core.QgsAbstract3DSymbol):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QgsPoint3DSymbol') -> None: ...

    def billboardHeight(self) -> float: ...
    def setTransform(self, transform: QtGui.QMatrix4x4) -> None: ...
    def transform(self) -> QtGui.QMatrix4x4: ...
    def setBillboardSymbol(self, symbol: typing.Optional[_core.QgsMarkerSymbol]) -> None: ...
    def billboardSymbol(self) -> typing.Optional[_core.QgsMarkerSymbol]: ...
    def setShapeProperties(self, properties: dict[typing.Optional[str], typing.Any]) -> None: ...
    def shapeProperty(self, property: typing.Optional[str]) -> typing.Any: ...
    def shapeProperties(self) -> dict[str, typing.Any]: ...
    def setShape(self, shape: _core.Qgis.Point3DShape) -> None: ...
    def shape(self) -> _core.Qgis.Point3DShape: ...
    @staticmethod
    def shapeToString(shape: _core.Qgis.Point3DShape) -> str: ...
    @staticmethod
    def shapeFromString(shape: typing.Optional[str]) -> _core.Qgis.Point3DShape: ...
    def setMaterialSettings(self, materialSettings: typing.Optional[QgsAbstractMaterialSettings]) -> None: ...
    def materialSettings(self) -> typing.Optional[QgsAbstractMaterialSettings]: ...
    def setAltitudeClamping(self, altClamping: _core.Qgis.AltitudeClamping) -> None: ...
    def altitudeClamping(self) -> _core.Qgis.AltitudeClamping: ...
    def setDefaultPropertiesFromLayer(self, layer: typing.Optional[_core.QgsVectorLayer]) -> None: ...
    def compatibleGeometryTypes(self) -> list[_core.Qgis.GeometryType]: ...
    def readXml(self, elem: QtXml.QDomElement, context: _core.QgsReadWriteContext) -> None: ...
    def writeXml(self, elem: QtXml.QDomElement, context: _core.QgsReadWriteContext) -> None: ...
    def clone(self) -> typing.Optional[_core.QgsAbstract3DSymbol]: ...
    def type(self) -> str: ...
    @staticmethod
    def create() -> typing.Optional[_core.QgsAbstract3DSymbol]: ...


class QgsPolygon3DSymbol(_core.QgsAbstract3DSymbol):

    def __init__(self) -> None: ...

    def renderedFacade(self) -> int: ...
    def setRenderedFacade(self, side: int) -> None: ...
    def setEdgeColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, int]) -> None: ...
    def edgeColor(self) -> QtGui.QColor: ...
    def setEdgeWidth(self, width: float) -> None: ...
    def edgeWidth(self) -> float: ...
    def setEdgesEnabled(self, enabled: bool) -> None: ...
    def edgesEnabled(self) -> bool: ...
    def setAddBackFaces(self, add: bool) -> None: ...
    def addBackFaces(self) -> bool: ...
    def setInvertNormals(self, invert: bool) -> None: ...
    def invertNormals(self) -> bool: ...
    def setCullingMode(self, mode: Qgs3DTypes.CullingMode) -> None: ...
    def cullingMode(self) -> Qgs3DTypes.CullingMode: ...
    def setMaterialSettings(self, materialSettings: typing.Optional[QgsAbstractMaterialSettings]) -> None: ...
    def materialSettings(self) -> typing.Optional[QgsAbstractMaterialSettings]: ...
    def setExtrusionHeight(self, extrusionHeight: float) -> None: ...
    def extrusionHeight(self) -> float: ...
    def setOffset(self, offset: float) -> None: ...
    def offset(self) -> float: ...
    @deprecated("""""")
    def setHeight(self, height: float) -> None: ...
    @deprecated("""""")
    def height(self) -> float: ...
    def setAltitudeBinding(self, altBinding: _core.Qgis.AltitudeBinding) -> None: ...
    def altitudeBinding(self) -> _core.Qgis.AltitudeBinding: ...
    def setAltitudeClamping(self, altClamping: _core.Qgis.AltitudeClamping) -> None: ...
    def altitudeClamping(self) -> _core.Qgis.AltitudeClamping: ...
    @staticmethod
    def create() -> typing.Optional[_core.QgsAbstract3DSymbol]: ...
    def setDefaultPropertiesFromLayer(self, layer: typing.Optional[_core.QgsVectorLayer]) -> None: ...
    def compatibleGeometryTypes(self) -> list[_core.Qgis.GeometryType]: ...
    def readXml(self, elem: QtXml.QDomElement, context: _core.QgsReadWriteContext) -> None: ...
    def writeXml(self, elem: QtXml.QDomElement, context: _core.QgsReadWriteContext) -> None: ...
    def clone(self) -> typing.Optional[_core.QgsAbstract3DSymbol]: ...
    def type(self) -> str: ...


class QgsPointCloud3DSymbol(_core.QgsAbstract3DSymbol):

    class RenderingStyle(enum.IntEnum):
        NoRendering = ... # type: QgsPointCloud3DSymbol.RenderingStyle
        SingleColor = ... # type: QgsPointCloud3DSymbol.RenderingStyle
        ColorRamp = ... # type: QgsPointCloud3DSymbol.RenderingStyle
        RgbRendering = ... # type: QgsPointCloud3DSymbol.RenderingStyle
        Classification = ... # type: QgsPointCloud3DSymbol.RenderingStyle

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsPointCloud3DSymbol') -> None: ...

    def readBaseXml(self, elem: QtXml.QDomElement, context: _core.QgsReadWriteContext) -> None: ...
    def writeBaseXml(self, elem: QtXml.QDomElement, context: _core.QgsReadWriteContext) -> None: ...
    def copyBaseSettings(self, destination: typing.Optional[_core.QgsAbstract3DSymbol]) -> None: ...
    def setVerticalFilterThreshold(self, verticalFilterThreshold: float) -> None: ...
    def verticalFilterThreshold(self) -> float: ...
    def setVerticalTriangleFilter(self, verticalTriangleFilter: bool) -> None: ...
    def verticalTriangleFilter(self) -> bool: ...
    def setHorizontalFilterThreshold(self, horizontalFilterThreshold: float) -> None: ...
    def horizontalFilterThreshold(self) -> float: ...
    def setHorizontalTriangleFilter(self, horizontalTriangleFilter: bool) -> None: ...
    def horizontalTriangleFilter(self) -> bool: ...
    def setRenderAsTriangles(self, asTriangles: bool) -> None: ...
    def renderAsTriangles(self) -> bool: ...
    def byteStride(self) -> int: ...
    def setPointSize(self, size: float) -> None: ...
    def pointSize(self) -> float: ...
    def symbolType(self) -> str: ...
    def type(self) -> str: ...


class QgsSingleColorPointCloud3DSymbol(QgsPointCloud3DSymbol):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsSingleColorPointCloud3DSymbol') -> None: ...

    def byteStride(self) -> int: ...
    def setSingleColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, int]) -> None: ...
    def singleColor(self) -> QtGui.QColor: ...
    def readXml(self, elem: QtXml.QDomElement, context: _core.QgsReadWriteContext) -> None: ...
    def writeXml(self, elem: QtXml.QDomElement, context: _core.QgsReadWriteContext) -> None: ...
    def clone(self) -> typing.Optional[_core.QgsAbstract3DSymbol]: ...
    def symbolType(self) -> str: ...


class QgsColorRampPointCloud3DSymbol(QgsPointCloud3DSymbol):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsColorRampPointCloud3DSymbol') -> None: ...

    def byteStride(self) -> int: ...
    def setColorRampShaderMinMax(self, min: float, max: float) -> None: ...
    def colorRampShaderMax(self) -> float: ...
    def colorRampShaderMin(self) -> float: ...
    def setColorRampShader(self, colorRampShader: _core.QgsColorRampShader) -> None: ...
    def colorRampShader(self) -> _core.QgsColorRampShader: ...
    def setAttribute(self, attribute: typing.Optional[str]) -> None: ...
    def attribute(self) -> str: ...
    def readXml(self, elem: QtXml.QDomElement, context: _core.QgsReadWriteContext) -> None: ...
    def writeXml(self, elem: QtXml.QDomElement, context: _core.QgsReadWriteContext) -> None: ...
    def symbolType(self) -> str: ...
    def clone(self) -> typing.Optional[_core.QgsAbstract3DSymbol]: ...


class QgsRgbPointCloud3DSymbol(QgsPointCloud3DSymbol):

    def __init__(self) -> None: ...

    def setBlueContrastEnhancement(self, enhancement: typing.Optional[_core.QgsContrastEnhancement]) -> None: ...
    def blueContrastEnhancement(self) -> typing.Optional[_core.QgsContrastEnhancement]: ...
    def setGreenContrastEnhancement(self, enhancement: typing.Optional[_core.QgsContrastEnhancement]) -> None: ...
    def greenContrastEnhancement(self) -> typing.Optional[_core.QgsContrastEnhancement]: ...
    def setRedContrastEnhancement(self, enhancement: typing.Optional[_core.QgsContrastEnhancement]) -> None: ...
    def redContrastEnhancement(self) -> typing.Optional[_core.QgsContrastEnhancement]: ...
    def setBlueAttribute(self, attribute: typing.Optional[str]) -> None: ...
    def blueAttribute(self) -> str: ...
    def setGreenAttribute(self, attribute: typing.Optional[str]) -> None: ...
    def greenAttribute(self) -> str: ...
    def setRedAttribute(self, attribute: typing.Optional[str]) -> None: ...
    def redAttribute(self) -> str: ...
    def byteStride(self) -> int: ...
    def readXml(self, elem: QtXml.QDomElement, context: _core.QgsReadWriteContext) -> None: ...
    def writeXml(self, elem: QtXml.QDomElement, context: _core.QgsReadWriteContext) -> None: ...
    def clone(self) -> typing.Optional[_core.QgsAbstract3DSymbol]: ...
    def symbolType(self) -> str: ...


class QgsClassificationPointCloud3DSymbol(QgsPointCloud3DSymbol):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsClassificationPointCloud3DSymbol') -> None: ...

    def byteStride(self) -> int: ...
    def getFilteredOutCategories(self) -> list[_core.QgsPointCloudCategory]: ...
    def setCategoriesList(self, categories: collections.abc.Iterable[_core.QgsPointCloudCategory]) -> None: ...
    def categoriesList(self) -> list[_core.QgsPointCloudCategory]: ...
    def setAttribute(self, attribute: typing.Optional[str]) -> None: ...
    def attribute(self) -> str: ...
    def readXml(self, elem: QtXml.QDomElement, context: _core.QgsReadWriteContext) -> None: ...
    def writeXml(self, elem: QtXml.QDomElement, context: _core.QgsReadWriteContext) -> None: ...
    def symbolType(self) -> str: ...
    def clone(self) -> typing.Optional[_core.QgsAbstract3DSymbol]: ...


class Qgs3DTerrainAbstractMetadata(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self, type: typing.Optional[str], visibleName: typing.Optional[str], icon: QtGui.QIcon = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'Qgs3DTerrainAbstractMetadata') -> None: ...

    def createTerrainSettings(self) -> typing.Optional['QgsAbstractTerrainSettings']: ...
    def icon(self) -> QtGui.QIcon: ...
    def visibleName(self) -> str: ...
    def type(self) -> str: ...


class Qgs3DTerrainRegistry(PyQt6.sip.wrapper):

    def __init__(self) -> None: ...

    def configureTerrainFromProject(self, properties: typing.Optional[_core.QgsProjectElevationProperties]) -> typing.Optional['QgsAbstractTerrainSettings']: ...
    def createTerrainSettings(self, type: typing.Optional[str]) -> typing.Optional['QgsAbstractTerrainSettings']: ...
    def addType(self, metadata: typing.Optional[Qgs3DTerrainAbstractMetadata]) -> bool: ...
    def types(self) -> list[str]: ...
    def terrainMetadata(self, type: typing.Optional[str]) -> typing.Optional[Qgs3DTerrainAbstractMetadata]: ...


class QgsAbstractTerrainSettings(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsAbstractTerrainSettings') -> None: ...

    def equalsCommon(self, other: typing.Optional['QgsAbstractTerrainSettings']) -> bool: ...
    def copyCommonProperties(self, source: typing.Optional['QgsAbstractTerrainSettings']) -> None: ...
    def readCommonProperties(self, element: QtXml.QDomElement, context: _core.QgsReadWriteContext) -> None: ...
    def writeCommonProperties(self, element: QtXml.QDomElement, context: _core.QgsReadWriteContext) -> None: ...
    def elevationOffset(self) -> float: ...
    def setElevationOffset(self, offset: float) -> None: ...
    def maximumGroundError(self) -> float: ...
    def setMaximumGroundError(self, error: float) -> None: ...
    def maximumScreenError(self) -> float: ...
    def setMaximumScreenError(self, error: float) -> None: ...
    def mapTileResolution(self) -> int: ...
    def setMapTileResolution(self, resolution: int) -> None: ...
    def verticalScale(self) -> float: ...
    def setVerticalScale(self, scale: float) -> None: ...
    def resolveReferences(self, project: typing.Optional[_core.QgsProject]) -> None: ...
    def writeXml(self, element: QtXml.QDomElement, context: _core.QgsReadWriteContext) -> None: ...
    def readXml(self, element: QtXml.QDomElement, context: _core.QgsReadWriteContext) -> None: ...
    def equals(self, other: typing.Optional['QgsAbstractTerrainSettings']) -> bool: ...
    def type(self) -> str: ...
    def clone(self) -> typing.Optional['QgsAbstractTerrainSettings']: ...


class QgsDemTerrainSettings(QgsAbstractTerrainSettings):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsDemTerrainSettings') -> None: ...

    def skirtHeight(self) -> float: ...
    def setSkirtHeight(self, height: float) -> None: ...
    def resolution(self) -> int: ...
    def setResolution(self, resolution: int) -> None: ...
    def layer(self) -> typing.Optional[_core.QgsRasterLayer]: ...
    def setLayer(self, layer: typing.Optional[_core.QgsRasterLayer]) -> None: ...
    def equals(self, other: typing.Optional[QgsAbstractTerrainSettings]) -> bool: ...
    def resolveReferences(self, project: typing.Optional[_core.QgsProject]) -> None: ...
    def writeXml(self, element: QtXml.QDomElement, context: _core.QgsReadWriteContext) -> None: ...
    def readXml(self, element: QtXml.QDomElement, context: _core.QgsReadWriteContext) -> None: ...
    def type(self) -> str: ...
    def clone(self) -> typing.Optional['QgsDemTerrainSettings']: ...
    @staticmethod
    def create() -> typing.Optional[QgsAbstractTerrainSettings]: ...


class QgsFlatTerrainSettings(QgsAbstractTerrainSettings):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsFlatTerrainSettings') -> None: ...

    def equals(self, other: typing.Optional[QgsAbstractTerrainSettings]) -> bool: ...
    def writeXml(self, element: QtXml.QDomElement, context: _core.QgsReadWriteContext) -> None: ...
    def readXml(self, element: QtXml.QDomElement, context: _core.QgsReadWriteContext) -> None: ...
    def type(self) -> str: ...
    def clone(self) -> typing.Optional['QgsFlatTerrainSettings']: ...
    @staticmethod
    def create() -> typing.Optional[QgsAbstractTerrainSettings]: ...


class QgsMeshTerrainSettings(QgsAbstractTerrainSettings):

    def __init__(self) -> None: ...

    def setSymbol(self, symbol: typing.Optional[QgsMesh3DSymbol]) -> None: ...
    def symbol(self) -> typing.Optional[QgsMesh3DSymbol]: ...
    def layer(self) -> typing.Optional[_core.QgsMeshLayer]: ...
    def setLayer(self, layer: typing.Optional[_core.QgsMeshLayer]) -> None: ...
    def equals(self, other: typing.Optional[QgsAbstractTerrainSettings]) -> bool: ...
    def resolveReferences(self, project: typing.Optional[_core.QgsProject]) -> None: ...
    def writeXml(self, element: QtXml.QDomElement, context: _core.QgsReadWriteContext) -> None: ...
    def readXml(self, element: QtXml.QDomElement, context: _core.QgsReadWriteContext) -> None: ...
    def type(self) -> str: ...
    def clone(self) -> typing.Optional['QgsMeshTerrainSettings']: ...
    @staticmethod
    def create() -> typing.Optional[QgsAbstractTerrainSettings]: ...


class QgsOnlineDemTerrainSettings(QgsAbstractTerrainSettings):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsOnlineDemTerrainSettings') -> None: ...

    def skirtHeight(self) -> float: ...
    def setSkirtHeight(self, height: float) -> None: ...
    def resolution(self) -> int: ...
    def setResolution(self, resolution: int) -> None: ...
    def equals(self, other: typing.Optional[QgsAbstractTerrainSettings]) -> bool: ...
    def writeXml(self, element: QtXml.QDomElement, context: _core.QgsReadWriteContext) -> None: ...
    def readXml(self, element: QtXml.QDomElement, context: _core.QgsReadWriteContext) -> None: ...
    def type(self) -> str: ...
    def clone(self) -> typing.Optional['QgsOnlineDemTerrainSettings']: ...
    @staticmethod
    def create() -> typing.Optional[QgsAbstractTerrainSettings]: ...


class QgsQuantizedMeshTerrainSettings(QgsAbstractTerrainSettings):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsQuantizedMeshTerrainSettings') -> None: ...

    def layer(self) -> typing.Optional[_core.QgsTiledSceneLayer]: ...
    def setLayer(self, layer: typing.Optional[_core.QgsTiledSceneLayer]) -> None: ...
    def equals(self, other: typing.Optional[QgsAbstractTerrainSettings]) -> bool: ...
    def resolveReferences(self, project: typing.Optional[_core.QgsProject]) -> None: ...
    def writeXml(self, element: QtXml.QDomElement, context: _core.QgsReadWriteContext) -> None: ...
    def readXml(self, element: QtXml.QDomElement, context: _core.QgsReadWriteContext) -> None: ...
    def type(self) -> str: ...
    def clone(self) -> typing.Optional['QgsQuantizedMeshTerrainSettings']: ...
    @staticmethod
    def create() -> typing.Optional[QgsAbstractTerrainSettings]: ...


class Qgs3DMapExportSettings(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'Qgs3DMapExportSettings') -> None: ...

    def setScale(self, scale: float) -> None: ...
    def setTerrainTextureResolution(self, resolution: int) -> None: ...
    def setExportTextures(self, exportTextures: bool) -> None: ...
    def setExportNormals(self, exportNormals: bool) -> None: ...
    def setSmoothEdges(self, smoothEdges: bool) -> None: ...
    def setTerrainResolution(self, resolution: int) -> None: ...
    def setSceneFolderPath(self, sceneFolderPath: typing.Optional[str]) -> None: ...
    def setSceneName(self, sceneName: typing.Optional[str]) -> None: ...
    def scale(self) -> float: ...
    def terrainTextureResolution(self) -> int: ...
    def exportTextures(self) -> bool: ...
    def exportNormals(self) -> bool: ...
    def smoothEdges(self) -> bool: ...
    def terrrainResolution(self) -> int: ...
    def sceneFolderPath(self) -> str: ...
    def sceneName(self) -> str: ...
