pragma Singleton

import QtQuick
import Quickshell

Singleton {
  id: root

  readonly property string defaultIcon: "skull"

  readonly property var aliases: {
    "close": "x",
    "check": "check",
    "settings": "settings",
    "refresh": "refresh",
    "add": "plus",
    "trash": "trash",
    "menu": "menu-2",
    "person": "user",
    "folder-open": "folder-open",
    "download": "download",
    "toast-notice": "circle-check",
    "toast-warning": "alert-circle",
    "toast-error": "circle-x",
    "question-mark": "question-mark",
    "search": "search",
    "warning": "exclamation-circle",
    "stop": "player-stop-filled",
    "busy": "hourglass-empty",
    "media-pause": "player-pause-filled",
    "media-play": "player-play-filled",
    "media-prev": "player-skip-back-filled",
    "media-next": "player-skip-forward-filled",
    "download-speed": "download",
    "upload-speed": "upload",
    "cpu-usage": "brand-speedtest",
    "cpu-temperature": "flame",
    "gpu-temperature": "device-desktop",
    "memory": "cpu",
    "performance": "gauge",
    "balanced": "scale",
    "powersaver": "leaf",
    "storage": "database",
    "ethernet": "sitemap",
    "ethernet-off": "sitemap-off",
    "keyboard": "keyboard",
    "shutdown": "power",
    "lock": "lock",
    "lock-pause": "lock-pause",
    "logout": "logout",
    "reboot": "refresh",
    "suspend": "player-pause",
    "hibernate": "zzz",
    "nightlight-on": "moon",
    "nightlight-off": "moon-off",
    "nightlight-forced": "moon-stars",
    "bell": "bell",
    "bell-off": "bell-off",
    "keep-awake-on": "mug",
    "keep-awake-off": "mug-off",
    "disc": "disc-filled",
    "eye": "eye",
    "pin": "pin",
    "unpin": "pinned-off",
    "image": "photo",
    "dark-mode": "contrast-filled",
    "camera-video": "video",
    "wallpaper-selector": "library-photo",
    "color-picker": "color-picker",
    "chevron-left": "chevron-left",
    "chevron-right": "chevron-right",
    "chevron-up": "chevron-up",
    "chevron-down": "chevron-down",
    "caret-up": "caret-up-filled",
    "caret-down": "caret-down-filled",
    "caret-left": "caret-left-filled",
    "caret-right": "caret-right-filled",
    "star": "star",
    "star-off": "star-off",
    "battery-exclamation": "battery-exclamation",
    "common.charging": "common.charging",
    "battery-4": "battery-4",
    "battery-3": "battery-3",
    "battery-2": "battery-2",
    "battery-1": "battery-1",
    "battery": "battery",
    "wifi-0": "wifi-0",
    "wifi-1": "wifi-1",
    "wifi-2": "wifi-2",
    "wifi-off": "wifi-off",
    "wifi": "wifi",
    "microphone": "microphone",
    "microphone-mute": "microphone-off",
    "volume-mute": "volume-off",
    "volume-x": "volume-3",
    "volume-zero": "volume-3",
    "volume-low": "volume-2",
    "volume-high": "volume",
    "weather-sun": "sun",
    "weather-cloud": "cloud",
    "weather-cloud-haze": "cloud-fog",
    "weather-cloud-lightning": "cloud-bolt",
    "weather-cloud-rain": "cloud-rain",
    "weather-cloud-snow": "cloud-snow",
    "weather-cloud-sun": "cloud-sun",
    "brightness-low": "brightness-down-filled",
    "brightness-high": "brightness-up-filled",
    "settings-general": "adjustments-horizontal",
    "settings-bar": "crop-16-9",
    "settings-user-interface": "layout-board",
    "settings-control-center": "adjustments-horizontal",
    "settings-dock": "layout-bottombar",
    "settings-launcher": "rocket",
    "settings-audio": "device-speaker",
    "settings-display": "device-desktop",
    "settings-network": "sitemap",
    "settings-brightness": "brightness-up",
    "settings-location": "world-pin",
    "settings-color-scheme": "palette",
    "settings-wallpaper": "paint",
    "settings-wallpaper-selector": "library-photo",
    "settings-hooks": "link",
    "settings-notifications": "bell",
    "settings-osd": "picture-in-picture",
    "settings-about": "info-square-rounded",
    "settings-lock-screen": "lock",
    "settings-session-menu": "power",
    "settings-system-monitor": "activity",
    "bluetooth": "bluetooth",
    "bt-device-generic": "bluetooth",
    "bt-device-gamepad": "device-gamepad-2",
    "bt-device-microphone": "microphone",
    "bt-device-headset": "headset",
    "bt-device-earbuds": "device-airpods",
    "bt-device-headphones": "headphones",
    "bt-device-mouse": "mouse-2",
    "bt-device-keyboard": "bluetooth",
    "bt-device-phone": "device-mobile",
    "bt-device-watch": "device-watch",
    "bt-device-speaker": "device-speaker",
    "bt-device-tv": "device-tv",
    "antenna-bars-1": "antenna-bars-1",
    "antenna-bars-2": "antenna-bars-2",
    "antenna-bars-3": "antenna-bars-3",
    "antenna-bars-4": "antenna-bars-4",
    "antenna-bars-5": "antenna-bars-5",
    "antenna-bars-off": "antenna-bars-off",
    "noctalia": "noctalia",
    "hyprland": "hyprland",
    "filepicker-folder": "folder",
    "filepicker-refresh": "refresh",
    "filepicker-close": "x",
    "filepicker-arrow-left": "arrow-left",
    "filepicker-arrow-up": "arrow-up",
    "filepicker-home": "home",
    "filepicker-layout-grid": "layout-grid",
    "filepicker-list": "list",
    "filepicker-search": "search",
    "filepicker-x": "x",
    "filepicker-photo": "photo",
    "filepicker-check": "check",
    "filepicker-file-text": "file-text",
    "filepicker-video": "video",
    "filepicker-music": "music",
    "filepicker-archive": "archive",
    "filepicker-table": "table",
    "filepicker-presentation": "presentation",
    "filepicker-code": "code",
    "filepicker-settings": "settings",
    "filepicker-file": "file",
    "filepicker-text": "file-text",
    "filepicker-eye": "eye",
    "filepicker-eye-off": "eye-off",
    "filepicker-folder-current": "checks",
    "plugin": "plug-connected"
  }

  // Fonts Codepoints - do not change!
  // Some icons have been disabled because Qt's text rendering engine recognizes
  // some ranges as special Unicode characters at a very low level.
  // ex: fe00-fe2f
  readonly property var icons: {
    "123": "\u{f554}",
    "360": "\u{f62f}",
    "12-hours": "\u{fc53}",
    "24-hours": "\u{f5e7}",
    "2fa": "\u{eca0}",
    "360-view": "\u{f566}",
    "3d-cube-sphere": "\u{ecd7}",
    "3d-cube-sphere-off": "\u{f3b5}",
    "3d-rotate": "\u{f020}",
    "a-b": "\u{ec36}",
    "a-b-2": "\u{f25f}",
    "a-b-off": "\u{f0a6}",
    "abacus": "\u{f05c}",
    "abacus-off": "\u{f3b6}",
    "abc": "\u{f567}",
    "access-point": "\u{ed1b}",
    "access-point-off": "\u{ed1a}",
    "accessible": "\u{eba9}",
    "accessible-filled": "\u{f6ea}",
    "accessible-off": "\u{f0a7}",
    "activity": "\u{ed23}",
    "activity-heartbeat": "\u{f0db}",
    "ad": "\u{ea02}",
    "ad-2": "\u{ef1f}",
    "ad-circle": "\u{f79e}",
    "ad-circle-filled": "\u{f7d3}",
    "ad-circle-off": "\u{f79d}",
    "ad-filled": "\u{f6eb}",
    "ad-off": "\u{f3b7}",
    "address-book": "\u{f021}",
    "address-book-off": "\u{f3b8}",
    "adjustments": "\u{ea03}",
    "adjustments-alt": "\u{ec37}",
    "adjustments-bolt": "\u{f7fb}",
    "adjustments-cancel": "\u{f7fc}",
    "adjustments-check": "\u{f7fd}",
    "adjustments-code": "\u{f7fe}",
    "adjustments-cog": "\u{f7ff}",
    "adjustments-dollar": "\u{f800}",
    "adjustments-down": "\u{f801}",
    "adjustments-exclamation": "\u{f802}",
    "adjustments-filled": "\u{f6ec}",
    "adjustments-heart": "\u{f803}",
    "adjustments-horizontal": "\u{ec38}",
    "adjustments-minus": "\u{f804}",
    "adjustments-off": "\u{f0a8}",
    "adjustments-pause": "\u{f805}",
    "adjustments-pin": "\u{f806}",
    "adjustments-plus": "\u{f807}",
    "adjustments-question": "\u{f808}",
    "adjustments-search": "\u{f809}",
    "adjustments-share": "\u{f80a}",
    "adjustments-spark": "\u{ffbe}",
    "adjustments-star": "\u{f80b}",
    "adjustments-up": "\u{f80c}",
    "adjustments-x": "\u{f80d}",
    "aerial-lift": "\u{edfe}",
    "aerial-lift-filled": "\u{10101}",
    "affiliate": "\u{edff}",
    "affiliate-filled": "\u{f6ed}",
    "ai": "\u{fee7}",
    "air-balloon": "\u{f4a6}",
    "air-balloon-filled": "\u{10100}",
    "air-conditioning": "\u{f3a2}",
    "air-conditioning-disabled": "\u{f542}",
    "air-traffic-control": "\u{fb01}",
    "alarm": "\u{ea04}",
    "alarm-average": "\u{fc9e}",
    "alarm-filled": "\u{f709}",
    "alarm-minus": "\u{f630}",
    "alarm-minus-filled": "\u{f70a}",
    "alarm-off": "\u{f0a9}",
    "alarm-plus": "\u{f631}",
    "alarm-plus-filled": "\u{f70b}",
    "alarm-smoke": "\u{100b6}",
    "alarm-snooze": "\u{f632}",
    "alarm-snooze-filled": "\u{f70c}",
    "album": "\u{f022}",
    "album-off": "\u{f3b9}",
    "alert-circle": "\u{ea05}",
    "alert-circle-filled": "\u{f6ee}",
    "alert-circle-off": "\u{fc65}",
    "alert-hexagon": "\u{f80e}",
    "alert-hexagon-filled": "\u{fa34}",
    "alert-hexagon-off": "\u{fc66}",
    "alert-octagon": "\u{ecc6}",
    "alert-octagon-filled": "\u{f6ef}",
    "alert-small": "\u{f80f}",
    "alert-small-off": "\u{fc67}",
    "alert-square": "\u{f811}",
    "alert-square-filled": "\u{fa35}",
    "alert-square-rounded": "\u{f810}",
    "alert-square-rounded-filled": "\u{fa36}",
    "alert-square-rounded-off": "\u{fc68}",
    "alert-triangle": "\u{ea06}",
    "alert-triangle-filled": "\u{f6f0}",
    "alert-triangle-off": "\u{fc69}",
    "alien": "\u{ebde}",
    "alien-filled": "\u{f70d}",
    "align-box-bottom-center": "\u{f530}",
    "align-box-bottom-center-filled": "\u{f70e}",
    "align-box-bottom-left": "\u{f531}",
    "align-box-bottom-left-filled": "\u{f70f}",
    "align-box-bottom-right": "\u{f532}",
    "align-box-bottom-right-filled": "\u{f710}",
    "align-box-center-bottom": "\u{facb}",
    "align-box-center-middle": "\u{f79f}",
    "align-box-center-middle-filled": "\u{f7d4}",
    "align-box-center-stretch": "\u{facc}",
    "align-box-center-top": "\u{facd}",
    "align-box-left-bottom": "\u{f533}",
    "align-box-left-bottom-filled": "\u{f711}",
    "align-box-left-middle": "\u{f534}",
    "align-box-left-middle-filled": "\u{f712}",
    "align-box-left-stretch": "\u{face}",
    "align-box-left-top": "\u{f535}",
    "align-box-left-top-filled": "\u{f713}",
    "align-box-right-bottom": "\u{f536}",
    "align-box-right-bottom-filled": "\u{f714}",
    "align-box-right-middle": "\u{f537}",
    "align-box-right-middle-filled": "\u{f7d5}",
    "align-box-right-stretch": "\u{facf}",
    "align-box-right-top": "\u{f538}",
    "align-box-right-top-filled": "\u{f715}",
    "align-box-top-center": "\u{f539}",
    "align-box-top-center-filled": "\u{f716}",
    "align-box-top-left": "\u{f53a}",
    "align-box-top-left-filled": "\u{f717}",
    "align-box-top-right": "\u{f53b}",
    "align-box-top-right-filled": "\u{f718}",
    "align-center": "\u{ea07}",
    "align-justified": "\u{ea08}",
    "align-left": "\u{ea09}",
    "align-left-2": "\u{ff00}",
    "align-right": "\u{ea0a}",
    //"align-right-2": "\u{feff}",
    "alpha": "\u{f543}",
    "alphabet-arabic": "\u{ff2f}",
    "alphabet-bangla": "\u{ff2e}",
    "alphabet-cyrillic": "\u{f1df}",
    "alphabet-greek": "\u{f1e0}",
    "alphabet-hebrew": "\u{ff2d}",
    "alphabet-korean": "\u{ff2c}",
    "alphabet-latin": "\u{f1e1}",
    "alphabet-thai": "\u{ff2b}",
    "alt": "\u{fc54}",
    "ambulance": "\u{ebf5}",
    "ampersand": "\u{f229}",
    "analyze": "\u{f3a3}",
    "analyze-filled": "\u{f719}",
    "analyze-off": "\u{f3ba}",
    "anchor": "\u{eb76}",
    "anchor-off": "\u{f0f7}",
    "angle": "\u{ef20}",
    "ankh": "\u{f1cd}",
    "antenna": "\u{f094}",
    "antenna-bars-1": "\u{ecc7}",
    "antenna-bars-2": "\u{ecc8}",
    "antenna-bars-3": "\u{ecc9}",
    "antenna-bars-4": "\u{ecca}",
    "antenna-bars-5": "\u{eccb}",
    "antenna-bars-off": "\u{f0aa}",
    "antenna-off": "\u{f3bb}",
    "aperture": "\u{eb58}",
    "aperture-off": "\u{f3bc}",
    "api": "\u{effd}",
    "api-app": "\u{effc}",
    "api-app-off": "\u{f0ab}",
    "api-off": "\u{f0f8}",
    "app-window": "\u{efe6}",
    "app-window-filled": "\u{f71a}",
    "apple": "\u{ef21}",
    "apple-filled": "\u{10017}",
    "apps": "\u{ebb6}",
    "apps-filled": "\u{f6f1}",
    "apps-off": "\u{f0ac}",
    "archery-arrow": "\u{fc55}",
    "archive": "\u{ea0b}",
    "archive-filled": "\u{fa82}",
    "archive-off": "\u{f0ad}",
    "armchair": "\u{ef9e}",
    "armchair-2": "\u{efe7}",
    "armchair-2-off": "\u{f3bd}",
    "armchair-off": "\u{f3be}",
    "arrow-autofit-content": "\u{ef31}",
    "arrow-autofit-content-filled": "\u{f6f2}",
    "arrow-autofit-down": "\u{ef32}",
    "arrow-autofit-down-filled": "\u{10113}",
    "arrow-autofit-height": "\u{ef33}",
    "arrow-autofit-height-filled": "\u{10112}",
    "arrow-autofit-left": "\u{ef34}",
    "arrow-autofit-left-filled": "\u{10111}",
    "arrow-autofit-right": "\u{ef35}",
    "arrow-autofit-right-filled": "\u{10110}",
    "arrow-autofit-up": "\u{ef36}",
    "arrow-autofit-up-filled": "\u{1010f}",
    "arrow-autofit-width": "\u{ef37}",
    "arrow-autofit-width-filled": "\u{1010e}",
    "arrow-back": "\u{ea0c}",
    "arrow-back-up": "\u{eb77}",
    "arrow-back-up-double": "\u{f9ec}",
    "arrow-badge-down": "\u{f60b}",
    "arrow-badge-down-filled": "\u{f7d6}",
    "arrow-badge-left": "\u{f60c}",
    "arrow-badge-left-filled": "\u{f7d7}",
    "arrow-badge-right": "\u{f60d}",
    "arrow-badge-right-filled": "\u{f7d8}",
    "arrow-badge-up": "\u{f60e}",
    "arrow-badge-up-filled": "\u{f7d9}",
    "arrow-bar-both": "\u{fadd}",
    "arrow-bar-down": "\u{ea0d}",
    "arrow-bar-left": "\u{ea0e}",
    "arrow-bar-right": "\u{ea0f}",
    "arrow-bar-to-down": "\u{ec88}",
    "arrow-bar-to-down-dashed": "\u{10164}",
    "arrow-bar-to-left": "\u{ec89}",
    "arrow-bar-to-left-dashed": "\u{10163}",
    "arrow-bar-to-right": "\u{ec8a}",
    "arrow-bar-to-right-dashed": "\u{10162}",
    "arrow-bar-to-up": "\u{ec8b}",
    "arrow-bar-to-up-dashed": "\u{10161}",
    "arrow-bar-up": "\u{ea10}",
    "arrow-bear-left": "\u{f045}",
    "arrow-bear-left-2": "\u{f044}",
    "arrow-bear-right": "\u{f047}",
    "arrow-bear-right-2": "\u{f046}",
    "arrow-big-down": "\u{edda}",
    "arrow-big-down-filled": "\u{f6c6}",
    "arrow-big-down-line": "\u{efe8}",
    "arrow-big-down-line-filled": "\u{f6c7}",
    "arrow-big-down-lines": "\u{efe9}",
    "arrow-big-down-lines-filled": "\u{f6c8}",
    "arrow-big-left": "\u{eddb}",
    "arrow-big-left-filled": "\u{f6c9}",
    "arrow-big-left-line": "\u{efea}",
    "arrow-big-left-line-filled": "\u{f6ca}",
    "arrow-big-left-lines": "\u{efeb}",
    "arrow-big-left-lines-filled": "\u{f6cb}",
    "arrow-big-right": "\u{eddc}",
    "arrow-big-right-filled": "\u{f6cc}",
    "arrow-big-right-line": "\u{efec}",
    "arrow-big-right-line-filled": "\u{f6cd}",
    "arrow-big-right-lines": "\u{efed}",
    "arrow-big-right-lines-filled": "\u{f6ce}",
    "arrow-big-up": "\u{eddd}",
    "arrow-big-up-filled": "\u{f6cf}",
    "arrow-big-up-line": "\u{efee}",
    "arrow-big-up-line-filled": "\u{f6d0}",
    "arrow-big-up-lines": "\u{efef}",
    "arrow-big-up-lines-filled": "\u{f6d1}",
    "arrow-bounce": "\u{f3a4}",
    "arrow-capsule": "\u{fade}",
    "arrow-curve-left": "\u{f048}",
    "arrow-curve-right": "\u{f049}",
    "arrow-down": "\u{ea16}",
    "arrow-down-bar": "\u{ed98}",
    "arrow-down-circle": "\u{ea11}",
    "arrow-down-circle-filled": "\u{1003b}",
    "arrow-down-dashed": "\u{1006a}",
    "arrow-down-from-arc": "\u{fd86}",
    "arrow-down-left": "\u{ea13}",
    "arrow-down-left-circle": "\u{ea12}",
    "arrow-down-rhombus": "\u{f61d}",
    "arrow-down-rhombus-filled": "\u{1003a}",
    "arrow-down-right": "\u{ea15}",
    "arrow-down-right-circle": "\u{ea14}",
    "arrow-down-square": "\u{ed9a}",
    "arrow-down-square-filled": "\u{10039}",
    "arrow-down-tail": "\u{ed9b}",
    "arrow-down-to-arc": "\u{fd87}",
    "arrow-elbow-left": "\u{f9ed}",
    "arrow-elbow-right": "\u{f9ee}",
    "arrow-fork": "\u{f04a}",
    "arrow-forward": "\u{ea17}",
    "arrow-forward-up": "\u{eb78}",
    "arrow-forward-up-double": "\u{f9ef}",
    "arrow-guide": "\u{f22a}",
    "arrow-guide-filled": "\u{10038}",
    "arrow-iteration": "\u{f578}",
    "arrow-left": "\u{ea19}",
    "arrow-left-bar": "\u{ed9c}",
    "arrow-left-circle": "\u{ea18}",
    "arrow-left-circle-filled": "\u{10037}",
    "arrow-left-dashed": "\u{10069}",
    "arrow-left-from-arc": "\u{fd88}",
    "arrow-left-rhombus": "\u{f61e}",
    "arrow-left-rhombus-filled": "\u{10036}",
    "arrow-left-right": "\u{f04b}",
    "arrow-left-square": "\u{ed9d}",
    "arrow-left-square-filled": "\u{10035}",
    "arrow-left-tail": "\u{ed9e}",
    "arrow-left-to-arc": "\u{fd89}",
    "arrow-loop-left": "\u{ed9f}",
    "arrow-loop-left-2": "\u{f04c}",
    "arrow-loop-right": "\u{eda0}",
    "arrow-loop-right-2": "\u{f04d}",
    "arrow-merge": "\u{f04e}",
    "arrow-merge-alt-left": "\u{fc9f}",
    "arrow-merge-alt-right": "\u{fca0}",
    "arrow-merge-both": "\u{f23b}",
    "arrow-merge-left": "\u{f23c}",
    "arrow-merge-right": "\u{f23d}",
    "arrow-move-down": "\u{f2ba}",
    "arrow-move-down-filled": "\u{10034}",
    "arrow-move-left": "\u{f2bb}",
    "arrow-move-left-filled": "\u{10033}",
    "arrow-move-right": "\u{f2bc}",
    "arrow-move-right-filled": "\u{10032}",
    "arrow-move-up": "\u{f2bd}",
    "arrow-move-up-filled": "\u{10031}",
    "arrow-narrow-down": "\u{ea1a}",
    "arrow-narrow-down-dashed": "\u{10068}",
    "arrow-narrow-left": "\u{ea1b}",
    "arrow-narrow-left-dashed": "\u{10067}",
    "arrow-narrow-right": "\u{ea1c}",
    "arrow-narrow-right-dashed": "\u{10066}",
    "arrow-narrow-up": "\u{ea1d}",
    "arrow-narrow-up-dashed": "\u{10065}",
    "arrow-ramp-left": "\u{ed3c}",
    "arrow-ramp-left-2": "\u{f04f}",
    "arrow-ramp-left-3": "\u{f050}",
    "arrow-ramp-right": "\u{ed3d}",
    "arrow-ramp-right-2": "\u{f051}",
    "arrow-ramp-right-3": "\u{f052}",
    "arrow-right": "\u{ea1f}",
    "arrow-right-bar": "\u{eda1}",
    "arrow-right-circle": "\u{ea1e}",
    "arrow-right-circle-filled": "\u{10030}",
    "arrow-right-dashed": "\u{10064}",
    "arrow-right-from-arc": "\u{fd8a}",
    "arrow-right-rhombus": "\u{f61f}",
    "arrow-right-rhombus-filled": "\u{1002f}",
    "arrow-right-square": "\u{eda2}",
    "arrow-right-square-filled": "\u{1002e}",
    "arrow-right-tail": "\u{eda3}",
    "arrow-right-to-arc": "\u{fd8b}",
    "arrow-rotary-first-left": "\u{f053}",
    "arrow-rotary-first-right": "\u{f054}",
    "arrow-rotary-last-left": "\u{f055}",
    "arrow-rotary-last-right": "\u{f056}",
    "arrow-rotary-left": "\u{f057}",
    "arrow-rotary-right": "\u{f058}",
    "arrow-rotary-straight": "\u{f059}",
    "arrow-roundabout-left": "\u{f22b}",
    "arrow-roundabout-right": "\u{f22c}",
    "arrow-sharp-turn-left": "\u{f05a}",
    "arrow-sharp-turn-right": "\u{f05b}",
    "arrow-up": "\u{ea25}",
    "arrow-up-bar": "\u{eda4}",
    "arrow-up-circle": "\u{ea20}",
    "arrow-up-circle-filled": "\u{1002d}",
    "arrow-up-dashed": "\u{10063}",
    "arrow-up-from-arc": "\u{fd8c}",
    "arrow-up-left": "\u{ea22}",
    "arrow-up-left-circle": "\u{ea21}",
    "arrow-up-rhombus": "\u{f620}",
    "arrow-up-rhombus-filled": "\u{1002c}",
    "arrow-up-right": "\u{ea24}",
    "arrow-up-right-circle": "\u{ea23}",
    "arrow-up-square": "\u{eda6}",
    "arrow-up-square-filled": "\u{1002b}",
    "arrow-up-tail": "\u{eda7}",
    "arrow-up-to-arc": "\u{fd8d}",
    "arrow-wave-left-down": "\u{eda8}",
    "arrow-wave-left-up": "\u{eda9}",
    "arrow-wave-right-down": "\u{edaa}",
    "arrow-wave-right-up": "\u{edab}",
    "arrow-zig-zag": "\u{f4a7}",
    "arrows-cross": "\u{effe}",
    "arrows-diagonal": "\u{ea27}",
    "arrows-diagonal-2": "\u{ea26}",
    "arrows-diagonal-minimize": "\u{ef39}",
    "arrows-diagonal-minimize-2": "\u{ef38}",
    "arrows-diff": "\u{f296}",
    "arrows-double-ne-sw": "\u{edde}",
    "arrows-double-nw-se": "\u{eddf}",
    "arrows-double-se-nw": "\u{ede0}",
    "arrows-double-sw-ne": "\u{ede1}",
    "arrows-down": "\u{edad}",
    "arrows-down-up": "\u{edac}",
    "arrows-exchange": "\u{f1f4}",
    "arrows-exchange-2": "\u{f1f3}",
    "arrows-horizontal": "\u{eb59}",
    "arrows-join": "\u{edaf}",
    "arrows-join-2": "\u{edae}",
    "arrows-left": "\u{edb1}",
    "arrows-left-down": "\u{ee00}",
    "arrows-left-right": "\u{edb0}",
    "arrows-maximize": "\u{ea28}",
    "arrows-minimize": "\u{ea29}",
    "arrows-move": "\u{f22f}",
    "arrows-move-horizontal": "\u{f22d}",
    "arrows-move-vertical": "\u{f22e}",
    "arrows-random": "\u{f095}",
    "arrows-right": "\u{edb3}",
    "arrows-right-down": "\u{ee01}",
    "arrows-right-left": "\u{edb2}",
    "arrows-shuffle": "\u{f000}",
    "arrows-shuffle-2": "\u{efff}",
    "arrows-sort": "\u{eb5a}",
    "arrows-split": "\u{edb5}",
    "arrows-split-2": "\u{edb4}",
    "arrows-transfer-down": "\u{f2cc}",
    "arrows-transfer-up": "\u{f2cd}",
    "arrows-transfer-up-down": "\u{ffac}",
    "arrows-up": "\u{edb7}",
    "arrows-up-down": "\u{edb6}",
    "arrows-up-left": "\u{ee02}",
    "arrows-up-right": "\u{ee03}",
    "arrows-vertical": "\u{eb5b}",
    "artboard": "\u{ea2a}",
    "artboard-filled": "\u{fa83}",
    "artboard-off": "\u{f0ae}",
    "article": "\u{f1e2}",
    "article-filled": "\u{f7da}",
    "article-off": "\u{f3bf}",
    "aspect-ratio": "\u{ed30}",
    "aspect-ratio-filled": "\u{f7db}",
    "aspect-ratio-off": "\u{f0af}",
    "assembly": "\u{f24d}",
    "assembly-filled": "\u{fe9e}",
    "assembly-off": "\u{f3c0}",
    "asset": "\u{f1ce}",
    "asset-filled": "\u{fe9d}",
    "asterisk": "\u{efd5}",
    "asterisk-simple": "\u{efd4}",
    "at": "\u{ea2b}",
    "at-off": "\u{f0b0}",
    "atom": "\u{eb79}",
    "atom-2": "\u{ebdf}",
    "atom-2-filled": "\u{f71b}",
    "atom-off": "\u{f0f9}",
    "augmented-reality": "\u{f023}",
    "augmented-reality-2": "\u{f37e}",
    "augmented-reality-off": "\u{f3c1}",
    "auth-2fa": "\u{eca0}",
    "automatic-gearbox": "\u{fc89}",
    "automatic-gearbox-filled": "\u{1002a}",
    "automation": "\u{fef8}",
    "avocado": "\u{fd8e}",
    "award": "\u{ea2c}",
    "award-filled": "\u{f71c}",
    "award-off": "\u{f0fa}",
    "axe": "\u{ef9f}",
    "axis-x": "\u{ef45}",
    "axis-y": "\u{ef46}",
    "baby-bottle": "\u{f5d2}",
    "baby-carriage": "\u{f05d}",
    "baby-carriage-filled": "\u{fe9c}",
    "background": "\u{fd2c}",
    "backhoe": "\u{ed86}",
    "backpack": "\u{ef47}",
    "backpack-off": "\u{f3c2}",
    "backslash": "\u{fab9}",
    "backspace": "\u{ea2d}",
    "backspace-filled": "\u{f7dc}",
    "badge": "\u{efc2}",
    "badge-2k": "\u{100b5}",
    "badge-3d": "\u{f555}",
    "badge-3d-filled": "\u{fe9b}",
    "badge-3k": "\u{100b4}",
    "badge-4k": "\u{f556}",
    "badge-4k-filled": "\u{fe9a}",
    "badge-5k": "\u{100b3}",
    "badge-8k": "\u{f557}",
    "badge-8k-filled": "\u{fe99}",
    "badge-ad": "\u{f558}",
    "badge-ad-filled": "\u{fe98}",
    "badge-ad-off": "\u{fd8f}",
    "badge-ar": "\u{f559}",
    "badge-ar-filled": "\u{fe97}",
    "badge-cc": "\u{f55a}",
    "badge-cc-filled": "\u{fe96}",
    "badge-filled": "\u{f667}",
    "badge-hd": "\u{f55b}",
    "badge-hd-filled": "\u{fe95}",
    "badge-off": "\u{f0fb}",
    "badge-sd": "\u{f55c}",
    "badge-sd-filled": "\u{fe94}",
    "badge-tm": "\u{f55d}",
    "badge-tm-filled": "\u{fe93}",
    "badge-vo": "\u{f55e}",
    "badge-vo-filled": "\u{fe92}",
    "badge-vr": "\u{f55f}",
    "badge-vr-filled": "\u{fe91}",
    "badge-wc": "\u{f560}",
    "badge-wc-filled": "\u{fe90}",
    "badges": "\u{efc3}",
    "badges-filled": "\u{f7dd}",
    "badges-off": "\u{f0fc}",
    "baguette": "\u{f3a5}",
    "ball-american-football": "\u{ee04}",
    "ball-american-football-off": "\u{f3c3}",
    "ball-baseball": "\u{efa0}",
    "ball-basketball": "\u{ec28}",
    "ball-bowling": "\u{ec29}",
    "ball-football": "\u{ee06}",
    "ball-football-off": "\u{ee05}",
    "ball-tennis": "\u{ec2a}",
    "ball-volleyball": "\u{ec2b}",
    "balloon": "\u{ef3a}",
    "balloon-filled": "\u{fa84}",
    "balloon-off": "\u{f0fd}",
    "ballpen": "\u{f06e}",
    "ballpen-filled": "\u{fa85}",
    "ballpen-off": "\u{f0b1}",
    "ban": "\u{ea2e}",
    "bandage": "\u{eb7a}",
    "bandage-filled": "\u{f7de}",
    "bandage-off": "\u{f3c4}",
    "barbell": "\u{eff0}",
    "barbell-filled": "\u{fe8f}",
    "barbell-off": "\u{f0b2}",
    "barcode": "\u{ebc6}",
    "barcode-off": "\u{f0b3}",
    "barrel": "\u{f0b4}",
    "barrel-off": "\u{f0fe}",
    "barrier-block": "\u{f00e}",
    "barrier-block-filled": "\u{fe8e}",
    "barrier-block-off": "\u{f0b5}",
    "baseline": "\u{f024}",
    "baseline-density-large": "\u{f9f0}",
    "baseline-density-medium": "\u{f9f1}",
    "baseline-density-small": "\u{f9f2}",
    "basket": "\u{ebe1}",
    "basket-bolt": "\u{fb43}",
    "basket-cancel": "\u{fb44}",
    "basket-check": "\u{fb45}",
    "basket-code": "\u{fb46}",
    "basket-cog": "\u{fb47}",
    "basket-discount": "\u{fb48}",
    "basket-dollar": "\u{fb49}",
    "basket-down": "\u{fb4a}",
    "basket-exclamation": "\u{fb4b}",
    "basket-filled": "\u{f7df}",
    "basket-heart": "\u{fb4c}",
    "basket-minus": "\u{fb4d}",
    "basket-off": "\u{f0b6}",
    "basket-pause": "\u{fb4e}",
    "basket-pin": "\u{fb4f}",
    "basket-plus": "\u{fb50}",
    "basket-question": "\u{fb51}",
    "basket-search": "\u{fb52}",
    "basket-share": "\u{fb53}",
    "basket-star": "\u{fb54}",
    "basket-up": "\u{fb55}",
    "basket-x": "\u{fb56}",
    "bat": "\u{f284}",
    "bath": "\u{ef48}",
    "bath-filled": "\u{f71d}",
    "bath-off": "\u{f0ff}",
    "battery": "\u{ea34}",
    "battery-1": "\u{ea2f}",
    "battery-1-filled": "\u{f71e}",
    "battery-2": "\u{ea30}",
    "battery-2-filled": "\u{f71f}",
    "battery-3": "\u{ea31}",
    "battery-3-filled": "\u{f720}",
    "battery-4": "\u{ea32}",
    "battery-4-filled": "\u{f721}",
    "battery-automotive": "\u{ee07}",
    "battery-automotive-filled": "\u{10029}",
    "common.charging": "\u{ea33}",
    "battery-charging-2": "\u{ef3b}",
    "battery-eco": "\u{ef3c}",
    "battery-exclamation": "\u{ff1d}",
    "battery-filled": "\u{f668}",
    "battery-off": "\u{ed1c}",
    "battery-spark": "\u{ffbd}",
    "battery-vertical": "\u{ff13}",
    "battery-vertical-1": "\u{ff1c}",
    "battery-vertical-1-filled": "\u{10028}",
    "battery-vertical-2": "\u{ff1b}",
    "battery-vertical-2-filled": "\u{10027}",
    "battery-vertical-3": "\u{ff1a}",
    "battery-vertical-3-filled": "\u{10026}",
    "battery-vertical-4": "\u{ff19}",
    "battery-vertical-4-filled": "\u{10025}",
    "battery-vertical-charging": "\u{ff17}",
    "battery-vertical-charging-2": "\u{ff18}",
    "battery-vertical-eco": "\u{ff16}",
    "battery-vertical-exclamation": "\u{ff15}",
    "battery-vertical-filled": "\u{10024}",
    "battery-vertical-off": "\u{ff14}",
    "beach": "\u{ef3d}",
    "beach-off": "\u{f0b7}",
    "bed": "\u{eb5c}",
    "bed-filled": "\u{f7e0}",
    "bed-flat": "\u{fca1}",
    "bed-flat-filled": "\u{fe8d}",
    "bed-off": "\u{f100}",
    "beer": "\u{efa1}",
    "beer-filled": "\u{f7e1}",
    "beer-off": "\u{f101}",
    "bell": "\u{ea35}",
    "bell-bolt": "\u{f812}",
    "bell-cancel": "\u{f813}",
    "bell-check": "\u{f814}",
    "bell-code": "\u{f815}",
    "bell-cog": "\u{f816}",
    "bell-dollar": "\u{f817}",
    "bell-down": "\u{f818}",
    "bell-exclamation": "\u{f819}",
    "bell-filled": "\u{f669}",
    "bell-heart": "\u{f81a}",
    "bell-minus": "\u{ede2}",
    "bell-minus-filled": "\u{f722}",
    "bell-off": "\u{ece9}",
    "bell-pause": "\u{f81b}",
    "bell-pin": "\u{f81c}",
    "bell-plus": "\u{ede3}",
    "bell-plus-filled": "\u{f723}",
    "bell-question": "\u{f81d}",
    "bell-ringing": "\u{ed07}",
    "bell-ringing-2": "\u{ede4}",
    "bell-ringing-2-filled": "\u{f724}",
    "bell-ringing-filled": "\u{f725}",
    "bell-school": "\u{f05e}",
    "bell-search": "\u{f81e}",
    "bell-share": "\u{f81f}",
    "bell-star": "\u{f820}",
    "bell-up": "\u{f821}",
    "bell-x": "\u{ede5}",
    "bell-x-filled": "\u{f726}",
    "bell-z": "\u{eff1}",
    "bell-z-filled": "\u{f727}",
    "beta": "\u{f544}",
    "bible": "\u{efc4}",
    "bike": "\u{ea36}",
    "bike-filled": "\u{10023}",
    "bike-off": "\u{f0b8}",
    "binary": "\u{ee08}",
    "binary-off": "\u{f3c5}",
    "binary-tree": "\u{f5d4}",
    "binary-tree-2": "\u{f5d3}",
    "binary-tree-2-filled": "\u{ff65}",
    "binary-tree-filled": "\u{ff64}",
    "binoculars": "\u{fefe}",
    "binoculars-filled": "\u{ff0b}",
    "biohazard": "\u{ecb8}",
    "biohazard-filled": "\u{fe8c}",
    "biohazard-off": "\u{f0b9}",
    "blade": "\u{f4bd}",
    "blade-filled": "\u{f7e2}",
    "bleach": "\u{f2f3}",
    "bleach-chlorine": "\u{f2f0}",
    "bleach-no-chlorine": "\u{f2f1}",
    "bleach-off": "\u{f2f2}",
    "blend-mode": "\u{feb0}",
    "blender": "\u{fca2}",
    "blender-filled": "\u{10022}",
    "blob": "\u{feaf}",
    "blob-filled": "\u{feb1}",
    "blockquote": "\u{ee09}",
    "blocks": "\u{100b2}",
    "bluetooth": "\u{ea37}",
    "bluetooth-connected": "\u{ecea}",
    "bluetooth-off": "\u{eceb}",
    "bluetooth-x": "\u{f081}",
    "blur": "\u{ef8c}",
    "blur-off": "\u{f3c6}",
    "bmp": "\u{f3a6}",
    "body-scan": "\u{fca3}",
    "bold": "\u{eb7b}",
    "bold-off": "\u{f0ba}",
    "bolt": "\u{ea38}",
    "bolt-filled": "\u{10021}",
    "bolt-off": "\u{ecec}",
    "bomb": "\u{f59c}",
    "bomb-filled": "\u{fa86}",
    "bone": "\u{edb8}",
    "bone-filled": "\u{fe8b}",
    "bone-off": "\u{f0bb}",
    "bong": "\u{f3a7}",
    "bong-filled": "\u{10020}",
    "bong-off": "\u{f3c7}",
    "book": "\u{ea39}",
    "book-2": "\u{efc5}",
    "book-download": "\u{f070}",
    "book-filled": "\u{fa87}",
    "book-off": "\u{f0bc}",
    "book-upload": "\u{f071}",
    "bookmark": "\u{ea3a}",
    "bookmark-ai": "\u{fc8a}",
    "bookmark-edit": "\u{fa5e}",
    "bookmark-filled": "\u{fa88}",
    "bookmark-minus": "\u{fa5f}",
    "bookmark-off": "\u{eced}",
    "bookmark-plus": "\u{fa60}",
    "bookmark-question": "\u{fa61}",
    "bookmarks": "\u{ed08}",
    "bookmarks-filled": "\u{fb1f}",
    "bookmarks-off": "\u{f0bd}",
    "books": "\u{eff2}",
    "books-off": "\u{f0be}",
    "boom": "\u{fdbe}",
    "boom-filled": "\u{fe8a}",
    "border-all": "\u{ea3b}",
    "border-bottom": "\u{ea3c}",
    "border-bottom-plus": "\u{fdbd}",
    "border-corner-ios": "\u{fd98}",
    "border-corner-pill": "\u{fd62}",
    "border-corner-rounded": "\u{fd63}",
    "border-corner-square": "\u{fd64}",
    "border-corners": "\u{f7a0}",
    "border-horizontal": "\u{ea3d}",
    "border-inner": "\u{ea3e}",
    "border-left": "\u{ea3f}",
    "border-left-plus": "\u{fdbc}",
    "border-none": "\u{ea40}",
    "border-outer": "\u{ea41}",
    "border-radius": "\u{eb7c}",
    "border-right": "\u{ea42}",
    "border-right-plus": "\u{fdbb}",
    "border-sides": "\u{f7a1}",
    "border-style": "\u{ee0a}",
    "border-style-2": "\u{ef22}",
    "border-top": "\u{ea43}",
    "border-top-plus": "\u{fdba}",
    "border-vertical": "\u{ea44}",
    "bottle": "\u{ef0b}",
    "bottle-filled": "\u{fa89}",
    "bottle-off": "\u{f3c8}",
    "bounce-left": "\u{f59d}",
    "bounce-left-filled": "\u{fb20}",
    "bounce-right": "\u{f59e}",
    "bounce-right-filled": "\u{fb21}",
    "bow": "\u{f096}",
    "bow-filled": "\u{fe89}",
    "bowl": "\u{f4fa}",
    "bowl-chopsticks": "\u{fd90}",
    "bowl-chopsticks-filled": "\u{fe88}",
    "bowl-filled": "\u{fb22}",
    "bowl-spoon": "\u{fd91}",
    "bowl-spoon-filled": "\u{fe87}",
    "bowling": "\u{100b1}",
    "box": "\u{ea45}",
    "box-align-bottom": "\u{f2a8}",
    "box-align-bottom-filled": "\u{fa8a}",
    "box-align-bottom-left": "\u{f2ce}",
    "box-align-bottom-left-filled": "\u{fa8b}",
    "box-align-bottom-right": "\u{f2cf}",
    "box-align-bottom-right-filled": "\u{fa8c}",
    "box-align-left": "\u{f2a9}",
    "box-align-left-filled": "\u{fa8d}",
    "box-align-right": "\u{f2aa}",
    "box-align-right-filled": "\u{fa8e}",
    "box-align-top": "\u{f2ab}",
    "box-align-top-filled": "\u{fa8f}",
    "box-align-top-left": "\u{f2d0}",
    "box-align-top-left-filled": "\u{fa90}",
    "box-align-top-right": "\u{f2d1}",
    "box-align-top-right-filled": "\u{fa91}",
    "box-margin": "\u{ee0b}",
    "box-model": "\u{ee0c}",
    "box-model-2": "\u{ef23}",
    "box-model-2-off": "\u{f3c9}",
    "box-model-off": "\u{f3ca}",
    "box-multiple": "\u{ee17}",
    "box-multiple-0": "\u{ee0d}",
    "box-multiple-1": "\u{ee0e}",
    "box-multiple-2": "\u{ee0f}",
    "box-multiple-3": "\u{ee10}",
    "box-multiple-4": "\u{ee11}",
    "box-multiple-5": "\u{ee12}",
    "box-multiple-6": "\u{ee13}",
    "box-multiple-7": "\u{ee14}",
    "box-multiple-8": "\u{ee15}",
    "box-multiple-9": "\u{ee16}",
    "box-multiple-filled": "\u{1001f}",
    "box-off": "\u{f102}",
    "box-padding": "\u{ee18}",
    "box-seam": "\u{eaff}",
    "braces": "\u{ebcc}",
    "braces-off": "\u{f0bf}",
    "brackets": "\u{ebcd}",
    "brackets-angle": "\u{fcb2}",
    "brackets-angle-off": "\u{fcb1}",
    "brackets-contain": "\u{f1e5}",
    "brackets-contain-end": "\u{f1e3}",
    "brackets-contain-start": "\u{f1e4}",
    "brackets-off": "\u{f0c0}",
    "braille": "\u{f545}",
    "brain": "\u{f59f}",
    "brand-4chan": "\u{f494}",
    "brand-abstract": "\u{f495}",
    "brand-adobe": "\u{f0dc}",
    "brand-adobe-after-effect": "\u{ff2a}",
    "brand-adobe-illustrator": "\u{ff29}",
    "brand-adobe-indesign": "\u{ff28}",
    "brand-adobe-photoshop": "\u{ff27}",
    "brand-adobe-premier": "\u{ff26}",
    "brand-adobe-xd": "\u{ff25}",
    "brand-adonis-js": "\u{f496}",
    "brand-airbnb": "\u{ed68}",
    "brand-airtable": "\u{ef6a}",
    "brand-algolia": "\u{f390}",
    "brand-alipay": "\u{f7a2}",
    "brand-alpine-js": "\u{f324}",
    "brand-amazon": "\u{f230}",
    "brand-amd": "\u{f653}",
    "brand-amie": "\u{ffab}",
    "brand-amigo": "\u{f5f9}",
    "brand-among-us": "\u{f205}",
    "brand-android": "\u{ec16}",
    "brand-angular": "\u{ef6b}",
    "brand-angular-filled": "\u{10095}",
    "brand-ansible": "\u{fa70}",
    "brand-ao3": "\u{f5e8}",
    "brand-appgallery": "\u{f231}",
    "brand-apple": "\u{ec17}",
    "brand-apple-arcade": "\u{ed69}",
    "brand-apple-filled": "\u{fd74}",
    "brand-apple-news": "\u{ff24}",
    "brand-apple-podcast": "\u{f1e6}",
    "brand-appstore": "\u{ed24}",
    "brand-arc": "\u{feae}",
    "brand-asana": "\u{edc5}",
    "brand-astro": "\u{fdb9}",
    "brand-auth0": "\u{fcb3}",
    "brand-aws": "\u{fa4c}",
    "brand-azure": "\u{fa4d}",
    "brand-backbone": "\u{f325}",
    "brand-badoo": "\u{f206}",
    "brand-baidu": "\u{f5e9}",
    "brand-bandcamp": "\u{f207}",
    "brand-bandlab": "\u{f5fa}",
    "brand-beats": "\u{f208}",
    "brand-bebo": "\u{ffaa}",
    "brand-behance": "\u{ec6e}",
    "brand-bilibili": "\u{f6d2}",
    "brand-binance": "\u{f5a0}",
    "brand-bing": "\u{edc6}",
    "brand-bitbucket": "\u{edc7}",
    "brand-bitbucket-filled": "\u{100cb}",
    "brand-blackberry": "\u{f568}",
    "brand-blender": "\u{f326}",
    "brand-blogger": "\u{f35a}",
    "brand-bluesky": "\u{fd75}",
    "brand-booking": "\u{edc8}",
    "brand-bootstrap": "\u{ef3e}",
    "brand-bulma": "\u{f327}",
    "brand-bumble": "\u{f5fb}",
    "brand-bunpo": "\u{f4cf}",
    "brand-c-sharp": "\u{f003}",
    "brand-cake": "\u{f7a3}",
    "brand-cakephp": "\u{f7af}",
    "brand-campaignmonitor": "\u{f328}",
    "brand-carbon": "\u{f348}",
    "brand-cashapp": "\u{f391}",
    "brand-chrome": "\u{ec18}",
    "brand-cinema-4d": "\u{fa71}",
    "brand-citymapper": "\u{f5fc}",
    "brand-cloudflare": "\u{fa4e}",
    "brand-codecov": "\u{f329}",
    "brand-codepen": "\u{ec6f}",
    "brand-codesandbox": "\u{ed6a}",
    "brand-cohost": "\u{f5d5}",
    "brand-coinbase": "\u{f209}",
    "brand-comedy-central": "\u{f217}",
    "brand-coreos": "\u{f5fd}",
    "brand-couchdb": "\u{f60f}",
    "brand-couchsurfing": "\u{f392}",
    "brand-cpp": "\u{f5fe}",
    "brand-craft": "\u{fa72}",
    "brand-crunchbase": "\u{f7e3}",
    "brand-css3": "\u{ed6b}",
    "brand-ctemplar": "\u{f4d0}",
    "brand-cucumber": "\u{ef6c}",
    "brand-cupra": "\u{f4d1}",
    "brand-cypress": "\u{f333}",
    "brand-d3": "\u{f24e}",
    "brand-databricks": "\u{fc41}",
    "brand-days-counter": "\u{f4d2}",
    "brand-dcos": "\u{f32a}",
    "brand-debian": "\u{ef57}",
    "brand-deezer": "\u{f78b}",
    "brand-deliveroo": "\u{f4d3}",
    "brand-deno": "\u{f24f}",
    "brand-denodo": "\u{f610}",
    "brand-deviantart": "\u{ecfb}",
    "brand-digg": "\u{fa73}",
    "brand-dingtalk": "\u{f5ea}",
    "brand-discord": "\u{ece3}",
    "brand-discord-filled": "\u{f7e4}",
    "brand-disney": "\u{f20a}",
    "brand-disqus": "\u{edc9}",
    "brand-django": "\u{f349}",
    "brand-docker": "\u{edca}",
    "brand-doctrine": "\u{ef6d}",
    "brand-dolby-digital": "\u{f4d4}",
    "brand-douban": "\u{f5ff}",
    "brand-dribbble": "\u{ec19}",
    "brand-dribbble-filled": "\u{f7e5}",
    "brand-dropbox": "\u{1018a}",
    "brand-drops": "\u{f4d5}",
    "brand-drupal": "\u{f393}",
    "brand-edge": "\u{ecfc}",
    "brand-elastic": "\u{f611}",
    "brand-electronic-arts": "\u{fa74}",
    "brand-ember": "\u{f497}",
    "brand-envato": "\u{f394}",
    "brand-etsy": "\u{f654}",
    "brand-evernote": "\u{f600}",
    "brand-facebook": "\u{ec1a}",
    "brand-facebook-filled": "\u{f7e6}",
    "brand-feedly": "\u{fa75}",
    "brand-figma": "\u{ec93}",
    "brand-filezilla": "\u{fa76}",
    "brand-finder": "\u{f218}",
    "brand-firebase": "\u{ef6e}",
    "brand-firefox": "\u{ecfd}",
    "brand-fiverr": "\u{f7a4}",
    "brand-flickr": "\u{ecfe}",
    "brand-flightradar24": "\u{f4d6}",
    "brand-flipboard": "\u{f20b}",
    "brand-flutter": "\u{f395}",
    "brand-fortnite": "\u{f260}",
    "brand-foursquare": "\u{ecff}",
    "brand-framer": "\u{ec1b}",
    "brand-framer-motion": "\u{f78c}",
    "brand-funimation": "\u{f655}",
    "brand-gatsby": "\u{f396}",
    "brand-git": "\u{ef6f}",
    "brand-github": "\u{ec1c}",
    "brand-github-copilot": "\u{f4a8}",
    "brand-github-filled": "\u{f7e7}",
    "brand-gitlab": "\u{ec1d}",
    "brand-gmail": "\u{efa2}",
    "brand-golang": "\u{f78d}",
    "brand-google": "\u{ec1f}",
    "brand-google-analytics": "\u{edcb}",
    "brand-google-big-query": "\u{f612}",
    "brand-google-drive": "\u{ec1e}",
    "brand-google-filled": "\u{fd1a}",
    "brand-google-fit": "\u{f297}",
    "brand-google-home": "\u{f601}",
    "brand-google-maps": "\u{fa4f}",
    "brand-google-one": "\u{f232}",
    "brand-google-photos": "\u{f20c}",
    "brand-google-play": "\u{ed25}",
    "brand-google-podcasts": "\u{f656}",
    "brand-grammarly": "\u{f32b}",
    "brand-graphql": "\u{f32c}",
    "brand-gravatar": "\u{edcc}",
    "brand-grindr": "\u{f20d}",
    "brand-guardian": "\u{f4fb}",
    "brand-gumroad": "\u{f5d6}",
    "brand-hackerrank": "\u{ff23}",
    "brand-hbo": "\u{f657}",
    "brand-headlessui": "\u{f32d}",
    "brand-hexo": "\u{fa50}",
    "brand-hipchat": "\u{edcd}",
    "brand-html5": "\u{ed6c}",
    "brand-inertia": "\u{f34a}",
    "brand-instagram": "\u{ec20}",
    "brand-instagram-filled": "\u{10094}",
    "brand-intercom": "\u{f1cf}",
    "brand-itch": "\u{fa22}",
    "brand-javascript": "\u{ef0c}",
    "brand-juejin": "\u{f7b0}",
    "brand-kako-talk": "\u{fd2d}",
    "brand-kbin": "\u{fad0}",
    "brand-kick": "\u{fa23}",
    "brand-kick-filled": "\u{10093}",
    "brand-kickstarter": "\u{edce}",
    "brand-kotlin": "\u{ed6d}",
    "brand-laravel": "\u{f34b}",
    "brand-lastfm": "\u{f001}",
    "brand-leetcode": "\u{fa51}",
    "brand-letterboxd": "\u{fa24}",
    "brand-line": "\u{f7e8}",
    "brand-linkedin": "\u{ec8c}",
    "brand-linkedin-filled": "\u{10092}",
    "brand-linktree": "\u{f1e7}",
    "brand-linqpad": "\u{f562}",
    "brand-livewire": "\u{fd76}",
    "brand-loom": "\u{ef70}",
    "brand-mailgun": "\u{f32e}",
    "brand-mantine": "\u{f32f}",
    "brand-mastercard": "\u{ef49}",
    "brand-mastodon": "\u{f250}",
    "brand-matrix": "\u{f5eb}",
    "brand-mcdonalds": "\u{f251}",
    "brand-medium": "\u{ec70}",
    "brand-meetup": "\u{fc6a}",
    "brand-mercedes": "\u{f072}",
    "brand-messenger": "\u{ec71}",
    "brand-messenger-filled": "\u{100a7}",
    "brand-meta": "\u{efb0}",
    "brand-metabrainz": "\u{ff12}",
    "brand-minecraft": "\u{faef}",
    "brand-miniprogram": "\u{f602}",
    "brand-mixpanel": "\u{f397}",
    "brand-monday": "\u{f219}",
    "brand-mongodb": "\u{f613}",
    "brand-my-oppo": "\u{f4d7}",
    "brand-mysql": "\u{f614}",
    "brand-national-geographic": "\u{f603}",
    "brand-nem": "\u{f5a1}",
    "brand-netbeans": "\u{ef71}",
    "brand-netease-music": "\u{f604}",
    "brand-netflix": "\u{edcf}",
    "brand-nexo": "\u{f5a2}",
    "brand-nextcloud": "\u{f4d8}",
    "brand-nextjs": "\u{f0dd}",
    "brand-nodejs": "\u{fae0}",
    "brand-nord-vpn": "\u{f37f}",
    "brand-notion": "\u{ef7b}",
    "brand-npm": "\u{f569}",
    "brand-nuxt": "\u{f0de}",
    "brand-nytimes": "\u{ef8d}",
    "brand-oauth": "\u{fa52}",
    "brand-office": "\u{f398}",
    "brand-ok-ru": "\u{f399}",
    "brand-onedrive": "\u{f5d7}",
    "brand-onlyfans": "\u{f605}",
    "brand-open-source": "\u{edd0}",
    "brand-open-source-filled": "\u{10091}",
    "brand-openai": "\u{f78e}",
    "brand-openvpn": "\u{f39a}",
    "brand-opera": "\u{ec21}",
    "brand-opera-filled": "\u{10090}",
    "brand-pagekit": "\u{edd1}",
    "brand-parsinta": "\u{fc42}",
    "brand-patreon": "\u{edd2}",
    "brand-patreon-filled": "\u{fcff}",
    "brand-paypal": "\u{ec22}",
    "brand-paypal-filled": "\u{f7e9}",
    "brand-paypay": "\u{f5ec}",
    "brand-peanut": "\u{f39b}",
    "brand-pepsi": "\u{f261}",
    "brand-php": "\u{ef72}",
    "brand-picsart": "\u{f4d9}",
    "brand-pinterest": "\u{ec8d}",
    "brand-pinterest-filled": "\u{1008f}",
    "brand-planetscale": "\u{f78f}",
    "brand-pnpm": "\u{fd77}",
    "brand-pocket": "\u{ed00}",
    "brand-polymer": "\u{f498}",
    "brand-powershell": "\u{f5ed}",
    "brand-printables": "\u{fd1b}",
    "brand-prisma": "\u{f499}",
    "brand-producthunt": "\u{edd3}",
    "brand-pushbullet": "\u{f330}",
    "brand-pushover": "\u{f20e}",
    "brand-python": "\u{ed01}",
    "brand-qq": "\u{f606}",
    "brand-radix-ui": "\u{f790}",
    "brand-react": "\u{f34c}",
    "brand-react-native": "\u{ef73}",
    "brand-reason": "\u{f49a}",
    "brand-reddit": "\u{ec8e}",
    "brand-redhat": "\u{f331}",
    "brand-redux": "\u{f3a8}",
    "brand-revolut": "\u{f4da}",
    "brand-rumble": "\u{fad1}",
    "brand-rust": "\u{fa53}",
    "brand-safari": "\u{ec23}",
    "brand-samsungpass": "\u{f4db}",
    "brand-sass": "\u{edd4}",
    "brand-sentry": "\u{edd5}",
    "brand-sharik": "\u{f4dc}",
    "brand-shazam": "\u{edd6}",
    "brand-shopee": "\u{f252}",
    "brand-sketch": "\u{ec24}",
    "brand-sketch-filled": "\u{1008e}",
    "brand-skype": "\u{ed02}",
    "brand-slack": "\u{ec72}",
    "brand-snapchat": "\u{ec25}",
    "brand-snapchat-filled": "\u{1008d}",
    "brand-snapseed": "\u{f253}",
    "brand-snowflake": "\u{f615}",
    "brand-socket-io": "\u{f49b}",
    "brand-solidjs": "\u{f5ee}",
    "brand-soundcloud": "\u{ed6e}",
    "brand-spacehey": "\u{f4fc}",
    "brand-speedtest": "\u{fa77}",
    "brand-spotify": "\u{ed03}",
    "brand-spotify-filled": "\u{fe86}",
    "brand-stackoverflow": "\u{ef58}",
    "brand-stackshare": "\u{f607}",
    "brand-steam": "\u{ed6f}",
    "brand-steam-filled": "\u{1008c}",
    "brand-stocktwits": "\u{fd78}",
    "brand-storj": "\u{fa54}",
    "brand-storybook": "\u{f332}",
    "brand-storytel": "\u{f608}",
    "brand-strava": "\u{f254}",
    "brand-stripe": "\u{edd7}",
    "brand-stripe-filled": "\u{1008b}",
    "brand-sublime-text": "\u{ef74}",
    "brand-sugarizer": "\u{f7a5}",
    "brand-supabase": "\u{f6d3}",
    "brand-superhuman": "\u{f50c}",
    "brand-supernova": "\u{f49c}",
    "brand-surfshark": "\u{f255}",
    "brand-svelte": "\u{f0df}",
    "brand-swift": "\u{fa55}",
    "brand-symfony": "\u{f616}",
    "brand-tabler": "\u{ec8f}",
    "brand-tabler-filled": "\u{1008a}",
    "brand-tailwind": "\u{eca1}",
    "brand-taobao": "\u{f5ef}",
    "brand-teams": "\u{fadf}",
    "brand-ted": "\u{f658}",
    "brand-telegram": "\u{ec26}",
    "brand-terraform": "\u{fa56}",
    "brand-tesla": "\u{10099}",
    "brand-tether": "\u{f5a3}",
    "brand-thingiverse": "\u{fd1c}",
    "brand-threads": "\u{fb02}",
    "brand-threejs": "\u{f5f0}",
    "brand-tidal": "\u{ed70}",
    "brand-tiktok": "\u{ec73}",
    "brand-tiktok-filled": "\u{f7ea}",
    "brand-tinder": "\u{ed71}",
    "brand-tinder-filled": "\u{10089}",
    "brand-topbuzz": "\u{f50d}",
    "brand-torchain": "\u{f5a4}",
    "brand-toyota": "\u{f262}",
    "brand-trello": "\u{f39d}",
    "brand-tripadvisor": "\u{f002}",
    "brand-tumblr": "\u{ed04}",
    "brand-tumblr-filled": "\u{10088}",
    "brand-twilio": "\u{f617}",
    "brand-twitch": "\u{ed05}",
    "brand-twitter": "\u{ec27}",
    "brand-twitter-filled": "\u{f7eb}",
    "brand-typescript": "\u{f5f1}",
    "brand-uber": "\u{ef75}",
    "brand-ubuntu": "\u{ef59}",
    "brand-unity": "\u{f49d}",
    "brand-unsplash": "\u{edd8}",
    "brand-upwork": "\u{f39e}",
    "brand-valorant": "\u{f39f}",
    "brand-vercel": "\u{ef24}",
    "brand-vercel-filled": "\u{10087}",
    "brand-vimeo": "\u{ed06}",
    "brand-vimeo-filled": "\u{10086}",
    "brand-vinted": "\u{f20f}",
    "brand-visa": "\u{f380}",
    "brand-visual-studio": "\u{ef76}",
    "brand-vite": "\u{f5f2}",
    "brand-vivaldi": "\u{f210}",
    "brand-vk": "\u{ed72}",
    "brand-vlc": "\u{fa78}",
    "brand-volkswagen": "\u{f50e}",
    "brand-vsco": "\u{f334}",
    "brand-vscode": "\u{f3a0}",
    "brand-vue": "\u{f0e0}",
    "brand-walmart": "\u{f211}",
    "brand-waze": "\u{f5d8}",
    "brand-webflow": "\u{f2d2}",
    "brand-wechat": "\u{f5f3}",
    "brand-weibo": "\u{f609}",
    "brand-weibo-filled": "\u{100a6}",
    "brand-whatsapp": "\u{ec74}",
    "brand-whatsapp-filled": "\u{10085}",
    "brand-wikipedia": "\u{fa79}",
    "brand-windows": "\u{ecd8}",
    "brand-windows-filled": "\u{10084}",
    "brand-windy": "\u{f4dd}",
    "brand-wish": "\u{f212}",
    "brand-wix": "\u{f3a1}",
    "brand-wordpress": "\u{f2d3}",
    "brand-x": "\u{fc0f}",
    "brand-x-filled": "\u{fc21}",
    "brand-xamarin": "\u{fa7a}",
    "brand-xbox": "\u{f298}",
    "brand-xdeep": "\u{fc10}",
    "brand-xing": "\u{f21a}",
    "brand-yahoo": "\u{ed73}",
    "brand-yandex": "\u{fae1}",
    "brand-yarn": "\u{fd79}",
    "brand-yatse": "\u{f213}",
    "brand-ycombinator": "\u{edd9}",
    "brand-youtube": "\u{ec90}",
    "brand-youtube-filled": "\u{fc22}",
    "brand-youtube-kids": "\u{f214}",
    "brand-zalando": "\u{f49e}",
    "brand-zapier": "\u{f49f}",
    "brand-zeit": "\u{f335}",
    "brand-zhihu": "\u{f60a}",
    "brand-zoom": "\u{f215}",
    "brand-zulip": "\u{f4de}",
    "brand-zwift": "\u{f216}",
    "bread": "\u{efa3}",
    "bread-filled": "\u{fe85}",
    "bread-off": "\u{f3cb}",
    "briefcase": "\u{ea46}",
    "briefcase-2": "\u{fb03}",
    "briefcase-2-filled": "\u{fe84}",
    "briefcase-filled": "\u{fd00}",
    "briefcase-off": "\u{f3cc}",
    "brightness": "\u{eb7f}",
    "brightness-2": "\u{ee19}",
    "brightness-auto": "\u{fd99}",
    "brightness-auto-filled": "\u{fe83}",
    "brightness-down": "\u{eb7d}",
    "brightness-down-filled": "\u{fb23}",
    "brightness-filled": "\u{fe82}",
    "brightness-half": "\u{ee1a}",
    "brightness-off": "\u{f3cd}",
    "brightness-up": "\u{eb7e}",
    "brightness-up-filled": "\u{fb24}",
    "broadcast": "\u{f1e9}",
    "broadcast-off": "\u{f1e8}",
    "browser": "\u{ebb7}",
    "browser-check": "\u{efd6}",
    "browser-maximize": "\u{100b0}",
    "browser-minus": "\u{100af}",
    "browser-off": "\u{f0c1}",
    "browser-plus": "\u{efd7}",
    "browser-share": "\u{100ae}",
    "browser-x": "\u{efd8}",
    "brush": "\u{ebb8}",
    "brush-off": "\u{f0c2}",
    "bubble": "\u{feba}",
    "bubble-filled": "\u{fec3}",
    "bubble-minus": "\u{febe}",
    "bubble-plus": "\u{febd}",
    "bubble-tea": "\u{ff51}",
    "bubble-tea-2": "\u{ff52}",
    "bubble-text": "\u{febc}",
    "bubble-text-filled": "\u{100a5}",
    "bubble-x": "\u{febb}",
    "bucket": "\u{ea47}",
    "bucket-droplet": "\u{f56a}",
    "bucket-off": "\u{f103}",
    "bug": "\u{ea48}",
    "bug-filled": "\u{fd01}",
    "bug-off": "\u{f0c3}",
    "building": "\u{ea4f}",
    "building-airport": "\u{ffa9}",
    "building-arch": "\u{ea49}",
    "building-bank": "\u{ebe2}",
    "building-bridge": "\u{ea4b}",
    "building-bridge-2": "\u{ea4a}",
    "building-bridge-2-filled": "\u{10189}",
    "building-broadcast-tower": "\u{f4be}",
    "building-broadcast-tower-filled": "\u{fe81}",
    "building-burj-al-arab": "\u{ff50}",
    "building-carousel": "\u{ed87}",
    "building-castle": "\u{ed88}",
    "building-church": "\u{ea4c}",
    "building-circus": "\u{f4bf}",
    "building-cog": "\u{10062}",
    "building-community": "\u{ebf6}",
    "building-cottage": "\u{ee1b}",
    "building-estate": "\u{f5a5}",
    "building-factory": "\u{ee1c}",
    "building-factory-2": "\u{f082}",
    "building-fortress": "\u{ed89}",
    "building-hospital": "\u{ea4d}",
    "building-lighthouse": "\u{ed8a}",
    "building-minus": "\u{10061}",
    "building-monument": "\u{ed26}",
    "building-mosque": "\u{fa57}",
    "building-off": "\u{fefd}",
    "building-pavilion": "\u{ebf7}",
    "building-plus": "\u{10060}",
    "building-skyscraper": "\u{ec39}",
    "building-stadium": "\u{f641}",
    "building-store": "\u{ea4e}",
    "building-tunnel": "\u{f5a6}",
    "building-warehouse": "\u{ebe3}",
    "building-wind-turbine": "\u{f4c0}",
    "buildings": "\u{ff40}",
    "bulb": "\u{ea51}",
    "bulb-filled": "\u{f66a}",
    "bulb-off": "\u{ea50}",
    "bulldozer": "\u{ee1d}",
    "burger": "\u{fcb4}",
    "bus": "\u{ebe4}",
    "bus-filled": "\u{100ff}",
    "bus-off": "\u{f3ce}",
    "bus-stop": "\u{f2d4}",
    "businessplan": "\u{ee1e}",
    "butterfly": "\u{efd9}",
    "butterfly-filled": "\u{10016}",
    "cactus": "\u{f21b}",
    "cactus-filled": "\u{fb25}",
    "cactus-off": "\u{f3cf}",
    "cake": "\u{f00f}",
    "cake-off": "\u{f104}",
    "cake-roll": "\u{100bd}",
    "calculator": "\u{eb80}",
    "calculator-filled": "\u{fb26}",
    "calculator-off": "\u{f0c4}",
    "calendar": "\u{ea53}",
    "calendar-bolt": "\u{f822}",
    "calendar-cancel": "\u{f823}",
    "calendar-check": "\u{f824}",
    "calendar-clock": "\u{fd2e}",
    "calendar-code": "\u{f825}",
    "calendar-cog": "\u{f826}",
    "calendar-dollar": "\u{f827}",
    "calendar-dot": "\u{fd3e}",
    "calendar-down": "\u{f828}",
    "calendar-due": "\u{f621}",
    "calendar-event": "\u{ea52}",
    "calendar-event-filled": "\u{100b9}",
    "calendar-exclamation": "\u{f829}",
    "calendar-filled": "\u{fb27}",
    "calendar-heart": "\u{f82a}",
    "calendar-minus": "\u{ebb9}",
    "calendar-month": "\u{fd2f}",
    "calendar-month-filled": "\u{100b8}",
    "calendar-off": "\u{ee1f}",
    "calendar-pause": "\u{f82b}",
    "calendar-pin": "\u{f82c}",
    "calendar-plus": "\u{ebba}",
    "calendar-question": "\u{f82d}",
    "calendar-repeat": "\u{fad2}",
    "calendar-sad": "\u{fd1d}",
    "calendar-search": "\u{f82e}",
    "calendar-share": "\u{f82f}",
    "calendar-smile": "\u{fd1e}",
    "calendar-star": "\u{f830}",
    "calendar-stats": "\u{ee20}",
    "calendar-time": "\u{ee21}",
    "calendar-up": "\u{f831}",
    "calendar-user": "\u{fd1f}",
    "calendar-week": "\u{fd30}",
    "calendar-week-filled": "\u{100b7}",
    "calendar-x": "\u{f832}",
    "camera": "\u{ea54}",
    "camera-ai": "\u{ffa8}",
    "camera-bitcoin": "\u{ffa7}",
    "camera-bolt": "\u{f833}",
    "camera-cancel": "\u{f834}",
    "camera-check": "\u{f835}",
    "camera-code": "\u{f836}",
    "camera-cog": "\u{f837}",
    "camera-dollar": "\u{f838}",
    "camera-down": "\u{f839}",
    "camera-exclamation": "\u{f83a}",
    "camera-filled": "\u{fa37}",
    "camera-heart": "\u{f83b}",
    "camera-minus": "\u{ec3a}",
    "camera-moon": "\u{ffa6}",
    "camera-off": "\u{ecee}",
    "camera-pause": "\u{f83c}",
    "camera-pin": "\u{f83d}",
    "camera-plus": "\u{ec3b}",
    "camera-question": "\u{f83e}",
    "camera-rotate": "\u{ee22}",
    "camera-search": "\u{f83f}",
    "camera-selfie": "\u{ee23}",
    "camera-share": "\u{f840}",
    "camera-spark": "\u{ffbc}",
    "camera-star": "\u{f841}",
    "camera-up": "\u{f842}",
    "camera-x": "\u{f843}",
    "camper": "\u{fa25}",
    "campfire": "\u{f5a7}",
    "campfire-filled": "\u{fb28}",
    "cancel": "\u{ff11}",
    "candle": "\u{efc6}",
    "candle-filled": "\u{fc23}",
    "candy": "\u{ef0d}",
    "candy-off": "\u{f0c5}",
    "cane": "\u{f50f}",
    "cannabis": "\u{f4c1}",
    "cannabis-filled": "\u{10015}",
    "cap-projecting": "\u{ff22}",
    "cap-rounded": "\u{ff21}",
    "cap-straight": "\u{ff20}",
    "capsule": "\u{fae3}",
    "capsule-filled": "\u{fc24}",
    "capsule-horizontal": "\u{fae2}",
    "capsule-horizontal-filled": "\u{fc25}",
    "capture": "\u{ec3c}",
    "capture-filled": "\u{fb29}",
    "capture-off": "\u{f0c6}",
    "car": "\u{ebbb}",
    "car-4wd": "\u{fdb8}",
    "car-4wd-filled": "\u{1001e}",
    "car-crane": "\u{ef25}",
    "car-crane-filled": "\u{100fe}",
    "car-crash": "\u{efa4}",
    "car-fan": "\u{fdb3}",
    "car-fan-1": "\u{fdb7}",
    "car-fan-2": "\u{fdb6}",
    "car-fan-3": "\u{fdb5}",
    "car-fan-auto": "\u{fdb4}",
    "car-fan-filled": "\u{1001d}",
    "car-filled": "\u{1004c}",
    "car-garage": "\u{fc77}",
    "car-off": "\u{f0c7}",
    "car-suv": "\u{fc8b}",
    "car-suv-filled": "\u{1004d}",
    "car-turbine": "\u{f4fd}",
    "carambola": "\u{feb9}",
    "carambola-filled": "\u{10014}",
    "caravan": "\u{ec7c}",
    "caravan-filled": "\u{100fd}",
    "cardboards": "\u{ed74}",
    "cardboards-filled": "\u{1001c}",
    "cardboards-off": "\u{f0c8}",
    "cards": "\u{f510}",
    "cards-filled": "\u{fc26}",
    "caret-down": "\u{eb5d}",
    "caret-down-filled": "\u{fb2a}",
    "caret-left": "\u{eb5e}",
    "caret-left-filled": "\u{fb2b}",
    "caret-left-right": "\u{fc43}",
    "caret-left-right-filled": "\u{fd02}",
    "caret-right": "\u{eb5f}",
    "caret-right-filled": "\u{fb2c}",
    "caret-up": "\u{eb60}",
    "caret-up-down": "\u{fc44}",
    "caret-up-down-filled": "\u{fd03}",
    "caret-up-filled": "\u{fb2d}",
    "carousel-horizontal": "\u{f659}",
    "carousel-horizontal-filled": "\u{fa92}",
    "carousel-vertical": "\u{f65a}",
    "carousel-vertical-filled": "\u{fa93}",
    "carrot": "\u{f21c}",
    "carrot-off": "\u{f3d0}",
    "cash": "\u{ea55}",
    "cash-banknote": "\u{ee25}",
    "cash-banknote-edit": "\u{10149}",
    "cash-banknote-filled": "\u{fe80}",
    "cash-banknote-heart": "\u{10148}",
    "cash-banknote-minus": "\u{10147}",
    "cash-banknote-move": "\u{10145}",
    "cash-banknote-move-back": "\u{10146}",
    "cash-banknote-off": "\u{ee24}",
    "cash-banknote-plus": "\u{10144}",
    "cash-edit": "\u{10143}",
    "cash-heart": "\u{10142}",
    "cash-minus": "\u{10141}",
    "cash-move": "\u{1013f}",
    "cash-move-back": "\u{10140}",
    "cash-off": "\u{f105}",
    "cash-plus": "\u{1013e}",
    "cash-register": "\u{fee6}",
    "cast": "\u{ea56}",
    "cast-off": "\u{f0c9}",
    "cat": "\u{f65b}",
    "category": "\u{f1f6}",
    "category-2": "\u{f1f5}",
    "category-filled": "\u{fb2e}",
    "category-minus": "\u{fd20}",
    "category-plus": "\u{fd21}",
    "ce": "\u{ed75}",
    "ce-off": "\u{f0ca}",
    "cell": "\u{f05f}",
    "cell-signal-1": "\u{f083}",
    "cell-signal-2": "\u{f084}",
    "cell-signal-3": "\u{f085}",
    "cell-signal-4": "\u{f086}",
    "cell-signal-5": "\u{f087}",
    "cell-signal-off": "\u{f088}",
    "certificate": "\u{ed76}",
    "certificate-2": "\u{f073}",
    "certificate-2-off": "\u{f0cb}",
    "certificate-off": "\u{f0cc}",
    "chair-director": "\u{f2d5}",
    "chalkboard": "\u{f34d}",
    "chalkboard-off": "\u{f3d1}",
    "chalkboard-teacher": "\u{10160}",
    "charging-pile": "\u{ee26}",
    "charging-pile-filled": "\u{1001b}",
    "chart-arcs": "\u{ee28}",
    "chart-arcs-3": "\u{ee27}",
    "chart-area": "\u{ea58}",
    "chart-area-filled": "\u{f66b}",
    "chart-area-line": "\u{ea57}",
    "chart-area-line-filled": "\u{f66c}",
    "chart-arrows": "\u{ee2a}",
    "chart-arrows-vertical": "\u{ee29}",
    "chart-bar": "\u{ea59}",
    "chart-bar-off": "\u{f3d2}",
    "chart-bar-popular": "\u{fef7}",
    "chart-bubble": "\u{ec75}",
    "chart-bubble-filled": "\u{f66d}",
    "chart-candle": "\u{ea5a}",
    "chart-candle-filled": "\u{f66e}",
    "chart-circles": "\u{ee2b}",
    "chart-cohort": "\u{fef6}",
    "chart-column": "\u{ffa5}",
    "chart-covariate": "\u{ffa4}",
    "chart-donut": "\u{ea5b}",
    "chart-donut-2": "\u{ee2c}",
    "chart-donut-3": "\u{ee2d}",
    "chart-donut-4": "\u{ee2e}",
    "chart-donut-filled": "\u{f66f}",
    "chart-dots": "\u{ee2f}",
    "chart-dots-2": "\u{f097}",
    "chart-dots-2-filled": "\u{100dd}",
    "chart-dots-3": "\u{f098}",
    "chart-dots-3-filled": "\u{100dc}",
    "chart-dots-filled": "\u{fd04}",
    "chart-funnel": "\u{fef5}",
    "chart-funnel-filled": "\u{100db}",
    "chart-grid-dots": "\u{f4c2}",
    "chart-grid-dots-filled": "\u{fd05}",
    "chart-histogram": "\u{f65c}",
    "chart-infographic": "\u{ee30}",
    "chart-line": "\u{ea5c}",
    "chart-pie": "\u{ea5d}",
    "chart-pie-2": "\u{ee31}",
    "chart-pie-2-filled": "\u{100da}",
    "chart-pie-3": "\u{ee32}",
    "chart-pie-3-filled": "\u{100d9}",
    "chart-pie-4": "\u{ee33}",
    "chart-pie-4-filled": "\u{100d8}",
    "chart-pie-filled": "\u{f670}",
    "chart-pie-off": "\u{f3d3}",
    "chart-ppf": "\u{f618}",
    "chart-radar": "\u{ed77}",
    "chart-sankey": "\u{f619}",
    "chart-scatter": "\u{fd93}",
    "chart-scatter-3d": "\u{fd92}",
    "chart-treemap": "\u{f381}",
    "check": "\u{ea5e}",
    "checkbox": "\u{eba6}",
    "checklist": "\u{f074}",
    "checks": "\u{ebaa}",
    "checkup-list": "\u{ef5a}",
    "cheese": "\u{ef26}",
    "chef-hat": "\u{f21d}",
    "chef-hat-filled": "\u{100d7}",
    "chef-hat-off": "\u{f3d4}",
    "cherry": "\u{f511}",
    "cherry-filled": "\u{f728}",
    "chess": "\u{f382}",
    "chess-bishop": "\u{f56b}",
    "chess-bishop-filled": "\u{f729}",
    "chess-filled": "\u{f72a}",
    "chess-king": "\u{f56c}",
    "chess-king-filled": "\u{f72b}",
    "chess-knight": "\u{f56d}",
    "chess-knight-filled": "\u{f72c}",
    "chess-queen": "\u{f56e}",
    "chess-queen-filled": "\u{f72d}",
    "chess-rook": "\u{f56f}",
    "chess-rook-filled": "\u{f72e}",
    "chevron-compact-down": "\u{faf0}",
    "chevron-compact-left": "\u{faf1}",
    "chevron-compact-right": "\u{faf2}",
    "chevron-compact-up": "\u{faf3}",
    "chevron-down": "\u{ea5f}",
    "chevron-down-left": "\u{ed09}",
    "chevron-down-right": "\u{ed0a}",
    "chevron-left": "\u{ea60}",
    "chevron-left-pipe": "\u{fae4}",
    "chevron-right": "\u{ea61}",
    "chevron-right-pipe": "\u{fae5}",
    "chevron-up": "\u{ea62}",
    "chevron-up-left": "\u{ed0b}",
    "chevron-up-right": "\u{ed0c}",
    "chevrons-down": "\u{ea63}",
    "chevrons-down-left": "\u{ed0d}",
    "chevrons-down-right": "\u{ed0e}",
    "chevrons-left": "\u{ea64}",
    "chevrons-right": "\u{ea65}",
    "chevrons-up": "\u{ea66}",
    "chevrons-up-left": "\u{ed0f}",
    "chevrons-up-right": "\u{ed10}",
    "chisel": "\u{f383}",
    "christmas-ball": "\u{fd31}",
    "christmas-tree": "\u{ed78}",
    "christmas-tree-filled": "\u{1001a}",
    "christmas-tree-off": "\u{f3d5}",
    "circle": "\u{ea6b}",
    "circle-0": "\u{ee34}",
    "circle-1": "\u{ee35}",
    "circle-2": "\u{ee36}",
    "circle-3": "\u{ee37}",
    "circle-4": "\u{ee38}",
    "circle-5": "\u{ee39}",
    "circle-6": "\u{ee3a}",
    "circle-7": "\u{ee3b}",
    "circle-8": "\u{ee3c}",
    "circle-9": "\u{ee3d}",
    "circle-arrow-down": "\u{f6f9}",
    "circle-arrow-down-filled": "\u{f6f4}",
    "circle-arrow-down-left": "\u{f6f6}",
    "circle-arrow-down-left-filled": "\u{f6f5}",
    "circle-arrow-down-right": "\u{f6f8}",
    "circle-arrow-down-right-filled": "\u{f6f7}",
    "circle-arrow-left": "\u{f6fb}",
    "circle-arrow-left-filled": "\u{f6fa}",
    "circle-arrow-right": "\u{f6fd}",
    "circle-arrow-right-filled": "\u{f6fc}",
    "circle-arrow-up": "\u{f703}",
    "circle-arrow-up-filled": "\u{f6fe}",
    "circle-arrow-up-left": "\u{f700}",
    "circle-arrow-up-left-filled": "\u{f6ff}",
    "circle-arrow-up-right": "\u{f702}",
    "circle-arrow-up-right-filled": "\u{f701}",
    "circle-caret-down": "\u{f4a9}",
    "circle-caret-down-filled": "\u{100d6}",
    "circle-caret-left": "\u{f4aa}",
    "circle-caret-left-filled": "\u{100d5}",
    "circle-caret-right": "\u{f4ab}",
    "circle-caret-right-filled": "\u{100d4}",
    "circle-caret-up": "\u{f4ac}",
    "circle-caret-up-filled": "\u{100d3}",
    "circle-check": "\u{ea67}",
    "circle-check-filled": "\u{f704}",
    "circle-chevron-down": "\u{f622}",
    "circle-chevron-down-filled": "\u{100d2}",
    "circle-chevron-left": "\u{f623}",
    "circle-chevron-left-filled": "\u{100d1}",
    "circle-chevron-right": "\u{f624}",
    "circle-chevron-right-filled": "\u{100d0}",
    "circle-chevron-up": "\u{f625}",
    "circle-chevron-up-filled": "\u{100cf}",
    "circle-chevrons-down": "\u{f642}",
    "circle-chevrons-down-filled": "\u{100ef}",
    "circle-chevrons-left": "\u{f643}",
    "circle-chevrons-left-filled": "\u{100ee}",
    "circle-chevrons-right": "\u{f644}",
    "circle-chevrons-right-filled": "\u{100ed}",
    "circle-chevrons-up": "\u{f645}",
    "circle-chevrons-up-filled": "\u{100ec}",
    "circle-dashed": "\u{ed27}",
    "circle-dashed-check": "\u{feb8}",
    "circle-dashed-letter-a": "\u{ff9a}",
    "circle-dashed-letter-b": "\u{ff99}",
    "circle-dashed-letter-c": "\u{ff98}",
    "circle-dashed-letter-d": "\u{ff97}",
    "circle-dashed-letter-e": "\u{ff96}",
    "circle-dashed-letter-f": "\u{ff95}",
    "circle-dashed-letter-g": "\u{ff94}",
    "circle-dashed-letter-h": "\u{ff93}",
    "circle-dashed-letter-i": "\u{ff92}",
    "circle-dashed-letter-j": "\u{ff91}",
    "circle-dashed-letter-k": "\u{ff90}",
    "circle-dashed-letter-l": "\u{ff8f}",
    "circle-dashed-letter-letter-v": "\u{ff84}",
    "circle-dashed-letter-m": "\u{ff8d}",
    "circle-dashed-letter-n": "\u{ff8c}",
    "circle-dashed-letter-o": "\u{ff8b}",
    "circle-dashed-letter-p": "\u{ff8a}",
    "circle-dashed-letter-q": "\u{ff89}",
    "circle-dashed-letter-r": "\u{ff88}",
    "circle-dashed-letter-s": "\u{ff87}",
    "circle-dashed-letter-t": "\u{ff86}",
    "circle-dashed-letter-u": "\u{ff85}",
    "circle-dashed-letter-v": "\u{ff84}",
    "circle-dashed-letter-w": "\u{ff83}",
    "circle-dashed-letter-x": "\u{ff82}",
    "circle-dashed-letter-y": "\u{ff81}",
    "circle-dashed-letter-z": "\u{ff80}",
    "circle-dashed-minus": "\u{feb7}",
    "circle-dashed-number-0": "\u{fc6b}",
    "circle-dashed-number-1": "\u{fc6c}",
    "circle-dashed-number-2": "\u{fc6d}",
    "circle-dashed-number-3": "\u{fc6e}",
    "circle-dashed-number-4": "\u{fc6f}",
    "circle-dashed-number-5": "\u{fc70}",
    "circle-dashed-number-6": "\u{fc71}",
    "circle-dashed-number-7": "\u{fc72}",
    "circle-dashed-number-8": "\u{fc73}",
    "circle-dashed-number-9": "\u{fc74}",
    "circle-dashed-percentage": "\u{fd7a}",
    "circle-dashed-plus": "\u{feb6}",
    "circle-dashed-x": "\u{fc75}",
    "circle-dot": "\u{efb1}",
    "circle-dot-filled": "\u{f705}",
    "circle-dotted": "\u{ed28}",
    "circle-dotted-letter-a": "\u{ff7f}",
    "circle-dotted-letter-b": "\u{ff7e}",
    "circle-dotted-letter-c": "\u{ff7d}",
    "circle-dotted-letter-d": "\u{ff7c}",
    "circle-dotted-letter-e": "\u{ff7b}",
    "circle-dotted-letter-f": "\u{ff7a}",
    "circle-dotted-letter-g": "\u{ff79}",
    "circle-dotted-letter-h": "\u{ff78}",
    "circle-dotted-letter-i": "\u{ff77}",
    "circle-dotted-letter-j": "\u{ff76}",
    "circle-dotted-letter-k": "\u{ff75}",
    "circle-dotted-letter-l": "\u{ff74}",
    "circle-dotted-letter-m": "\u{ff73}",
    "circle-dotted-letter-n": "\u{ff72}",
    "circle-dotted-letter-o": "\u{ff71}",
    "circle-dotted-letter-p": "\u{ff70}",
    "circle-dotted-letter-q": "\u{ff6f}",
    "circle-dotted-letter-r": "\u{ff6e}",
    "circle-dotted-letter-s": "\u{ff6d}",
    "circle-dotted-letter-t": "\u{ff6c}",
    "circle-dotted-letter-u": "\u{ff6b}",
    "circle-dotted-letter-v": "\u{ff6a}",
    "circle-dotted-letter-w": "\u{ff69}",
    "circle-dotted-letter-x": "\u{ff68}",
    "circle-dotted-letter-y": "\u{ff67}",
    "circle-dotted-letter-z": "\u{ff66}",
    "circle-filled": "\u{f671}",
    "circle-half": "\u{ee3f}",
    "circle-half-2": "\u{eff3}",
    "circle-half-vertical": "\u{ee3e}",
    "circle-key": "\u{f633}",
    "circle-key-filled": "\u{f706}",
    "circle-letter-a": "\u{f441}",
    "circle-letter-a-filled": "\u{fe7f}",
    "circle-letter-b": "\u{f442}",
    "circle-letter-b-filled": "\u{fe7e}",
    "circle-letter-c": "\u{f443}",
    "circle-letter-c-filled": "\u{fe7d}",
    "circle-letter-d": "\u{f444}",
    "circle-letter-d-filled": "\u{fe7c}",
    "circle-letter-e": "\u{f445}",
    "circle-letter-e-filled": "\u{fe7b}",
    "circle-letter-f": "\u{f446}",
    "circle-letter-f-filled": "\u{fe7a}",
    "circle-letter-g": "\u{f447}",
    "circle-letter-g-filled": "\u{fe79}",
    "circle-letter-h": "\u{f448}",
    "circle-letter-h-filled": "\u{fe78}",
    "circle-letter-i": "\u{f449}",
    "circle-letter-i-filled": "\u{fe77}",
    "circle-letter-j": "\u{f44a}",
    "circle-letter-j-filled": "\u{fe76}",
    "circle-letter-k": "\u{f44b}",
    "circle-letter-k-filled": "\u{fe75}",
    "circle-letter-l": "\u{f44c}",
    "circle-letter-l-filled": "\u{fe74}",
    "circle-letter-m": "\u{f44d}",
    "circle-letter-m-filled": "\u{fe73}",
    "circle-letter-n": "\u{f44e}",
    "circle-letter-n-filled": "\u{fe72}",
    "circle-letter-o": "\u{f44f}",
    "circle-letter-o-filled": "\u{fe71}",
    "circle-letter-p": "\u{f450}",
    "circle-letter-p-filled": "\u{fe70}",
    "circle-letter-q": "\u{f451}",
    "circle-letter-q-filled": "\u{fe6f}",
    "circle-letter-r": "\u{f452}",
    "circle-letter-r-filled": "\u{fe6e}",
    "circle-letter-s": "\u{f453}",
    "circle-letter-s-filled": "\u{fe6d}",
    "circle-letter-t": "\u{f454}",
    "circle-letter-t-filled": "\u{fe6c}",
    "circle-letter-u": "\u{f455}",
    "circle-letter-u-filled": "\u{fe6b}",
    "circle-letter-v": "\u{f4ad}",
    "circle-letter-v-filled": "\u{fe6a}",
    "circle-letter-w": "\u{f456}",
    "circle-letter-w-filled": "\u{fe69}",
    "circle-letter-x": "\u{f4ae}",
    "circle-letter-x-filled": "\u{fe68}",
    "circle-letter-y": "\u{f457}",
    "circle-letter-y-filled": "\u{fe67}",
    "circle-letter-z": "\u{f458}",
    "circle-letter-z-filled": "\u{fe66}",
    "circle-minus": "\u{ea68}",
    "circle-minus-2": "\u{fc8c}",
    "circle-number-0": "\u{ee34}",
    "circle-number-0-filled": "\u{f72f}",
    "circle-number-1": "\u{ee35}",
    "circle-number-1-filled": "\u{f730}",
    "circle-number-2": "\u{ee36}",
    "circle-number-2-filled": "\u{f731}",
    "circle-number-3": "\u{ee37}",
    "circle-number-3-filled": "\u{f732}",
    "circle-number-4": "\u{ee38}",
    "circle-number-4-filled": "\u{f733}",
    "circle-number-5": "\u{ee39}",
    "circle-number-5-filled": "\u{f734}",
    "circle-number-6": "\u{ee3a}",
    "circle-number-6-filled": "\u{f735}",
    "circle-number-7": "\u{ee3b}",
    "circle-number-7-filled": "\u{f736}",
    "circle-number-8": "\u{ee3c}",
    "circle-number-8-filled": "\u{f737}",
    "circle-number-9": "\u{ee3d}",
    "circle-number-9-filled": "\u{f738}",
    "circle-off": "\u{ee40}",
    "circle-percentage": "\u{fd7b}",
    "circle-percentage-filled": "\u{fed5}",
    "circle-plus": "\u{ea69}",
    "circle-plus-2": "\u{fc8d}",
    "circle-plus-filled": "\u{fef9}",
    "circle-rectangle": "\u{f010}",
    "circle-rectangle-filled": "\u{ff63}",
    "circle-rectangle-off": "\u{f0cd}",
    "circle-square": "\u{ece4}",
    "circle-triangle": "\u{f011}",
    "circle-x": "\u{ea6a}",
    "circle-x-filled": "\u{f739}",
    "circles": "\u{ece5}",
    "circles-filled": "\u{f672}",
    "circles-relation": "\u{f4c3}",
    "circuit-ammeter": "\u{f271}",
    "circuit-battery": "\u{f272}",
    "circuit-bulb": "\u{f273}",
    "circuit-capacitor": "\u{f275}",
    "circuit-capacitor-polarized": "\u{f274}",
    "circuit-cell": "\u{f277}",
    "circuit-cell-plus": "\u{f276}",
    "circuit-changeover": "\u{f278}",
    "circuit-diode": "\u{f27a}",
    "circuit-diode-zener": "\u{f279}",
    "circuit-ground": "\u{f27c}",
    "circuit-ground-digital": "\u{f27b}",
    "circuit-inductor": "\u{f27d}",
    "circuit-motor": "\u{f27e}",
    "circuit-pushbutton": "\u{f27f}",
    "circuit-resistor": "\u{f280}",
    "circuit-switch-closed": "\u{f281}",
    "circuit-switch-open": "\u{f282}",
    "circuit-voltmeter": "\u{f283}",
    "clear-all": "\u{ee41}",
    "clear-formatting": "\u{ebe5}",
    "click": "\u{ebbc}",
    "cliff-jumping": "\u{fefc}",
    "clipboard": "\u{ea6f}",
    "clipboard-check": "\u{ea6c}",
    "clipboard-check-filled": "\u{100ce}",
    "clipboard-copy": "\u{f299}",
    "clipboard-data": "\u{f563}",
    "clipboard-data-filled": "\u{100eb}",
    "clipboard-filled": "\u{100cc}",
    "clipboard-heart": "\u{f34e}",
    "clipboard-list": "\u{ea6d}",
    "clipboard-list-filled": "\u{100ea}",
    "clipboard-off": "\u{f0ce}",
    "clipboard-plus": "\u{efb2}",
    "clipboard-plus-filled": "\u{10176}",
    "clipboard-search": "\u{10098}",
    "clipboard-smile": "\u{fd9a}",
    "clipboard-smile-filled": "\u{10175}",
    "clipboard-text": "\u{f089}",
    "clipboard-text-filled": "\u{100e9}",
    "clipboard-typography": "\u{f34f}",
    "clipboard-typography-filled": "\u{100e8}",
    "clipboard-x": "\u{ea6e}",
    "clipboard-x-filled": "\u{100cd}",
    "clock": "\u{ea70}",
    "clock-12": "\u{fc56}",
    "clock-2": "\u{f099}",
    "clock-24": "\u{fc57}",
    "clock-bitcoin": "\u{ff3f}",
    "clock-bolt": "\u{f844}",
    "clock-cancel": "\u{f546}",
    "clock-check": "\u{f7c1}",
    "clock-code": "\u{f845}",
    "clock-cog": "\u{f7c2}",
    "clock-dollar": "\u{f846}",
    "clock-down": "\u{f7c3}",
    "clock-edit": "\u{f547}",
    "clock-exclamation": "\u{f847}",
    "clock-filled": "\u{f73a}",
    "clock-heart": "\u{f7c4}",
    "clock-hour-1": "\u{f313}",
    "clock-hour-1-filled": "\u{fe65}",
    "clock-hour-10": "\u{f314}",
    "clock-hour-10-filled": "\u{fe64}",
    "clock-hour-11": "\u{f315}",
    "clock-hour-11-filled": "\u{fe63}",
    "clock-hour-12": "\u{f316}",
    "clock-hour-12-filled": "\u{fe62}",
    "clock-hour-2": "\u{f317}",
    "clock-hour-2-filled": "\u{fe61}",
    "clock-hour-3": "\u{f318}",
    "clock-hour-3-filled": "\u{fe60}",
    "clock-hour-4": "\u{f319}",
    "clock-hour-4-filled": "\u{fe5f}",
    "clock-hour-5": "\u{f31a}",
    "clock-hour-5-filled": "\u{fe5e}",
    "clock-hour-6": "\u{f31b}",
    "clock-hour-6-filled": "\u{fe5d}",
    "clock-hour-7": "\u{f31c}",
    "clock-hour-7-filled": "\u{fe5c}",
    "clock-hour-8": "\u{f31d}",
    "clock-hour-8-filled": "\u{fe5b}",
    "clock-hour-9": "\u{f31e}",
    "clock-hour-9-filled": "\u{fe5a}",
    "clock-minus": "\u{f848}",
    "clock-off": "\u{f0cf}",
    "clock-pause": "\u{f548}",
    "clock-pin": "\u{f849}",
    "clock-play": "\u{f549}",
    "clock-plus": "\u{f7c5}",
    "clock-question": "\u{f7c6}",
    "clock-record": "\u{f54a}",
    "clock-search": "\u{f7c7}",
    "clock-share": "\u{f84a}",
    "clock-shield": "\u{f7c8}",
    "clock-star": "\u{f7c9}",
    "clock-stop": "\u{f54b}",
    "clock-up": "\u{f7ca}",
    "clock-x": "\u{f7cb}",
    "clothes-rack": "\u{f285}",
    "clothes-rack-off": "\u{f3d6}",
    "cloud": "\u{ea76}",
    "cloud-bitcoin": "\u{ff3e}",
    "cloud-bolt": "\u{f84b}",
    "cloud-cancel": "\u{f84c}",
    "cloud-check": "\u{f84d}",
    "cloud-code": "\u{f84e}",
    "cloud-cog": "\u{f84f}",
    "cloud-computing": "\u{f1d0}",
    "cloud-computing-filled": "\u{1010d}",
    "cloud-data-connection": "\u{f1d1}",
    "cloud-data-connection-filled": "\u{1010c}",
    "cloud-dollar": "\u{f850}",
    "cloud-down": "\u{f851}",
    "cloud-download": "\u{ea71}",
    "cloud-exclamation": "\u{f852}",
    "cloud-filled": "\u{f673}",
    "cloud-fog": "\u{ecd9}",
    "cloud-heart": "\u{f853}",
    "cloud-lock": "\u{efdb}",
    "cloud-lock-open": "\u{efda}",
    "cloud-minus": "\u{f854}",
    "cloud-network": "\u{fc78}",
    "cloud-off": "\u{ed3e}",
    "cloud-pause": "\u{f855}",
    "cloud-pin": "\u{f856}",
    "cloud-plus": "\u{f857}",
    "cloud-question": "\u{f858}",
    "cloud-rain": "\u{ea72}",
    "cloud-search": "\u{f859}",
    "cloud-share": "\u{f85a}",
    "cloud-snow": "\u{ea73}",
    "cloud-star": "\u{f85b}",
    "cloud-storm": "\u{ea74}",
    "cloud-sun": "\u{ec6d}",
    "cloud-up": "\u{f85c}",
    "cloud-upload": "\u{ea75}",
    "cloud-x": "\u{f85d}",
    "clover": "\u{f1ea}",
    "clover-2": "\u{f21e}",
    "clover-filled": "\u{10013}",
    "clubs": "\u{eff4}",
    "clubs-filled": "\u{f674}",
    "code": "\u{ea77}",
    "code-asterisk": "\u{f312}",
    "code-asterix": "\u{f312}",
    "code-circle": "\u{f4ff}",
    "code-circle-2": "\u{f4fe}",
    "code-circle-2-filled": "\u{fed4}",
    "code-circle-filled": "\u{fed3}",
    "code-dots": "\u{f61a}",
    "code-minus": "\u{ee42}",
    "code-off": "\u{f0d0}",
    "code-plus": "\u{ee43}",
    "code-variable": "\u{100ab}",
    "code-variable-minus": "\u{100ad}",
    "code-variable-plus": "\u{100ac}",
    "coffee": "\u{ef0e}",
    "coffee-off": "\u{f106}",
    "coffin": "\u{f579}",
    "coin": "\u{eb82}",
    "coin-bitcoin": "\u{f2be}",
    "coin-bitcoin-filled": "\u{fd06}",
    "coin-euro": "\u{f2bf}",
    "coin-euro-filled": "\u{fd07}",
    "coin-filled": "\u{fd08}",
    "coin-monero": "\u{f4a0}",
    "coin-monero-filled": "\u{fd09}",
    "coin-off": "\u{f0d1}",
    "coin-pound": "\u{f2c0}",
    "coin-pound-filled": "\u{fd0a}",
    "coin-rupee": "\u{f2c1}",
    "coin-rupee-filled": "\u{fd0b}",
    "coin-taka": "\u{fd0d}",
    "coin-taka-filled": "\u{fd0c}",
    "coin-yen": "\u{f2c2}",
    "coin-yen-filled": "\u{fd0e}",
    "coin-yuan": "\u{f2c3}",
    "coin-yuan-filled": "\u{fd0f}",
    "coins": "\u{f65d}",
    "color-filter": "\u{f5a8}",
    "color-picker": "\u{ebe6}",
    "color-picker-off": "\u{f0d2}",
    "color-swatch": "\u{eb61}",
    "color-swatch-off": "\u{f0d3}",
    "column-insert-left": "\u{ee44}",
    "column-insert-right": "\u{ee45}",
    "column-remove": "\u{faf4}",
    "columns": "\u{eb83}",
    "columns-1": "\u{f6d4}",
    "columns-1-filled": "\u{10188}",
    "columns-2": "\u{f6d5}",
    "columns-2-filled": "\u{10187}",
    "columns-3": "\u{f6d6}",
    "columns-3-filled": "\u{10186}",
    "columns-off": "\u{f0d4}",
    "comet": "\u{ec76}",
    "command": "\u{ea78}",
    "command-off": "\u{f3d7}",
    "compass": "\u{ea79}",
    "compass-filled": "\u{fd10}",
    "compass-off": "\u{f0d5}",
    "components": "\u{efa5}",
    "components-off": "\u{f0d6}",
    "cone": "\u{efdd}",
    "cone-2": "\u{efdc}",
    "cone-2-filled": "\u{fe59}",
    "cone-filled": "\u{fe58}",
    "cone-off": "\u{f3d8}",
    "cone-plus": "\u{fa94}",
    "confetti": "\u{ee46}",
    "confetti-filled": "\u{10185}",
    "confetti-off": "\u{f3d9}",
    "confucius": "\u{f58a}",
    "congruent-to": "\u{ffa3}",
    "container": "\u{ee47}",
    "container-filled": "\u{10184}",
    "container-off": "\u{f107}",
    "contract": "\u{fefb}",
    "contrast": "\u{ec4e}",
    "contrast-2": "\u{efc7}",
    "contrast-2-filled": "\u{fe57}",
    "contrast-2-off": "\u{f3da}",
    "contrast-filled": "\u{fe56}",
    "contrast-off": "\u{f3db}",
    "cooker": "\u{f57a}",
    "cookie": "\u{fdb1}",
    "cookie-filled": "\u{fe54}",
    "cookie-man": "\u{fdb2}",
    "cookie-man-filled": "\u{fe55}",
    "cookie-off": "\u{f0d7}",
    "copy": "\u{ea7a}",
    "copy-check": "\u{fdb0}",
    "copy-check-filled": "\u{fe53}",
    "copy-minus": "\u{fdaf}",
    "copy-minus-filled": "\u{fe52}",
    "copy-off": "\u{f0d8}",
    "copy-plus": "\u{fdae}",
    "copy-plus-filled": "\u{fe51}",
    "copy-x": "\u{fdad}",
    "copy-x-filled": "\u{fe50}",
    "copyleft": "\u{ec3d}",
    "copyleft-filled": "\u{f73b}",
    "copyleft-off": "\u{f0d9}",
    "copyright": "\u{ea7b}",
    "copyright-filled": "\u{f73c}",
    "copyright-off": "\u{f0da}",
    "corner-down-left": "\u{ea7c}",
    "corner-down-left-double": "\u{ee48}",
    "corner-down-right": "\u{ea7d}",
    "corner-down-right-double": "\u{ee49}",
    "corner-left-down": "\u{ea7e}",
    "corner-left-down-double": "\u{ee4a}",
    "corner-left-up": "\u{ea7f}",
    "corner-left-up-double": "\u{ee4b}",
    "corner-right-down": "\u{ea80}",
    "corner-right-down-double": "\u{ee4c}",
    "corner-right-up": "\u{ea81}",
    "corner-right-up-double": "\u{ee4d}",
    "corner-up-left": "\u{ea82}",
    "corner-up-left-double": "\u{ee4e}",
    "corner-up-right": "\u{ea83}",
    "corner-up-right-double": "\u{ee4f}",
    "cpu": "\u{ef8e}",
    "cpu-2": "\u{f075}",
    "cpu-off": "\u{f108}",
    "crane": "\u{ef27}",
    "crane-off": "\u{f109}",
    "creative-commons": "\u{efb3}",
    "creative-commons-by": "\u{f21f}",
    "creative-commons-nc": "\u{f220}",
    "creative-commons-nd": "\u{f221}",
    "creative-commons-off": "\u{f10a}",
    "creative-commons-sa": "\u{f222}",
    "creative-commons-zero": "\u{f223}",
    "credit-card": "\u{ea84}",
    "credit-card-filled": "\u{fd11}",
    "credit-card-off": "\u{ed11}",
    "credit-card-pay": "\u{fd32}",
    "credit-card-refund": "\u{fd33}",
    "cricket": "\u{f09a}",
    "crop": "\u{ea85}",
    "crop-1-1": "\u{fd50}",
    "crop-1-1-filled": "\u{fe4f}",
    "crop-16-9": "\u{fd51}",
    "crop-16-9-filled": "\u{fe4e}",
    "crop-3-2": "\u{fd52}",
    "crop-3-2-filled": "\u{fe4d}",
    "crop-5-4": "\u{fd53}",
    "crop-5-4-filled": "\u{fe4c}",
    "crop-7-5": "\u{fd54}",
    "crop-7-5-filled": "\u{fe4b}",
    "crop-landscape": "\u{fd55}",
    "crop-landscape-filled": "\u{fe4a}",
    "crop-portrait": "\u{fd56}",
    "crop-portrait-filled": "\u{fe49}",
    "cross": "\u{ef8f}",
    "cross-filled": "\u{f675}",
    "cross-off": "\u{f10b}",
    "crosshair": "\u{ec3e}",
    "crown": "\u{ed12}",
    "crown-off": "\u{ee50}",
    "crutches": "\u{ef5b}",
    "crutches-off": "\u{f10c}",
    "crystal-ball": "\u{f57b}",
    "csv": "\u{f791}",
    "cube": "\u{fa97}",
    "cube-3d-sphere": "\u{ecd7}",
    "cube-3d-sphere-off": "\u{f3b5}",
    "cube-off": "\u{fa95}",
    "cube-plus": "\u{fa96}",
    "cube-send": "\u{f61b}",
    "cube-spark": "\u{ffbb}",
    "cube-unfolded": "\u{f61c}",
    "cup": "\u{ef28}",
    "cup-off": "\u{f10d}",
    "curling": "\u{efc8}",
    "curly-loop": "\u{ecda}",
    "currency": "\u{efa6}",
    "currency-afghani": "\u{f65e}",
    "currency-bahraini": "\u{ee51}",
    "currency-baht": "\u{f08a}",
    "currency-bitcoin": "\u{ebab}",
    "currency-cent": "\u{ee53}",
    "currency-dinar": "\u{ee54}",
    "currency-dirham": "\u{ee55}",
    "currency-dogecoin": "\u{ef4b}",
    "currency-dollar": "\u{eb84}",
    "currency-dollar-australian": "\u{ee56}",
    "currency-dollar-brunei": "\u{f36c}",
    "currency-dollar-canadian": "\u{ee57}",
    "currency-dollar-guyanese": "\u{f36d}",
    "currency-dollar-off": "\u{f3dc}",
    "currency-dollar-singapore": "\u{ee58}",
    "currency-dollar-zimbabwean": "\u{f36e}",
    "currency-dong": "\u{f36f}",
    "currency-dram": "\u{f370}",
    "currency-ethereum": "\u{ee59}",
    "currency-euro": "\u{eb85}",
    "currency-euro-off": "\u{f3dd}",
    "currency-florin": "\u{faf5}",
    "currency-forint": "\u{ee5a}",
    "currency-frank": "\u{ee5b}",
    "currency-guarani": "\u{f371}",
    "currency-hryvnia": "\u{f372}",
    "currency-iranian-rial": "\u{fa58}",
    "currency-kip": "\u{f373}",
    "currency-krone-czech": "\u{ee5c}",
    "currency-krone-danish": "\u{ee5d}",
    "currency-krone-swedish": "\u{ee5e}",
    "currency-lari": "\u{f374}",
    "currency-leu": "\u{ee5f}",
    "currency-lira": "\u{ee60}",
    "currency-litecoin": "\u{ee61}",
    "currency-lyd": "\u{f375}",
    "currency-manat": "\u{f376}",
    "currency-monero": "\u{f377}",
    "currency-naira": "\u{ee62}",
    "currency-nano": "\u{f7a6}",
    "currency-off": "\u{f3de}",
    "currency-paanga": "\u{f378}",
    "currency-peso": "\u{f65f}",
    "currency-pound": "\u{ebac}",
    "currency-pound-off": "\u{f3df}",
    "currency-quetzal": "\u{f379}",
    "currency-real": "\u{ee63}",
    "currency-renminbi": "\u{ee64}",
    "currency-ripple": "\u{ee65}",
    "currency-riyal": "\u{ee66}",
    "currency-rubel": "\u{ee67}",
    "currency-rufiyaa": "\u{f37a}",
    "currency-rupee": "\u{ebad}",
    "currency-rupee-nepalese": "\u{f37b}",
    "currency-shekel": "\u{ee68}",
    "currency-solana": "\u{f4a1}",
    "currency-som": "\u{f37c}",
    "currency-taka": "\u{ee69}",
    "currency-tenge": "\u{f37d}",
    "currency-tugrik": "\u{ee6a}",
    "currency-won": "\u{ee6b}",
    "currency-xrp": "\u{fd34}",
    "currency-yen": "\u{ebae}",
    "currency-yen-off": "\u{f3e0}",
    "currency-yuan": "\u{f29a}",
    "currency-zloty": "\u{ee6c}",
    "current-location": "\u{ecef}",
    "current-location-filled": "\u{10125}",
    "current-location-off": "\u{f10e}",
    "cursor-off": "\u{f10f}",
    "cursor-text": "\u{ee6d}",
    "cut": "\u{ea86}",
    "cylinder": "\u{f54c}",
    "cylinder-off": "\u{fa98}",
    "cylinder-plus": "\u{fa99}",
    "dashboard": "\u{ea87}",
    "dashboard-filled": "\u{10019}",
    "dashboard-off": "\u{f3e1}",
    "database": "\u{ea88}",
    "database-cog": "\u{fa10}",
    "database-dollar": "\u{fa11}",
    "database-edit": "\u{fa12}",
    "database-exclamation": "\u{fa13}",
    "database-export": "\u{ee6e}",
    "database-heart": "\u{fa14}",
    "database-import": "\u{ee6f}",
    "database-leak": "\u{fa15}",
    "database-minus": "\u{fa16}",
    "database-off": "\u{ee70}",
    "database-plus": "\u{fa17}",
    "database-search": "\u{fa18}",
    "database-share": "\u{fa19}",
    "database-smile": "\u{fd9b}",
    "database-star": "\u{fa1a}",
    "database-x": "\u{fa1b}",
    "decimal": "\u{fa26}",
    "deer": "\u{f4c5}",
    "delta": "\u{f53c}",
    "dental": "\u{f025}",
    "dental-broken": "\u{f286}",
    "dental-off": "\u{f110}",
    "deselect": "\u{f9f3}",
    "desk": "\u{fd35}",
    "details": "\u{ee71}",
    "details-off": "\u{f3e2}",
    "device-airpods": "\u{f5a9}",
    "device-airpods-case": "\u{f646}",
    "device-airtag": "\u{fae6}",
    "device-analytics": "\u{ee72}",
    "device-audio-tape": "\u{ee73}",
    "device-camera-phone": "\u{f233}",
    "device-cctv": "\u{ee74}",
    "device-cctv-filled": "\u{1004b}",
    "device-cctv-off": "\u{f3e3}",
    "device-computer-camera": "\u{ee76}",
    "device-computer-camera-off": "\u{ee75}",
    "device-desktop": "\u{ea89}",
    "device-desktop-analytics": "\u{ee77}",
    "device-desktop-bolt": "\u{f85e}",
    "device-desktop-cancel": "\u{f85f}",
    "device-desktop-check": "\u{f860}",
    "device-desktop-code": "\u{f861}",
    "device-desktop-cog": "\u{f862}",
    "device-desktop-dollar": "\u{f863}",
    "device-desktop-down": "\u{f864}",
    "device-desktop-exclamation": "\u{f865}",
    "device-desktop-filled": "\u{1004a}",
    "device-desktop-heart": "\u{f866}",
    "device-desktop-minus": "\u{f867}",
    "device-desktop-off": "\u{ee78}",
    "device-desktop-pause": "\u{f868}",
    "device-desktop-pin": "\u{f869}",
    "device-desktop-plus": "\u{f86a}",
    "device-desktop-question": "\u{f86b}",
    "device-desktop-search": "\u{f86c}",
    "device-desktop-share": "\u{f86d}",
    "device-desktop-star": "\u{f86e}",
    "device-desktop-up": "\u{f86f}",
    "device-desktop-x": "\u{f870}",
    "device-floppy": "\u{eb62}",
    "device-gamepad": "\u{eb63}",
    "device-gamepad-2": "\u{f1d2}",
    "device-gamepad-3": "\u{fc58}",
    "device-gamepad-3-filled": "\u{10049}",
    "device-heart-monitor": "\u{f060}",
    "device-heart-monitor-filled": "\u{fa38}",
    "device-imac": "\u{f7a7}",
    "device-imac-bolt": "\u{f871}",
    "device-imac-cancel": "\u{f872}",
    "device-imac-check": "\u{f873}",
    "device-imac-code": "\u{f874}",
    "device-imac-cog": "\u{f875}",
    "device-imac-dollar": "\u{f876}",
    "device-imac-down": "\u{f877}",
    "device-imac-exclamation": "\u{f878}",
    "device-imac-filled": "\u{10048}",
    "device-imac-heart": "\u{f879}",
    "device-imac-minus": "\u{f87a}",
    "device-imac-off": "\u{f87b}",
    "device-imac-pause": "\u{f87c}",
    "device-imac-pin": "\u{f87d}",
    "device-imac-plus": "\u{f87e}",
    "device-imac-question": "\u{f87f}",
    "device-imac-search": "\u{f880}",
    "device-imac-share": "\u{f881}",
    "device-imac-star": "\u{f882}",
    "device-imac-up": "\u{f883}",
    "device-imac-x": "\u{f884}",
    "device-ipad": "\u{f648}",
    "device-ipad-bolt": "\u{f885}",
    "device-ipad-cancel": "\u{f886}",
    "device-ipad-check": "\u{f887}",
    "device-ipad-code": "\u{f888}",
    "device-ipad-cog": "\u{f889}",
    "device-ipad-dollar": "\u{f88a}",
    "device-ipad-down": "\u{f88b}",
    "device-ipad-exclamation": "\u{f88c}",
    "device-ipad-filled": "\u{10047}",
    "device-ipad-heart": "\u{f88d}",
    "device-ipad-horizontal": "\u{f647}",
    "device-ipad-horizontal-bolt": "\u{f88e}",
    "device-ipad-horizontal-cancel": "\u{f88f}",
    "device-ipad-horizontal-check": "\u{f890}",
    "device-ipad-horizontal-code": "\u{f891}",
    "device-ipad-horizontal-cog": "\u{f892}",
    "device-ipad-horizontal-dollar": "\u{f893}",
    "device-ipad-horizontal-down": "\u{f894}",
    "device-ipad-horizontal-exclamation": "\u{f895}",
    "device-ipad-horizontal-heart": "\u{f896}",
    "device-ipad-horizontal-minus": "\u{f897}",
    "device-ipad-horizontal-off": "\u{f898}",
    "device-ipad-horizontal-pause": "\u{f899}",
    "device-ipad-horizontal-pin": "\u{f89a}",
    "device-ipad-horizontal-plus": "\u{f89b}",
    "device-ipad-horizontal-question": "\u{f89c}",
    "device-ipad-horizontal-search": "\u{f89d}",
    "device-ipad-horizontal-share": "\u{f89e}",
    "device-ipad-horizontal-star": "\u{f89f}",
    "device-ipad-horizontal-up": "\u{f8a0}",
    "device-ipad-horizontal-x": "\u{f8a1}",
    "device-ipad-minus": "\u{f8a2}",
    "device-ipad-off": "\u{f8a3}",
    "device-ipad-pause": "\u{f8a4}",
    "device-ipad-pin": "\u{f8a5}",
    "device-ipad-plus": "\u{f8a6}",
    "device-ipad-question": "\u{f8a7}",
    "device-ipad-search": "\u{f8a8}",
    "device-ipad-share": "\u{f8a9}",
    "device-ipad-star": "\u{f8aa}",
    "device-ipad-up": "\u{f8ab}",
    "device-ipad-x": "\u{f8ac}",
    "device-landline-phone": "\u{f649}",
    "device-laptop": "\u{eb64}",
    "device-laptop-off": "\u{f061}",
    "device-mobile": "\u{ea8a}",
    "device-mobile-bolt": "\u{f8ad}",
    "device-mobile-cancel": "\u{f8ae}",
    "device-mobile-charging": "\u{f224}",
    "device-mobile-check": "\u{f8af}",
    "device-mobile-code": "\u{f8b0}",
    "device-mobile-cog": "\u{f8b1}",
    "device-mobile-dollar": "\u{f8b2}",
    "device-mobile-down": "\u{f8b3}",
    "device-mobile-exclamation": "\u{f8b4}",
    "device-mobile-filled": "\u{fa39}",
    "device-mobile-heart": "\u{f8b5}",
    "device-mobile-message": "\u{ee79}",
    "device-mobile-minus": "\u{f8b6}",
    "device-mobile-off": "\u{f062}",
    "device-mobile-pause": "\u{f8b7}",
    "device-mobile-pin": "\u{f8b8}",
    "device-mobile-plus": "\u{f8b9}",
    "device-mobile-question": "\u{f8ba}",
    "device-mobile-rotated": "\u{ecdb}",
    "device-mobile-search": "\u{f8bb}",
    "device-mobile-share": "\u{f8bc}",
    "device-mobile-star": "\u{f8bd}",
    "device-mobile-up": "\u{f8be}",
    "device-mobile-vibration": "\u{eb86}",
    "device-mobile-x": "\u{f8bf}",
    "device-nintendo": "\u{f026}",
    "device-nintendo-off": "\u{f111}",
    "device-projector": "\u{fc11}",
    "device-remote": "\u{f792}",
    "device-remote-filled": "\u{10046}",
    "device-sd-card": "\u{f384}",
    "device-sim": "\u{f4b2}",
    "device-sim-1": "\u{f4af}",
    "device-sim-2": "\u{f4b0}",
    "device-sim-3": "\u{f4b1}",
    "device-speaker": "\u{ea8b}",
    "device-speaker-filled": "\u{10045}",
    "device-speaker-off": "\u{f112}",
    "device-tablet": "\u{ea8c}",
    "device-tablet-bolt": "\u{f8c0}",
    "device-tablet-cancel": "\u{f8c1}",
    "device-tablet-check": "\u{f8c2}",
    "device-tablet-code": "\u{f8c3}",
    "device-tablet-cog": "\u{f8c4}",
    "device-tablet-dollar": "\u{f8c5}",
    "device-tablet-down": "\u{f8c6}",
    "device-tablet-exclamation": "\u{f8c7}",
    "device-tablet-filled": "\u{fa3a}",
    "device-tablet-heart": "\u{f8c8}",
    "device-tablet-minus": "\u{f8c9}",
    "device-tablet-off": "\u{f063}",
    "device-tablet-pause": "\u{f8ca}",
    "device-tablet-pin": "\u{f8cb}",
    "device-tablet-plus": "\u{f8cc}",
    "device-tablet-question": "\u{f8cd}",
    "device-tablet-search": "\u{f8ce}",
    "device-tablet-share": "\u{f8cf}",
    "device-tablet-star": "\u{f8d0}",
    "device-tablet-up": "\u{f8d1}",
    "device-tablet-x": "\u{f8d2}",
    "device-tv": "\u{ea8d}",
    "device-tv-filled": "\u{10043}",
    "device-tv-off": "\u{f064}",
    "device-tv-old": "\u{f1d3}",
    "device-tv-old-filled": "\u{10044}",
    "device-unknown": "\u{fef4}",
    "device-unknown-filled": "\u{10018}",
    "device-usb": "\u{fc59}",
    "device-usb-filled": "\u{10042}",
    "device-vision-pro": "\u{fae7}",
    "device-vision-pro-filled": "\u{10041}",
    "device-watch": "\u{ebf9}",
    "device-watch-bolt": "\u{f8d3}",
    "device-watch-cancel": "\u{f8d4}",
    "device-watch-check": "\u{f8d5}",
    "device-watch-code": "\u{f8d6}",
    "device-watch-cog": "\u{f8d7}",
    "device-watch-dollar": "\u{f8d8}",
    "device-watch-down": "\u{f8d9}",
    "device-watch-exclamation": "\u{f8da}",
    "device-watch-filled": "\u{10040}",
    "device-watch-heart": "\u{f8db}",
    "device-watch-minus": "\u{f8dc}",
    "device-watch-off": "\u{f065}",
    "device-watch-pause": "\u{f8dd}",
    "device-watch-pin": "\u{f8de}",
    "device-watch-plus": "\u{f8df}",
    "device-watch-question": "\u{f8e0}",
    "device-watch-search": "\u{f8e1}",
    "device-watch-share": "\u{f8e2}",
    "device-watch-star": "\u{f8e3}",
    "device-watch-stats": "\u{ef7d}",
    "device-watch-stats-2": "\u{ef7c}",
    "device-watch-up": "\u{f8e4}",
    "device-watch-x": "\u{f8e5}",
    "devices": "\u{eb87}",
    "devices-2": "\u{ed29}",
    "devices-bolt": "\u{f8e6}",
    "devices-cancel": "\u{f8e7}",
    "devices-check": "\u{f8e8}",
    "devices-code": "\u{f8e9}",
    "devices-cog": "\u{f8ea}",
    "devices-dollar": "\u{f8eb}",
    "devices-down": "\u{f8ec}",
    "devices-exclamation": "\u{f8ed}",
    "devices-heart": "\u{f8ee}",
    "devices-minus": "\u{f8ef}",
    "devices-off": "\u{f3e4}",
    "devices-pause": "\u{f8f0}",
    "devices-pc": "\u{ee7a}",
    "devices-pc-off": "\u{f113}",
    "devices-pin": "\u{f8f1}",
    "devices-plus": "\u{f8f2}",
    "devices-question": "\u{f8f3}",
    "devices-search": "\u{f8f4}",
    "devices-share": "\u{f8f5}",
    "devices-star": "\u{f8f6}",
    "devices-up": "\u{f8f7}",
    "devices-x": "\u{f8f8}",
    "diabolo": "\u{fa9c}",
    "diabolo-off": "\u{fa9a}",
    "diabolo-plus": "\u{fa9b}",
    "dialpad": "\u{f067}",
    "dialpad-filled": "\u{fa3b}",
    "dialpad-off": "\u{f114}",
    "diamond": "\u{eb65}",
    "diamond-filled": "\u{f73d}",
    "diamond-off": "\u{f115}",
    "diamonds": "\u{eff5}",
    "diamonds-filled": "\u{f676}",
    "diaper": "\u{ffa2}",
    "dice": "\u{eb66}",
    "dice-1": "\u{f08b}",
    "dice-1-filled": "\u{f73e}",
    "dice-2": "\u{f08c}",
    "dice-2-filled": "\u{f73f}",
    "dice-3": "\u{f08d}",
    "dice-3-filled": "\u{f740}",
    "dice-4": "\u{f08e}",
    "dice-4-filled": "\u{f741}",
    "dice-5": "\u{f08f}",
    "dice-5-filled": "\u{f742}",
    "dice-6": "\u{f090}",
    "dice-6-filled": "\u{f743}",
    "dice-filled": "\u{f744}",
    "dimensions": "\u{ee7b}",
    "direction": "\u{ebfb}",
    "direction-arrows": "\u{fd36}",
    "direction-arrows-filled": "\u{100ca}",
    "direction-horizontal": "\u{ebfa}",
    "direction-sign": "\u{f1f7}",
    "direction-sign-filled": "\u{f745}",
    "direction-sign-off": "\u{f3e5}",
    "directions": "\u{ea8e}",
    "directions-filled": "\u{1003f}",
    "directions-off": "\u{f116}",
    "disabled": "\u{ea8f}",
    "disabled-2": "\u{ebaf}",
    "disabled-off": "\u{f117}",
    "disc": "\u{ea90}",
    "disc-filled": "\u{1003e}",
    "disc-golf": "\u{f385}",
    "disc-off": "\u{f118}",
    "discount": "\u{ebbd}",
    "discount-2": "\u{ee7c}",
    "discount-2-off": "\u{f3e6}",
    "discount-check": "\u{f1f8}",
    "discount-check-filled": "\u{f746}",
    "discount-filled": "\u{1003d}",
    "discount-off": "\u{f3e7}",
    "divide": "\u{ed5c}",
    "dna": "\u{ee7d}",
    "dna-2": "\u{ef5c}",
    "dna-2-off": "\u{f119}",
    "dna-off": "\u{f11a}",
    "dog": "\u{f660}",
    "dog-bowl": "\u{ef29}",
    "door": "\u{ef4e}",
    "door-enter": "\u{ef4c}",
    "door-exit": "\u{ef4d}",
    "door-off": "\u{f11b}",
    "dots": "\u{ea95}",
    "dots-circle-horizontal": "\u{ea91}",
    "dots-diagonal": "\u{ea93}",
    "dots-diagonal-2": "\u{ea92}",
    "dots-vertical": "\u{ea94}",
    "download": "\u{ea96}",
    "download-off": "\u{f11c}",
    "drag-drop": "\u{eb89}",
    "drag-drop-2": "\u{eb88}",
    "drone": "\u{ed79}",
    "drone-off": "\u{ee7e}",
    "drop-circle": "\u{efde}",
    "drop-circle-filled": "\u{10137}",
    "droplet": "\u{ea97}",
    "droplet-bolt": "\u{f8f9}",
    "droplet-cancel": "\u{f8fa}",
    "droplet-check": "\u{f8fb}",
    "droplet-code": "\u{f8fc}",
    "droplet-cog": "\u{f8fd}",
    "droplet-dollar": "\u{f8fe}",
    "droplet-down": "\u{f8ff}",
    "droplet-exclamation": "\u{f900}",
    "droplet-filled": "\u{ee80}",
    "droplet-half": "\u{ee82}",
    "droplet-half-2": "\u{ee81}",
    "droplet-half-2-filled": "\u{fb6c}",
    "droplet-half-filled": "\u{f6c5}",
    "droplet-heart": "\u{f901}",
    "droplet-minus": "\u{f902}",
    "droplet-off": "\u{ee83}",
    "droplet-pause": "\u{f903}",
    "droplet-pin": "\u{f904}",
    "droplet-plus": "\u{f905}",
    "droplet-question": "\u{f906}",
    "droplet-search": "\u{f907}",
    "droplet-share": "\u{f908}",
    "droplet-star": "\u{f909}",
    "droplet-up": "\u{f90a}",
    "droplet-x": "\u{f90b}",
    "droplets": "\u{fc12}",
    "droplets-filled": "\u{100c9}",
    "dual-screen": "\u{fa59}",
    "dual-screen-filled": "\u{10136}",
    "dumpling": "\u{feb5}",
    "dumpling-filled": "\u{10135}",
    "e-passport": "\u{f4df}",
    "ear": "\u{ebce}",
    "ear-off": "\u{ee84}",
    "ear-scan": "\u{fd57}",
    "ease-in": "\u{f573}",
    "ease-in-control-point": "\u{f570}",
    "ease-in-control-point-filled": "\u{10174}",
    "ease-in-out": "\u{f572}",
    "ease-in-out-control-points": "\u{f571}",
    "ease-in-out-control-points-filled": "\u{10173}",
    "ease-out": "\u{f575}",
    "ease-out-control-point": "\u{f574}",
    "ease-out-control-point-filled": "\u{10172}",
    "edit": "\u{ea98}",
    "edit-circle": "\u{ee85}",
    "edit-circle-off": "\u{f11d}",
    "edit-off": "\u{f11e}",
    "egg": "\u{eb8a}",
    "egg-cracked": "\u{f2d6}",
    "egg-cracked-filled": "\u{10012}",
    "egg-filled": "\u{f678}",
    "egg-fried": "\u{f386}",
    "egg-fried-filled": "\u{10134}",
    "egg-off": "\u{f11f}",
    "eggs": "\u{f500}",
    "elevator": "\u{efdf}",
    "elevator-filled": "\u{1003c}",
    "elevator-off": "\u{f3e8}",
    "emergency-bed": "\u{ef5d}",
    "empathize": "\u{f29b}",
    "empathize-off": "\u{f3e9}",
    "emphasis": "\u{ebcf}",
    "engine": "\u{ef7e}",
    "engine-filled": "\u{100fc}",
    "engine-off": "\u{f120}",
    "equal": "\u{ee87}",
    "equal-double": "\u{f4e1}",
    "equal-not": "\u{ee86}",
    "eraser": "\u{eb8b}",
    "eraser-off": "\u{f121}",
    "error-404": "\u{f027}",
    "error-404-off": "\u{f122}",
    "escalator": "\u{fb06}",
    "escalator-down": "\u{fb04}",
    "escalator-down-filled": "\u{10133}",
    "escalator-filled": "\u{10131}",
    "escalator-up": "\u{fb05}",
    "escalator-up-filled": "\u{10132}",
    "exchange": "\u{ebe7}",
    "exchange-filled": "\u{10130}",
    "exchange-off": "\u{f123}",
    "exclamation-circle": "\u{f634}",
    "exclamation-circle-filled": "\u{ff62}",
    "exclamation-mark": "\u{efb4}",
    "exclamation-mark-off": "\u{f124}",
    "explicit": "\u{f256}",
    "explicit-filled": "\u{1012f}",
    "explicit-off": "\u{f3ea}",
    "exposure": "\u{eb8c}",
    "exposure-0": "\u{f29c}",
    "exposure-filled": "\u{10124}",
    "exposure-minus-1": "\u{f29d}",
    "exposure-minus-2": "\u{f29e}",
    "exposure-off": "\u{f3eb}",
    "exposure-plus-1": "\u{f29f}",
    "exposure-plus-2": "\u{f2a0}",
    "external-link": "\u{ea99}",
    "external-link-off": "\u{f125}",
    "eye": "\u{ea9a}",
    "eye-bitcoin": "\u{ff3d}",
    "eye-bolt": "\u{fb6d}",
    "eye-cancel": "\u{fb6e}",
    "eye-check": "\u{ee88}",
    "eye-closed": "\u{f7ec}",
    "eye-code": "\u{fb6f}",
    "eye-cog": "\u{f7ed}",
    "eye-discount": "\u{fb70}",
    "eye-dollar": "\u{fb71}",
    "eye-dotted": "\u{fead}",
    "eye-down": "\u{fb72}",
    "eye-edit": "\u{f7ee}",
    "eye-exclamation": "\u{f7ef}",
    "eye-filled": "\u{f679}",
    "eye-heart": "\u{f7f0}",
    "eye-minus": "\u{fb73}",
    "eye-off": "\u{ecf0}",
    "eye-pause": "\u{fb74}",
    "eye-pin": "\u{fb75}",
    "eye-plus": "\u{fb76}",
    "eye-question": "\u{fb77}",
    "eye-search": "\u{fb78}",
    "eye-share": "\u{fb79}",
    "eye-spark": "\u{ffba}",
    "eye-star": "\u{fb7a}",
    "eye-table": "\u{ef5e}",
    "eye-table-filled": "\u{10123}",
    "eye-up": "\u{fb7b}",
    "eye-x": "\u{f7f1}",
    "eyeglass": "\u{ee8a}",
    "eyeglass-2": "\u{ee89}",
    "eyeglass-2-filled": "\u{10122}",
    "eyeglass-filled": "\u{100c8}",
    "eyeglass-off": "\u{f126}",
    "face-id": "\u{ea9b}",
    "face-id-error": "\u{efa7}",
    "face-mask": "\u{efb5}",
    "face-mask-filled": "\u{10121}",
    "face-mask-off": "\u{f127}",
    "fall": "\u{ecb9}",
    "favicon": "\u{fd65}",
    "favicon-filled": "\u{10071}",
    "feather": "\u{ee8b}",
    "feather-filled": "\u{10011}",
    "feather-off": "\u{f128}",
    "fence": "\u{ef2a}",
    "fence-filled": "\u{10120}",
    "fence-off": "\u{f129}",
    "ferry": "\u{10074}",
    "ferry-filled": "\u{100fb}",
    "fidget-spinner": "\u{f068}",
    "fidget-spinner-filled": "\u{1011f}",
    "file": "\u{eaa4}",
    "file-3d": "\u{f032}",
    "file-ai": "\u{ffa1}",
    "file-alert": "\u{ede6}",
    "file-analytics": "\u{ede7}",
    "file-analytics-filled": "\u{10171}",
    "file-arrow-left": "\u{f033}",
    "file-arrow-right": "\u{f034}",
    "file-barcode": "\u{f035}",
    "file-bitcoin": "\u{ffa0}",
    "file-broken": "\u{f501}",
    "file-certificate": "\u{ed4d}",
    "file-chart": "\u{f036}",
    "file-check": "\u{ea9c}",
    "file-check-filled": "\u{1012e}",
    "file-code": "\u{ebd0}",
    "file-code-2": "\u{ede8}",
    "file-code-2-filled": "\u{1012d}",
    "file-code-filled": "\u{10170}",
    "file-cv": "\u{fa5a}",
    "file-cv-filled": "\u{1012c}",
    "file-database": "\u{f037}",
    "file-delta": "\u{f53d}",
    "file-delta-filled": "\u{1012b}",
    "file-description": "\u{f028}",
    "file-description-filled": "\u{1011e}",
    "file-diff": "\u{ecf1}",
    "file-diff-filled": "\u{1016f}",
    "file-digit": "\u{efa8}",
    "file-digit-filled": "\u{1011d}",
    "file-dislike": "\u{ed2a}",
    "file-dollar": "\u{efe0}",
    "file-dots": "\u{f038}",
    "file-dots-filled": "\u{1016e}",
    "file-download": "\u{ea9d}",
    "file-download-filled": "\u{1012a}",
    "file-euro": "\u{efe1}",
    "file-excel": "\u{fef3}",
    "file-export": "\u{ede9}",
    "file-filled": "\u{f747}",
    "file-function": "\u{f53e}",
    "file-function-filled": "\u{1016d}",
    "file-horizontal": "\u{ebb0}",
    "file-horizontal-filled": "\u{1011c}",
    "file-import": "\u{edea}",
    "file-infinity": "\u{f502}",
    "file-info": "\u{edec}",
    "file-info-filled": "\u{1016c}",
    "file-invoice": "\u{eb67}",
    "file-invoice-filled": "\u{1011b}",
    "file-isr": "\u{feac}",
    "file-lambda": "\u{f53f}",
    "file-lambda-filled": "\u{10129}",
    "file-like": "\u{ed2b}",
    "file-minus": "\u{ea9e}",
    "file-minus-filled": "\u{1011a}",
    "file-music": "\u{ea9f}",
    "file-neutral": "\u{fd22}",
    "file-neutral-filled": "\u{10119}",
    "file-off": "\u{ecf2}",
    "file-orientation": "\u{f2a1}",
    "file-pencil": "\u{f039}",
    "file-percent": "\u{f540}",
    "file-percent-filled": "\u{10128}",
    "file-phone": "\u{ecdc}",
    "file-phone-filled": "\u{10127}",
    "file-plus": "\u{eaa0}",
    "file-power": "\u{f03a}",
    "file-power-filled": "\u{10118}",
    "file-report": "\u{eded}",
    "file-rss": "\u{f03b}",
    "file-rss-filled": "\u{10126}",
    "file-sad": "\u{fd23}",
    "file-sad-filled": "\u{10117}",
    "file-scissors": "\u{f03c}",
    "file-search": "\u{ed5d}",
    "file-settings": "\u{f029}",
    "file-shredder": "\u{eaa1}",
    "file-signal": "\u{f03d}",
    "file-smile": "\u{fd24}",
    "file-smile-filled": "\u{10116}",
    "file-spark": "\u{ffb9}",
    "file-spreadsheet": "\u{f03e}",
    "file-stack": "\u{f503}",
    "file-star": "\u{f03f}",
    "file-star-filled": "\u{10115}",
    "file-symlink": "\u{ed53}",
    "file-text": "\u{eaa2}",
    "file-text-ai": "\u{fa27}",
    "file-text-filled": "\u{10114}",
    "file-text-shield": "\u{100f2}",
    "file-text-spark": "\u{ffb8}",
    "file-time": "\u{f040}",
    "file-type-bmp": "\u{fb07}",
    "file-type-css": "\u{fb08}",
    "file-type-csv": "\u{fb09}",
    "file-type-doc": "\u{fb0a}",
    "file-type-docx": "\u{fb0b}",
    "file-type-html": "\u{fb0c}",
    "file-type-jpg": "\u{fb0d}",
    "file-type-js": "\u{fb0e}",
    "file-type-jsx": "\u{fb0f}",
    "file-type-pdf": "\u{fb10}",
    "file-type-php": "\u{fb11}",
    "file-type-png": "\u{fb12}",
    "file-type-ppt": "\u{fb13}",
    "file-type-rs": "\u{fb14}",
    "file-type-sql": "\u{fb15}",
    "file-type-svg": "\u{fb16}",
    "file-type-ts": "\u{fb17}",
    "file-type-tsx": "\u{fb18}",
    "file-type-txt": "\u{fb19}",
    "file-type-vue": "\u{fb1a}",
    "file-type-xls": "\u{fb1b}",
    "file-type-xml": "\u{fb1c}",
    "file-type-zip": "\u{fb1d}",
    "file-typography": "\u{f041}",
    "file-typography-filled": "\u{1016b}",
    "file-unknown": "\u{f042}",
    "file-upload": "\u{ec91}",
    "file-vector": "\u{f043}",
    "file-word": "\u{fef2}",
    "file-x": "\u{eaa3}",
    "file-x-filled": "\u{f748}",
    "file-zip": "\u{ed4e}",
    "files": "\u{edef}",
    "files-off": "\u{edee}",
    "filter": "\u{eaa5}",
    "filter-2": "\u{1014b}",
    "filter-2-bolt": "\u{1015f}",
    "filter-2-cancel": "\u{1015e}",
    "filter-2-check": "\u{1015d}",
    "filter-2-code": "\u{1015c}",
    "filter-2-cog": "\u{1015b}",
    "filter-2-discount": "\u{1015a}",
    "filter-2-dollar": "\u{10159}",
    "filter-2-down": "\u{10158}",
    "filter-2-edit": "\u{10157}",
    "filter-2-exclamation": "\u{10156}",
    "filter-2-minus": "\u{10155}",
    "filter-2-pause": "\u{10154}",
    "filter-2-pin": "\u{10153}",
    "filter-2-plus": "\u{10152}",
    "filter-2-question": "\u{10151}",
    "filter-2-search": "\u{10150}",
    "filter-2-share": "\u{1014f}",
    "filter-2-spark": "\u{1014e}",
    "filter-2-up": "\u{1014d}",
    "filter-2-x": "\u{1014c}",
    "filter-bolt": "\u{fb7c}",
    "filter-cancel": "\u{fb7d}",
    "filter-check": "\u{fb7e}",
    "filter-code": "\u{fb7f}",
    "filter-cog": "\u{f9fe}",
    "filter-discount": "\u{fb80}",
    "filter-dollar": "\u{f9ff}",
    "filter-down": "\u{fb81}",
    "filter-edit": "\u{fa00}",
    "filter-exclamation": "\u{fb82}",
    "filter-filled": "\u{fc27}",
    "filter-heart": "\u{fb83}",
    "filter-minus": "\u{fa01}",
    "filter-off": "\u{ed2c}",
    "filter-pause": "\u{fb84}",
    "filter-pin": "\u{fb85}",
    "filter-plus": "\u{fa02}",
    "filter-question": "\u{fb86}",
    "filter-search": "\u{fb87}",
    "filter-share": "\u{fb88}",
    "filter-spark": "\u{1014a}",
    "filter-star": "\u{fa03}",
    "filter-up": "\u{fb89}",
    "filter-x": "\u{fa04}",
    "filters": "\u{f793}",
    "filters-filled": "\u{100c7}",
    "fingerprint": "\u{ebd1}",
    "fingerprint-off": "\u{f12a}",
    "fingerprint-scan": "\u{fcb5}",
    "fire-extinguisher": "\u{faf6}",
    "fire-hydrant": "\u{f3a9}",
    "fire-hydrant-off": "\u{f3ec}",
    "firetruck": "\u{ebe8}",
    "first-aid-kit": "\u{ef5f}",
    "first-aid-kit-off": "\u{f3ed}",
    "fish": "\u{ef2b}",
    "fish-bone": "\u{f287}",
    "fish-bone-filled": "\u{1010b}",
    "fish-christianity": "\u{f58b}",
    "fish-hook": "\u{f1f9}",
    "fish-hook-off": "\u{f3ee}",
    "fish-off": "\u{f12b}",
    "flag": "\u{eaa6}",
    "flag-2": "\u{ee8c}",
    "flag-2-filled": "\u{f707}",
    "flag-2-off": "\u{f12c}",
    "flag-3": "\u{ee8d}",
    "flag-3-filled": "\u{f708}",
    "flag-bitcoin": "\u{ff3c}",
    "flag-bolt": "\u{fb8a}",
    "flag-cancel": "\u{fb8b}",
    "flag-check": "\u{fb8c}",
    "flag-code": "\u{fb8d}",
    "flag-cog": "\u{fb8e}",
    "flag-discount": "\u{fb8f}",
    "flag-dollar": "\u{fb90}",
    "flag-down": "\u{fb91}",
    "flag-exclamation": "\u{fb92}",
    "flag-filled": "\u{f67a}",
    "flag-heart": "\u{fb93}",
    "flag-minus": "\u{fb94}",
    "flag-off": "\u{f12d}",
    "flag-pause": "\u{fb95}",
    "flag-pin": "\u{fb96}",
    "flag-plus": "\u{fb97}",
    "flag-question": "\u{fb98}",
    "flag-search": "\u{fb99}",
    "flag-share": "\u{fb9a}",
    "flag-spark": "\u{ffb7}",
    "flag-star": "\u{fb9b}",
    "flag-up": "\u{fb9c}",
    "flag-x": "\u{fb9d}",
    "flame": "\u{ec2c}",
    "flame-filled": "\u{100c6}",
    "flame-off": "\u{f12e}",
    "flare": "\u{ee8e}",
    "flare-filled": "\u{100c5}",
    "flask": "\u{ebd2}",
    "flask-2": "\u{ef60}",
    "flask-2-filled": "\u{fd12}",
    "flask-2-off": "\u{f12f}",
    "flask-filled": "\u{fd13}",
    "flask-off": "\u{f130}",
    "flip-flops": "\u{f564}",
    "flip-horizontal": "\u{eaa7}",
    "flip-vertical": "\u{eaa8}",
    "float-center": "\u{ebb1}",
    "float-left": "\u{ebb2}",
    "float-none": "\u{ed13}",
    "float-right": "\u{ebb3}",
    "flower": "\u{eff6}",
    "flower-filled": "\u{10010}",
    "flower-off": "\u{f131}",
    "focus": "\u{eb8d}",
    "focus-2": "\u{ebd3}",
    "focus-auto": "\u{fa62}",
    "focus-centered": "\u{f02a}",
    "fold": "\u{ed56}",
    "fold-down": "\u{ed54}",
    "fold-up": "\u{ed55}",
    "folder": "\u{eaad}",
    "folder-bolt": "\u{f90c}",
    "folder-cancel": "\u{f90d}",
    "folder-check": "\u{f90e}",
    "folder-code": "\u{f90f}",
    "folder-cog": "\u{f910}",
    "folder-dollar": "\u{f911}",
    "folder-down": "\u{f912}",
    "folder-exclamation": "\u{f913}",
    "folder-filled": "\u{f749}",
    "folder-heart": "\u{f914}",
    "folder-minus": "\u{eaaa}",
    "folder-off": "\u{ed14}",
    "folder-open": "\u{faf7}",
    "folder-pause": "\u{f915}",
    "folder-pin": "\u{f916}",
    "folder-plus": "\u{eaab}",
    "folder-question": "\u{f917}",
    "folder-root": "\u{fd43}",
    "folder-search": "\u{f918}",
    "folder-share": "\u{f919}",
    "folder-star": "\u{f91a}",
    "folder-symlink": "\u{f91b}",
    "folder-up": "\u{f91c}",
    "folder-x": "\u{eaac}",
    "folders": "\u{eaae}",
    "folders-filled": "\u{100c4}",
    "folders-off": "\u{f133}",
    "forbid": "\u{ebd5}",
    "forbid-2": "\u{ebd4}",
    "forbid-2-filled": "\u{fc28}",
    "forbid-filled": "\u{fc29}",
    "forklift": "\u{ebe9}",
    "forms": "\u{ee8f}",
    "fountain": "\u{f09b}",
    "fountain-filled": "\u{fc2a}",
    "fountain-off": "\u{f134}",
    "frame": "\u{eaaf}",
    "frame-off": "\u{f135}",
    "free-rights": "\u{efb6}",
    "freeze-column": "\u{fa63}",
    "freeze-row": "\u{fa65}",
    "freeze-row-column": "\u{fa64}",
    "fridge": "\u{f1fa}",
    "fridge-off": "\u{f3ef}",
    "friends": "\u{eab0}",
    "friends-off": "\u{f136}",
    "frustum": "\u{fa9f}",
    //"frustum-off": "\u{fa9d}",
    "frustum-plus": "\u{fa9e}",
    "function": "\u{f225}",
    "function-filled": "\u{fc2b}",
    "function-off": "\u{f3f0}",
    "galaxy": "\u{fcb6}",
    "garden-cart": "\u{f23e}",
    "garden-cart-filled": "\u{100c3}",
    "garden-cart-off": "\u{f3f1}",
    "gas-station": "\u{ec7d}",
    "gas-station-filled": "\u{100fa}",
    "gas-station-off": "\u{f137}",
    "gauge": "\u{eab1}",
    "gauge-filled": "\u{fc2c}",
    "gauge-off": "\u{f138}",
    "gavel": "\u{ef90}",
    "gender-agender": "\u{f0e1}",
    "gender-androgyne": "\u{f0e2}",
    "gender-bigender": "\u{f0e3}",
    "gender-demiboy": "\u{f0e4}",
    "gender-demigirl": "\u{f0e5}",
    "gender-epicene": "\u{f0e6}",
    "gender-female": "\u{f0e7}",
    "gender-femme": "\u{f0e8}",
    "gender-genderfluid": "\u{f0e9}",
    "gender-genderless": "\u{f0ea}",
    "gender-genderqueer": "\u{f0eb}",
    "gender-hermaphrodite": "\u{f0ec}",
    "gender-intergender": "\u{f0ed}",
    "gender-male": "\u{f0ee}",
    "gender-neutrois": "\u{f0ef}",
    "gender-third": "\u{f0f0}",
    "gender-transgender": "\u{f0f1}",
    "gender-trasvesti": "\u{f0f2}",
    "geometry": "\u{ee90}",
    "ghost": "\u{eb8e}",
    "ghost-2": "\u{f57c}",
    "ghost-2-filled": "\u{f74a}",
    "ghost-3": "\u{fc13}",
    "ghost-3-filled": "\u{100a4}",
    "ghost-filled": "\u{f74b}",
    "ghost-off": "\u{f3f2}",
    "gif": "\u{f257}",
    "gift": "\u{eb68}",
    "gift-card": "\u{f3aa}",
    "gift-card-filled": "\u{fc2d}",
    "gift-filled": "\u{fd14}",
    "gift-off": "\u{f3f3}",
    "git-branch": "\u{eab2}",
    "git-branch-deleted": "\u{f57d}",
    "git-cherry-pick": "\u{f57e}",
    "git-commit": "\u{eab3}",
    "git-compare": "\u{eab4}",
    "git-fork": "\u{eb8f}",
    "git-merge": "\u{eab5}",
    "git-pull-request": "\u{eab6}",
    "git-pull-request-closed": "\u{ef7f}",
    "git-pull-request-draft": "\u{efb7}",
    "gizmo": "\u{f02b}",
    "glass": "\u{eab8}",
    "glass-champagne": "\u{fd9c}",
    "glass-cocktail": "\u{fd9d}",
    "glass-filled": "\u{1000f}",
    "glass-full": "\u{eab7}",
    "glass-full-filled": "\u{fc2e}",
    "glass-gin": "\u{fd9e}",
    "glass-off": "\u{ee91}",
    "globe": "\u{eab9}",
    "globe-filled": "\u{fc2f}",
    "globe-off": "\u{f139}",
    "go-game": "\u{f512}",
    "golf": "\u{ed8c}",
    "golf-filled": "\u{100a3}",
    "golf-off": "\u{f13a}",
    "gps": "\u{ed7a}",
    "gps-filled": "\u{fe48}",
    "gradienter": "\u{f3ab}",
    "grain": "\u{ee92}",
    "graph": "\u{f288}",
    "graph-filled": "\u{fd15}",
    "graph-off": "\u{f3f4}",
    "grave": "\u{f580}",
    "grave-2": "\u{f57f}",
    "grid-3x3": "\u{fca4}",
    "grid-4x4": "\u{fca5}",
    "grid-dots": "\u{eaba}",
    "grid-goldenratio": "\u{fca6}",
    "grid-pattern": "\u{efc9}",
    "grid-pattern-filled": "\u{100c2}",
    "grid-scan": "\u{fca7}",
    "grill": "\u{efa9}",
    "grill-fork": "\u{f35b}",
    "grill-off": "\u{f3f5}",
    "grill-spatula": "\u{f35c}",
    "grip-horizontal": "\u{ec00}",
    "grip-vertical": "\u{ec01}",
    "growth": "\u{ee93}",
    "guitar-pick": "\u{f4c6}",
    "guitar-pick-filled": "\u{f67b}",
    "gymnastics": "\u{fd44}",
    "h-1": "\u{ec94}",
    "h-2": "\u{ec95}",
    "h-3": "\u{ec96}",
    "h-4": "\u{ec97}",
    "h-5": "\u{ec98}",
    "h-6": "\u{ec99}",
    "hammer": "\u{ef91}",
    "hammer-off": "\u{f13c}",
    "hand-click": "\u{ef4f}",
    "hand-click-off": "\u{100f1}",
    "hand-finger": "\u{ee94}",
    "hand-finger-down": "\u{ff4f}",
    "hand-finger-left": "\u{ff4e}",
    "hand-finger-off": "\u{f13d}",
    "hand-finger-right": "\u{ff4d}",
    "hand-grab": "\u{f091}",
    "hand-little-finger": "\u{ee95}",
    "hand-love-you": "\u{ee97}",
    "hand-middle-finger": "\u{ec2d}",
    "hand-move": "\u{ef50}",
    "hand-off": "\u{ed15}",
    "hand-ring-finger": "\u{ee96}",
    "hand-rock": "\u{ee97}",
    "hand-sanitizer": "\u{f5f4}",
    "hand-stop": "\u{ec2e}",
    "hand-three-fingers": "\u{ee98}",
    "hand-two-fingers": "\u{ee99}",
    "hanger": "\u{ee9a}",
    "hanger-2": "\u{f09c}",
    "hanger-2-filled": "\u{ff61}",
    "hanger-off": "\u{f13e}",
    "hash": "\u{eabc}",
    "haze": "\u{efaa}",
    "haze-moon": "\u{faf8}",
    "hdr": "\u{fa7b}",
    "heading": "\u{ee9b}",
    "heading-off": "\u{f13f}",
    "headphones": "\u{eabd}",
    "headphones-filled": "\u{fa3c}",
    "headphones-off": "\u{ed1d}",
    "headset": "\u{eb90}",
    "headset-off": "\u{f3f6}",
    "health-recognition": "\u{f1fb}",
    "heart": "\u{eabe}",
    "heart-bitcoin": "\u{ff3b}",
    "heart-bolt": "\u{fb9e}",
    "heart-broken": "\u{ecba}",
    "heart-broken-filled": "\u{1016a}",
    "heart-cancel": "\u{fb9f}",
    "heart-check": "\u{fba0}",
    "heart-code": "\u{fba1}",
    "heart-cog": "\u{fba2}",
    "heart-discount": "\u{fba3}",
    "heart-dollar": "\u{fba4}",
    "heart-down": "\u{fba5}",
    "heart-exclamation": "\u{fba6}",
    "heart-filled": "\u{f67c}",
    "heart-handshake": "\u{f0f3}",
    "heart-minus": "\u{f140}",
    "heart-off": "\u{f141}",
    "heart-pause": "\u{fba7}",
    "heart-pin": "\u{fba8}",
    "heart-plus": "\u{f142}",
    "heart-question": "\u{fba9}",
    "heart-rate-monitor": "\u{ef61}",
    "heart-search": "\u{fbaa}",
    "heart-share": "\u{fbab}",
    "heart-spark": "\u{ffb6}",
    "heart-star": "\u{fbac}",
    "heart-up": "\u{fbad}",
    "heart-x": "\u{fbae}",
    "heartbeat": "\u{ef92}",
    "hearts": "\u{f387}",
    "hearts-off": "\u{f3f7}",
    "helicopter": "\u{ed8e}",
    "helicopter-filled": "\u{100f9}",
    "helicopter-landing": "\u{ed8d}",
    "helicopter-landing-filled": "\u{100c1}",
    "helmet": "\u{efca}",
    "helmet-off": "\u{f143}",
    "help": "\u{eabf}",
    "help-circle": "\u{f91d}",
    "help-circle-filled": "\u{fa3d}",
    "help-hexagon": "\u{f7a8}",
    "help-hexagon-filled": "\u{fa3e}",
    "help-octagon": "\u{f7a9}",
    "help-octagon-filled": "\u{fa3f}",
    "help-off": "\u{f3f8}",
    "help-small": "\u{f91e}",
    "help-square": "\u{f920}",
    "help-square-filled": "\u{fa40}",
    "help-square-rounded": "\u{f91f}",
    "help-square-rounded-filled": "\u{fa41}",
    "help-triangle": "\u{f921}",
    "help-triangle-filled": "\u{fa42}",
    "hemisphere": "\u{faa2}",
    "hemisphere-off": "\u{faa0}",
    "hemisphere-plus": "\u{faa1}",
    "hexagon": "\u{ec02}",
    "hexagon-0": "\u{f459}",
    "hexagon-1": "\u{f45a}",
    "hexagon-2": "\u{f45b}",
    "hexagon-3": "\u{f45c}",
    "hexagon-3d": "\u{f4c7}",
    "hexagon-4": "\u{f45d}",
    "hexagon-5": "\u{f45e}",
    "hexagon-6": "\u{f45f}",
    "hexagon-7": "\u{f460}",
    "hexagon-8": "\u{f461}",
    "hexagon-9": "\u{f462}",
    "hexagon-filled": "\u{f67d}",
    "hexagon-letter-a": "\u{f463}",
    "hexagon-letter-a-filled": "\u{fe47}",
    "hexagon-letter-b": "\u{f464}",
    "hexagon-letter-b-filled": "\u{fe46}",
    "hexagon-letter-c": "\u{f465}",
    "hexagon-letter-c-filled": "\u{fe45}",
    "hexagon-letter-d": "\u{f466}",
    "hexagon-letter-d-filled": "\u{fe44}",
    "hexagon-letter-e": "\u{f467}",
    "hexagon-letter-e-filled": "\u{fe43}",
    "hexagon-letter-f": "\u{f468}",
    "hexagon-letter-f-filled": "\u{fe42}",
    "hexagon-letter-g": "\u{f469}",
    "hexagon-letter-g-filled": "\u{fe41}",
    "hexagon-letter-h": "\u{f46a}",
    "hexagon-letter-h-filled": "\u{fe40}",
    "hexagon-letter-i": "\u{f46b}",
    "hexagon-letter-i-filled": "\u{fe3f}",
    "hexagon-letter-j": "\u{f46c}",
    "hexagon-letter-j-filled": "\u{fe3e}",
    "hexagon-letter-k": "\u{f46d}",
    "hexagon-letter-k-filled": "\u{fe3d}",
    "hexagon-letter-l": "\u{f46e}",
    "hexagon-letter-l-filled": "\u{fe3c}",
    "hexagon-letter-m": "\u{f46f}",
    "hexagon-letter-m-filled": "\u{fe3b}",
    "hexagon-letter-n": "\u{f470}",
    "hexagon-letter-n-filled": "\u{fe3a}",
    "hexagon-letter-o": "\u{f471}",
    "hexagon-letter-o-filled": "\u{fe39}",
    "hexagon-letter-p": "\u{f472}",
    "hexagon-letter-p-filled": "\u{fe38}",
    "hexagon-letter-q": "\u{f473}",
    "hexagon-letter-q-filled": "\u{fe37}",
    "hexagon-letter-r": "\u{f474}",
    "hexagon-letter-r-filled": "\u{fe36}",
    "hexagon-letter-s": "\u{f475}",
    "hexagon-letter-s-filled": "\u{fe35}",
    "hexagon-letter-t": "\u{f476}",
    "hexagon-letter-t-filled": "\u{fe34}",
    "hexagon-letter-u": "\u{f477}",
    "hexagon-letter-u-filled": "\u{fe33}",
    "hexagon-letter-v": "\u{f4b3}",
    "hexagon-letter-v-filled": "\u{fe32}",
    "hexagon-letter-w": "\u{f478}",
    "hexagon-letter-w-filled": "\u{fe31}",
    "hexagon-letter-x": "\u{f479}",
    "hexagon-letter-x-filled": "\u{fe30}",
    "hexagon-letter-y": "\u{f47a}",
    //"hexagon-letter-y-filled": "\u{fe2f}",
    "hexagon-letter-z": "\u{f47b}",
    //"hexagon-letter-z-filled": "\u{fe2e}",
    "hexagon-minus": "\u{fc8f}",
    "hexagon-minus-2": "\u{fc8e}",
    //"hexagon-minus-filled": "\u{fe2d}",
    "hexagon-number-0": "\u{f459}",
    "hexagon-number-0-filled": "\u{f74c}",
    "hexagon-number-1": "\u{f45a}",
    "hexagon-number-1-filled": "\u{f74d}",
    "hexagon-number-2": "\u{f45b}",
    "hexagon-number-2-filled": "\u{f74e}",
    "hexagon-number-3": "\u{f45c}",
    "hexagon-number-3-filled": "\u{f74f}",
    "hexagon-number-4": "\u{f45d}",
    "hexagon-number-4-filled": "\u{f750}",
    "hexagon-number-5": "\u{f45e}",
    "hexagon-number-5-filled": "\u{f751}",
    "hexagon-number-6": "\u{f45f}",
    "hexagon-number-6-filled": "\u{f752}",
    "hexagon-number-7": "\u{f460}",
    "hexagon-number-7-filled": "\u{f753}",
    "hexagon-number-8": "\u{f461}",
    "hexagon-number-8-filled": "\u{f754}",
    "hexagon-number-9": "\u{f462}",
    "hexagon-number-9-filled": "\u{f755}",
    "hexagon-off": "\u{ee9c}",
    "hexagon-plus": "\u{fc45}",
    "hexagon-plus-2": "\u{fc90}",
    //"hexagon-plus-filled": "\u{fe2c}",
    "hexagonal-prism": "\u{faa5}",
    "hexagonal-prism-off": "\u{faa3}",
    "hexagonal-prism-plus": "\u{faa4}",
    "hexagonal-pyramid": "\u{faa8}",
    "hexagonal-pyramid-off": "\u{faa6}",
    "hexagonal-pyramid-plus": "\u{faa7}",
    "hexagons": "\u{f09d}",
    "hexagons-off": "\u{f3f9}",
    "hierarchy": "\u{ee9e}",
    "hierarchy-2": "\u{ee9d}",
    "hierarchy-3": "\u{f289}",
    "hierarchy-off": "\u{f3fa}",
    "highlight": "\u{ef3f}",
    "highlight-off": "\u{f144}",
    "history": "\u{ebea}",
    "history-off": "\u{f3fb}",
    "history-toggle": "\u{f1fc}",
    "home": "\u{eac1}",
    "home-2": "\u{eac0}",
    "home-bitcoin": "\u{ff3a}",
    "home-bolt": "\u{f336}",
    "home-cancel": "\u{f350}",
    "home-check": "\u{f337}",
    "home-cog": "\u{f338}",
    "home-dollar": "\u{f339}",
    "home-dot": "\u{f33a}",
    "home-down": "\u{f33b}",
    "home-eco": "\u{f351}",
    "home-edit": "\u{f352}",
    "home-exclamation": "\u{f33c}",
    //"home-filled": "\u{fe2b}",
    "home-hand": "\u{f504}",
    "home-heart": "\u{f353}",
    "home-infinity": "\u{f505}",
    "home-link": "\u{f354}",
    "home-minus": "\u{f33d}",
    "home-move": "\u{f33e}",
    "home-off": "\u{f145}",
    "home-plus": "\u{f33f}",
    "home-question": "\u{f340}",
    "home-ribbon": "\u{f355}",
    "home-search": "\u{f341}",
    "home-share": "\u{f342}",
    "home-shield": "\u{f343}",
    "home-signal": "\u{f356}",
    "home-spark": "\u{ffb5}",
    "home-star": "\u{f344}",
    "home-stats": "\u{f345}",
    "home-up": "\u{f346}",
    "home-x": "\u{f347}",
    "horse": "\u{fc46}",
    "horse-toy": "\u{f28a}",
    "horseshoe": "\u{fcb7}",
    "hospital": "\u{fd59}",
    "hospital-circle": "\u{fd58}",
    "hospital-circle-filled": "\u{fed2}",
    "hotel-service": "\u{ef80}",
    "hourglass": "\u{ef93}",
    "hourglass-empty": "\u{f146}",
    "hourglass-filled": "\u{f756}",
    "hourglass-high": "\u{f092}",
    "hourglass-low": "\u{f093}",
    "hourglass-off": "\u{f147}",
    "hours-12": "\u{fc53}",
    "hours-24": "\u{f5e7}",
    "html": "\u{f7b1}",
    "http-connect": "\u{fa28}",
    "http-connect-off": "\u{100e7}",
    "http-delete": "\u{fa29}",
    "http-delete-off": "\u{100e6}",
    "http-get": "\u{fa2a}",
    "http-get-off": "\u{100e5}",
    "http-head": "\u{fa2b}",
    "http-head-off": "\u{100e4}",
    "http-options": "\u{fa2c}",
    "http-options-off": "\u{100e3}",
    "http-patch": "\u{fa2d}",
    "http-patch-off": "\u{100e2}",
    "http-post": "\u{fa2e}",
    "http-post-off": "\u{100e1}",
    "http-put": "\u{fa2f}",
    "http-put-off": "\u{100e0}",
    "http-que": "\u{fa5b}",
    "http-que-off": "\u{100df}",
    "http-trace": "\u{fa30}",
    "http-trace-off": "\u{100de}",
    "hyprland": "\u{ec6a}",
    "ice-cream": "\u{eac2}",
    "ice-cream-2": "\u{ee9f}",
    "ice-cream-off": "\u{f148}",
    "ice-skating": "\u{efcb}",
    "icons": "\u{f1d4}",
    "icons-filled": "\u{10070}",
    "icons-off": "\u{f3fc}",
    "id": "\u{eac3}",
    "id-badge": "\u{eff7}",
    "id-badge-2": "\u{f076}",
    "id-badge-off": "\u{f3fd}",
    "id-off": "\u{f149}",
    "ikosaedr": "\u{fec6}",
    "image-in-picture": "\u{fd9f}",
    "inbox": "\u{eac4}",
    "inbox-off": "\u{f14a}",
    "indent-decrease": "\u{eb91}",
    "indent-increase": "\u{eb92}",
    "infinity": "\u{eb69}",
    "infinity-off": "\u{f3fe}",
    "info-circle": "\u{eac5}",
    "info-circle-filled": "\u{f6d8}",
    "info-hexagon": "\u{f7aa}",
    "info-hexagon-filled": "\u{fa43}",
    "info-octagon": "\u{f7ab}",
    "info-octagon-filled": "\u{fa44}",
    "info-small": "\u{f922}",
    "info-square": "\u{eac6}",
    "info-square-filled": "\u{fa45}",
    "info-square-rounded": "\u{f635}",
    "info-square-rounded-filled": "\u{f6d9}",
    "info-triangle": "\u{f923}",
    "info-triangle-filled": "\u{fa46}",
    "inner-shadow-bottom": "\u{f520}",
    "inner-shadow-bottom-filled": "\u{f757}",
    "inner-shadow-bottom-left": "\u{f51e}",
    "inner-shadow-bottom-left-filled": "\u{f758}",
    "inner-shadow-bottom-right": "\u{f51f}",
    "inner-shadow-bottom-right-filled": "\u{f759}",
    "inner-shadow-left": "\u{f521}",
    "inner-shadow-left-filled": "\u{f75a}",
    "inner-shadow-right": "\u{f522}",
    "inner-shadow-right-filled": "\u{f75b}",
    "inner-shadow-top": "\u{f525}",
    "inner-shadow-top-filled": "\u{f75c}",
    "inner-shadow-top-left": "\u{f523}",
    "inner-shadow-top-left-filled": "\u{f75d}",
    "inner-shadow-top-right": "\u{f524}",
    "inner-shadow-top-right-filled": "\u{f75e}",
    "input-ai": "\u{fc5a}",
    "input-check": "\u{fc5b}",
    "input-search": "\u{f2a2}",
    "input-spark": "\u{ffb4}",
    "input-x": "\u{fc5c}",
    "invoice": "\u{feab}",
    "ironing": "\u{fa7c}",
    "ironing-1": "\u{f2f4}",
    "ironing-1-filled": "\u{1006f}",
    "ironing-2": "\u{f2f5}",
    "ironing-2-filled": "\u{1006e}",
    "ironing-3": "\u{f2f6}",
    "ironing-3-filled": "\u{1006d}",
    //"ironing-filled": "\u{fe2a}",
    "ironing-off": "\u{f2f7}",
    "ironing-steam": "\u{f2f9}",
    "ironing-steam-filled": "\u{1006c}",
    "ironing-steam-off": "\u{f2f8}",
    "irregular-polyhedron": "\u{faab}",
    "irregular-polyhedron-off": "\u{faa9}",
    "irregular-polyhedron-plus": "\u{faaa}",
    "italic": "\u{eb93}",
    "jacket": "\u{f661}",
    "jetpack": "\u{f581}",
    //"jetpack-filled": "\u{fe29}",
    "jewish-star": "\u{f3ff}",
    "jewish-star-filled": "\u{f67e}",
    "join-bevel": "\u{ff4c}",
    "join-round": "\u{ff4b}",
    "join-straight": "\u{ff4a}",
    "joker": "\u{1005f}",
    "jpg": "\u{f3ac}",
    "json": "\u{f7b2}",
    "jump-rope": "\u{ed8f}",
    "karate": "\u{ed32}",
    "kayak": "\u{f1d6}",
    "kering": "\u{efb8}",
    "kerning": "\u{efb8}",
    "key": "\u{eac7}",
    //"key-filled": "\u{fe28}",
    "key-off": "\u{f14b}",
    "keyboard": "\u{ebd6}",
    "keyboard-filled": "\u{100a2}",
    "keyboard-hide": "\u{ec7e}",
    "keyboard-off": "\u{eea0}",
    "keyboard-show": "\u{ec7f}",
    "keyframe": "\u{f576}",
    "keyframe-align-center": "\u{f582}",
    "keyframe-align-center-filled": "\u{fc30}",
    "keyframe-align-horizontal": "\u{f583}",
    "keyframe-align-horizontal-filled": "\u{fc31}",
    "keyframe-align-vertical": "\u{f584}",
    "keyframe-align-vertical-filled": "\u{fc32}",
    "keyframe-filled": "\u{fc33}",
    "keyframes": "\u{f585}",
    "keyframes-filled": "\u{fc34}",
    "label": "\u{ff38}",
    "label-filled": "\u{ff41}",
    "label-important": "\u{ff49}",
    "label-important-filled": "\u{ff60}",
    "label-off": "\u{ff39}",
    "ladder": "\u{efe2}",
    "ladder-off": "\u{f14c}",
    "ladle": "\u{fc14}",
    "lambda": "\u{f541}",
    "lamp": "\u{efab}",
    "lamp-2": "\u{f09e}",
    "lamp-off": "\u{f14d}",
    "lane": "\u{faf9}",
    "language": "\u{ebbe}",
    "language-hiragana": "\u{ef77}",
    "language-katakana": "\u{ef78}",
    "language-off": "\u{f14e}",
    "lasso": "\u{efac}",
    "lasso-off": "\u{f14f}",
    "lasso-polygon": "\u{f388}",
    "lasso-polygon-filled": "\u{ff5f}",
    "laurel-wreath": "\u{ff45}",
    "laurel-wreath-1": "\u{ff48}",
    "laurel-wreath-1-filled": "\u{10169}",
    "laurel-wreath-2": "\u{ff47}",
    "laurel-wreath-2-filled": "\u{10168}",
    "laurel-wreath-3": "\u{ff46}",
    "laurel-wreath-3-filled": "\u{10167}",
    "laurel-wreath-filled": "\u{100c0}",
    "layers-difference": "\u{eac8}",
    "layers-intersect": "\u{eac9}",
    "layers-intersect-2": "\u{eff8}",
    "layers-linked": "\u{eea1}",
    "layers-off": "\u{f150}",
    "layers-selected": "\u{fea9}",
    "layers-selected-bottom": "\u{feaa}",
    "layers-subtract": "\u{eaca}",
    "layers-union": "\u{eacb}",
    "layout": "\u{eadb}",
    "layout-2": "\u{eacc}",
    //"layout-2-filled": "\u{fe27}",
    //"layout-align-bottom": "\u{eacd}",
    //"layout-align-bottom-filled": "\u{fe26}",
    //"layout-align-center": "\u{eace}",
    //"layout-align-center-filled": "\u{fe25}",
    "layout-align-left": "\u{eacf}",
    //"layout-align-left-filled": "\u{fe24}",
    "layout-align-middle": "\u{ead0}",
    //"layout-align-middle-filled": "\u{fe23}",
    "layout-align-right": "\u{ead1}",
    //"layout-align-right-filled": "\u{fe22}",
    "layout-align-top": "\u{ead2}",
    //"layout-align-top-filled": "\u{fe21}",
    "layout-board": "\u{ef95}",
    "layout-board-filled": "\u{10182}",
    "layout-board-split": "\u{ef94}",
    "layout-board-split-filled": "\u{10183}",
    "layout-bottombar": "\u{ead3}",
    "layout-bottombar-collapse": "\u{f28b}",
    "layout-bottombar-collapse-filled": "\u{fc35}",
    "layout-bottombar-expand": "\u{f28c}",
    "layout-bottombar-expand-filled": "\u{fc36}",
    "layout-bottombar-filled": "\u{fc37}",
    "layout-bottombar-inactive": "\u{fd45}",
    "layout-cards": "\u{ec13}",
    //"layout-cards-filled": "\u{fe20}",
    "layout-collage": "\u{f389}",
    "layout-columns": "\u{ead4}",
    "layout-dashboard": "\u{f02c}",
    "layout-dashboard-filled": "\u{fe1f}",
    "layout-distribute-horizontal": "\u{ead5}",
    "layout-distribute-horizontal-filled": "\u{fe1e}",
    "layout-distribute-vertical": "\u{ead6}",
    "layout-distribute-vertical-filled": "\u{fe1d}",
    "layout-filled": "\u{fe17}",
    "layout-grid": "\u{edba}",
    "layout-grid-add": "\u{edb9}",
    "layout-grid-filled": "\u{fe1c}",
    "layout-grid-remove": "\u{fa7d}",
    "layout-kanban": "\u{ec3f}",
    "layout-kanban-filled": "\u{fe1b}",
    "layout-list": "\u{ec14}",
    "layout-list-filled": "\u{fe1a}",
    "layout-navbar": "\u{ead7}",
    "layout-navbar-collapse": "\u{f28d}",
    "layout-navbar-collapse-filled": "\u{fc38}",
    "layout-navbar-expand": "\u{f28e}",
    "layout-navbar-expand-filled": "\u{fc39}",
    "layout-navbar-filled": "\u{fc3a}",
    "layout-navbar-inactive": "\u{fd46}",
    "layout-off": "\u{f151}",
    "layout-rows": "\u{ead8}",
    "layout-sidebar": "\u{eada}",
    "layout-sidebar-filled": "\u{fe18}",
    "layout-sidebar-inactive": "\u{fd47}",
    "layout-sidebar-left-collapse": "\u{f004}",
    "layout-sidebar-left-collapse-filled": "\u{fc3b}",
    "layout-sidebar-left-expand": "\u{f005}",
    "layout-sidebar-left-expand-filled": "\u{fc3c}",
    "layout-sidebar-right": "\u{ead9}",
    "layout-sidebar-right-collapse": "\u{f006}",
    "layout-sidebar-right-collapse-filled": "\u{fc3d}",
    "layout-sidebar-right-expand": "\u{f007}",
    "layout-sidebar-right-expand-filled": "\u{fc3e}",
    "layout-sidebar-right-filled": "\u{fe19}",
    "layout-sidebar-right-inactive": "\u{fd48}",
    "leaf": "\u{ed4f}",
    "leaf-2": "\u{ff44}",
    "leaf-off": "\u{f400}",
    "lego": "\u{eadc}",
    "lego-filled": "\u{fe16}",
    "lego-off": "\u{f401}",
    "lemon": "\u{ef10}",
    "lemon-2": "\u{ef81}",
    "lemon-2-filled": "\u{100bf}",
    "letter-a": "\u{ec50}",
    "letter-a-small": "\u{fcc7}",
    "letter-b": "\u{ec51}",
    "letter-b-small": "\u{fcc8}",
    "letter-c": "\u{ec52}",
    "letter-c-small": "\u{fcc9}",
    "letter-case": "\u{eea5}",
    "letter-case-lower": "\u{eea2}",
    "letter-case-toggle": "\u{eea3}",
    "letter-case-upper": "\u{eea4}",
    "letter-d": "\u{ec53}",
    "letter-d-small": "\u{fcca}",
    "letter-e": "\u{ec54}",
    "letter-e-small": "\u{fccb}",
    "letter-f": "\u{ec55}",
    "letter-f-small": "\u{fccc}",
    "letter-g": "\u{ec56}",
    "letter-g-small": "\u{fccd}",
    "letter-h": "\u{ec57}",
    "letter-h-small": "\u{fcce}",
    "letter-i": "\u{ec58}",
    "letter-i-small": "\u{fccf}",
    "letter-j": "\u{ec59}",
    "letter-j-small": "\u{fcd0}",
    "letter-k": "\u{ec5a}",
    "letter-k-small": "\u{fcd1}",
    "letter-l": "\u{ec5b}",
    "letter-l-small": "\u{fcd2}",
    "letter-m": "\u{ec5c}",
    "letter-m-small": "\u{fcd3}",
    "letter-n": "\u{ec5d}",
    "letter-n-small": "\u{fcd4}",
    "letter-o": "\u{ec5e}",
    "letter-o-small": "\u{fcd5}",
    "letter-p": "\u{ec5f}",
    "letter-p-small": "\u{fcd6}",
    "letter-q": "\u{ec60}",
    "letter-q-small": "\u{fcd7}",
    "letter-r": "\u{ec61}",
    "letter-r-small": "\u{fcd8}",
    "letter-s": "\u{ec62}",
    "letter-s-small": "\u{fcd9}",
    "letter-spacing": "\u{eea6}",
    "letter-t": "\u{ec63}",
    "letter-t-small": "\u{fcda}",
    "letter-u": "\u{ec64}",
    "letter-u-small": "\u{fcdb}",
    "letter-v": "\u{ec65}",
    "letter-v-small": "\u{fcdc}",
    "letter-w": "\u{ec66}",
    "letter-w-small": "\u{fcdd}",
    "letter-x": "\u{ec67}",
    "letter-x-small": "\u{fcde}",
    "letter-y": "\u{ec68}",
    "letter-y-small": "\u{fcdf}",
    "letter-z": "\u{ec69}",
    "letter-z-small": "\u{fce0}",
    "library": "\u{fd4c}",
    "library-filled": "\u{10180}",
    "library-minus": "\u{fd49}",
    "library-photo": "\u{fd4a}",
    "library-plus": "\u{fd4b}",
    "library-plus-filled": "\u{10181}",
    "license": "\u{ebc0}",
    "license-off": "\u{f153}",
    "lifebuoy": "\u{eadd}",
    "lifebuoy-filled": "\u{100be}",
    "lifebuoy-off": "\u{f154}",
    "lighter": "\u{f794}",
    "line": "\u{ec40}",
    "line-dashed": "\u{eea7}",
    "line-dotted": "\u{eea8}",
    "line-height": "\u{eb94}",
    "line-scan": "\u{fcb8}",
    "link": "\u{eade}",
    "link-minus": "\u{fd16}",
    "link-off": "\u{f402}",
    "link-plus": "\u{fd17}",
    "list": "\u{eb6b}",
    "list-check": "\u{eb6a}",
    "list-details": "\u{ef40}",
    "list-letters": "\u{fc47}",
    "list-numbers": "\u{ef11}",
    "list-search": "\u{eea9}",
    "list-tree": "\u{fafa}",
    "live-photo": "\u{eadf}",
    "live-photo-filled": "\u{fed1}",
    "live-photo-off": "\u{f403}",
    "live-view": "\u{ec6b}",
    "live-view-filled": "\u{100a1}",
    "load-balancer": "\u{fa5c}",
    "loader": "\u{eca3}",
    "loader-2": "\u{f226}",
    "loader-3": "\u{f513}",
    "loader-quarter": "\u{eca2}",
    "location": "\u{eae0}",
    "location-bolt": "\u{fbaf}",
    "location-broken": "\u{f2c4}",
    "location-cancel": "\u{fbb0}",
    "location-check": "\u{fbb1}",
    "location-code": "\u{fbb2}",
    "location-cog": "\u{fbb3}",
    "location-discount": "\u{fbb4}",
    "location-dollar": "\u{fbb5}",
    "location-down": "\u{fbb6}",
    "location-exclamation": "\u{fbb7}",
    "location-filled": "\u{f67f}",
    "location-heart": "\u{fbb8}",
    "location-minus": "\u{fbb9}",
    "location-off": "\u{f155}",
    "location-pause": "\u{fbba}",
    "location-pin": "\u{fbbb}",
    "location-plus": "\u{fbbc}",
    "location-question": "\u{fbbd}",
    "location-search": "\u{fbbe}",
    "location-share": "\u{fbbf}",
    "location-star": "\u{fbc0}",
    "location-up": "\u{fbc1}",
    "location-x": "\u{fbc2}",
    "lock": "\u{eae2}",
    "lock-access": "\u{eeaa}",
    "lock-access-off": "\u{f404}",
    "lock-bitcoin": "\u{ff37}",
    "lock-bolt": "\u{f924}",
    "lock-cancel": "\u{f925}",
    "lock-check": "\u{f926}",
    "lock-code": "\u{f927}",
    "lock-cog": "\u{f928}",
    "lock-dollar": "\u{f929}",
    "lock-down": "\u{f92a}",
    "lock-exclamation": "\u{f92b}",
    "lock-filled": "\u{fe15}",
    "lock-heart": "\u{f92c}",
    "lock-minus": "\u{f92d}",
    "lock-off": "\u{ed1e}",
    "lock-open": "\u{eae1}",
    "lock-open-2": "\u{fea8}",
    "lock-open-off": "\u{f156}",
    "lock-password": "\u{ff9f}",
    "lock-pause": "\u{f92e}",
    "lock-pin": "\u{f92f}",
    "lock-plus": "\u{f930}",
    "lock-question": "\u{f931}",
    "lock-search": "\u{f932}",
    "lock-share": "\u{f933}",
    "lock-square": "\u{ef51}",
    "lock-square-rounded": "\u{f636}",
    "lock-square-rounded-filled": "\u{f6da}",
    "lock-star": "\u{f934}",
    "lock-up": "\u{f935}",
    "lock-x": "\u{f936}",
    "logic-and": "\u{f240}",
    "logic-buffer": "\u{f241}",
    "logic-nand": "\u{f242}",
    "logic-nor": "\u{f243}",
    "logic-not": "\u{f244}",
    "logic-or": "\u{f245}",
    "logic-xnor": "\u{f246}",
    "logic-xor": "\u{f247}",
    "login": "\u{eba7}",
    "login-2": "\u{fc76}",
    "logout": "\u{eba8}",
    "logout-2": "\u{fa7e}",
    "logs": "\u{fea7}",
    "lollipop": "\u{efcc}",
    "lollipop-off": "\u{f157}",
    "luggage": "\u{efad}",
    "luggage-off": "\u{f158}",
    "lungs": "\u{ef62}",
    "lungs-filled": "\u{fe14}",
    "lungs-off": "\u{f405}",
    "macro": "\u{eeab}",
    "macro-filled": "\u{fe13}",
    "macro-off": "\u{f406}",
    "magnet": "\u{eae3}",
    "magnet-filled": "\u{fe12}",
    "magnet-off": "\u{f159}",
    "magnetic": "\u{fcb9}",
    "mail": "\u{eae5}",
    "mail-ai": "\u{fa31}",
    "mail-bitcoin": "\u{ff36}",
    "mail-bolt": "\u{f937}",
    "mail-cancel": "\u{f938}",
    "mail-check": "\u{f939}",
    "mail-code": "\u{f93a}",
    "mail-cog": "\u{f93b}",
    "mail-dollar": "\u{f93c}",
    "mail-down": "\u{f93d}",
    "mail-exclamation": "\u{f93e}",
    "mail-fast": "\u{f069}",
    "mail-filled": "\u{fa47}",
    "mail-forward": "\u{eeac}",
    "mail-heart": "\u{f93f}",
    "mail-minus": "\u{f940}",
    "mail-off": "\u{f15a}",
    "mail-opened": "\u{eae4}",
    "mail-opened-filled": "\u{fa48}",
    "mail-pause": "\u{f941}",
    "mail-pin": "\u{f942}",
    "mail-plus": "\u{f943}",
    "mail-question": "\u{f944}",
    "mail-search": "\u{f945}",
    "mail-share": "\u{f946}",
    "mail-spark": "\u{ffb3}",
    "mail-star": "\u{f947}",
    "mail-up": "\u{f948}",
    "mail-x": "\u{f949}",
    "mailbox": "\u{eead}",
    "mailbox-off": "\u{f15b}",
    "man": "\u{eae6}",
    "man-filled": "\u{fe11}",
    "manual-gearbox": "\u{ed7b}",
    "manual-gearbox-filled": "\u{fe10}",
    "map": "\u{eae9}",
    "map-2": "\u{eae7}",
    "map-bolt": "\u{fbc3}",
    "map-cancel": "\u{fbc4}",
    "map-check": "\u{fbc5}",
    "map-code": "\u{fbc6}",
    "map-cog": "\u{fbc7}",
    "map-discount": "\u{fbc8}",
    "map-dollar": "\u{fbc9}",
    "map-down": "\u{fbca}",
    "map-east": "\u{fc5d}",
    "map-exclamation": "\u{fbcb}",
    "map-heart": "\u{fbcc}",
    "map-minus": "\u{fbcd}",
    "map-north": "\u{fc5e}",
    "map-off": "\u{f15c}",
    "map-pause": "\u{fbce}",
    "map-pin": "\u{eae8}",
    "map-pin-2": "\u{fc48}",
    "map-pin-bolt": "\u{f94a}",
    "map-pin-cancel": "\u{f94b}",
    "map-pin-check": "\u{f94c}",
    "map-pin-code": "\u{f94d}",
    "map-pin-cog": "\u{f94e}",
    "map-pin-dollar": "\u{f94f}",
    "map-pin-down": "\u{f950}",
    "map-pin-exclamation": "\u{f951}",
    "map-pin-filled": "\u{f680}",
    "map-pin-heart": "\u{f952}",
    "map-pin-minus": "\u{f953}",
    "map-pin-off": "\u{ecf3}",
    "map-pin-pause": "\u{f954}",
    "map-pin-pin": "\u{f955}",
    "map-pin-plus": "\u{f956}",
    "map-pin-question": "\u{f957}",
    "map-pin-search": "\u{f958}",
    "map-pin-share": "\u{f795}",
    "map-pin-star": "\u{f959}",
    "map-pin-up": "\u{f95a}",
    "map-pin-x": "\u{f95b}",
    "map-pins": "\u{ed5e}",
    "map-plus": "\u{fbcf}",
    "map-question": "\u{fbd0}",
    "map-route": "\u{fc79}",
    "map-search": "\u{ef82}",
    "map-share": "\u{fbd1}",
    "map-south": "\u{fc5f}",
    "map-star": "\u{fbd2}",
    "map-up": "\u{fbd3}",
    "map-west": "\u{fc60}",
    "map-x": "\u{fbd4}",
    "markdown": "\u{ec41}",
    "markdown-off": "\u{f407}",
    "marquee": "\u{ec77}",
    "marquee-2": "\u{eeae}",
    "marquee-off": "\u{f15d}",
    "mars": "\u{ec80}",
    "mask": "\u{eeb0}",
    "mask-off": "\u{eeaf}",
    "masks-theater": "\u{f263}",
    "masks-theater-off": "\u{f408}",
    "massage": "\u{eeb1}",
    "matchstick": "\u{f577}",
    "math": "\u{ebeb}",
    "math-1-divide-2": "\u{f4e2}",
    "math-1-divide-3": "\u{f4e3}",
    "math-avg": "\u{f0f4}",
    "math-cos": "\u{ff1f}",
    "math-ctg": "\u{ff35}",
    "math-equal-greater": "\u{f4e4}",
    "math-equal-lower": "\u{f4e5}",
    "math-function": "\u{eeb2}",
    "math-function-off": "\u{f15e}",
    "math-function-y": "\u{f4e6}",
    "math-greater": "\u{f4e7}",
    "math-integral": "\u{f4e9}",
    "math-integral-x": "\u{f4e8}",
    "math-integrals": "\u{f4ea}",
    "math-lower": "\u{f4eb}",
    "math-max": "\u{f0f5}",
    "math-max-min": "\u{fda0}",
    "math-min": "\u{f0f6}",
    "math-not": "\u{f4ec}",
    "math-off": "\u{f409}",
    "math-pi": "\u{f4ee}",
    "math-pi-divide-2": "\u{f4ed}",
    "math-sec": "\u{ff34}",
    "math-sin": "\u{ff1e}",
    "math-symbols": "\u{eeb3}",
    "math-tg": "\u{ff33}",
    "math-x-divide-2": "\u{f4ef}",
    "math-x-divide-y": "\u{f4f1}",
    "math-x-divide-y-2": "\u{f4f0}",
    "math-x-floor-divide-y": "\u{10073}",
    "math-x-minus-x": "\u{f4f2}",
    "math-x-minus-y": "\u{f4f3}",
    "math-x-plus-x": "\u{f4f4}",
    "math-x-plus-y": "\u{f4f5}",
    "math-xy": "\u{f4f6}",
    "math-y-minus-y": "\u{f4f7}",
    "math-y-plus-y": "\u{f4f8}",
    "matrix": "\u{100bc}",
    "maximize": "\u{eaea}",
    "maximize-off": "\u{f15f}",
    "meat": "\u{ef12}",
    "meat-off": "\u{f40a}",
    "medal": "\u{ec78}",
    "medal-2": "\u{efcd}",
    "medical-cross": "\u{ec2f}",
    "medical-cross-circle": "\u{fae8}",
    "medical-cross-filled": "\u{f681}",
    "medical-cross-off": "\u{f160}",
    "medicine-syrup": "\u{ef63}",
    "meeple": "\u{f514}",
    "meeple-filled": "\u{100a0}",
    "melon": "\u{fc7a}",
    "melon-filled": "\u{1000e}",
    "menorah": "\u{f58c}",
    "menu": "\u{eaeb}",
    "menu-2": "\u{ec42}",
    "menu-3": "\u{ff43}",
    "menu-4": "\u{ff42}",
    "menu-deep": "\u{fafb}",
    "menu-order": "\u{f5f5}",
    "message": "\u{eaef}",
    "message-2": "\u{eaec}",
    "message-2-bolt": "\u{f95c}",
    "message-2-cancel": "\u{f95d}",
    "message-2-check": "\u{f95e}",
    "message-2-code": "\u{f012}",
    "message-2-cog": "\u{f95f}",
    "message-2-dollar": "\u{f960}",
    "message-2-down": "\u{f961}",
    "message-2-exclamation": "\u{f962}",
    "message-2-filled": "\u{1009f}",
    "message-2-heart": "\u{f963}",
    "message-2-minus": "\u{f964}",
    "message-2-off": "\u{f40b}",
    "message-2-pause": "\u{f965}",
    "message-2-pin": "\u{f966}",
    "message-2-plus": "\u{f967}",
    "message-2-question": "\u{f968}",
    "message-2-search": "\u{f969}",
    "message-2-share": "\u{f077}",
    "message-2-star": "\u{f96a}",
    "message-2-up": "\u{f96b}",
    "message-2-x": "\u{f96c}",
    "message-bolt": "\u{f96d}",
    "message-cancel": "\u{f96e}",
    "message-chatbot": "\u{f38a}",
    "message-chatbot-filled": "\u{fed0}",
    "message-check": "\u{f96f}",
    "message-circle": "\u{eaed}",
    "message-circle-2": "\u{eaed}",
    "message-circle-2-filled": "\u{fecf}",
    "message-circle-bolt": "\u{f970}",
    "message-circle-cancel": "\u{f971}",
    "message-circle-check": "\u{f972}",
    "message-circle-code": "\u{f973}",
    "message-circle-cog": "\u{f974}",
    "message-circle-dollar": "\u{f975}",
    "message-circle-down": "\u{f976}",
    "message-circle-exclamation": "\u{f977}",
    "message-circle-filled": "\u{fecf}",
    "message-circle-heart": "\u{f978}",
    "message-circle-minus": "\u{f979}",
    "message-circle-off": "\u{ed40}",
    "message-circle-pause": "\u{f97a}",
    "message-circle-pin": "\u{f97b}",
    "message-circle-plus": "\u{f97c}",
    "message-circle-question": "\u{f97d}",
    "message-circle-search": "\u{f97e}",
    "message-circle-share": "\u{f97f}",
    "message-circle-star": "\u{f980}",
    "message-circle-up": "\u{f981}",
    "message-circle-user": "\u{fec5}",
    "message-circle-x": "\u{f982}",
    "message-code": "\u{f013}",
    "message-cog": "\u{f983}",
    "message-dollar": "\u{f984}",
    "message-dots": "\u{eaee}",
    "message-down": "\u{f985}",
    "message-exclamation": "\u{f986}",
    "message-filled": "\u{fecd}",
    "message-forward": "\u{f28f}",
    "message-heart": "\u{f987}",
    "message-language": "\u{efae}",
    "message-minus": "\u{f988}",
    "message-off": "\u{ed41}",
    "message-pause": "\u{f989}",
    "message-pin": "\u{f98a}",
    "message-plus": "\u{ec9a}",
    "message-question": "\u{f98b}",
    "message-reply": "\u{fd4d}",
    "message-report": "\u{ec9b}",
    "message-report-filled": "\u{fece}",
    "message-search": "\u{f98c}",
    "message-share": "\u{f078}",
    "message-star": "\u{f98d}",
    "message-up": "\u{f98e}",
    "message-user": "\u{fec4}",
    "message-x": "\u{f98f}",
    "messages": "\u{eb6c}",
    "messages-off": "\u{ed42}",
    "meteor": "\u{f1fd}",
    "meteor-filled": "\u{1000d}",
    "meteor-off": "\u{f40c}",
    "meter-cube": "\u{fd7c}",
    "meter-square": "\u{fd7d}",
    "metronome": "\u{fd25}",
    "michelin-bib-gourmand": "\u{fae9}",
    "michelin-star": "\u{faeb}",
    "michelin-star-filled": "\u{1000c}",
    "michelin-star-green": "\u{faea}",
    "mickey": "\u{f2a3}",
    "mickey-filled": "\u{f683}",
    "microphone": "\u{eaf0}",
    "microphone-2": "\u{ef2c}",
    "microphone-2-off": "\u{f40d}",
    //"microphone-filled": "\u{fe0f}",
    "microphone-off": "\u{ed16}",
    "microscope": "\u{ef64}",
    "microscope-filled": "\u{10166}",
    "microscope-off": "\u{f40e}",
    "microwave": "\u{f248}",
    //"microwave-filled": "\u{fe0e}",
    "microwave-off": "\u{f264}",
    "military-award": "\u{f079}",
    "military-rank": "\u{efcf}",
    "military-rank-filled": "\u{ff5e}",
    "milk": "\u{ef13}",
    "milk-filled": "\u{1000b}",
    "milk-off": "\u{f40f}",
    "milkshake": "\u{f4c8}",
    "minimize": "\u{eaf1}",
    "minus": "\u{eaf2}",
    "minus-vertical": "\u{eeb4}",
    "mist": "\u{ec30}",
    "mist-off": "\u{f410}",
    "mobiledata": "\u{f9f5}",
    "mobiledata-off": "\u{f9f4}",
    "moneybag": "\u{f506}",
    "moneybag-edit": "\u{1013d}",
    "moneybag-heart": "\u{1013c}",
    "moneybag-minus": "\u{1013b}",
    "moneybag-move": "\u{10139}",
    "moneybag-move-back": "\u{1013a}",
    "moneybag-plus": "\u{10138}",
    "monkeybar": "\u{feb4}",
    "mood-angry": "\u{f2de}",
    "mood-angry-filled": "\u{ff0a}",
    "mood-annoyed": "\u{f2e0}",
    "mood-annoyed-2": "\u{f2df}",
    "mood-bitcoin": "\u{ff32}",
    "mood-boy": "\u{ed2d}",
    "mood-check": "\u{f7b3}",
    "mood-cog": "\u{f7b4}",
    "mood-confuzed": "\u{eaf3}",
    "mood-confuzed-filled": "\u{f7f2}",
    "mood-crazy-happy": "\u{ed90}",
    "mood-crazy-happy-filled": "\u{ff09}",
    "mood-cry": "\u{ecbb}",
    "mood-dollar": "\u{f7b5}",
    "mood-edit": "\u{fa05}",
    "mood-empty": "\u{eeb5}",
    "mood-empty-filled": "\u{f7f3}",
    "mood-happy": "\u{eaf4}",
    "mood-happy-filled": "\u{f7f4}",
    "mood-heart": "\u{f7b6}",
    "mood-kid": "\u{ec03}",
    "mood-kid-filled": "\u{f7f5}",
    "mood-look-down": "\u{fd37}",
    "mood-look-left": "\u{f2c5}",
    "mood-look-right": "\u{f2c6}",
    "mood-look-up": "\u{fd38}",
    "mood-minus": "\u{f7b7}",
    "mood-nerd": "\u{f2e1}",
    "mood-nervous": "\u{ef96}",
    "mood-neutral": "\u{eaf5}",
    "mood-neutral-filled": "\u{f7f6}",
    "mood-off": "\u{f161}",
    "mood-pin": "\u{f7b8}",
    "mood-plus": "\u{f7b9}",
    "mood-puzzled": "\u{fd39}",
    "mood-sad": "\u{eaf6}",
    "mood-sad-2": "\u{f2e2}",
    "mood-sad-dizzy": "\u{f2e3}",
    "mood-sad-filled": "\u{f7f7}",
    "mood-sad-squint": "\u{f2e4}",
    "mood-search": "\u{f7ba}",
    "mood-share": "\u{fa06}",
    "mood-sick": "\u{f2e5}",
    "mood-silence": "\u{f2e6}",
    "mood-sing": "\u{f2c7}",
    "mood-smile": "\u{eaf7}",
    "mood-smile-beam": "\u{f2e7}",
    "mood-smile-dizzy": "\u{f2e8}",
    "mood-smile-filled": "\u{f7f8}",
    "mood-spark": "\u{ffb2}",
    "mood-suprised": "\u{ec04}",
    "mood-surprised": "\u{ec04}",
    "mood-tongue": "\u{eb95}",
    "mood-tongue-wink": "\u{f2ea}",
    "mood-tongue-wink-2": "\u{f2e9}",
    "mood-unamused": "\u{f2eb}",
    "mood-up": "\u{f7bb}",
    "mood-wink": "\u{f2ed}",
    "mood-wink-2": "\u{f2ec}",
    "mood-wrrr": "\u{f2ee}",
    "mood-wrrr-filled": "\u{ff08}",
    "mood-x": "\u{f7bc}",
    "mood-xd": "\u{f2ef}",
    "moon": "\u{eaf8}",
    "moon-2": "\u{ece6}",
    "moon-filled": "\u{f684}",
    "moon-off": "\u{f162}",
    "moon-stars": "\u{ece7}",
    "moped": "\u{ecbc}",
    "motorbike": "\u{eeb6}",
    "motorbike-filled": "\u{100f8}",
    "mountain": "\u{ef97}",
    "mountain-filled": "\u{1000a}",
    "mountain-off": "\u{f411}",
    "mouse": "\u{eaf9}",
    "mouse-2": "\u{f1d7}",
    "mouse-filled": "\u{fb2f}",
    "mouse-off": "\u{f163}",
    "moustache": "\u{f4c9}",
    "movie": "\u{eafa}",
    "movie-off": "\u{f164}",
    "mug": "\u{eafb}",
    "mug-filled": "\u{10009}",
    "mug-off": "\u{f165}",
    "multiplier-0-5x": "\u{ef41}",
    "multiplier-1-5x": "\u{ef42}",
    "multiplier-1x": "\u{ef43}",
    "multiplier-2x": "\u{ef44}",
    "mushroom": "\u{ef14}",
    "mushroom-filled": "\u{f7f9}",
    "mushroom-off": "\u{f412}",
    "music": "\u{eafc}",
    "music-bolt": "\u{fbd5}",
    "music-cancel": "\u{fbd6}",
    "music-check": "\u{fbd7}",
    "music-code": "\u{fbd8}",
    "music-cog": "\u{fbd9}",
    "music-discount": "\u{fbda}",
    "music-dollar": "\u{fbdb}",
    "music-down": "\u{fbdc}",
    "music-exclamation": "\u{fbdd}",
    "music-heart": "\u{fbde}",
    "music-minus": "\u{fbdf}",
    "music-off": "\u{f166}",
    "music-pause": "\u{fbe0}",
    "music-pin": "\u{fbe1}",
    "music-plus": "\u{fbe2}",
    "music-question": "\u{fbe3}",
    "music-search": "\u{fbe4}",
    "music-share": "\u{fbe5}",
    "music-star": "\u{fbe6}",
    "music-up": "\u{fbe7}",
    "music-x": "\u{fbe8}",
    "navigation": "\u{f2c8}",
    "navigation-bolt": "\u{fbe9}",
    "navigation-cancel": "\u{fbea}",
    "navigation-check": "\u{fbeb}",
    "navigation-code": "\u{fbec}",
    "navigation-cog": "\u{fbed}",
    "navigation-discount": "\u{fbee}",
    "navigation-dollar": "\u{fbef}",
    "navigation-down": "\u{fbf0}",
    "navigation-east": "\u{fcba}",
    "navigation-exclamation": "\u{fbf1}",
    "navigation-filled": "\u{f685}",
    "navigation-heart": "\u{fbf2}",
    "navigation-minus": "\u{fbf3}",
    "navigation-north": "\u{fcbb}",
    "navigation-off": "\u{f413}",
    "navigation-pause": "\u{fbf4}",
    "navigation-pin": "\u{fbf5}",
    "navigation-plus": "\u{fbf6}",
    "navigation-question": "\u{fbf7}",
    "navigation-search": "\u{fbf8}",
    "navigation-share": "\u{fbf9}",
    "navigation-south": "\u{fcbc}",
    "navigation-star": "\u{fbfa}",
    "navigation-top": "\u{faec}",
    "navigation-up": "\u{fbfb}",
    "navigation-west": "\u{fcbd}",
    "navigation-x": "\u{fbfc}",
    "needle": "\u{f508}",
    "needle-thread": "\u{f507}",
    "network": "\u{f09f}",
    "network-off": "\u{f414}",
    "new-section": "\u{ebc1}",
    "news": "\u{eafd}",
    "news-off": "\u{f167}",
    "nfc": "\u{eeb7}",
    "nfc-off": "\u{f168}",
    "niri": "\u{ec32}",
    "noctalia": "\u{ec33}",
    "no-copyright": "\u{efb9}",
    "no-creative-commons": "\u{efba}",
    "no-derivatives": "\u{efbb}",
    "north-star": "\u{f014}",
    "note": "\u{eb6d}",
    "note-off": "\u{f169}",
    "notebook": "\u{eb96}",
    "notebook-off": "\u{f415}",
    "notes": "\u{eb6e}",
    "notes-off": "\u{f16a}",
    "notification": "\u{eafe}",
    "notification-off": "\u{f16b}",
    "number": "\u{f1fe}",
    "number-0": "\u{edf0}",
    "number-0-small": "\u{fce1}",
    "number-1": "\u{edf1}",
    "number-1-small": "\u{fce2}",
    "number-10": "\u{1005e}",
    "number-10-small": "\u{fce3}",
    "number-100-small": "\u{10005}",
    "number-11": "\u{1005d}",
    "number-11-small": "\u{fce4}",
    "number-12-small": "\u{fce5}",
    "number-123": "\u{f554}",
    "number-13-small": "\u{fce6}",
    "number-14-small": "\u{fce7}",
    "number-15-small": "\u{fce8}",
    "number-16-small": "\u{fce9}",
    "number-17-small": "\u{fcea}",
    "number-18-small": "\u{fceb}",
    "number-19-small": "\u{fcec}",
    "number-2": "\u{edf2}",
    "number-2-small": "\u{fced}",
    "number-20-small": "\u{fcee}",
    "number-21-small": "\u{fcef}",
    "number-22-small": "\u{fcf0}",
    "number-23-small": "\u{fcf1}",
    "number-24-small": "\u{fcf2}",
    "number-25-small": "\u{fcf3}",
    "number-26-small": "\u{fcf4}",
    "number-27-small": "\u{fcf5}",
    "number-28-small": "\u{fcf6}",
    "number-29-small": "\u{fcf7}",
    "number-3": "\u{edf3}",
    "number-3-small": "\u{fcf8}",
    "number-30-small": "\u{10004}",
    "number-31-small": "\u{10003}",
    "number-32-small": "\u{10002}",
    "number-33-small": "\u{10001}",
    "number-34-small": "\u{10000}",
    "number-35-small": "\u{ffff}",
    "number-36-small": "\u{fffe}",
    "number-37-small": "\u{fffd}",
    "number-38-small": "\u{fffc}",
    "number-39-small": "\u{fffb}",
    "number-4": "\u{edf4}",
    "number-4-small": "\u{fcf9}",
    "number-40-small": "\u{fffa}",
    "number-41-small": "\u{fff9}",
    //"number-42-small": "\u{fff8}",
    //"number-43-small": "\u{fff7}",
    //"number-44-small": "\u{fff6}",
    //"number-45-small": "\u{fff5}",
    //"number-46-small": "\u{fff4}",
    //"number-47-small": "\u{fff3}",
    //"number-48-small": "\u{fff2}",
    //"number-49-small": "\u{fff1}",
    "number-5": "\u{edf5}",
    "number-5-small": "\u{fcfa}",
    //"number-50-small": "\u{fff0}",
    "number-51-small": "\u{ffef}",
    "number-52-small": "\u{ffee}",
    "number-53-small": "\u{ffed}",
    "number-54-small": "\u{ffec}",
    "number-55-small": "\u{ffeb}",
    "number-56-small": "\u{ffea}",
    "number-57-small": "\u{ffe9}",
    "number-58-small": "\u{ffe8}",
    "number-59-small": "\u{ffe7}",
    "number-6": "\u{edf6}",
    "number-6-small": "\u{fcfb}",
    "number-60-small": "\u{ffe6}",
    "number-61-small": "\u{ffe5}",
    "number-62-small": "\u{ffe4}",
    "number-63-small": "\u{ffe3}",
    "number-64-small": "\u{ffe2}",
    "number-65-small": "\u{ffe1}",
    "number-66-small": "\u{ffe0}",
    "number-67-small": "\u{ffdf}",
    "number-68-small": "\u{ffde}",
    "number-69-small": "\u{ffdd}",
    "number-7": "\u{edf7}",
    "number-7-small": "\u{fcfc}",
    "number-70-small": "\u{ffdc}",
    "number-71-small": "\u{ffdb}",
    "number-72-small": "\u{ffda}",
    "number-73-small": "\u{ffd9}",
    "number-74-small": "\u{ffd8}",
    "number-75-small": "\u{ffd7}",
    "number-76-small": "\u{ffd6}",
    "number-77-small": "\u{ffd5}",
    "number-78-small": "\u{ffd4}",
    "number-79-small": "\u{ffd3}",
    "number-8": "\u{edf8}",
    "number-8-small": "\u{fcfd}",
    "number-80-small": "\u{ffd2}",
    "number-81-small": "\u{ffd1}",
    "number-82-small": "\u{ffd0}",
    "number-83-small": "\u{ffcf}",
    "number-84-small": "\u{ffce}",
    "number-85-small": "\u{ffcd}",
    "number-86-small": "\u{ffcc}",
    "number-87-small": "\u{ffcb}",
    "number-88-small": "\u{ffca}",
    "number-89-small": "\u{ffc9}",
    "number-9": "\u{edf9}",
    "number-9-small": "\u{fcfe}",
    "number-90-small": "\u{ffc8}",
    "number-91-small": "\u{ffc7}",
    "number-92-small": "\u{ffc6}",
    "number-93-small": "\u{ffc5}",
    "number-94-small": "\u{ffc4}",
    "number-95-small": "\u{ffc3}",
    "number-96-small": "\u{ffc2}",
    "number-97-small": "\u{ffc1}",
    "number-98-small": "\u{ffc0}",
    "number-99-small": "\u{ffbf}",
    "numbers": "\u{f015}",
    "nurse": "\u{ef65}",
    "nurse-filled": "\u{1009e}",
    "nut": "\u{fc61}",
    "object-scan": "\u{fef1}",
    "octagon": "\u{ecbd}",
    "octagon-filled": "\u{f686}",
    "octagon-minus": "\u{fc92}",
    "octagon-minus-2": "\u{fc91}",
    "octagon-minus-filled": "\u{1017f}",
    "octagon-off": "\u{eeb8}",
    "octagon-plus": "\u{fc94}",
    "octagon-plus-2": "\u{fc93}",
    "octagon-plus-filled": "\u{1017e}",
    "octahedron": "\u{faae}",
    "octahedron-off": "\u{faac}",
    "octahedron-plus": "\u{faad}",
    "old": "\u{eeb9}",
    "olympics": "\u{eeba}",
    "olympics-off": "\u{f416}",
    "om": "\u{f58d}",
    "omega": "\u{eb97}",
    "outbound": "\u{f249}",
    "outlet": "\u{ebd7}",
    "oval": "\u{f02e}",
    "oval-filled": "\u{f687}",
    "oval-vertical": "\u{f02d}",
    "oval-vertical-filled": "\u{f688}",
    "overline": "\u{eebb}",
    "package": "\u{eaff}",
    "package-export": "\u{f07a}",
    "package-import": "\u{f07b}",
    "package-off": "\u{f16c}",
    "packages": "\u{f2c9}",
    "pacman": "\u{eebc}",
    "page-break": "\u{ec81}",
    "paint": "\u{eb00}",
    "paint-filled": "\u{f75f}",
    "paint-off": "\u{f16d}",
    "palette": "\u{eb01}",
    "palette-filled": "\u{1009d}",
    "palette-off": "\u{f16e}",
    "panorama-horizontal": "\u{ed33}",
    "panorama-horizontal-filled": "\u{fecc}",
    "panorama-horizontal-off": "\u{f417}",
    "panorama-vertical": "\u{ed34}",
    "panorama-vertical-filled": "\u{fecb}",
    "panorama-vertical-off": "\u{f418}",
    "paper-bag": "\u{f02f}",
    "paper-bag-off": "\u{f16f}",
    "paperclip": "\u{eb02}",
    "parachute": "\u{ed7c}",
    "parachute-off": "\u{f170}",
    "parentheses": "\u{ebd8}",
    "parentheses-off": "\u{f171}",
    "parking": "\u{eb03}",
    "parking-circle": "\u{fd5a}",
    "parking-circle-filled": "\u{feca}",
    "parking-off": "\u{f172}",
    "password": "\u{f4ca}",
    "password-fingerprint": "\u{fc7b}",
    "password-mobile-phone": "\u{fc7c}",
    "password-user": "\u{fc7d}",
    "paw": "\u{eff9}",
    "paw-filled": "\u{f689}",
    "paw-off": "\u{f419}",
    "paywall": "\u{fd7e}",
    "pdf": "\u{f7ac}",
    "peace": "\u{ecbe}",
    "pencil": "\u{eb04}",
    "pencil-bolt": "\u{fbfd}",
    "pencil-cancel": "\u{fbfe}",
    "pencil-check": "\u{fbff}",
    "pencil-code": "\u{fc00}",
    "pencil-cog": "\u{fc01}",
    "pencil-discount": "\u{fc02}",
    "pencil-dollar": "\u{fc03}",
    "pencil-down": "\u{fc04}",
    "pencil-exclamation": "\u{fc05}",
    "pencil-heart": "\u{fc06}",
    "pencil-minus": "\u{f1eb}",
    "pencil-off": "\u{f173}",
    "pencil-pause": "\u{fc07}",
    "pencil-pin": "\u{fc08}",
    "pencil-plus": "\u{f1ec}",
    "pencil-question": "\u{fc09}",
    "pencil-search": "\u{fc0a}",
    "pencil-share": "\u{fc0b}",
    "pencil-star": "\u{fc0c}",
    "pencil-up": "\u{fc0d}",
    "pencil-x": "\u{fc0e}",
    "pennant": "\u{ed7d}",
    "pennant-2": "\u{f06a}",
    "pennant-2-filled": "\u{f68a}",
    "pennant-filled": "\u{f68b}",
    "pennant-off": "\u{f174}",
    "pentagon": "\u{efe3}",
    "pentagon-filled": "\u{f68c}",
    "pentagon-minus": "\u{feb3}",
    "pentagon-number-0": "\u{fc7e}",
    "pentagon-number-1": "\u{fc7f}",
    "pentagon-number-2": "\u{fc80}",
    "pentagon-number-3": "\u{fc81}",
    "pentagon-number-4": "\u{fc82}",
    "pentagon-number-5": "\u{fc83}",
    "pentagon-number-6": "\u{fc84}",
    "pentagon-number-7": "\u{fc85}",
    "pentagon-number-8": "\u{fc86}",
    "pentagon-number-9": "\u{fc87}",
    "pentagon-off": "\u{f41a}",
    "pentagon-plus": "\u{fc49}",
    "pentagon-x": "\u{fc88}",
    "pentagram": "\u{f586}",
    "pepper": "\u{ef15}",
    "pepper-off": "\u{f175}",
    "percentage": "\u{ecf4}",
    "percentage-0": "\u{fee5}",
    "percentage-10": "\u{fee4}",
    "percentage-100": "\u{fee3}",
    "percentage-20": "\u{fee2}",
    "percentage-25": "\u{fee1}",
    "percentage-30": "\u{fee0}",
    "percentage-33": "\u{fedf}",
    "percentage-40": "\u{fede}",
    "percentage-50": "\u{fedd}",
    "percentage-60": "\u{fedc}",
    "percentage-66": "\u{fedb}",
    "percentage-70": "\u{feda}",
    "percentage-75": "\u{fed9}",
    "percentage-80": "\u{fed8}",
    "percentage-90": "\u{fed7}",
    "perfume": "\u{f509}",
    "perspective": "\u{eebd}",
    "perspective-off": "\u{f176}",
    "phone": "\u{eb09}",
    "phone-call": "\u{eb05}",
    "phone-calling": "\u{ec43}",
    "phone-check": "\u{ec05}",
    "phone-done": "\u{ff9e}",
    "phone-end": "\u{ff9d}",
    "phone-filled": "\u{fa49}",
    "phone-incoming": "\u{eb06}",
    "phone-off": "\u{ecf5}",
    "phone-outgoing": "\u{eb07}",
    "phone-pause": "\u{eb08}",
    "phone-plus": "\u{ec06}",
    "phone-ringing": "\u{ff9c}",
    "phone-spark": "\u{ffb1}",
    "phone-x": "\u{ec07}",
    "photo": "\u{eb0a}",
    "photo-ai": "\u{fa32}",
    "photo-bitcoin": "\u{ff31}",
    "photo-bolt": "\u{f990}",
    "photo-cancel": "\u{f35d}",
    "photo-check": "\u{f35e}",
    "photo-circle": "\u{fc4a}",
    "photo-circle-minus": "\u{fc62}",
    "photo-circle-plus": "\u{fc63}",
    "photo-code": "\u{f991}",
    "photo-cog": "\u{f992}",
    "photo-dollar": "\u{f993}",
    "photo-down": "\u{f35f}",
    "photo-edit": "\u{f360}",
    "photo-exclamation": "\u{f994}",
    "photo-filled": "\u{fa4a}",
    "photo-heart": "\u{f361}",
    "photo-hexagon": "\u{fc4b}",
    "photo-minus": "\u{f362}",
    "photo-off": "\u{ecf6}",
    "photo-pause": "\u{f995}",
    "photo-pentagon": "\u{fc4c}",
    "photo-pin": "\u{f996}",
    "photo-plus": "\u{f363}",
    "photo-question": "\u{f997}",
    "photo-scan": "\u{fca8}",
    "photo-search": "\u{f364}",
    "photo-sensor": "\u{f798}",
    "photo-sensor-2": "\u{f796}",
    "photo-sensor-3": "\u{f797}",
    "photo-share": "\u{f998}",
    "photo-shield": "\u{f365}",
    "photo-spark": "\u{ffb0}",
    "photo-square-rounded": "\u{fc4d}",
    "photo-star": "\u{f366}",
    "photo-up": "\u{f38b}",
    "photo-video": "\u{fc95}",
    "photo-x": "\u{f367}",
    "physotherapist": "\u{eebe}",
    "piano": "\u{fad3}",
    "pick": "\u{fafc}",
    "picnic-table": "\u{fed6}",
    "picture-in-picture": "\u{ed35}",
    "picture-in-picture-filled": "\u{fec1}",
    "picture-in-picture-off": "\u{ed43}",
    "picture-in-picture-on": "\u{ed44}",
    "picture-in-picture-top": "\u{efe4}",
    "picture-in-picture-top-filled": "\u{fec2}",
    "pig": "\u{ef52}",
    "pig-filled": "\u{1010a}",
    "pig-money": "\u{f38c}",
    "pig-off": "\u{f177}",
    "pilcrow": "\u{f5f6}",
    "pilcrow-left": "\u{fd7f}",
    "pilcrow-right": "\u{fd80}",
    "pill": "\u{ec44}",
    "pill-filled": "\u{ff07}",
    "pill-off": "\u{f178}",
    "pills": "\u{ef66}",
    "pin": "\u{ec9c}",
    "pin-end": "\u{fd5b}",
    "pin-filled": "\u{f68d}",
    "pin-invoke": "\u{fd5c}",
    "ping-pong": "\u{f38d}",
    "pinned": "\u{ed60}",
    "pinned-filled": "\u{f68e}",
    "pinned-off": "\u{ed5f}",
    "pizza": "\u{edbb}",
    "pizza-filled": "\u{10008}",
    "pizza-off": "\u{f179}",
    "placeholder": "\u{f626}",
    "plane": "\u{eb6f}",
    "plane-arrival": "\u{eb99}",
    "plane-departure": "\u{eb9a}",
    "plane-inflight": "\u{ef98}",
    "plane-off": "\u{f17a}",
    "plane-tilt": "\u{f1ed}",
    "planet": "\u{ec08}",
    "planet-off": "\u{f17b}",
    "plant": "\u{ed50}",
    "plant-2": "\u{ed7e}",
    "plant-2-off": "\u{f17c}",
    "plant-off": "\u{f17d}",
    "play-basketball": "\u{fa66}",
    "play-card": "\u{eebf}",
    "play-card-1": "\u{1005c}",
    "play-card-1-filled": "\u{10083}",
    "play-card-10": "\u{1005b}",
    "play-card-10-filled": "\u{10082}",
    "play-card-2": "\u{1005a}",
    "play-card-2-filled": "\u{10081}",
    "play-card-3": "\u{10059}",
    "play-card-3-filled": "\u{10080}",
    "play-card-4": "\u{10058}",
    "play-card-4-filled": "\u{1007f}",
    "play-card-5": "\u{10057}",
    "play-card-5-filled": "\u{1007e}",
    "play-card-6": "\u{10056}",
    "play-card-6-filled": "\u{1007d}",
    "play-card-7": "\u{10055}",
    "play-card-7-filled": "\u{1007c}",
    "play-card-8": "\u{10054}",
    "play-card-8-filled": "\u{1007b}",
    "play-card-9": "\u{10053}",
    "play-card-9-filled": "\u{1007a}",
    "play-card-a": "\u{10052}",
    "play-card-a-filled": "\u{10079}",
    "play-card-j": "\u{10051}",
    "play-card-j-filled": "\u{10078}",
    "play-card-k": "\u{10050}",
    "play-card-k-filled": "\u{10077}",
    "play-card-off": "\u{f17e}",
    "play-card-q": "\u{1004f}",
    "play-card-q-filled": "\u{10076}",
    "play-card-star": "\u{1004e}",
    "play-card-star-filled": "\u{10075}",
    "play-football": "\u{fa67}",
    "play-handball": "\u{fa68}",
    "play-volleyball": "\u{fa69}",
    "player-eject": "\u{efbc}",
    "player-eject-filled": "\u{f68f}",
    "player-pause": "\u{ed45}",
    "player-pause-filled": "\u{f690}",
    "player-play": "\u{ed46}",
    "player-play-filled": "\u{f691}",
    "player-record": "\u{ed47}",
    "player-record-filled": "\u{f692}",
    "player-skip-back": "\u{ed48}",
    "player-skip-back-filled": "\u{f693}",
    "player-skip-forward": "\u{ed49}",
    "player-skip-forward-filled": "\u{f694}",
    "player-stop": "\u{ed4a}",
    "player-stop-filled": "\u{f695}",
    "player-track-next": "\u{ed4b}",
    "player-track-next-filled": "\u{f696}",
    "player-track-prev": "\u{ed4c}",
    "player-track-prev-filled": "\u{f697}",
    "playlist": "\u{eec0}",
    "playlist-add": "\u{f008}",
    "playlist-off": "\u{f17f}",
    "playlist-x": "\u{f009}",
    "playstation-circle": "\u{f2ad}",
    "playstation-square": "\u{f2ae}",
    "playstation-triangle": "\u{f2af}",
    "playstation-x": "\u{f2b0}",
    "plug": "\u{ebd9}",
    "plug-connected": "\u{f00a}",
    "plug-connected-x": "\u{f0a0}",
    "plug-off": "\u{f180}",
    "plug-x": "\u{f0a1}",
    "plus": "\u{eb0b}",
    "plus-equal": "\u{f7ad}",
    "plus-minus": "\u{f7ae}",
    "png": "\u{f3ad}",
    "podium": "\u{f1d8}",
    "podium-off": "\u{f41b}",
    "point": "\u{eb0c}",
    "point-filled": "\u{f698}",
    "point-off": "\u{f181}",
    "pointer": "\u{f265}",
    "pointer-bolt": "\u{f999}",
    "pointer-cancel": "\u{f99a}",
    "pointer-check": "\u{f99b}",
    "pointer-code": "\u{f99c}",
    "pointer-cog": "\u{f99d}",
    "pointer-dollar": "\u{f99e}",
    "pointer-down": "\u{f99f}",
    "pointer-exclamation": "\u{f9a0}",
    "pointer-filled": "\u{fb30}",
    "pointer-heart": "\u{f9a1}",
    "pointer-minus": "\u{f9a2}",
    "pointer-off": "\u{f9a3}",
    "pointer-pause": "\u{f9a4}",
    "pointer-pin": "\u{f9a5}",
    "pointer-plus": "\u{f9a6}",
    "pointer-question": "\u{f9a7}",
    "pointer-search": "\u{f9a8}",
    "pointer-share": "\u{f9a9}",
    "pointer-star": "\u{f9aa}",
    "pointer-up": "\u{f9ab}",
    "pointer-x": "\u{f9ac}",
    "pokeball": "\u{eec1}",
    "pokeball-off": "\u{f41c}",
    "poker-chip": "\u{f515}",
    "polaroid": "\u{eec2}",
    "polaroid-filled": "\u{fa4b}",
    "polygon": "\u{efd0}",
    "polygon-off": "\u{f182}",
    "poo": "\u{f258}",
    "poo-filled": "\u{fec9}",
    "pool": "\u{ed91}",
    "pool-off": "\u{f41d}",
    "power": "\u{eb0d}",
    "pray": "\u{ecbf}",
    "premium-rights": "\u{efbd}",
    "prescription": "\u{ef99}",
    "presentation": "\u{eb70}",
    "presentation-analytics": "\u{eec3}",
    "presentation-analytics-filled": "\u{ff5d}",
    "presentation-filled": "\u{ff5c}",
    "presentation-off": "\u{f183}",
    "printer": "\u{eb0e}",
    "printer-off": "\u{f184}",
    "prism": "\u{fab1}",
    "prism-light": "\u{fea6}",
    "prism-off": "\u{faaf}",
    "prism-plus": "\u{fab0}",
    "prison": "\u{ef79}",
    "progress": "\u{fa0d}",
    "progress-alert": "\u{fa07}",
    "progress-bolt": "\u{fa08}",
    "progress-check": "\u{fa09}",
    "progress-down": "\u{fa0a}",
    "progress-help": "\u{fa0b}",
    "progress-x": "\u{fa0c}",
    "prompt": "\u{eb0f}",
    "prong": "\u{fda1}",
    "propeller": "\u{eec4}",
    "propeller-off": "\u{f185}",
    "protocol": "\u{fd81}",
    "pumpkin-scary": "\u{f587}",
    "puzzle": "\u{eb10}",
    "puzzle-2": "\u{ef83}",
    "puzzle-filled": "\u{f699}",
    "puzzle-off": "\u{f186}",
    "pyramid": "\u{eec5}",
    "pyramid-off": "\u{f187}",
    "pyramid-plus": "\u{fab2}",
    "qrcode": "\u{eb11}",
    "qrcode-off": "\u{f41e}",
    "question-mark": "\u{ec9d}",
    "quote": "\u{efbe}",
    "quote-filled": "\u{1009c}",
    "quote-off": "\u{f188}",
    //"quotes": "\u{fb1e}",
    "radar": "\u{f017}",
    "radar-2": "\u{f016}",
    //"radar-filled": "\u{fe0d}",
    "radar-off": "\u{f41f}",
    "radio": "\u{ef2d}",
    "radio-off": "\u{f420}",
    "radioactive": "\u{ecc0}",
    "radioactive-filled": "\u{f760}",
    "radioactive-off": "\u{f189}",
    "radius-bottom-left": "\u{eec6}",
    "radius-bottom-right": "\u{eec7}",
    "radius-top-left": "\u{eec8}",
    "radius-top-right": "\u{eec9}",
    "rainbow": "\u{edbc}",
    "rainbow-off": "\u{f18a}",
    "rating-12-plus": "\u{f266}",
    "rating-14-plus": "\u{f267}",
    "rating-16-plus": "\u{f268}",
    "rating-18-plus": "\u{f269}",
    "rating-21-plus": "\u{f26a}",
    "razor": "\u{f4b5}",
    "razor-electric": "\u{f4b4}",
    "receipt": "\u{edfd}",
    "receipt-2": "\u{edfa}",
    "receipt-bitcoin": "\u{fd66}",
    "receipt-dollar": "\u{fd67}",
    "receipt-dollar-filled": "\u{1017d}",
    "receipt-euro": "\u{fd68}",
    "receipt-euro-filled": "\u{1017c}",
    "receipt-filled": "\u{ff06}",
    "receipt-off": "\u{edfb}",
    "receipt-pound": "\u{fd69}",
    "receipt-pound-filled": "\u{1017b}",
    "receipt-refund": "\u{edfc}",
    "receipt-rupee": "\u{fd82}",
    "receipt-rupee-filled": "\u{1017a}",
    "receipt-tax": "\u{edbd}",
    "receipt-yen": "\u{fd6a}",
    "receipt-yen-filled": "\u{10179}",
    "receipt-yuan": "\u{fd6b}",
    "receipt-yuan-filled": "\u{10178}",
    "recharging": "\u{eeca}",
    "record-mail": "\u{eb12}",
    "record-mail-off": "\u{f18b}",
    "rectangle": "\u{ed37}",
    "rectangle-filled": "\u{f69a}",
    "rectangle-rounded-bottom": "\u{faed}",
    "rectangle-rounded-top": "\u{faee}",
    "rectangle-vertical": "\u{ed36}",
    "rectangle-vertical-filled": "\u{f69b}",
    "rectangular-prism": "\u{fab5}",
    "rectangular-prism-off": "\u{fab3}",
    "rectangular-prism-plus": "\u{fab4}",
    "recycle": "\u{eb9b}",
    "recycle-off": "\u{f18c}",
    "refresh": "\u{eb13}",
    "refresh-alert": "\u{ed57}",
    "refresh-dot": "\u{efbf}",
    "refresh-off": "\u{f18d}",
    "regex": "\u{f31f}",
    "regex-off": "\u{f421}",
    "registered": "\u{eb14}",
    "relation-many-to-many": "\u{ed7f}",
    //"relation-many-to-many-filled": "\u{fe0c}",
    "relation-one-to-many": "\u{ed80}",
    //"relation-one-to-many-filled": "\u{fe0b}",
    "relation-one-to-one": "\u{ed81}",
    //"relation-one-to-one-filled": "\u{fe0a}",
    "reload": "\u{f3ae}",
    "reorder": "\u{fc15}",
    "repeat": "\u{eb72}",
    "repeat-off": "\u{f18e}",
    "repeat-once": "\u{eb71}",
    "replace": "\u{ebc7}",
    "replace-filled": "\u{f69c}",
    "replace-off": "\u{f422}",
    "replace-user": "\u{100f0}",
    "report": "\u{eece}",
    "report-analytics": "\u{eecb}",
    "report-medical": "\u{eecc}",
    "report-money": "\u{eecd}",
    "report-off": "\u{f18f}",
    "report-search": "\u{ef84}",
    "reserved-line": "\u{f9f6}",
    "resize": "\u{eecf}",
    "restore": "\u{fafd}",
    "rewind-backward-10": "\u{faba}",
    "rewind-backward-15": "\u{fabb}",
    "rewind-backward-20": "\u{fabc}",
    "rewind-backward-30": "\u{fabd}",
    "rewind-backward-40": "\u{fabe}",
    "rewind-backward-5": "\u{fabf}",
    "rewind-backward-50": "\u{fac0}",
    "rewind-backward-60": "\u{fac1}",
    "rewind-forward-10": "\u{fac2}",
    "rewind-forward-15": "\u{fac3}",
    "rewind-forward-20": "\u{fac4}",
    "rewind-forward-30": "\u{fac5}",
    "rewind-forward-40": "\u{fac6}",
    "rewind-forward-5": "\u{fac7}",
    "rewind-forward-50": "\u{fac8}",
    "rewind-forward-60": "\u{fac9}",
    "ribbon-health": "\u{f58e}",
    "rings": "\u{fa6a}",
    "ripple": "\u{ed82}",
    "ripple-off": "\u{f190}",
    "road": "\u{f018}",
    "road-off": "\u{f191}",
    "road-sign": "\u{ecdd}",
    "robot": "\u{f00b}",
    "robot-face": "\u{fcbe}",
    "robot-off": "\u{f192}",
    "rocket": "\u{ec45}",
    "rocket-off": "\u{f193}",
    "roller-skating": "\u{efd1}",
    "rollercoaster": "\u{f0a2}",
    "rollercoaster-filled": "\u{100f7}",
    "rollercoaster-off": "\u{f423}",
    "rosette": "\u{f599}",
    "rosette-discount": "\u{ee7c}",
    "rosette-discount-check": "\u{f1f8}",
    "rosette-discount-check-filled": "\u{f746}",
    "rosette-discount-check-off": "\u{ff10}",
    "rosette-discount-filled": "\u{ff05}",
    "rosette-discount-off": "\u{f3e6}",
    "rosette-filled": "\u{f69d}",
    "rosette-number-0": "\u{f58f}",
    "rosette-number-1": "\u{f590}",
    "rosette-number-2": "\u{f591}",
    "rosette-number-3": "\u{f592}",
    "rosette-number-4": "\u{f593}",
    "rosette-number-5": "\u{f594}",
    "rosette-number-6": "\u{f595}",
    "rosette-number-7": "\u{f596}",
    "rosette-number-8": "\u{f597}",
    "rosette-number-9": "\u{f598}",
    "rotate": "\u{eb16}",
    "rotate-2": "\u{ebb4}",
    "rotate-360": "\u{ef85}",
    "rotate-3d": "\u{f020}",
    "rotate-clockwise": "\u{eb15}",
    "rotate-clockwise-2": "\u{ebb5}",
    "rotate-dot": "\u{efe5}",
    "rotate-rectangle": "\u{ec15}",
    "route": "\u{eb17}",
    "route-2": "\u{f4b6}",
    "route-alt-left": "\u{fca9}",
    "route-alt-right": "\u{fcaa}",
    "route-off": "\u{f194}",
    "route-scan": "\u{fcbf}",
    "route-square": "\u{fcac}",
    "route-square-2": "\u{fcab}",
    "route-x": "\u{fcae}",
    "route-x-2": "\u{fcad}",
    "router": "\u{eb18}",
    "router-off": "\u{f424}",
    "row-insert-bottom": "\u{eed0}",
    "row-insert-top": "\u{eed1}",
    "row-remove": "\u{fafe}",
    "rss": "\u{eb19}",
    "rubber-stamp": "\u{f5ab}",
    "rubber-stamp-off": "\u{f5aa}",
    "ruler": "\u{eb1a}",
    "ruler-2": "\u{eed2}",
    "ruler-2-off": "\u{f195}",
    "ruler-3": "\u{f290}",
    "ruler-measure": "\u{f291}",
    "ruler-measure-2": "\u{ff0f}",
    "ruler-off": "\u{f196}",
    "run": "\u{ec82}",
    "rv-truck": "\u{fcc0}",
    "s-turn-down": "\u{f516}",
    "s-turn-left": "\u{f517}",
    "s-turn-right": "\u{f518}",
    "s-turn-up": "\u{f519}",
    "sailboat": "\u{ec83}",
    "sailboat-2": "\u{f5f7}",
    "sailboat-off": "\u{f425}",
    "salad": "\u{f50a}",
    "salad-filled": "\u{10007}",
    "salt": "\u{ef16}",
    "sandbox": "\u{fd6c}",
    "satellite": "\u{eed3}",
    "satellite-off": "\u{f197}",
    "sausage": "\u{ef17}",
    "scale": "\u{ebc2}",
    "scale-off": "\u{f198}",
    "scale-outline": "\u{ef53}",
    "scale-outline-off": "\u{f199}",
    "scan": "\u{ebc8}",
    "scan-eye": "\u{f1ff}",
    "scan-position": "\u{fdac}",
    "schema": "\u{f200}",
    "schema-off": "\u{f426}",
    "school": "\u{ecf7}",
    "school-bell": "\u{f64a}",
    "school-off": "\u{f19a}",
    "scissors": "\u{eb1b}",
    "scissors-off": "\u{f19b}",
    "scooter": "\u{ec6c}",
    "scooter-electric": "\u{ecc1}",
    "scoreboard": "\u{fa6b}",
    "screen-share": "\u{ed18}",
    "screen-share-off": "\u{ed17}",
    "screenshot": "\u{f201}",
    "scribble": "\u{f0a3}",
    "scribble-off": "\u{f427}",
    "script": "\u{f2da}",
    "script-minus": "\u{f2d7}",
    "script-plus": "\u{f2d8}",
    "script-x": "\u{f2d9}",
    "scuba-diving": "\u{fd4e}",
    "scuba-diving-tank": "\u{fefa}",
    "scuba-diving-tank-filled": "\u{ff04}",
    "scuba-mask": "\u{eed4}",
    "scuba-mask-off": "\u{f428}",
    "sdk": "\u{f3af}",
    "search": "\u{eb1c}",
    "search-off": "\u{f19c}",
    "section": "\u{eed5}",
    //"section-filled": "\u{fe09}",
    "section-sign": "\u{f019}",
    "seeding": "\u{ed51}",
    "seeding-filled": "\u{10006}",
    "seeding-off": "\u{f19d}",
    "seedling": "\u{ed51}",
    "seedling-filled": "\u{10006}",
    "seedling-off": "\u{f19d}",
    "select": "\u{ec9e}",
    "select-all": "\u{f9f7}",
    "selector": "\u{eb1d}",
    "send": "\u{eb1e}",
    "send-2": "\u{fd5d}",
    "send-off": "\u{f429}",
    "seo": "\u{f26b}",
    "separator": "\u{ebda}",
    "separator-horizontal": "\u{ec79}",
    "separator-vertical": "\u{ec7a}",
    "server": "\u{eb1f}",
    "server-2": "\u{f07c}",
    "server-bolt": "\u{f320}",
    "server-cog": "\u{f321}",
    "server-off": "\u{f19e}",
    "server-spark": "\u{ffaf}",
    "servicemark": "\u{ec09}",
    "settings": "\u{eb20}",
    "settings-2": "\u{f5ac}",
    "settings-automation": "\u{eed6}",
    "settings-bolt": "\u{f9ad}",
    "settings-cancel": "\u{f9ae}",
    "settings-check": "\u{f9af}",
    "settings-code": "\u{f9b0}",
    "settings-cog": "\u{f9b1}",
    "settings-dollar": "\u{f9b2}",
    "settings-down": "\u{f9b3}",
    "settings-exclamation": "\u{f9b4}",
    "settings-filled": "\u{f69e}",
    "settings-heart": "\u{f9b5}",
    "settings-minus": "\u{f9b6}",
    "settings-off": "\u{f19f}",
    "settings-pause": "\u{f9b7}",
    "settings-pin": "\u{f9b8}",
    "settings-plus": "\u{f9b9}",
    "settings-question": "\u{f9ba}",
    "settings-search": "\u{f9bb}",
    "settings-share": "\u{f9bc}",
    "settings-spark": "\u{ffae}",
    "settings-star": "\u{f9bd}",
    "settings-up": "\u{f9be}",
    "settings-x": "\u{f9bf}",
    "shadow": "\u{eed8}",
    "shadow-off": "\u{eed7}",
    "shape": "\u{eb9c}",
    "shape-2": "\u{eed9}",
    "shape-3": "\u{eeda}",
    "shape-off": "\u{f1a0}",
    "share": "\u{eb21}",
    "share-2": "\u{f799}",
    "share-3": "\u{f7bd}",
    "share-off": "\u{f1a1}",
    "shareplay": "\u{fea5}",
    "shi-jumping": "\u{fa6c}",
    "shield": "\u{eb24}",
    "shield-bolt": "\u{f9c0}",
    "shield-cancel": "\u{f9c1}",
    "shield-check": "\u{eb22}",
    "shield-check-filled": "\u{f761}",
    "shield-checkered": "\u{ef9a}",
    "shield-checkered-filled": "\u{f762}",
    "shield-chevron": "\u{ef9b}",
    "shield-code": "\u{f9c2}",
    "shield-cog": "\u{f9c3}",
    "shield-dollar": "\u{f9c4}",
    "shield-down": "\u{f9c5}",
    "shield-exclamation": "\u{f9c6}",
    "shield-filled": "\u{f69f}",
    "shield-half": "\u{f358}",
    "shield-half-filled": "\u{f357}",
    "shield-heart": "\u{f9c7}",
    "shield-lock": "\u{ed58}",
    "shield-lock-filled": "\u{f763}",
    "shield-minus": "\u{f9c8}",
    "shield-off": "\u{ecf8}",
    "shield-pause": "\u{f9c9}",
    "shield-pin": "\u{f9ca}",
    "shield-plus": "\u{f9cb}",
    "shield-question": "\u{f9cc}",
    "shield-search": "\u{f9cd}",
    "shield-share": "\u{f9ce}",
    "shield-star": "\u{f9cf}",
    "shield-up": "\u{f9d0}",
    "shield-x": "\u{eb23}",
    "ship": "\u{ec84}",
    "ship-off": "\u{f42a}",
    "shirt": "\u{ec0a}",
    "shirt-filled": "\u{f6a0}",
    "shirt-off": "\u{f1a2}",
    "shirt-sport": "\u{f26c}",
    "shoe": "\u{efd2}",
    "shoe-off": "\u{f1a4}",
    "shopping-bag": "\u{f5f8}",
    "shopping-bag-check": "\u{fc16}",
    "shopping-bag-discount": "\u{fc17}",
    "shopping-bag-edit": "\u{fc18}",
    "shopping-bag-exclamation": "\u{fc19}",
    "shopping-bag-heart": "\u{fda2}",
    "shopping-bag-minus": "\u{fc1a}",
    "shopping-bag-plus": "\u{fc1b}",
    "shopping-bag-search": "\u{fc1c}",
    "shopping-bag-x": "\u{fc1d}",
    "shopping-cart": "\u{eb25}",
    "shopping-cart-bolt": "\u{fb57}",
    "shopping-cart-cancel": "\u{fb58}",
    "shopping-cart-check": "\u{fb59}",
    "shopping-cart-code": "\u{fb5a}",
    "shopping-cart-cog": "\u{fb5b}",
    "shopping-cart-copy": "\u{fb5c}",
    "shopping-cart-discount": "\u{fb5d}",
    "shopping-cart-dollar": "\u{fb5e}",
    "shopping-cart-down": "\u{fb5f}",
    "shopping-cart-exclamation": "\u{fb60}",
    "shopping-cart-filled": "\u{fc3f}",
    "shopping-cart-heart": "\u{fb61}",
    "shopping-cart-minus": "\u{fb62}",
    "shopping-cart-off": "\u{eedc}",
    "shopping-cart-pause": "\u{fb63}",
    "shopping-cart-pin": "\u{fb64}",
    "shopping-cart-plus": "\u{fb65}",
    "shopping-cart-question": "\u{fb66}",
    "shopping-cart-search": "\u{fb67}",
    "shopping-cart-share": "\u{fb68}",
    "shopping-cart-star": "\u{fb69}",
    "shopping-cart-up": "\u{fb6a}",
    "shopping-cart-x": "\u{fb6b}",
    "shovel": "\u{f1d9}",
    "shovel-pitchforks": "\u{fd3a}",
    "shredder": "\u{eedf}",
    "sign-left": "\u{f06b}",
    "sign-left-filled": "\u{f6a1}",
    "sign-right": "\u{f06c}",
    "sign-right-filled": "\u{f6a2}",
    "signal-2g": "\u{f79a}",
    "signal-3g": "\u{f1ee}",
    "signal-4g": "\u{f1ef}",
    "signal-4g-plus": "\u{f259}",
    "signal-5g": "\u{f1f0}",
    "signal-6g": "\u{f9f8}",
    "signal-e": "\u{f9f9}",
    "signal-g": "\u{f9fa}",
    "signal-h": "\u{f9fc}",
    "signal-h-plus": "\u{f9fb}",
    "signal-lte": "\u{f9fd}",
    "signature": "\u{eee0}",
    "signature-off": "\u{f1a5}",
    "sitemap": "\u{eb9d}",
    "sitemap-filled": "\u{1006b}",
    "sitemap-off": "\u{f1a6}",
    "skateboard": "\u{ecc2}",
    "skateboard-off": "\u{f42b}",
    "skateboarding": "\u{faca}",
    "skew-x": "\u{fd3b}",
    "skew-y": "\u{fd3c}",
    "ski-jumping": "\u{fa6c}",
    "skull": "\u{f292}",
    "slash": "\u{f4f9}",
    "slashes": "\u{f588}",
    "sleigh": "\u{ef9c}",
    "slice": "\u{ebdb}",
    "slideshow": "\u{ebc9}",
    "smart-home": "\u{ecde}",
    "smart-home-off": "\u{f1a7}",
    "smoking": "\u{ecc4}",
    "smoking-no": "\u{ecc3}",
    "snowboarding": "\u{fd4f}",
    "snowflake": "\u{ec0b}",
    "snowflake-off": "\u{f1a8}",
    "snowman": "\u{f26d}",
    "soccer-field": "\u{ed92}",
    "social": "\u{ebec}",
    "social-off": "\u{f1a9}",
    "sock": "\u{eee1}",
    "sofa": "\u{efaf}",
    "sofa-off": "\u{f42c}",
    "solar-electricity": "\u{fcc1}",
    "solar-panel": "\u{f7bf}",
    "solar-panel-2": "\u{f7be}",
    "sort-0-9": "\u{f54d}",
    "sort-9-0": "\u{f54e}",
    "sort-a-z": "\u{f54f}",
    "sort-ascending": "\u{eb26}",
    "sort-ascending-2": "\u{eee2}",
    "sort-ascending-2-filled": "\u{ff5b}",
    "sort-ascending-letters": "\u{ef18}",
    "sort-ascending-numbers": "\u{ef19}",
    "sort-ascending-shapes": "\u{fd94}",
    "sort-ascending-shapes-filled": "\u{ff5a}",
    "sort-ascending-small-big": "\u{fd95}",
    "sort-deacending-small-big": "\u{fd96}",
    "sort-descending": "\u{eb27}",
    "sort-descending-2": "\u{eee3}",
    "sort-descending-2-filled": "\u{ff59}",
    "sort-descending-letters": "\u{ef1a}",
    "sort-descending-numbers": "\u{ef1b}",
    "sort-descending-shapes": "\u{fd97}",
    "sort-descending-shapes-filled": "\u{ff58}",
    "sort-descending-small-big": "\u{fd96}",
    "sort-z-a": "\u{f550}",
    "sos": "\u{f24a}",
    "soup": "\u{ef2e}",
    //"soup-filled": "\u{fe08}",
    "soup-off": "\u{f42d}",
    "source-code": "\u{f4a2}",
    "space": "\u{ec0c}",
    "space-off": "\u{f1aa}",
    "spaces": "\u{fea4}",
    "spacing-horizontal": "\u{ef54}",
    "spacing-vertical": "\u{ef55}",
    "spade": "\u{effa}",
    "spade-filled": "\u{f6a3}",
    "sparkles": "\u{f6d7}",
    "speakerphone": "\u{ed61}",
    "speedboat": "\u{ed93}",
    "speedboat-filled": "\u{100f6}",
    "sphere": "\u{fab8}",
    "sphere-off": "\u{fab6}",
    "sphere-plus": "\u{fab7}",
    "spider": "\u{f293}",
    "spider-filled": "\u{10109}",
    "spiral": "\u{f294}",
    "spiral-off": "\u{f42e}",
    "sport-billard": "\u{eee4}",
    "spray": "\u{f50b}",
    "spy": "\u{f227}",
    "spy-off": "\u{f42f}",
    "sql": "\u{f7c0}",
    "square": "\u{eb2c}",
    "square-0": "\u{eee5}",
    "square-1": "\u{eee6}",
    "square-2": "\u{eee7}",
    "square-3": "\u{eee8}",
    "square-4": "\u{eee9}",
    "square-5": "\u{eeea}",
    "square-6": "\u{eeeb}",
    "square-7": "\u{eeec}",
    "square-8": "\u{eeed}",
    "square-9": "\u{eeee}",
    "square-arrow-down": "\u{f4b7}",
    "square-arrow-down-filled": "\u{fb31}",
    "square-arrow-left": "\u{f4b8}",
    "square-arrow-left-filled": "\u{fb32}",
    "square-arrow-right": "\u{f4b9}",
    "square-arrow-right-filled": "\u{fb33}",
    "square-arrow-up": "\u{f4ba}",
    "square-arrow-up-filled": "\u{fb34}",
    "square-asterisk": "\u{f01a}",
    "square-asterisk-filled": "\u{fb35}",
    "square-check": "\u{eb28}",
    "square-check-filled": "\u{f76d}",
    "square-chevron-down": "\u{f627}",
    "square-chevron-down-filled": "\u{fb36}",
    "square-chevron-left": "\u{f628}",
    "square-chevron-left-filled": "\u{fb37}",
    "square-chevron-right": "\u{f629}",
    "square-chevron-right-filled": "\u{fb38}",
    "square-chevron-up": "\u{f62a}",
    "square-chevron-up-filled": "\u{fb39}",
    "square-chevrons-down": "\u{f64b}",
    "square-chevrons-down-filled": "\u{fb3a}",
    "square-chevrons-left": "\u{f64c}",
    "square-chevrons-left-filled": "\u{fb3b}",
    "square-chevrons-right": "\u{f64d}",
    "square-chevrons-right-filled": "\u{fb3c}",
    "square-chevrons-up": "\u{f64e}",
    "square-chevrons-up-filled": "\u{fb3d}",
    "square-dashed": "\u{100bb}",
    "square-dot": "\u{ed59}",
    "square-dot-filled": "\u{fb3e}",
    "square-f0": "\u{f526}",
    "square-f0-filled": "\u{f76e}",
    "square-f1": "\u{f527}",
    "square-f1-filled": "\u{f76f}",
    "square-f2": "\u{f528}",
    "square-f2-filled": "\u{f770}",
    "square-f3": "\u{f529}",
    "square-f3-filled": "\u{f771}",
    "square-f4": "\u{f52a}",
    "square-f4-filled": "\u{f772}",
    "square-f5": "\u{f52b}",
    "square-f5-filled": "\u{f773}",
    "square-f6": "\u{f52c}",
    "square-f6-filled": "\u{f774}",
    "square-f7": "\u{f52d}",
    "square-f7-filled": "\u{f775}",
    "square-f8": "\u{f52e}",
    "square-f8-filled": "\u{f776}",
    "square-f9": "\u{f52f}",
    "square-f9-filled": "\u{f777}",
    "square-filled": "\u{fc40}",
    "square-forbid": "\u{ed5b}",
    "square-forbid-2": "\u{ed5a}",
    "square-half": "\u{effb}",
    "square-key": "\u{f638}",
    "square-letter-a": "\u{f47c}",
    //"square-letter-a-filled": "\u{fe07}",
    "square-letter-b": "\u{f47d}",
    //"square-letter-b-filled": "\u{fe06}",
    "square-letter-c": "\u{f47e}",
    //"square-letter-c-filled": "\u{fe05}",
    "square-letter-d": "\u{f47f}",
    //"square-letter-d-filled": "\u{fe04}",
    "square-letter-e": "\u{f480}",
    //"square-letter-e-filled": "\u{fe03}",
    "square-letter-f": "\u{f481}",
    //"square-letter-f-filled": "\u{fe02}",
    "square-letter-g": "\u{f482}",
    //"square-letter-g-filled": "\u{fe01}",
    "square-letter-h": "\u{f483}",
    //"square-letter-h-filled": "\u{fe00}",
    "square-letter-i": "\u{f484}",
    "square-letter-i-filled": "\u{fdff}",
    "square-letter-j": "\u{f485}",
    "square-letter-j-filled": "\u{fdfe}",
    "square-letter-k": "\u{f486}",
    "square-letter-k-filled": "\u{fdfd}",
    "square-letter-l": "\u{f487}",
    "square-letter-l-filled": "\u{fdfc}",
    "square-letter-m": "\u{f488}",
    "square-letter-m-filled": "\u{fdfb}",
    "square-letter-n": "\u{f489}",
    "square-letter-n-filled": "\u{fdfa}",
    "square-letter-o": "\u{f48a}",
    "square-letter-o-filled": "\u{fdf9}",
    "square-letter-p": "\u{f48b}",
    "square-letter-p-filled": "\u{fdf8}",
    "square-letter-q": "\u{f48c}",
    "square-letter-q-filled": "\u{fdf7}",
    "square-letter-r": "\u{f48d}",
    "square-letter-r-filled": "\u{fdf6}",
    "square-letter-s": "\u{f48e}",
    "square-letter-s-filled": "\u{fdf5}",
    "square-letter-t": "\u{f48f}",
    "square-letter-t-filled": "\u{fdf4}",
    "square-letter-u": "\u{f490}",
    "square-letter-u-filled": "\u{fdf3}",
    "square-letter-v": "\u{f4bb}",
    "square-letter-v-filled": "\u{fdf2}",
    "square-letter-w": "\u{f491}",
    "square-letter-w-filled": "\u{fdf1}",
    "square-letter-x": "\u{f4bc}",
    "square-letter-x-filled": "\u{fdf0}",
    "square-letter-y": "\u{f492}",
    "square-letter-y-filled": "\u{fdef}",
    "square-letter-z": "\u{f493}",
    "square-letter-z-filled": "\u{fdee}",
    "square-minus": "\u{eb29}",
    "square-minus-filled": "\u{fb3f}",
    "square-number-0": "\u{eee5}",
    "square-number-0-filled": "\u{f764}",
    "square-number-1": "\u{eee6}",
    "square-number-1-filled": "\u{f765}",
    "square-number-2": "\u{eee7}",
    "square-number-2-filled": "\u{f7fa}",
    "square-number-3": "\u{eee8}",
    "square-number-3-filled": "\u{f766}",
    "square-number-4": "\u{eee9}",
    "square-number-4-filled": "\u{f767}",
    "square-number-5": "\u{eeea}",
    "square-number-5-filled": "\u{f768}",
    "square-number-6": "\u{eeeb}",
    "square-number-6-filled": "\u{f769}",
    "square-number-7": "\u{eeec}",
    "square-number-7-filled": "\u{f76a}",
    "square-number-8": "\u{eeed}",
    "square-number-8-filled": "\u{f76b}",
    "square-number-9": "\u{eeee}",
    "square-number-9-filled": "\u{f76c}",
    "square-off": "\u{eeef}",
    "square-percentage": "\u{fd83}",
    "square-plus": "\u{eb2a}",
    "square-plus-2": "\u{fc96}",
    "square-root": "\u{eef1}",
    "square-root-2": "\u{eef0}",
    "square-rotated": "\u{ecdf}",
    "square-rotated-filled": "\u{f6a4}",
    "square-rotated-forbid": "\u{f01c}",
    "square-rotated-forbid-2": "\u{f01b}",
    "square-rotated-off": "\u{eef2}",
    "square-rounded": "\u{f59a}",
    "square-rounded-arrow-down": "\u{f639}",
    "square-rounded-arrow-down-filled": "\u{f6db}",
    "square-rounded-arrow-left": "\u{f63a}",
    "square-rounded-arrow-left-filled": "\u{f6dc}",
    "square-rounded-arrow-right": "\u{f63b}",
    "square-rounded-arrow-right-filled": "\u{f6dd}",
    "square-rounded-arrow-up": "\u{f63c}",
    "square-rounded-arrow-up-filled": "\u{f6de}",
    "square-rounded-check": "\u{f63d}",
    "square-rounded-check-filled": "\u{f6df}",
    "square-rounded-chevron-down": "\u{f62b}",
    "square-rounded-chevron-down-filled": "\u{f6e0}",
    "square-rounded-chevron-left": "\u{f62c}",
    "square-rounded-chevron-left-filled": "\u{f6e1}",
    "square-rounded-chevron-right": "\u{f62d}",
    "square-rounded-chevron-right-filled": "\u{f6e2}",
    "square-rounded-chevron-up": "\u{f62e}",
    "square-rounded-chevron-up-filled": "\u{f6e3}",
    "square-rounded-chevrons-down": "\u{f64f}",
    "square-rounded-chevrons-down-filled": "\u{f6e4}",
    "square-rounded-chevrons-left": "\u{f650}",
    "square-rounded-chevrons-left-filled": "\u{f6e5}",
    "square-rounded-chevrons-right": "\u{f651}",
    "square-rounded-chevrons-right-filled": "\u{f6e6}",
    "square-rounded-chevrons-up": "\u{f652}",
    "square-rounded-chevrons-up-filled": "\u{f6e7}",
    "square-rounded-filled": "\u{f6a5}",
    "square-rounded-letter-a": "\u{f5ae}",
    "square-rounded-letter-a-filled": "\u{fded}",
    "square-rounded-letter-b": "\u{f5af}",
    "square-rounded-letter-b-filled": "\u{fdec}",
    "square-rounded-letter-c": "\u{f5b0}",
    "square-rounded-letter-c-filled": "\u{fdeb}",
    "square-rounded-letter-d": "\u{f5b1}",
    "square-rounded-letter-d-filled": "\u{fdea}",
    "square-rounded-letter-e": "\u{f5b2}",
    "square-rounded-letter-e-filled": "\u{fde9}",
    "square-rounded-letter-f": "\u{f5b3}",
    "square-rounded-letter-f-filled": "\u{fde8}",
    "square-rounded-letter-g": "\u{f5b4}",
    "square-rounded-letter-g-filled": "\u{fde7}",
    "square-rounded-letter-h": "\u{f5b5}",
    "square-rounded-letter-h-filled": "\u{fde6}",
    "square-rounded-letter-i": "\u{f5b6}",
    "square-rounded-letter-i-filled": "\u{fde5}",
    "square-rounded-letter-j": "\u{f5b7}",
    "square-rounded-letter-j-filled": "\u{fde4}",
    "square-rounded-letter-k": "\u{f5b8}",
    "square-rounded-letter-k-filled": "\u{fde3}",
    "square-rounded-letter-l": "\u{f5b9}",
    "square-rounded-letter-l-filled": "\u{fde2}",
    "square-rounded-letter-m": "\u{f5ba}",
    "square-rounded-letter-m-filled": "\u{fde1}",
    "square-rounded-letter-n": "\u{f5bb}",
    "square-rounded-letter-n-filled": "\u{fde0}",
    "square-rounded-letter-o": "\u{f5bc}",
    "square-rounded-letter-o-filled": "\u{fddf}",
    "square-rounded-letter-p": "\u{f5bd}",
    "square-rounded-letter-p-filled": "\u{fdde}",
    "square-rounded-letter-q": "\u{f5be}",
    "square-rounded-letter-q-filled": "\u{fddd}",
    "square-rounded-letter-r": "\u{f5bf}",
    "square-rounded-letter-r-filled": "\u{fddc}",
    "square-rounded-letter-s": "\u{f5c0}",
    "square-rounded-letter-s-filled": "\u{fddb}",
    "square-rounded-letter-t": "\u{f5c1}",
    "square-rounded-letter-t-filled": "\u{fdda}",
    "square-rounded-letter-u": "\u{f5c2}",
    "square-rounded-letter-u-filled": "\u{fdd9}",
    "square-rounded-letter-v": "\u{f5c3}",
    "square-rounded-letter-v-filled": "\u{fdd8}",
    "square-rounded-letter-w": "\u{f5c4}",
    "square-rounded-letter-w-filled": "\u{fdd7}",
    "square-rounded-letter-x": "\u{f5c5}",
    "square-rounded-letter-x-filled": "\u{fdd6}",
    "square-rounded-letter-y": "\u{f5c6}",
    "square-rounded-letter-y-filled": "\u{fdd5}",
    "square-rounded-letter-z": "\u{f5c7}",
    "square-rounded-letter-z-filled": "\u{fdd4}",
    "square-rounded-minus": "\u{f63e}",
    "square-rounded-minus-2": "\u{fc97}",
    "square-rounded-minus-filled": "\u{fb40}",
    "square-rounded-number-0": "\u{f5c8}",
    "square-rounded-number-0-filled": "\u{f778}",
    "square-rounded-number-1": "\u{f5c9}",
    "square-rounded-number-1-filled": "\u{f779}",
    "square-rounded-number-2": "\u{f5ca}",
    "square-rounded-number-2-filled": "\u{f77a}",
    "square-rounded-number-3": "\u{f5cb}",
    "square-rounded-number-3-filled": "\u{f77b}",
    "square-rounded-number-4": "\u{f5cc}",
    "square-rounded-number-4-filled": "\u{f77c}",
    "square-rounded-number-5": "\u{f5cd}",
    "square-rounded-number-5-filled": "\u{f77d}",
    "square-rounded-number-6": "\u{f5ce}",
    "square-rounded-number-6-filled": "\u{f77e}",
    "square-rounded-number-7": "\u{f5cf}",
    "square-rounded-number-7-filled": "\u{f77f}",
    "square-rounded-number-8": "\u{f5d0}",
    "square-rounded-number-8-filled": "\u{f780}",
    "square-rounded-number-9": "\u{f5d1}",
    "square-rounded-number-9-filled": "\u{f781}",
    "square-rounded-percentage": "\u{fd84}",
    "square-rounded-plus": "\u{f63f}",
    "square-rounded-plus-2": "\u{fc98}",
    "square-rounded-plus-filled": "\u{f6e8}",
    "square-rounded-x": "\u{f640}",
    "square-rounded-x-filled": "\u{f6e9}",
    "square-toggle": "\u{eef4}",
    "square-toggle-horizontal": "\u{eef3}",
    "square-x": "\u{eb2b}",
    "square-x-filled": "\u{fb41}",
    "squares": "\u{eef6}",
    "squares-diagonal": "\u{eef5}",
    "squares-filled": "\u{fe9f}",
    "squares-selected": "\u{fea3}",
    "stack": "\u{eb2d}",
    "stack-2": "\u{eef7}",
    "stack-2-filled": "\u{fdd3}",
    "stack-3": "\u{ef9d}",
    "stack-3-filled": "\u{fdd2}",
    "stack-back": "\u{fd26}",
    "stack-backward": "\u{fd27}",
    "stack-filled": "\u{fdd1}",
    "stack-forward": "\u{fd28}",
    "stack-front": "\u{fd29}",
    "stack-middle": "\u{fd2a}",
    "stack-pop": "\u{f234}",
    "stack-push": "\u{f235}",
    "stairs": "\u{eca6}",
    "stairs-down": "\u{eca4}",
    "stairs-up": "\u{eca5}",
    "star": "\u{eb2e}",
    "star-filled": "\u{f6a6}",
    "star-half": "\u{ed19}",
    "star-half-filled": "\u{f6a7}",
    "star-off": "\u{ed62}",
    "stars": "\u{ed38}",
    "stars-filled": "\u{f6a8}",
    "stars-off": "\u{f430}",
    "status-change": "\u{f3b0}",
    "steam": "\u{f24b}",
    "steering-wheel": "\u{ec7b}",
    "steering-wheel-filled": "\u{ff03}",
    "steering-wheel-off": "\u{f431}",
    "step-into": "\u{ece0}",
    "step-out": "\u{ece1}",
    "stereo-glasses": "\u{f4cb}",
    "stethoscope": "\u{edbe}",
    "stethoscope-off": "\u{f432}",
    "sticker": "\u{eb2f}",
    "sticker-2": "\u{fd3d}",
    "stopwatch": "\u{ff9b}",
    "storm": "\u{f24c}",
    "storm-off": "\u{f433}",
    "stretching": "\u{f2db}",
    "stretching-2": "\u{fa6d}",
    "strikethrough": "\u{eb9e}",
    "submarine": "\u{ed94}",
    "subscript": "\u{eb9f}",
    "subtask": "\u{ec9f}",
    "sum": "\u{eb73}",
    "sum-off": "\u{f1ab}",
    "sun": "\u{eb30}",
    "sun-electricity": "\u{fcc2}",
    "sun-filled": "\u{f6a9}",
    "sun-high": "\u{f236}",
    "sun-high-filled": "\u{10108}",
    "sun-low": "\u{f237}",
    "sun-low-filled": "\u{10107}",
    "sun-moon": "\u{f4a3}",
    "sun-off": "\u{ed63}",
    "sun-wind": "\u{f238}",
    "sunglasses": "\u{f239}",
    "sunglasses-filled": "\u{fec8}",
    "sunrise": "\u{ef1c}",
    "sunrise-filled": "\u{10106}",
    "sunset": "\u{ec31}",
    "sunset-2": "\u{f23a}",
    "sunset-2-filled": "\u{10105}",
    "sunset-filled": "\u{10104}",
    "superscript": "\u{eba0}",
    "svg": "\u{f25a}",
    "swimming": "\u{ec92}",
    "swipe": "\u{f551}",
    "swipe-down": "\u{fd5e}",
    "swipe-down-filled": "\u{ff57}",
    "swipe-left": "\u{fd5f}",
    "swipe-left-filled": "\u{ff56}",
    "swipe-right": "\u{fd60}",
    "swipe-right-filled": "\u{ff55}",
    "swipe-up": "\u{fd61}",
    "swipe-up-filled": "\u{ff54}",
    "switch": "\u{eb33}",
    "switch-2": "\u{edbf}",
    "switch-3": "\u{edc0}",
    "switch-horizontal": "\u{eb31}",
    "switch-vertical": "\u{eb32}",
    "sword": "\u{f030}",
    "sword-off": "\u{f434}",
    "swords": "\u{f132}",
    "table": "\u{eba1}",
    "table-alias": "\u{f25b}",
    "table-column": "\u{faff}",
    "table-dashed": "\u{100ba}",
    "table-down": "\u{fa1c}",
    "table-export": "\u{eef8}",
    "table-filled": "\u{f782}",
    "table-heart": "\u{fa1d}",
    "table-import": "\u{eef9}",
    "table-minus": "\u{fa1e}",
    "table-off": "\u{eefa}",
    "table-options": "\u{f25c}",
    "table-plus": "\u{fa1f}",
    "table-row": "\u{fb00}",
    "table-share": "\u{fa20}",
    "table-shortcut": "\u{f25d}",
    "table-spark": "\u{ffad}",
    "tag": "\u{10096}",
    "tag-filled": "\u{ff02}",
    "tag-minus": "\u{eb34}",
    "tag-off": "\u{efc0}",
    "tag-plus": "\u{10097}",
    "tag-starred": "\u{fc99}",
    "tags": "\u{ef86}",
    "tags-filled": "\u{ff01}",
    "tags-off": "\u{efc1}",
    "tallymark-1": "\u{ec46}",
    "tallymark-2": "\u{ec47}",
    "tallymark-3": "\u{ec48}",
    "tallymark-4": "\u{ec49}",
    "tallymarks": "\u{ec4a}",
    "tank": "\u{ed95}",
    "target": "\u{eb35}",
    "target-arrow": "\u{f51a}",
    "target-off": "\u{f1ad}",
    "tax": "\u{feee}",
    "tax-euro": "\u{fef0}",
    "tax-pound": "\u{feef}",
    "teapot": "\u{f552}",
    "telescope": "\u{f07d}",
    "telescope-off": "\u{f1ae}",
    "temperature": "\u{eb38}",
    "temperature-celsius": "\u{eb36}",
    "temperature-fahrenheit": "\u{eb37}",
    "temperature-minus": "\u{ebed}",
    "temperature-minus-filled": "\u{10103}",
    "temperature-off": "\u{f1af}",
    "temperature-plus": "\u{ebee}",
    "temperature-plus-filled": "\u{10102}",
    "temperature-snow": "\u{fda3}",
    "temperature-sun": "\u{fda4}",
    "template": "\u{eb39}",
    "template-filled": "\u{10177}",
    "template-off": "\u{f1b0}",
    "tent": "\u{eefb}",
    "tent-off": "\u{f435}",
    "terminal": "\u{ebdc}",
    "terminal-2": "\u{ebef}",
    "test-pipe": "\u{eb3a}",
    "test-pipe-2": "\u{f0a4}",
    "test-pipe-2-filled": "\u{ff53}",
    "test-pipe-off": "\u{f1b1}",
    "tex": "\u{f4e0}",
    "text-caption": "\u{f4a4}",
    "text-color": "\u{f2dc}",
    "text-decrease": "\u{f202}",
    "text-direction-ltr": "\u{eefc}",
    "text-direction-rtl": "\u{eefd}",
    "text-grammar": "\u{fd6d}",
    "text-increase": "\u{f203}",
    "text-orientation": "\u{f2a4}",
    "text-plus": "\u{f2a5}",
    "text-recognition": "\u{f204}",
    "text-resize": "\u{ef87}",
    "text-scan-2": "\u{fcc3}",
    "text-size": "\u{f2b1}",
    "text-spellcheck": "\u{f2a6}",
    "text-wrap": "\u{ebdd}",
    "text-wrap-column": "\u{feb2}",
    "text-wrap-disabled": "\u{eca7}",
    "texture": "\u{f51b}",
    "theater": "\u{f79b}",
    "thermometer": "\u{ef67}",
    "thumb-down": "\u{eb3b}",
    "thumb-down-filled": "\u{f6aa}",
    "thumb-down-off": "\u{f436}",
    "thumb-up": "\u{eb3c}",
    "thumb-up-filled": "\u{f6ab}",
    "thumb-up-off": "\u{f437}",
    "tic-tac": "\u{f51c}",
    "ticket": "\u{eb3d}",
    "ticket-off": "\u{f1b2}",
    "tie": "\u{f07e}",
    "tilde": "\u{f4a5}",
    "tilt-shift": "\u{eefe}",
    "tilt-shift-filled": "\u{fec7}",
    "tilt-shift-off": "\u{f1b3}",
    "time-duration-0": "\u{fad4}",
    "time-duration-10": "\u{fad5}",
    "time-duration-15": "\u{fad6}",
    "time-duration-30": "\u{fad7}",
    "time-duration-45": "\u{fad8}",
    "time-duration-5": "\u{fad9}",
    "time-duration-60": "\u{fada}",
    "time-duration-90": "\u{fadb}",
    "time-duration-off": "\u{fadc}",
    "timeline": "\u{f031}",
    "timeline-event": "\u{f553}",
    "timeline-event-exclamation": "\u{f662}",
    "timeline-event-filled": "\u{fd18}",
    "timeline-event-minus": "\u{f663}",
    "timeline-event-plus": "\u{f664}",
    "timeline-event-text": "\u{f665}",
    "timeline-event-x": "\u{f666}",
    "timezone": "\u{feed}",
    "tip-jar": "\u{feea}",
    "tip-jar-euro": "\u{feec}",
    "tip-jar-pound": "\u{feeb}",
    "tir": "\u{ebf0}",
    "toggle-left": "\u{eb3e}",
    "toggle-left-filled": "\u{fec0}",
    "toggle-right": "\u{eb3f}",
    "toggle-right-filled": "\u{febf}",
    "toilet-paper": "\u{efd3}",
    "toilet-paper-off": "\u{f1b4}",
    "toml": "\u{fa5d}",
    "tool": "\u{eb40}",
    "tools": "\u{ebca}",
    "tools-kitchen": "\u{ed64}",
    "tools-kitchen-2": "\u{eeff}",
    "tools-kitchen-2-off": "\u{f1b5}",
    "tools-kitchen-3": "\u{fd2b}",
    "tools-kitchen-off": "\u{f1b6}",
    "tools-off": "\u{f1b7}",
    "tooltip": "\u{f2dd}",
    "topology-bus": "\u{f5d9}",
    "topology-complex": "\u{f5da}",
    "topology-full": "\u{f5dc}",
    "topology-full-hierarchy": "\u{f5db}",
    "topology-ring": "\u{f5df}",
    "topology-ring-2": "\u{f5dd}",
    "topology-ring-3": "\u{f5de}",
    "topology-star": "\u{f5e5}",
    "topology-star-2": "\u{f5e0}",
    "topology-star-3": "\u{f5e1}",
    "topology-star-ring": "\u{f5e4}",
    "topology-star-ring-2": "\u{f5e2}",
    "topology-star-ring-3": "\u{f5e3}",
    "torii": "\u{f59b}",
    "tornado": "\u{ece2}",
    "tournament": "\u{ecd0}",
    "tower": "\u{f2cb}",
    "tower-off": "\u{f2ca}",
    "track": "\u{ef00}",
    "tractor": "\u{ec0d}",
    "trademark": "\u{ec0e}",
    "traffic-cone": "\u{ec0f}",
    "traffic-cone-off": "\u{f1b8}",
    "traffic-lights": "\u{ed39}",
    "traffic-lights-off": "\u{f1b9}",
    "train": "\u{ed96}",
    "train-filled": "\u{100f5}",
    "transaction-bitcoin": "\u{fd6e}",
    "transaction-dollar": "\u{fd6f}",
    "transaction-euro": "\u{fd70}",
    "transaction-pound": "\u{fd71}",
    "transaction-rupee": "\u{fd85}",
    "transaction-yen": "\u{fd72}",
    "transaction-yuan": "\u{fd73}",
    "transfer": "\u{fc1f}",
    "transfer-in": "\u{ef2f}",
    "transfer-out": "\u{ef30}",
    "transfer-vertical": "\u{fc1e}",
    "transform": "\u{f38e}",
    "transform-filled": "\u{f6ac}",
    "transform-point": "\u{fda9}",
    "transform-point-bottom-left": "\u{fda5}",
    "transform-point-bottom-right": "\u{fda6}",
    "transform-point-top-left": "\u{fda7}",
    "transform-point-top-right": "\u{fda8}",
    "transition-bottom": "\u{f2b2}",
    "transition-bottom-filled": "\u{fdd0}",
    "transition-left": "\u{f2b3}",
    "transition-left-filled": "\u{fdcf}",
    "transition-right": "\u{f2b4}",
    "transition-right-filled": "\u{fdce}",
    "transition-top": "\u{f2b5}",
    "transition-top-filled": "\u{fdcd}",
    "trash": "\u{eb41}",
    "trash-filled": "\u{f783}",
    "trash-off": "\u{ed65}",
    "trash-x": "\u{ef88}",
    "trash-x-filled": "\u{f784}",
    "treadmill": "\u{fa6e}",
    "tree": "\u{ef01}",
    "trees": "\u{ec10}",
    "trekking": "\u{f5ad}",
    "trending-down": "\u{eb42}",
    "trending-down-2": "\u{edc1}",
    "trending-down-3": "\u{edc2}",
    "trending-up": "\u{eb43}",
    "trending-up-2": "\u{edc3}",
    "trending-up-3": "\u{edc4}",
    "triangle": "\u{eb44}",
    "triangle-filled": "\u{f6ad}",
    "triangle-inverted": "\u{f01d}",
    "triangle-inverted-filled": "\u{f6ae}",
    "triangle-minus": "\u{fc9b}",
    "triangle-minus-2": "\u{fc9a}",
    "triangle-off": "\u{ef02}",
    "triangle-plus": "\u{fc9d}",
    "triangle-plus-2": "\u{fc9c}",
    "triangle-square-circle": "\u{ece8}",
    "triangle-square-circle-filled": "\u{fb42}",
    "triangles": "\u{f0a5}",
    "trident": "\u{ecc5}",
    "trolley": "\u{f4cc}",
    "trolley-filled": "\u{100f4}",
    "trophy": "\u{eb45}",
    "trophy-filled": "\u{f6af}",
    "trophy-off": "\u{f438}",
    "trowel": "\u{f368}",
    "truck": "\u{ebc4}",
    "truck-delivery": "\u{ec4b}",
    "truck-filled": "\u{100f3}",
    "truck-loading": "\u{f1da}",
    "truck-off": "\u{ef03}",
    "truck-return": "\u{ec4c}",
    "txt": "\u{f3b1}",
    "typeface": "\u{fdab}",
    "typography": "\u{ebc5}",
    "typography-off": "\u{f1ba}",
    "u-turn-left": "\u{fea2}",
    "u-turn-right": "\u{fea1}",
    "ufo": "\u{f26f}",
    "ufo-filled": "\u{10165}",
    "ufo-off": "\u{f26e}",
    "uhd": "\u{100aa}",
    "umbrella": "\u{ebf1}",
    "umbrella-2": "\u{ff0e}",
    "umbrella-closed": "\u{ff0c}",
    "umbrella-closed-2": "\u{ff0d}",
    "umbrella-filled": "\u{f6b0}",
    "umbrella-off": "\u{f1bb}",
    "underline": "\u{eba2}",
    "universe": "\u{fcc4}",
    "unlink": "\u{eb46}",
    "upload": "\u{eb47}",
    "urgent": "\u{eb48}",
    "usb": "\u{f00c}",
    "user": "\u{eb4d}",
    "user-bitcoin": "\u{ff30}",
    "user-bolt": "\u{f9d1}",
    "user-cancel": "\u{f9d2}",
    "user-check": "\u{eb49}",
    "user-circle": "\u{ef68}",
    "user-code": "\u{f9d3}",
    "user-cog": "\u{f9d4}",
    "user-dollar": "\u{f9d5}",
    "user-down": "\u{f9d6}",
    "user-edit": "\u{f7cc}",
    "user-exclamation": "\u{ec12}",
    "user-filled": "\u{fd19}",
    "user-heart": "\u{f7cd}",
    "user-hexagon": "\u{fc4e}",
    "user-minus": "\u{eb4a}",
    "user-off": "\u{ecf9}",
    "user-pause": "\u{f9d7}",
    "user-pentagon": "\u{fc4f}",
    "user-pin": "\u{f7ce}",
    "user-plus": "\u{eb4b}",
    "user-question": "\u{f7cf}",
    "user-scan": "\u{fcaf}",
    "user-screen": "\u{fea0}",
    "user-search": "\u{ef89}",
    "user-share": "\u{f9d8}",
    "user-shield": "\u{f7d0}",
    "user-square": "\u{fc51}",
    "user-square-rounded": "\u{fc50}",
    "user-star": "\u{f7d1}",
    "user-up": "\u{f7d2}",
    "user-x": "\u{eb4c}",
    "users": "\u{ebf2}",
    "users-group": "\u{fa21}",
    "users-minus": "\u{fa0e}",
    "users-plus": "\u{fa0f}",
    "uv-index": "\u{f3b2}",
    "ux-circle": "\u{f369}",
    "vaccine": "\u{ef04}",
    "vaccine-bottle": "\u{ef69}",
    "vaccine-bottle-off": "\u{f439}",
    "vaccine-off": "\u{f1bc}",
    "vacuum-cleaner": "\u{f5e6}",
    "variable": "\u{ef05}",
    "variable-minus": "\u{f36a}",
    "variable-off": "\u{f1bd}",
    "variable-plus": "\u{f36b}",
    "vector": "\u{eca9}",
    "vector-bezier": "\u{ef1d}",
    "vector-bezier-2": "\u{f1a3}",
    "vector-bezier-arc": "\u{f4cd}",
    "vector-bezier-circle": "\u{f4ce}",
    "vector-off": "\u{f1be}",
    "vector-spline": "\u{f565}",
    "vector-triangle": "\u{eca8}",
    "vector-triangle-off": "\u{f1bf}",
    "venus": "\u{ec86}",
    "versions": "\u{ed52}",
    "versions-filled": "\u{f6b1}",
    "versions-off": "\u{f1c0}",
    "video": "\u{ed22}",
    "video-filled": "\u{1009b}",
    "video-minus": "\u{ed1f}",
    "video-off": "\u{ed20}",
    "video-plus": "\u{ed21}",
    "view-360": "\u{ed84}",
    "view-360-arrow": "\u{f62f}",
    "view-360-number": "\u{f566}",
    "view-360-off": "\u{f1c1}",
    "viewfinder": "\u{eb4e}",
    "viewfinder-off": "\u{f1c2}",
    "viewport-narrow": "\u{ebf3}",
    "viewport-short": "\u{fee9}",
    "viewport-tall": "\u{fee8}",
    "viewport-wide": "\u{ebf4}",
    "vinyl": "\u{f00d}",
    "vip": "\u{f3b3}",
    "vip-off": "\u{f43a}",
    "virus": "\u{eb74}",
    "virus-off": "\u{ed66}",
    "virus-search": "\u{ed67}",
    "vocabulary": "\u{ef1e}",
    "vocabulary-off": "\u{f43b}",
    "volcano": "\u{f79c}",
    "volume": "\u{eb51}",
    "volume-2": "\u{eb4f}",
    "volume-3": "\u{eb50}",
    "volume-off": "\u{f1c3}",
    "vs": "\u{fc52}",
    "walk": "\u{ec87}",
    "wall": "\u{ef7a}",
    "wall-off": "\u{f43c}",
    "wallet": "\u{eb75}",
    "wallet-off": "\u{f1c4}",
    "wallpaper": "\u{ef56}",
    "wallpaper-off": "\u{f1c5}",
    "wand": "\u{ebcb}",
    "wand-off": "\u{f1c6}",
    "wash": "\u{f311}",
    "wash-dry": "\u{f304}",
    "wash-dry-1": "\u{f2fa}",
    "wash-dry-2": "\u{f2fb}",
    "wash-dry-3": "\u{f2fc}",
    "wash-dry-a": "\u{f2fd}",
    "wash-dry-dip": "\u{f2fe}",
    "wash-dry-f": "\u{f2ff}",
    "wash-dry-flat": "\u{fa7f}",
    "wash-dry-hang": "\u{f300}",
    "wash-dry-off": "\u{f301}",
    "wash-dry-p": "\u{f302}",
    "wash-dry-shade": "\u{f303}",
    "wash-dry-w": "\u{f322}",
    "wash-dryclean": "\u{f305}",
    "wash-dryclean-off": "\u{f323}",
    "wash-eco": "\u{fa80}",
    "wash-gentle": "\u{f306}",
    "wash-hand": "\u{fa81}",
    "wash-machine": "\u{f25e}",
    "wash-off": "\u{f307}",
    "wash-press": "\u{f308}",
    "wash-temperature-1": "\u{f309}",
    "wash-temperature-2": "\u{f30a}",
    "wash-temperature-3": "\u{f30b}",
    "wash-temperature-4": "\u{f30c}",
    "wash-temperature-5": "\u{f30d}",
    "wash-temperature-6": "\u{f30e}",
    "wash-tumble-dry": "\u{f30f}",
    "wash-tumble-off": "\u{f310}",
    "waterpolo": "\u{fa6f}",
    "wave-saw-tool": "\u{ecd3}",
    "wave-sine": "\u{ecd4}",
    "wave-square": "\u{ecd5}",
    "waves-electricity": "\u{fcc5}",
    "webhook": "\u{f01e}",
    "webhook-off": "\u{f43d}",
    "weight": "\u{f589}",
    "wheat": "\u{100a8}",
    "wheat-off": "\u{100a9}",
    "wheel": "\u{fc64}",
    "wheelchair": "\u{f1db}",
    "wheelchair-off": "\u{f43e}",
    "whirl": "\u{f51d}",
    "wifi": "\u{eb52}",
    "wifi-0": "\u{eba3}",
    "wifi-1": "\u{eba4}",
    "wifi-2": "\u{eba5}",
    "wifi-off": "\u{ecfa}",
    "wind": "\u{ec34}",
    "wind-electricity": "\u{fcc6}",
    "wind-off": "\u{f1c7}",
    "windmill": "\u{ed85}",
    "windmill-filled": "\u{f6b2}",
    "windmill-off": "\u{f1c8}",
    "window": "\u{ef06}",
    "window-maximize": "\u{f1f1}",
    "window-minimize": "\u{f1f2}",
    "window-off": "\u{f1c9}",
    "windsock": "\u{f06d}",
    "windsock-filled": "\u{1009a}",
    "wiper": "\u{ecab}",
    "wiper-wash": "\u{ecaa}",
    "woman": "\u{eb53}",
    "woman-filled": "\u{fdcc}",
    "wood": "\u{f359}",
    "world": "\u{eb54}",
    "world-bolt": "\u{f9d9}",
    "world-cancel": "\u{f9da}",
    "world-check": "\u{f9db}",
    "world-code": "\u{f9dc}",
    "world-cog": "\u{f9dd}",
    "world-dollar": "\u{f9de}",
    "world-down": "\u{f9df}",
    "world-download": "\u{ef8a}",
    "world-exclamation": "\u{f9e0}",
    "world-heart": "\u{f9e1}",
    "world-latitude": "\u{ed2e}",
    "world-longitude": "\u{ed2f}",
    "world-minus": "\u{f9e2}",
    "world-off": "\u{f1ca}",
    "world-pause": "\u{f9e3}",
    "world-pin": "\u{f9e4}",
    "world-plus": "\u{f9e5}",
    "world-question": "\u{f9e6}",
    "world-search": "\u{f9e7}",
    "world-share": "\u{f9e8}",
    "world-star": "\u{f9e9}",
    "world-up": "\u{f9ea}",
    "world-upload": "\u{ef8b}",
    "world-www": "\u{f38f}",
    "world-x": "\u{f9eb}",
    "wrecking-ball": "\u{ed97}",
    "writing": "\u{ef08}",
    "writing-off": "\u{f1cb}",
    "writing-sign": "\u{ef07}",
    "writing-sign-off": "\u{f1cc}",
    "x": "\u{eb55}",
    "x-power-y": "\u{10072}",
    "xbox-a": "\u{f2b6}",
    "xbox-a-filled": "\u{fdcb}",
    "xbox-b": "\u{f2b7}",
    "xbox-b-filled": "\u{fdca}",
    "xbox-x": "\u{f2b8}",
    "xbox-x-filled": "\u{fdc9}",
    "xbox-y": "\u{f2b9}",
    "xbox-y-filled": "\u{fdc8}",
    "xd": "\u{fa33}",
    "xxx": "\u{fc20}",
    "yin-yang": "\u{ec35}",
    "yin-yang-filled": "\u{f785}",
    "yoga": "\u{f01f}",
    "zeppelin": "\u{f270}",
    "zeppelin-filled": "\u{fdc7}",
    "zeppelin-off": "\u{f43f}",
    "zip": "\u{f3b4}",
    "zodiac-aquarius": "\u{ecac}",
    "zodiac-aries": "\u{ecad}",
    "zodiac-cancer": "\u{ecae}",
    "zodiac-capricorn": "\u{ecaf}",
    "zodiac-gemini": "\u{ecb0}",
    "zodiac-leo": "\u{ecb1}",
    "zodiac-libra": "\u{ecb2}",
    "zodiac-pisces": "\u{ecb3}",
    "zodiac-sagittarius": "\u{ecb4}",
    "zodiac-scorpio": "\u{ecb5}",
    "zodiac-taurus": "\u{ecb6}",
    "zodiac-virgo": "\u{ecb7}",
    "zoom": "\u{fdaa}",
    "zoom-cancel": "\u{ec4d}",
    "zoom-cancel-filled": "\u{fdc6}",
    "zoom-check": "\u{ef09}",
    "zoom-check-filled": "\u{f786}",
    "zoom-code": "\u{f07f}",
    "zoom-code-filled": "\u{fdc5}",
    "zoom-exclamation": "\u{f080}",
    "zoom-exclamation-filled": "\u{fdc4}",
    "zoom-filled": "\u{f787}",
    "zoom-in": "\u{eb56}",
    "zoom-in-area": "\u{f1dc}",
    "zoom-in-area-filled": "\u{f788}",
    "zoom-in-filled": "\u{f789}",
    "zoom-money": "\u{ef0a}",
    "zoom-money-filled": "\u{fdc3}",
    "zoom-out": "\u{eb57}",
    "zoom-out-area": "\u{f1dd}",
    "zoom-out-area-filled": "\u{fdc2}",
    "zoom-out-filled": "\u{f78a}",
    "zoom-pan": "\u{f1de}",
    "zoom-pan-filled": "\u{fdc1}",
    "zoom-question": "\u{edeb}",
    "zoom-question-filled": "\u{fdc0}",
    "zoom-replace": "\u{f2a7}",
    "zoom-reset": "\u{f295}",
    "zoom-scan": "\u{fcb0}",
    "zoom-scan-filled": "\u{fdbf}",
    "zzz": "\u{f228}",
    "zzz-off": "\u{f440}"
  }
}
