/* Generated by wayland-scanner 1.24.0 */

#ifndef SLIDE_SERVER_PROTOCOL_H
#define SLIDE_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_slide The slide protocol
 * @section page_ifaces_slide Interfaces
 * - @subpage page_iface_org_kde_kwin_slide_manager - 
 * - @subpage page_iface_org_kde_kwin_slide - slide a surface from a location to another
 * @section page_copyright_slide Copyright
 * <pre>
 *
 * SPDX-FileCopyrightText: 2015 Martin Gräßlin
 * SPDX-FileCopyrightText: 2015 Marco Martin
 *
 * SPDX-License-Identifier: LGPL-2.1-or-later
 * </pre>
 */
struct org_kde_kwin_slide;
struct org_kde_kwin_slide_manager;
struct wl_surface;

#ifndef ORG_KDE_KWIN_SLIDE_MANAGER_INTERFACE
#define ORG_KDE_KWIN_SLIDE_MANAGER_INTERFACE
/**
 * @page page_iface_org_kde_kwin_slide_manager org_kde_kwin_slide_manager
 * @section page_iface_org_kde_kwin_slide_manager_api API
 * See @ref iface_org_kde_kwin_slide_manager.
 */
/**
 * @defgroup iface_org_kde_kwin_slide_manager The org_kde_kwin_slide_manager interface
 */
extern const struct wl_interface org_kde_kwin_slide_manager_interface;
#endif
#ifndef ORG_KDE_KWIN_SLIDE_INTERFACE
#define ORG_KDE_KWIN_SLIDE_INTERFACE
/**
 * @page page_iface_org_kde_kwin_slide org_kde_kwin_slide
 * @section page_iface_org_kde_kwin_slide_desc Description
 *
 * Ask the compositor to move the surface from a location to another
 * with a slide animation.
 *
 * The from argument provides a clue about where the slide animation
 * begins, offset is the distance from screen edge to begin the animation.
 * @section page_iface_org_kde_kwin_slide_api API
 * See @ref iface_org_kde_kwin_slide.
 */
/**
 * @defgroup iface_org_kde_kwin_slide The org_kde_kwin_slide interface
 *
 * Ask the compositor to move the surface from a location to another
 * with a slide animation.
 *
 * The from argument provides a clue about where the slide animation
 * begins, offset is the distance from screen edge to begin the animation.
 */
extern const struct wl_interface org_kde_kwin_slide_interface;
#endif

/**
 * @ingroup iface_org_kde_kwin_slide_manager
 * @struct org_kde_kwin_slide_manager_interface
 */
struct org_kde_kwin_slide_manager_interface {
	/**
	 */
	void (*create)(struct wl_client *client,
		       struct wl_resource *resource,
		       uint32_t id,
		       struct wl_resource *surface);
	/**
	 */
	void (*unset)(struct wl_client *client,
		      struct wl_resource *resource,
		      struct wl_resource *surface);
};


/**
 * @ingroup iface_org_kde_kwin_slide_manager
 */
#define ORG_KDE_KWIN_SLIDE_MANAGER_CREATE_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_kwin_slide_manager
 */
#define ORG_KDE_KWIN_SLIDE_MANAGER_UNSET_SINCE_VERSION 1

#ifndef ORG_KDE_KWIN_SLIDE_LOCATION_ENUM
#define ORG_KDE_KWIN_SLIDE_LOCATION_ENUM
enum org_kde_kwin_slide_location {
	ORG_KDE_KWIN_SLIDE_LOCATION_LEFT = 0,
	ORG_KDE_KWIN_SLIDE_LOCATION_TOP = 1,
	ORG_KDE_KWIN_SLIDE_LOCATION_RIGHT = 2,
	ORG_KDE_KWIN_SLIDE_LOCATION_BOTTOM = 3,
};
#endif /* ORG_KDE_KWIN_SLIDE_LOCATION_ENUM */

#ifndef ORG_KDE_KWIN_SLIDE_LOCATION_ENUM_IS_VALID
#define ORG_KDE_KWIN_SLIDE_LOCATION_ENUM_IS_VALID
/**
 * @ingroup iface_org_kde_kwin_slide
 * Validate a org_kde_kwin_slide location value.
 *
 * @return true on success, false on error.
 * @ref org_kde_kwin_slide_location
 */
static inline bool
org_kde_kwin_slide_location_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case ORG_KDE_KWIN_SLIDE_LOCATION_LEFT:
		return version >= 1;
	case ORG_KDE_KWIN_SLIDE_LOCATION_TOP:
		return version >= 1;
	case ORG_KDE_KWIN_SLIDE_LOCATION_RIGHT:
		return version >= 1;
	case ORG_KDE_KWIN_SLIDE_LOCATION_BOTTOM:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* ORG_KDE_KWIN_SLIDE_LOCATION_ENUM_IS_VALID */

/**
 * @ingroup iface_org_kde_kwin_slide
 * @struct org_kde_kwin_slide_interface
 */
struct org_kde_kwin_slide_interface {
	/**
	 */
	void (*commit)(struct wl_client *client,
		       struct wl_resource *resource);
	/**
	 */
	void (*set_location)(struct wl_client *client,
			     struct wl_resource *resource,
			     uint32_t location);
	/**
	 */
	void (*set_offset)(struct wl_client *client,
			   struct wl_resource *resource,
			   int32_t offset);
	/**
	 * release the slide object
	 *
	 * 
	 */
	void (*release)(struct wl_client *client,
			struct wl_resource *resource);
};


/**
 * @ingroup iface_org_kde_kwin_slide
 */
#define ORG_KDE_KWIN_SLIDE_COMMIT_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_kwin_slide
 */
#define ORG_KDE_KWIN_SLIDE_SET_LOCATION_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_kwin_slide
 */
#define ORG_KDE_KWIN_SLIDE_SET_OFFSET_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_kwin_slide
 */
#define ORG_KDE_KWIN_SLIDE_RELEASE_SINCE_VERSION 1

#ifdef  __cplusplus
}
#endif

#endif
