/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.projectcommander;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.sf.mpxj.common.ByteArrayHelper;
import net.sf.mpxj.common.DebugLogPrintWriter;
import net.sf.mpxj.common.InputStreamHelper;
import net.sf.mpxj.projectcommander.Block;
import net.sf.mpxj.projectcommander.BlockPattern;
import net.sf.mpxj.projectcommander.BlockPatternValidator;
import net.sf.mpxj.projectcommander.BlockReference;
import net.sf.mpxj.projectcommander.DatatypeConverter;

final class ProjectCommanderData {
    private byte[] m_buffer;
    private byte[] m_usageFingerprint;
    private PrintWriter m_log;
    private final List<Block> m_blocks = new ArrayList<Block>();
    private final Deque<Block> m_parentStack = new ArrayDeque<Block>();
    private static final BlockPattern[] NAMED_BLOCK_PATTERNS = new BlockPattern[]{new BlockPattern(null, -1, -1, 1, 0), new BlockPattern(null, -1, -1, 2, 0)};
    private static final BlockPattern[] BLOCK_PATTERNS = new BlockPattern[]{new BlockPattern("CSymbol", 1, -128), new BlockPattern("Unknown1", 2, -128), new BlockPattern("CCalendar", 5, -128), new BlockPattern("CDayFlag", 7, -128), new BlockPattern("CShape", 3, -128)};
    private static final byte[] REPORT_DATA_FINGERPRINT = new byte[]{5, 66, 97, 115, 105, 99, 5, 66, 97, 115, 105};
    private static final byte[] REPORT_GROUP_FINGERPRINT = new byte[]{21, 69, 97, 114, 110, 101, 100, 32, 86, 97, 108, 117, 101, 32, 65, 110, 97, 108, 121, 115, 105, 115, 1, 0};
    private static final byte[] VIEW_FINGERPRINT = new byte[]{12, 66, 111, 114, 100, 101, 114, 76, 97, 121, 111, 117, 116};
    private static final byte[] BASELINE_DATA_FINGERPRINT = new byte[]{10, 0, 0, -128};
    private static final byte[] BAR_FINGERPRINT = new byte[]{0, 10, 0, 0};
    private static final byte[] TASK_FINGERPRINT_1 = new byte[]{64, 0, 1, 0, 0, 0, 0, 0, 0};
    private static final byte[] TASK_FINGERPRINT_2 = new byte[]{66, 0, 1, 0, 0, 0, 0, 0, 0};
    private static final byte[] LINK_FINGERPRINT = new byte[]{8, 3, 5, 0};
    private static final Map<String, Set<String>> EXPECTED_CHILD_CLASSES = new HashMap<String, Set<String>>();

    ProjectCommanderData() {
    }

    public void process(InputStream is) throws IOException {
        this.openLogFile();
        this.populateBuffer(is);
        this.populateBlocks();
        this.updateHierarchy();
        this.closeLogFile();
        this.m_buffer = null;
    }

    public List<Block> getBlocks() {
        return this.m_blocks;
    }

    private void updateHierarchy() {
        this.m_blocks.stream().filter(x -> "CTask".equals(x.getName())).forEach(this::updateHierarchy);
    }

    private void updateHierarchy(Block block) {
        this.reparentBlocks(block, "CBar", "CLink");
        this.reparentBlocks(block, "CBaselineData", "CBar");
    }

    private void reparentBlocks(Block block, String parentName, String childName) {
        Block lastParent = null;
        Iterator<Block> iter = block.getChildBlocks().iterator();
        while (iter.hasNext()) {
            Block child = iter.next();
            if (parentName.equals(child.getName())) {
                lastParent = child;
                continue;
            }
            if (!childName.equals(child.getName()) || lastParent == null) continue;
            iter.remove();
            lastParent.getChildBlocks().add(child);
        }
    }

    private void populateBuffer(InputStream is) throws IOException {
        try {
            this.m_buffer = InputStreamHelper.read(is, is.available());
        }
        finally {
            is.close();
        }
    }

    private List<BlockPattern> selectBlockPatterns() {
        HashMap<String, BlockPattern> map = new HashMap<String, BlockPattern>();
        Arrays.stream(BLOCK_PATTERNS).forEach(pattern -> map.put(pattern.getName(), (BlockPattern)pattern));
        this.m_usageFingerprint = this.extractFingerprint("CResourceTask", false, 9);
        this.determineReportDataBlockBoundary(map);
        this.determineReportGroupBlockBoundary(map);
        this.determineResourceTaskBlockBoundary(map);
        this.determineViewBlockBoundary(map);
        this.determineResourceBlockBoundary(map);
        this.determineTaskBlockBoundary(map);
        this.determineLinkBlockBoundary(map);
        this.determineFilterObjectBlockBoundary(map);
        ArrayList<BlockPattern> blockPatterns = new ArrayList<BlockPattern>(Arrays.asList(NAMED_BLOCK_PATTERNS));
        map.values().stream().filter(Objects::nonNull).forEach(blockPatterns::add);
        this.logPatterns(blockPatterns);
        return blockPatterns;
    }

    private void determineReportDataBlockBoundary(Map<String, BlockPattern> map) {
        map.put("CReportData", this.identifyPattern("CReportData", null, REPORT_DATA_FINGERPRINT));
    }

    private void determineReportGroupBlockBoundary(Map<String, BlockPattern> map) {
        map.put("CReportGroup", this.identifyPattern("CReportGroup", null, REPORT_GROUP_FINGERPRINT));
    }

    private void determineResourceTaskBlockBoundary(Map<String, BlockPattern> map) {
        map.put("CResourceTask", this.identifyPattern("CResourceTask", set -> !set.contains("CReportGroup"), this.m_usageFingerprint));
    }

    private void determineViewBlockBoundary(Map<String, BlockPattern> map) {
        map.put("View", this.identifyPattern("View", 0, null, VIEW_FINGERPRINT));
    }

    private void determineResourceBlockBoundary(Map<String, BlockPattern> map) {
        BlockPattern test = map.get("CResourceTask");
        if (test == null) {
            this.logMessage("Unable to calculate CResource, no CResourceTask found");
        } else {
            int value = DatatypeConverter.getShort(test.getPattern(), 0);
            byte[] patternBytes = new byte[2];
            DatatypeConverter.setShort(patternBytes, 0, value -= 3);
            BlockPattern blockPattern = new BlockPattern("CResource", set -> !set.contains("CReportGroup"), patternBytes);
            map.put(blockPattern.getName(), blockPattern);
        }
    }

    private void determineTaskBlockBoundary(Map<String, BlockPattern> map) {
        long fingerprint2;
        long fingerprint1 = IntStream.range(0, this.m_buffer.length - TASK_FINGERPRINT_1.length).filter(index -> this.matchPattern(TASK_FINGERPRINT_1, index)).count();
        byte[] fingerprint = fingerprint1 > (fingerprint2 = IntStream.range(0, this.m_buffer.length - TASK_FINGERPRINT_2.length).filter(index -> this.matchPattern(TASK_FINGERPRINT_2, index)).count()) ? TASK_FINGERPRINT_1 : TASK_FINGERPRINT_2;
        int index2 = this.findFirstMatch(fingerprint, 0);
        if (index2 == -1) {
            this.logMessage("Unable to determine CTask boundary: no first task match");
        } else if ((index2 = this.findFirstMatch(fingerprint, index2 + 1)) == -1) {
            this.logMessage("Unable to determine CTask boundary: no second task match");
        } else {
            int secondTaskMatchIndex = index2;
            while (index2 >= 0 && this.m_buffer[index2] != 0) {
                --index2;
            }
            if (index2 == -1) {
                this.logMessage("Unable to determine CTask boundary: past data start");
            } else {
                BlockPattern blockPattern = new BlockPattern("CTask", this.m_buffer, index2 + 1);
                map.put(blockPattern.getName(), blockPattern);
                this.determineUsageTaskBlockBoundary(secondTaskMatchIndex, map);
            }
        }
    }

    private void determineUsageTaskBlockBoundary(int startIndex, Map<String, BlockPattern> map) {
        block2: {
            int index;
            while (true) {
                if ((index = this.findFirstMatch(this.m_usageFingerprint, startIndex + 1)) == -1) {
                    this.logMessage("Unable to determine CUsageTask boundary: no fingerprint match");
                    break block2;
                }
                if ((this.m_buffer[index - 1] & 0x80) != 0) break;
                startIndex = index;
            }
            BlockPattern blockPattern = new BlockPattern("CUsageTask", null, this.m_buffer, index -= 2);
            map.put(blockPattern.getName(), blockPattern);
            this.determineBarBlockBoundary(index, map);
            this.determineBaselineDataBlockBoundary(index, map);
        }
    }

    private void determineBaselineDataBlockBoundary(int index, Map<String, BlockPattern> map) {
        if ((index = this.findFirstMatch(BASELINE_DATA_FINGERPRINT, index + 1)) == -1) {
            this.logMessage("Unable to determine CBaselineData boundary: no fingerprint match");
        } else {
            BlockPattern blockPattern = new BlockPattern("CBaselineData", null, this.m_buffer, index -= 2);
            map.put(blockPattern.getName(), blockPattern);
        }
    }

    private void determineLinkBlockBoundary(Map<String, BlockPattern> map) {
        Map valueCounts = IntStream.range(0, this.m_buffer.length - LINK_FINGERPRINT.length).filter(index -> this.matchPattern(LINK_FINGERPRINT, index)).mapToObj(index -> DatatypeConverter.getShort(this.m_buffer, index - 4)).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
        Map.Entry entry = valueCounts.entrySet().stream().max(Map.Entry.comparingByValue()).orElse(null);
        if (entry != null) {
            byte[] patternBytes = new byte[2];
            DatatypeConverter.setShort(patternBytes, 0, (Integer)entry.getKey());
            BlockPattern blockPattern = new BlockPattern("CLink", patternBytes);
            map.put(blockPattern.getName(), blockPattern);
        } else {
            this.logMessage("Unable to determine CLink boundary: no fingerprint match");
        }
    }

    private void determineBarBlockBoundary(int index, Map<String, BlockPattern> map) {
        int searchLimit = index - 100;
        while (index > searchLimit) {
            if (this.matchPattern(BAR_FINGERPRINT, index)) {
                BlockPattern blockPattern = new BlockPattern("CBar", null, this.m_buffer, index - 2);
                map.put(blockPattern.getName(), blockPattern);
                break;
            }
            --index;
        }
        if (index == searchLimit) {
            this.logMessage("Unable to determine CBar boundary: no fingerprint match");
        }
    }

    private void determineFilterObjectBlockBoundary(Map<String, BlockPattern> map) {
        int index = this.findFirstMatch(VIEW_FINGERPRINT, 0);
        if (index == -1) {
            this.logMessage("Unable to determine CFilterObject boundary: no fingerprint match");
        } else {
            BlockPattern blockPattern = new BlockPattern("CFilterObject", null, this.m_buffer, index += 17);
            map.put(blockPattern.getName(), blockPattern);
        }
    }

    private List<BlockReference> populateBlockReferences() {
        ArrayList<BlockReference> blockReferences = new ArrayList<BlockReference>();
        List<BlockPattern> blockPatterns = this.selectBlockPatterns();
        HashSet<String> matchedPatternNames = new HashSet<String>();
        boolean skipImage = false;
        for (int index = 0; index < this.m_buffer.length - 11; ++index) {
            String name;
            BlockPattern block = this.matchPattern(blockPatterns, index);
            if (block == null || !block.getValid(matchedPatternNames)) continue;
            String string = name = block.getName() == null ? DatatypeConverter.getTwoByteLengthString(this.m_buffer, index + 4) : null;
            if (skipImage = skipImage ? name == null : "CImage".equals(name)) continue;
            blockReferences.add(new BlockReference(block, index));
            matchedPatternNames.add(block.getName());
            if ("CFormatCellInfo".equals(name)) break;
        }
        return blockReferences;
    }

    private void populateBlocks() {
        List<BlockReference> blockReferences = this.populateBlockReferences();
        int blockIndex = 0;
        int startIndex = 0;
        BlockReference startBlock = null;
        for (BlockReference block : blockReferences) {
            int endIndex = block.getIndex();
            int blockLength = endIndex - startIndex;
            this.readBlock(startBlock, blockIndex, startIndex, blockLength);
            startIndex = endIndex;
            startBlock = block;
            ++blockIndex;
        }
        int blockLength = this.m_buffer.length - startIndex;
        this.readBlock(startBlock, blockIndex, startIndex, blockLength);
    }

    private void readBlock(BlockReference blockReference, int blockIndex, int startIndex, int blockLength) {
        if (blockLength != 0) {
            int offset;
            String name;
            if (blockReference == null) {
                name = "First Block";
                offset = 0;
            } else if (blockReference.getPattern().getName() == null) {
                name = DatatypeConverter.getTwoByteLengthString(this.m_buffer, startIndex + 4);
                offset = 6 + (name == null ? 0 : name.length());
            } else {
                name = blockReference.getPattern().getName();
                offset = 2;
            }
            if (offset > blockLength) {
                this.logMessage("Skipping block " + name + " (blockLength=" + blockLength + " offset=" + offset + ")");
            } else {
                byte[] data = new byte[blockLength - offset];
                System.arraycopy(this.m_buffer, startIndex + offset, data, 0, data.length);
                Block block = new Block(name, data);
                this.addBlockToHierarchy(block);
                this.logBlock(name, blockIndex, startIndex, blockLength);
            }
        }
    }

    private void addBlockToHierarchy(Block block) {
        if (this.m_parentStack.isEmpty()) {
            this.m_blocks.add(block);
            this.addParentBlockToHierarchy(block);
        } else {
            Block parentBlock = this.m_parentStack.getFirst();
            Set<String> set = EXPECTED_CHILD_CLASSES.get(parentBlock.getName());
            if (set != null && set.contains(block.getName())) {
                parentBlock.getChildBlocks().add(block);
                this.addParentBlockToHierarchy(block);
            } else {
                this.m_parentStack.pop();
                this.addBlockToHierarchy(block);
            }
        }
    }

    private void addParentBlockToHierarchy(Block block) {
        if (EXPECTED_CHILD_CLASSES.containsKey(block.getName())) {
            this.m_parentStack.push(block);
        }
    }

    private BlockPattern matchPattern(List<BlockPattern> blocks, int bufferIndex) {
        BlockPattern match = null;
        for (BlockPattern block : blocks) {
            if (!this.matchPattern(block.getPattern(), bufferIndex)) continue;
            match = block;
            break;
        }
        return match;
    }

    private byte[] extractFingerprint(String name, boolean skipBlockStartString, int fingerprintLength) {
        byte[] fingerprint = null;
        byte[] namePattern = new byte[name.length() + 2];
        namePattern[0] = (byte)name.length();
        System.arraycopy(name.getBytes(), 0, namePattern, 2, name.length());
        int index = this.findFirstMatch(namePattern, 0);
        if (index == -1) {
            this.logMessage("Unable to extract fingerprint for " + name + ": no named block");
        } else {
            index += name.length() + 2;
            if (skipBlockStartString) {
                index += DatatypeConverter.getByte(this.m_buffer, index) + 1;
            }
            fingerprint = new byte[fingerprintLength];
            System.arraycopy(this.m_buffer, index, fingerprint, 0, fingerprintLength);
        }
        this.logMessage("Fingerprint for " + name + ": " + ByteArrayHelper.hexdump(fingerprint, false));
        return fingerprint;
    }

    private BlockPattern identifyPattern(String name, BlockPatternValidator validator, byte[] fingerprint) {
        BlockPattern result = null;
        byte[] namePattern = new byte[name.length() + 2];
        namePattern[0] = (byte)name.length();
        System.arraycopy(name.getBytes(), 0, namePattern, 2, name.length());
        int index = this.findFirstMatch(namePattern, 0);
        if (index == -1) {
            this.logMessage("No " + name + " named block");
        } else {
            result = this.identifyPattern(name, index += name.length() + 2 + 1, validator, fingerprint);
        }
        return result;
    }

    private BlockPattern identifyPattern(String name, int index, BlockPatternValidator validator, byte[] fingerprint) {
        BlockPattern result = null;
        if ((index = this.findFirstMatch(fingerprint, index)) == -1) {
            this.logMessage("No " + name + " fingerprint");
        } else if ((this.m_buffer[index - 1] & 0x80) == 0) {
            this.logMessage("Matched " + name + " fingerprint but found " + ByteArrayHelper.hexdump(this.m_buffer, index - 2, 2, false));
        } else {
            result = new BlockPattern(name, validator, this.m_buffer, index - 2);
        }
        return result;
    }

    private int findFirstMatch(byte[] pattern, int offset) {
        int result = -1;
        for (int bufferIndex = offset; bufferIndex < this.m_buffer.length - pattern.length; ++bufferIndex) {
            if (!this.matchPattern(pattern, bufferIndex)) continue;
            result = bufferIndex;
            break;
        }
        return result;
    }

    private boolean matchPattern(byte[] pattern, int bufferIndex) {
        boolean result = true;
        int index = 0;
        for (byte b : pattern) {
            if (b != this.m_buffer[bufferIndex + index]) {
                result = false;
                break;
            }
            ++index;
        }
        return result;
    }

    private void openLogFile() {
        this.m_log = DebugLogPrintWriter.getInstance();
    }

    private void closeLogFile() {
        if (this.m_log != null) {
            this.m_log.flush();
            this.m_log.close();
        }
    }

    private void logBlock(String name, int blockIndex, int startIndex, int blockLength) {
        if (this.m_log != null) {
            this.m_log.println("Block Index: " + blockIndex);
            this.m_log.println("Block Name: " + name);
            this.m_log.println("Length: " + blockLength + " (" + Integer.toHexString(blockLength) + ")");
            this.m_log.println();
            this.m_log.println(ByteArrayHelper.hexdump(this.m_buffer, startIndex, blockLength, true, 16, ""));
            this.m_log.flush();
        }
    }

    private void logPatterns(List<BlockPattern> blockPatterns) {
        if (this.m_log != null) {
            this.m_log.println();
            this.m_log.println("Patterns:");
            blockPatterns.forEach(pattern -> this.m_log.println(pattern));
            this.m_log.println();
        }
    }

    private void logMessage(String message) {
        if (this.m_log != null) {
            this.m_log.println(message);
        }
    }

    static {
        EXPECTED_CHILD_CLASSES.put("CCalendar", new HashSet<String>(Collections.singletonList("CDayFlag")));
        EXPECTED_CHILD_CLASSES.put("CResource", new HashSet<String>(Arrays.asList("CSymbol", "CResourceTask", "CBaselineData", "CBar", "CCalendar")));
        EXPECTED_CHILD_CLASSES.put("CTask", new HashSet<String>(Arrays.asList("CPlanObject", "CCalendar", "CBaselineIndex", "CBaselineData", "CBar", "CUsageTask", "CLink")));
        EXPECTED_CHILD_CLASSES.put("CUsageTask", new HashSet<String>(Collections.singletonList("CBaselineData")));
    }
}

