/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.primavera;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class StructuredTextRecord {
    private final Map<String, String> m_attributes;
    private final List<StructuredTextRecord> m_children;
    private final Map<String, StructuredTextRecord> m_childrenByName;
    public static final String RECORD_NUMBER_ATTRIBUTE = "_record_number";
    public static final String RECORD_NAME_ATTRIBUTE = "_record_name";
    public static final StructuredTextRecord EMPTY = new StructuredTextRecord(Collections.emptyMap(), Collections.emptyList());

    public StructuredTextRecord(Map<String, String> attributes, List<StructuredTextRecord> children) {
        this.m_attributes = attributes;
        this.m_children = children;
        this.m_childrenByName = this.m_children.stream().filter(r -> r.getRecordName() != null).collect(Collectors.toMap(StructuredTextRecord::getRecordName, r -> r, (r1, r2) -> r1));
    }

    public String getRecordName() {
        return this.m_attributes.get(RECORD_NAME_ATTRIBUTE);
    }

    public String getRecordNumber() {
        return this.m_attributes.get(RECORD_NUMBER_ATTRIBUTE);
    }

    public String getAttribute(String name) {
        return this.m_attributes.get(name);
    }

    public Map<String, String> getAttributes() {
        return this.m_attributes;
    }

    public List<StructuredTextRecord> getChildren() {
        return this.m_children;
    }

    public StructuredTextRecord getChild(String name) {
        return this.m_childrenByName.get(name);
    }
}

