/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpd;

import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.Cursor;
import com.healthmarketscience.jackcess.CursorBuilder;
import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.DatabaseBuilder;
import com.healthmarketscience.jackcess.Table;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.sf.mpxj.mpd.JackcessResultSetRow;
import net.sf.mpxj.mpd.MPD9AbstractReader;
import net.sf.mpxj.mpd.MpdException;
import net.sf.mpxj.mpd.Row;

final class MPD9FileReader
extends MPD9AbstractReader {
    private File m_databaseFile;
    private Database m_database;

    MPD9FileReader() {
    }

    public void setDatabaseFile(File file) {
        this.m_databaseFile = file;
    }

    @Override
    protected List<Row> getRows(String tableName, Map<String, Integer> keys) throws MpdException {
        try {
            this.openDatabase();
            ArrayList<Row> result = new ArrayList<Row>();
            Table table = this.m_database.getTable(tableName);
            List<? extends Column> columns = table.getColumns();
            Cursor cursor = CursorBuilder.createCursor(table);
            if (cursor.findFirstRow(keys)) {
                result.add(new JackcessResultSetRow(cursor.getCurrentRow(), columns));
                while (cursor.findNextRow(keys)) {
                    result.add(new JackcessResultSetRow(cursor.getCurrentRow(), columns));
                }
            }
            return result;
        }
        catch (IOException ex) {
            throw new MpdException(ex);
        }
    }

    @Override
    protected void releaseResources() {
        this.closeDatabase();
    }

    private void openDatabase() throws IOException {
        if (this.m_database == null) {
            this.m_database = DatabaseBuilder.open(this.m_databaseFile);
            this.queryDatabaseMetaData();
        }
    }

    private void closeDatabase() {
        try {
            if (this.m_database != null) {
                this.m_database.close();
                this.m_database = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void queryDatabaseMetaData() {
        try {
            HashSet<String> tables = new HashSet<String>(this.m_database.getTableNames());
            this.m_hasResourceBaselines = tables.contains("MSP_RESOURCE_BASELINES");
            this.m_hasTaskBaselines = tables.contains("MSP_TASK_BASELINES");
            this.m_hasAssignmentBaselines = tables.contains("MSP_ASSIGNMENT_BASELINES");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

