/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.mpxj.AccrueType;
import net.sf.mpxj.AssignmentField;
import net.sf.mpxj.ConstraintType;
import net.sf.mpxj.CostRateTable;
import net.sf.mpxj.CostRateTableEntry;
import net.sf.mpxj.DataType;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.Duration;
import net.sf.mpxj.EventManager;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.Priority;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectConfig;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.Rate;
import net.sf.mpxj.Relation;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.ResourceField;
import net.sf.mpxj.ResourceType;
import net.sf.mpxj.RtfNotes;
import net.sf.mpxj.ScheduleFrom;
import net.sf.mpxj.SubProject;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.TaskType;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.WorkContour;
import net.sf.mpxj.WorkGroup;
import net.sf.mpxj.common.DateHelper;
import net.sf.mpxj.common.MPPAssignmentField;
import net.sf.mpxj.common.MPPResourceField;
import net.sf.mpxj.common.MPPTaskField;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.common.Pair;
import net.sf.mpxj.common.RateHelper;
import net.sf.mpxj.listener.ProjectListener;
import net.sf.mpxj.mpd.MPDUtility;
import net.sf.mpxj.mpd.MpdException;
import net.sf.mpxj.mpd.Row;

abstract class MPD9AbstractReader {
    private Integer m_projectID;
    private Map<String, Integer> m_projectKey;
    private ProjectFile m_project;
    private EventManager m_eventManager;
    private String m_defaultCalendarName;
    private boolean m_autoWBS = true;
    protected boolean m_hasResourceBaselines;
    protected boolean m_hasTaskBaselines;
    protected boolean m_hasAssignmentBaselines;
    private List<ProjectListener> m_projectListeners;
    private final Map<Integer, ProjectCalendar> m_calendarMap = new HashMap<Integer, ProjectCalendar>();
    private final List<Pair<ProjectCalendar, Integer>> m_baseCalendarReferences = new ArrayList<Pair<ProjectCalendar, Integer>>();
    private final Map<Integer, ResourceAssignment> m_assignmentMap = new HashMap<Integer, ResourceAssignment>();

    MPD9AbstractReader() {
    }

    public void addProjectListener(ProjectListener listener) {
        if (this.m_projectListeners == null) {
            this.m_projectListeners = new ArrayList<ProjectListener>();
        }
        this.m_projectListeners.add(listener);
    }

    public Map<Integer, String> listProjects() throws MPXJException {
        try {
            HashMap<Integer, String> result = new HashMap<Integer, String>();
            List<Row> rows = this.getRows("MSP_PROJECTS", Collections.emptyMap());
            for (Row row : rows) {
                this.processProjectListItem(result, row);
            }
            HashMap<Integer, String> hashMap = result;
            return hashMap;
        }
        catch (MpdException ex) {
            throw new MPXJException("Error reading file", ex);
        }
        finally {
            this.releaseResources();
        }
    }

    public ProjectFile read() throws MPXJException {
        try {
            this.m_project = new ProjectFile();
            this.m_eventManager = this.m_project.getEventManager();
            ProjectConfig config = this.m_project.getProjectConfig();
            config.setAutoTaskID(false);
            config.setAutoTaskUniqueID(false);
            config.setAutoResourceID(false);
            config.setAutoResourceUniqueID(false);
            config.setAutoOutlineLevel(false);
            config.setAutoOutlineNumber(false);
            config.setAutoWBS(false);
            config.setAutoCalendarUniqueID(false);
            config.setAutoAssignmentUniqueID(false);
            this.m_project.getProjectProperties().setFileApplication("Microsoft");
            this.m_project.getProjectProperties().setFileType("MPD");
            this.m_project.getEventManager().addProjectListeners(this.m_projectListeners);
            this.processProjectProperties();
            this.processCalendars();
            this.processResources();
            this.processResourceBaselines();
            this.processTasks();
            this.processTaskBaselines();
            this.processLinks();
            this.processAssignments();
            this.processAssignmentBaselines();
            this.processExtendedAttributes();
            this.processSubProjects();
            this.postProcessing();
            ProjectFile projectFile = this.m_project;
            return projectFile;
        }
        catch (MpdException ex) {
            throw new MPXJException("Error reading file", ex);
        }
        finally {
            this.reset();
            this.releaseResources();
        }
    }

    private void processProjectProperties() throws MpdException {
        List<Row> rows = this.getRows("MSP_PROJECTS", this.m_projectKey);
        if (!rows.isEmpty()) {
            this.processProjectProperties(rows.get(0));
        }
    }

    private void processCalendars() throws MpdException {
        for (Row row : this.getRows("MSP_CALENDARS", this.m_projectKey)) {
            this.processCalendar(row);
        }
        this.updateBaseCalendarNames();
        this.processCalendarData(this.m_project.getCalendars());
        this.m_project.getProjectProperties().setDefaultCalendar(this.m_project.getCalendars().getByName(this.m_defaultCalendarName));
    }

    private void processCalendarData(List<ProjectCalendar> calendars) throws MpdException {
        HashMap<String, Integer> keys = new HashMap<String, Integer>();
        keys.put("PROJ_ID", this.m_projectID);
        for (ProjectCalendar calendar : calendars) {
            keys.put("CAL_UID", calendar.getUniqueID());
            this.processCalendarData(calendar, this.getRows("MSP_CALENDAR_DATA", keys));
        }
    }

    private void processCalendarData(ProjectCalendar calendar, List<Row> calendarData) {
        for (Row row : calendarData) {
            this.processCalendarData(calendar, row);
        }
    }

    private void processResources() throws MpdException {
        for (Row row : this.getRows("MSP_RESOURCES", this.m_projectKey)) {
            this.processResource(row);
        }
    }

    private void processResourceBaselines() throws MpdException {
        if (this.m_hasResourceBaselines) {
            for (Row row : this.getRows("MSP_RESOURCE_BASELINES", this.m_projectKey)) {
                this.processResourceBaseline(row);
            }
        }
    }

    private void processTasks() throws MpdException {
        for (Row row : this.getRows("MSP_TASKS", this.m_projectKey)) {
            this.processTask(row);
        }
    }

    private void processTaskBaselines() throws MpdException {
        if (this.m_hasTaskBaselines) {
            for (Row row : this.getRows("MSP_TASK_BASELINES", this.m_projectKey)) {
                this.processTaskBaseline(row);
            }
        }
    }

    private void processLinks() throws MpdException {
        for (Row row : this.getRows("MSP_LINKS", this.m_projectKey)) {
            this.processLink(row);
        }
    }

    private void processAssignments() throws MpdException {
        for (Row row : this.getRows("MSP_ASSIGNMENTS", this.m_projectKey)) {
            this.processAssignment(row);
        }
    }

    private void processAssignmentBaselines() throws MpdException {
        if (this.m_hasAssignmentBaselines) {
            for (Row row : this.getRows("MSP_ASSIGNMENT_BASELINES", this.m_projectKey)) {
                this.processAssignmentBaseline(row);
            }
        }
    }

    private void processExtendedAttributes() throws MpdException {
        this.processTextFields();
        this.processNumberFields();
        this.processFlagFields();
        this.processDurationFields();
        this.processDateFields();
        this.processOutlineCodeFields();
    }

    private void processSubProjects() {
        int subprojectIndex = 1;
        for (Task task : this.m_project.getTasks()) {
            String subProjectFileName = task.getSubprojectName();
            if (subProjectFileName == null) continue;
            String fileName = subProjectFileName;
            int offset = 0x1000000 + subprojectIndex * 0x400000;
            int index = subProjectFileName.lastIndexOf(92);
            if (index != -1) {
                fileName = subProjectFileName.substring(index + 1);
            }
            SubProject sp = new SubProject();
            sp.setFileName(fileName);
            sp.setFullPath(subProjectFileName);
            sp.setUniqueIDOffset(offset);
            sp.setTaskUniqueID(task.getUniqueID());
            task.setSubProject(sp);
            ++subprojectIndex;
        }
    }

    private void processTextFields() throws MpdException {
        for (Row row : this.getRows("MSP_TEXT_FIELDS", this.m_projectKey)) {
            this.processTextField(row);
        }
    }

    private void processNumberFields() throws MpdException {
        for (Row row : this.getRows("MSP_NUMBER_FIELDS", this.m_projectKey)) {
            this.processNumberField(row);
        }
    }

    private void processFlagFields() throws MpdException {
        for (Row row : this.getRows("MSP_FLAG_FIELDS", this.m_projectKey)) {
            this.processFlagField(row);
        }
    }

    private void processDurationFields() throws MpdException {
        for (Row row : this.getRows("MSP_DURATION_FIELDS", this.m_projectKey)) {
            this.processDurationField(row);
        }
    }

    private void processDateFields() throws MpdException {
        for (Row row : this.getRows("MSP_DATE_FIELDS", this.m_projectKey)) {
            this.processDateField(row);
        }
    }

    private void processOutlineCodeFields() throws MpdException {
        for (Row row : this.getRows("MSP_CODE_FIELDS", this.m_projectKey)) {
            this.processOutlineCodeFields(row);
        }
    }

    private void processOutlineCodeFields(Row parentRow) throws MpdException {
        Integer entityID = parentRow.getInteger("CODE_REF_UID");
        Integer outlineCodeEntityID = parentRow.getInteger("CODE_UID");
        for (Row row : this.getRows("MSP_OUTLINE_CODES", Collections.singletonMap("CODE_UID", outlineCodeEntityID))) {
            this.processOutlineCodeField(entityID, row);
        }
    }

    private void reset() {
        this.m_calendarMap.clear();
        this.m_baseCalendarReferences.clear();
        this.m_assignmentMap.clear();
    }

    private void processProjectListItem(Map<Integer, String> result, Row row) {
        Integer id = row.getInteger("PROJ_ID");
        String name = row.getString("PROJ_NAME");
        result.put(id, name);
    }

    private void processProjectProperties(Row row) {
        ProjectProperties properties = this.m_project.getProjectProperties();
        properties.setCurrencySymbol(row.getString("PROJ_OPT_CURRENCY_SYMBOL"));
        properties.setSymbolPosition(MPDUtility.getSymbolPosition(row.getInt("PROJ_OPT_CURRENCY_POSITION")));
        properties.setCurrencyDigits(row.getInteger("PROJ_OPT_CURRENCY_DIGITS"));
        properties.setDefaultDurationUnits(MPDUtility.getDurationTimeUnits(row.getInt("PROJ_OPT_DUR_ENTRY_FMT")));
        properties.setDefaultWorkUnits(MPDUtility.getDurationTimeUnits(row.getInt("PROJ_OPT_WORK_ENTRY_FMT")));
        properties.setMinutesPerDay(row.getInteger("PROJ_OPT_MINUTES_PER_DAY"));
        properties.setMinutesPerWeek(row.getInteger("PROJ_OPT_MINUTES_PER_WEEK"));
        properties.setDefaultStandardRate(new Rate(row.getDouble("PROJ_OPT_DEF_STD_RATE"), TimeUnit.HOURS));
        properties.setDefaultOvertimeRate(new Rate(row.getDouble("PROJ_OPT_DEF_OVT_RATE"), TimeUnit.HOURS));
        properties.setUpdatingTaskStatusUpdatesResourceStatus(row.getBoolean("PROJ_OPT_TASK_UPDATES_RES"));
        properties.setSplitInProgressTasks(row.getBoolean("PROJ_OPT_SPLIT_IN_PROGRESS"));
        properties.setDefaultStartTime(row.getDate("PROJ_OPT_DEF_START_TIME"));
        properties.setProjectTitle(row.getString("PROJ_PROP_TITLE"));
        properties.setCompany(row.getString("PROJ_PROP_COMPANY"));
        properties.setManager(row.getString("PROJ_PROP_MANAGER"));
        properties.setStartDate(row.getDate("PROJ_INFO_START_DATE"));
        properties.setFinishDate(row.getDate("PROJ_INFO_FINISH_DATE"));
        properties.setScheduleFrom(ScheduleFrom.getInstance(1 - row.getInt("PROJ_INFO_SCHED_FROM")));
        properties.setCurrentDate(row.getDate("PROJ_INFO_CURRENT_DATE"));
        properties.setSubject(row.getString("PROJ_PROP_SUBJECT"));
        properties.setAuthor(row.getString("PROJ_PROP_AUTHOR"));
        properties.setKeywords(row.getString("PROJ_PROP_KEYWORDS"));
        properties.setDefaultEndTime(row.getDate("PROJ_OPT_DEF_FINISH_TIME"));
        properties.setProjectExternallyEdited(row.getBoolean("PROJ_EXT_EDITED_FLAG"));
        properties.setCategory(row.getString("PROJ_PROP_CATEGORY"));
        properties.setDaysPerMonth(row.getInteger("PROJ_OPT_DAYS_PER_MONTH"));
        properties.setFiscalYearStart(row.getBoolean("PROJ_OPT_FY_USE_START_YR"));
        properties.setNewTasksEstimated(row.getBoolean("PROJ_OPT_NEW_TASK_EST"));
        properties.setSpreadActualCost(row.getBoolean("PROJ_OPT_SPREAD_ACT_COSTS"));
        properties.setMultipleCriticalPaths(row.getBoolean("PROJ_OPT_MULT_CRITICAL_PATHS"));
        properties.setLastSaved(row.getDate("PROJ_LAST_SAVED"));
        properties.setStatusDate(row.getDate("PROJ_INFO_STATUS_DATE"));
        properties.setHonorConstraints(row.getBoolean("PROJ_OPT_HONOR_CONSTRAINTS"));
        properties.setName(row.getString("PROJ_NAME"));
        properties.setSpreadPercentComplete(row.getBoolean("PROJ_OPT_SPREAD_PCT_COMP"));
        properties.setNewTasksEffortDriven(row.getBoolean("PROJ_OPT_NEW_ARE_EFFORT_DRIVEN"));
        properties.setDefaultTaskType(TaskType.getInstance(row.getInt("PROJ_OPT_DEF_TASK_TYPE")));
        properties.setCreationDate(row.getDate("PROJ_CREATION_DATE"));
        properties.setDefaultFixedCostAccrual(AccrueType.getInstance(row.getInt("PROJ_OPT_DEF_FIX_COST_ACCRUAL")));
        properties.setCriticalSlackLimit(row.getInteger("PROJ_OPT_CRITICAL_SLACK_LIMIT"));
        properties.setFiscalYearStartMonth(row.getInteger("PROJ_OPT_FY_START_MONTH"));
        properties.setWeekStartDay(Day.getInstance(row.getInt("PROJ_OPT_WEEK_START_DAY") + 1));
        this.m_defaultCalendarName = row.getString("PROJ_INFO_CAL_NAME");
    }

    private void processCalendar(Row row) {
        Integer uniqueID = row.getInteger("CAL_UID");
        if (NumberHelper.getInt(uniqueID) > 0) {
            boolean baseCalendar = row.getBoolean("CAL_IS_BASE_CAL");
            ProjectCalendar cal = this.m_project.addCalendar();
            cal.setUniqueID(uniqueID);
            this.m_calendarMap.put(uniqueID, cal);
            if (baseCalendar) {
                cal.setName(row.getString("CAL_NAME"));
            } else {
                this.m_baseCalendarReferences.add(new Pair<ProjectCalendar, Integer>(cal, row.getInteger("CAL_BASE_UID")));
            }
            this.m_eventManager.fireCalendarReadEvent(cal);
        }
    }

    private void processCalendarData(ProjectCalendar calendar, Row row) {
        int dayIndex = row.getInt("CD_DAY_OR_EXCEPTION");
        if (dayIndex == 0) {
            this.processCalendarException(calendar, row);
        } else {
            this.processCalendarHours(calendar, row, dayIndex);
        }
    }

    private void processCalendarException(ProjectCalendar calendar, Row row) {
        Date fromDate = row.getDate("CD_FROM_DATE");
        Date toDate = row.getDate("CD_TO_DATE");
        boolean working = row.getInt("CD_WORKING") != 0;
        ProjectCalendarException exception = calendar.addCalendarException(fromDate, toDate);
        if (working) {
            exception.add(new DateRange(row.getDate("CD_FROM_TIME1"), row.getDate("CD_TO_TIME1")));
            exception.add(new DateRange(row.getDate("CD_FROM_TIME2"), row.getDate("CD_TO_TIME2")));
            exception.add(new DateRange(row.getDate("CD_FROM_TIME3"), row.getDate("CD_TO_TIME3")));
            exception.add(new DateRange(row.getDate("CD_FROM_TIME4"), row.getDate("CD_TO_TIME4")));
            exception.add(new DateRange(row.getDate("CD_FROM_TIME5"), row.getDate("CD_TO_TIME5")));
        }
    }

    private void processCalendarHours(ProjectCalendar calendar, Row row, int dayIndex) {
        Day day = Day.getInstance(dayIndex);
        boolean working = row.getInt("CD_WORKING") != 0;
        calendar.setWorkingDay(day, working);
        if (working) {
            ProjectCalendarHours hours = calendar.addCalendarHours(day);
            Date start = row.getDate("CD_FROM_TIME1");
            Date end = row.getDate("CD_TO_TIME1");
            if (start != null && end != null) {
                hours.add(new DateRange(start, end));
            }
            start = row.getDate("CD_FROM_TIME2");
            end = row.getDate("CD_TO_TIME2");
            if (start != null && end != null) {
                hours.add(new DateRange(start, end));
            }
            start = row.getDate("CD_FROM_TIME3");
            end = row.getDate("CD_TO_TIME3");
            if (start != null && end != null) {
                hours.add(new DateRange(start, end));
            }
            start = row.getDate("CD_FROM_TIME4");
            end = row.getDate("CD_TO_TIME4");
            if (start != null && end != null) {
                hours.add(new DateRange(start, end));
            }
            start = row.getDate("CD_FROM_TIME5");
            end = row.getDate("CD_TO_TIME5");
            if (start != null && end != null) {
                hours.add(new DateRange(start, end));
            }
        }
    }

    private void updateBaseCalendarNames() {
        for (Pair<ProjectCalendar, Integer> pair : this.m_baseCalendarReferences) {
            ProjectCalendar cal = pair.getFirst();
            Integer baseCalendarID = pair.getSecond();
            ProjectCalendar baseCal = this.m_calendarMap.get(baseCalendarID);
            if (baseCal == null) continue;
            cal.setParent(baseCal);
        }
    }

    private void processResource(Row row) {
        Integer uniqueID = row.getInteger("RES_UID");
        if (uniqueID != null && uniqueID >= 0) {
            ProjectCalendar calendar;
            Resource resource = this.m_project.addResource();
            resource.setAccrueAt(AccrueType.getInstance(row.getInt("RES_ACCRUE_AT")));
            resource.setActualCost(this.getDefaultOnNull(row.getCurrency("RES_ACT_COST"), NumberHelper.DOUBLE_ZERO));
            resource.setActualOvertimeCost(row.getCurrency("RES_ACT_OVT_COST"));
            resource.setActualOvertimeWork(row.getDuration("RES_ACT_OVT_WORK"));
            resource.setActualWork(row.getDuration("RES_ACT_WORK"));
            resource.setACWP(row.getCurrency("RES_ACWP"));
            resource.setAvailableFrom(row.getDate("RES_AVAIL_FROM"));
            resource.setAvailableTo(row.getDate("RES_AVAIL_TO"));
            resource.setBaselineCost(this.getDefaultOnNull(row.getCurrency("RES_BASE_COST"), NumberHelper.DOUBLE_ZERO));
            resource.setBaselineWork(row.getDuration("RES_BASE_WORK"));
            resource.setBCWP(row.getCurrency("RES_BCWP"));
            resource.setBCWS(row.getCurrency("RES_BCWS"));
            resource.setCanLevel(row.getBoolean("RES_CAN_LEVEL"));
            resource.setCost(this.getDefaultOnNull(row.getCurrency("RES_COST"), NumberHelper.DOUBLE_ZERO));
            resource.setID(row.getInteger("RES_ID"));
            resource.setInitials(row.getString("RES_INITIALS"));
            resource.setMaterialLabel(row.getString("RES_MATERIAL_LABEL"));
            resource.setMaxUnits(NumberHelper.getDouble(row.getDouble("RES_MAX_UNITS")) * 100.0);
            resource.setName(row.getString("RES_NAME"));
            resource.setObjects(this.getNullOnValue(row.getInteger("RES_NUM_OBJECTS"), 0));
            resource.setOverAllocated(row.getBoolean("RES_IS_OVERALLOCATED"));
            resource.setOvertimeCost(row.getCurrency("RES_OVT_COST"));
            resource.setOvertimeWork(row.getDuration("RES_OVT_WORK"));
            resource.setPeakUnits(NumberHelper.getDouble(row.getDouble("RES_PEAK")) * 100.0);
            resource.setPhonetics(row.getString("RES_PHONETICS"));
            resource.setRegularWork(row.getDuration("RES_REG_WORK"));
            resource.setRemainingCost(this.getDefaultOnNull(row.getCurrency("RES_REM_COST"), NumberHelper.DOUBLE_ZERO));
            resource.setRemainingOvertimeCost(row.getCurrency("RES_REM_OVT_COST"));
            resource.setRemainingOvertimeWork(row.getDuration("RES_REM_OVT_WORK"));
            resource.setRemainingWork(row.getDuration("RES_REM_WORK"));
            resource.setType(row.getBoolean("RES_TYPE") ? ResourceType.WORK : ResourceType.MATERIAL);
            resource.setUniqueID(uniqueID);
            resource.setWork(row.getDuration("RES_WORK"));
            resource.setWorkGroup(WorkGroup.getInstance(row.getInt("RES_WORKGROUP_MESSAGING")));
            String notes = row.getString("RES_RTF_NOTES");
            if (notes != null) {
                resource.setNotesObject(new RtfNotes(notes));
            }
            if ((calendar = this.m_project.getCalendarByUniqueID(row.getInteger("RES_CAL_UID"))) != null && (calendar.getName() == null || calendar.getName().isEmpty())) {
                String name = resource.getName();
                if (name == null || name.isEmpty()) {
                    name = "Unnamed Resource";
                }
                calendar.setName(name);
            }
            resource.setCalendar(calendar);
            if (resource.getCost() != null && resource.getBaselineCost() != null) {
                resource.setCostVariance(NumberHelper.getDouble(resource.getCost().doubleValue() - resource.getBaselineCost().doubleValue()));
            }
            if (resource.getWork() != null && resource.getBaselineWork() != null) {
                resource.setWorkVariance(Duration.getInstance(resource.getWork().getDuration() - resource.getBaselineWork().getDuration(), TimeUnit.HOURS));
            }
            resource.setOverAllocated(NumberHelper.getDouble(resource.getPeakUnits()) > NumberHelper.getDouble(resource.getMaxUnits()));
            Double costPerUse = row.getCurrency("RES_COST_PER_USE");
            Rate standardRate = RateHelper.convertFromHours(this.m_project, NumberHelper.getDouble(row.getDouble("RES_STD_RATE")), TimeUnit.getInstance(row.getInt("RES_STD_RATE_FMT") - 1));
            Rate overtimeRate = RateHelper.convertFromHours(this.m_project, NumberHelper.getDouble(row.getDouble("RES_OVT_RATE")), TimeUnit.getInstance(row.getInt("RES_OVT_RATE_FMT") - 1));
            CostRateTable costRateTable = new CostRateTable();
            costRateTable.add(new CostRateTableEntry(DateHelper.START_DATE_NA, DateHelper.END_DATE_NA, costPerUse, standardRate, overtimeRate));
            resource.setCostRateTable(0, costRateTable);
            this.m_eventManager.fireResourceReadEvent(resource);
        }
    }

    private void processResourceBaseline(Row row) {
        Integer id = row.getInteger("RES_UID");
        Resource resource = this.m_project.getResourceByUniqueID(id);
        if (resource != null) {
            int index = row.getInt("RB_BASE_NUM");
            resource.setBaselineWork(index, row.getDuration("RB_BASE_WORK"));
            resource.setBaselineCost(index, row.getCurrency("RB_BASE_COST"));
        }
    }

    private void processTextField(Row row) {
        this.processField(row, "TEXT_FIELD_ID", "TEXT_REF_UID", (Object)row.getString("TEXT_VALUE"));
    }

    private void processNumberField(Row row) {
        this.processField(row, "NUM_FIELD_ID", "NUM_REF_UID", (Object)row.getDouble("NUM_VALUE"));
    }

    private void processFlagField(Row row) {
        this.processField(row, "FLAG_FIELD_ID", "FLAG_REF_UID", (Object)row.getBoolean("FLAG_VALUE"));
    }

    private void processDurationField(Row row) {
        this.processField(row, "DUR_FIELD_ID", "DUR_REF_UID", (Object)MPDUtility.getAdjustedDuration(this.m_project, row.getInt("DUR_VALUE"), MPDUtility.getDurationTimeUnits(row.getInt("DUR_FMT"))));
    }

    private void processDateField(Row row) {
        this.processField(row, "DATE_FIELD_ID", "DATE_REF_UID", (Object)row.getDate("DATE_VALUE"));
    }

    private void processOutlineCodeField(Integer entityID, Row row) {
        this.processField(row, "OC_FIELD_ID", entityID, (Object)row.getString("OC_NAME"));
    }

    private void processField(Row row, String fieldIDColumn, String entityIDColumn, Object value) {
        this.processField(row, fieldIDColumn, row.getInteger(entityIDColumn), value);
    }

    private void processField(Row row, String fieldIDColumn, Integer entityID, Object value) {
        int fieldID = row.getInt(fieldIDColumn);
        int prefix = fieldID & 0xFFFF0000;
        int index = fieldID & 0xFFFF;
        switch (prefix) {
            case 0xB400000: {
                Task task;
                TaskField field = MPPTaskField.getInstance(index);
                if (field == null || field == TaskField.NOTES || (task = this.m_project.getTaskByUniqueID(entityID)) == null) break;
                if (field.getDataType() == DataType.CURRENCY) {
                    value = (Double)value / 100.0;
                }
                task.set((FieldType)field, value);
                break;
            }
            case 0xC400000: {
                Resource resource;
                ResourceField field = MPPResourceField.getInstance(index);
                if (field == null || field == ResourceField.NOTES || (resource = this.m_project.getResourceByUniqueID(entityID)) == null) break;
                if (field.getDataType() == DataType.CURRENCY) {
                    value = (Double)value / 100.0;
                }
                resource.set((FieldType)field, value);
                break;
            }
            case 0xF400000: {
                ResourceAssignment assignment;
                AssignmentField field = MPPAssignmentField.getInstance(index);
                if (field == null || field == AssignmentField.NOTES || (assignment = this.m_assignmentMap.get(entityID)) == null) break;
                if (field.getDataType() == DataType.CURRENCY) {
                    value = (Double)value / 100.0;
                }
                assignment.set((FieldType)field, value);
                break;
            }
        }
    }

    private void processTask(Row row) {
        Integer uniqueID = row.getInteger("TASK_UID");
        if (uniqueID != null && uniqueID >= 0) {
            Task task = this.m_project.addTask();
            TimeUnit durationFormat = MPDUtility.getDurationTimeUnits(row.getInt("TASK_DUR_FMT"));
            task.setActualCost(row.getCurrency("TASK_ACT_COST"));
            task.setActualDuration(MPDUtility.getAdjustedDuration(this.m_project, row.getInt("TASK_ACT_DUR"), durationFormat));
            task.setActualFinish(row.getDate("TASK_ACT_FINISH"));
            task.setActualOvertimeCost(row.getCurrency("TASK_ACT_OVT_COST"));
            task.setActualOvertimeWork(row.getDuration("TASK_ACT_OVT_WORK"));
            task.setActualStart(row.getDate("TASK_ACT_START"));
            task.setActualWork(row.getDuration("TASK_ACT_WORK"));
            task.setACWP(row.getCurrency("TASK_ACWP"));
            task.setBaselineCost(row.getCurrency("TASK_BASE_COST"));
            task.setBaselineDuration(MPDUtility.getAdjustedDuration(this.m_project, row.getInt("TASK_BASE_DUR"), durationFormat));
            task.setBaselineFinish(row.getDate("TASK_BASE_FINISH"));
            task.setBaselineStart(row.getDate("TASK_BASE_START"));
            task.setBaselineWork(row.getDuration("TASK_BASE_WORK"));
            task.setCalendar(this.m_project.getCalendarByUniqueID(row.getInteger("TASK_CAL_UID")));
            task.setConstraintDate(row.getDate("TASK_CONSTRAINT_DATE"));
            task.setConstraintType(ConstraintType.getInstance(row.getInt("TASK_CONSTRAINT_TYPE")));
            task.setCost(row.getCurrency("TASK_COST"));
            task.setCreateDate(row.getDate("TASK_CREATION_DATE"));
            task.setDeadline(row.getDate("TASK_DEADLINE"));
            task.setDuration(MPDUtility.getAdjustedDuration(this.m_project, row.getInt("TASK_DUR"), durationFormat));
            task.setDurationVariance(MPDUtility.getAdjustedDuration(this.m_project, row.getInt("TASK_DUR_VAR"), durationFormat));
            task.setEarlyFinish(row.getDate("TASK_EARLY_FINISH"));
            task.setEarlyStart(row.getDate("TASK_EARLY_START"));
            task.setEffortDriven(row.getBoolean("TASK_IS_EFFORT_DRIVEN"));
            task.setEstimated(row.getBoolean("TASK_DUR_IS_EST"));
            task.setExpanded(!row.getBoolean("TASK_IS_COLLAPSED"));
            task.setExternalTask(row.getBoolean("TASK_IS_EXTERNAL"));
            task.setFinish(row.getDate("TASK_FINISH_DATE"));
            task.setFixedCost(row.getCurrency("TASK_FIXED_COST"));
            task.setFixedCostAccrual(AccrueType.getInstance(row.getInt("TASK_FIXED_COST_ACCRUAL")));
            task.setFreeSlack(row.getDuration("TASK_FREE_SLACK").convertUnits(durationFormat, this.m_project.getProjectProperties()));
            task.setHideBar(row.getBoolean("TASK_BAR_IS_HIDDEN"));
            task.setID(row.getInteger("TASK_ID"));
            task.setIgnoreResourceCalendar(row.getBoolean("TASK_IGNORES_RES_CAL"));
            task.setLateFinish(row.getDate("TASK_LATE_FINISH"));
            task.setLateStart(row.getDate("TASK_LATE_START"));
            task.setLevelAssignments(row.getBoolean("TASK_LEVELING_ADJUSTS_ASSN"));
            task.setLevelingCanSplit(row.getBoolean("TASK_LEVELING_CAN_SPLIT"));
            task.setLevelingDelayFormat(MPDUtility.getDurationTimeUnits(row.getInt("TASK_LEVELING_DELAY_FMT")));
            task.setLevelingDelay(MPDUtility.getAdjustedDuration(this.m_project, row.getInt("TASK_LEVELING_DELAY"), task.getLevelingDelayFormat()));
            task.setMarked(row.getBoolean("TASK_IS_MARKED"));
            task.setMilestone(row.getBoolean("TASK_IS_MILESTONE"));
            task.setName(row.getString("TASK_NAME"));
            task.setObjects(this.getNullOnValue(row.getInteger("TASK_NUM_OBJECTS"), 0));
            task.setOutlineLevel(row.getInteger("TASK_OUTLINE_LEVEL"));
            task.setOutlineNumber(row.getString("TASK_OUTLINE_NUM"));
            task.setOverAllocated(row.getBoolean("TASK_IS_OVERALLOCATED"));
            task.setOvertimeCost(row.getCurrency("TASK_OVT_COST"));
            task.setPercentageComplete(row.getDouble("TASK_PCT_COMP"));
            task.setPercentageWorkComplete(row.getDouble("TASK_PCT_WORK_COMP"));
            task.setPreleveledFinish(row.getDate("TASK_PRELEVELED_FINISH"));
            task.setPreleveledStart(row.getDate("TASK_PRELEVELED_START"));
            task.setPriority(Priority.getInstance(row.getInt("TASK_PRIORITY")));
            task.setRecurring(row.getBoolean("TASK_IS_RECURRING"));
            task.setRegularWork(row.getDuration("TASK_REG_WORK"));
            task.setRemainingCost(row.getCurrency("TASK_REM_COST"));
            task.setRemainingDuration(MPDUtility.getAdjustedDuration(this.m_project, row.getInt("TASK_REM_DUR"), durationFormat));
            task.setRemainingOvertimeCost(row.getCurrency("TASK_REM_OVT_COST"));
            task.setRemainingOvertimeWork(row.getDuration("TASK_REM_OVT_WORK"));
            task.setRemainingWork(row.getDuration("TASK_REM_WORK"));
            task.setResume(row.getDate("TASK_RESUME_DATE"));
            task.setRollup(row.getBoolean("TASK_IS_ROLLED_UP"));
            task.setStart(row.getDate("TASK_START_DATE"));
            task.setStop(row.getDate("TASK_STOP_DATE"));
            task.setSummary(row.getBoolean("TASK_IS_SUMMARY"));
            task.setType(TaskType.getInstance(row.getInt("TASK_TYPE")));
            task.setUniqueID(uniqueID);
            task.setWBS(row.getString("TASK_WBS"));
            task.setWork(row.getDuration("TASK_WORK"));
            String notes = row.getString("TASK_RTF_NOTES");
            if (notes != null) {
                task.setNotesObject(new RtfNotes(notes));
            }
            if (task.getCost() != null && task.getBaselineCost() != null) {
                task.setCostVariance(NumberHelper.getDouble(task.getCost().doubleValue() - task.getBaselineCost().doubleValue()));
            }
            task.setFlag(1, false);
            task.setFlag(2, false);
            task.setFlag(3, false);
            task.setFlag(4, false);
            task.setFlag(5, false);
            task.setFlag(6, false);
            task.setFlag(7, false);
            task.setFlag(8, false);
            task.setFlag(9, false);
            task.setFlag(10, false);
            if (task.getWBS() != null) {
                this.m_autoWBS = false;
            }
            if (task.getName() == null && task.getStart() == null && task.getFinish() == null) {
                task.setNull(true);
            }
            this.m_eventManager.fireTaskReadEvent(task);
        }
    }

    private void processTaskBaseline(Row row) {
        Integer id = row.getInteger("TASK_UID");
        Task task = this.m_project.getTaskByUniqueID(id);
        if (task != null) {
            int index = row.getInt("TB_BASE_NUM");
            task.setBaselineDuration(index, MPDUtility.getAdjustedDuration(this.m_project, row.getInt("TB_BASE_DUR"), MPDUtility.getDurationTimeUnits(row.getInt("TB_BASE_DUR_FMT"))));
            task.setBaselineStart(index, row.getDate("TB_BASE_START"));
            task.setBaselineFinish(index, row.getDate("TB_BASE_FINISH"));
            task.setBaselineWork(index, row.getDuration("TB_BASE_WORK"));
            task.setBaselineCost(index, row.getCurrency("TB_BASE_COST"));
        }
    }

    private void processLink(Row row) {
        Task predecessorTask = this.m_project.getTaskByUniqueID(row.getInteger("LINK_PRED_UID"));
        Task successorTask = this.m_project.getTaskByUniqueID(row.getInteger("LINK_SUCC_UID"));
        if (predecessorTask != null && successorTask != null) {
            RelationType type = RelationType.getInstance(row.getInt("LINK_TYPE"));
            TimeUnit durationUnits = MPDUtility.getDurationTimeUnits(row.getInt("LINK_LAG_FMT"));
            Duration duration = MPDUtility.getDuration(row.getDouble("LINK_LAG"), durationUnits);
            Relation relation = successorTask.addPredecessor(predecessorTask, type, duration);
            relation.setUniqueID(row.getInteger("LINK_UID"));
            this.m_eventManager.fireRelationReadEvent(relation);
        }
    }

    private void processAssignment(Row row) {
        Resource resource = this.m_project.getResourceByUniqueID(row.getInteger("RES_UID"));
        Task task = this.m_project.getTaskByUniqueID(row.getInteger("TASK_UID"));
        if (task != null) {
            ResourceAssignment assignment = task.addResourceAssignment(resource);
            this.m_assignmentMap.put(row.getInteger("ASSN_UID"), assignment);
            assignment.setActualCost(row.getCurrency("ASSN_ACT_COST"));
            assignment.setActualFinish(row.getDate("ASSN_ACT_FINISH"));
            assignment.setActualOvertimeCost(row.getCurrency("ASSN_ACT_OVT_COST"));
            assignment.setActualOvertimeWork(row.getDuration("ASSN_ACT_OVT_WORK"));
            assignment.setActualStart(row.getDate("ASSN_ACT_START"));
            assignment.setActualWork(row.getDuration("ASSN_ACT_WORK"));
            assignment.setACWP(row.getCurrency("ASSN_ACWP"));
            assignment.setBaselineCost(row.getCurrency("ASSN_BASE_COST"));
            assignment.setBaselineFinish(row.getDate("ASSN_BASE_FINISH"));
            assignment.setBaselineStart(row.getDate("ASSN_BASE_START"));
            assignment.setBaselineWork(row.getDuration("ASSN_BASE_WORK"));
            assignment.setBCWP(row.getCurrency("ASSN_BCWP"));
            assignment.setBCWS(row.getCurrency("ASSN_BCWS"));
            assignment.setCost(row.getCurrency("ASSN_COST"));
            assignment.setCostRateTableIndex(row.getInt("ASSN_COST_RATE_TABLE"));
            assignment.setDelay(row.getDuration("ASSN_DELAY"));
            assignment.setFinish(row.getDate("ASSN_FINISH_DATE"));
            assignment.setFinishVariance(MPDUtility.getAdjustedDuration(this.m_project, row.getInt("ASSN_FINISH_VAR"), TimeUnit.DAYS));
            assignment.setLevelingDelay(MPDUtility.getAdjustedDuration(this.m_project, row.getInt("ASSN_LEVELING_DELAY"), MPDUtility.getDurationTimeUnits(row.getInt("ASSN_DELAY_FMT"))));
            assignment.setLinkedFields(row.getBoolean("ASSN_HAS_LINKED_FIELDS"));
            assignment.setOvertimeWork(row.getDuration("ASSN_OVT_WORK"));
            assignment.setRemainingCost(row.getCurrency("ASSN_REM_COST"));
            assignment.setRemainingOvertimeCost(row.getCurrency("ASSN_REM_OVT_COST"));
            assignment.setRemainingOvertimeWork(row.getDuration("ASSN_REM_OVT_WORK"));
            assignment.setRegularWork(row.getDuration("ASSN_REG_WORK"));
            assignment.setRemainingWork(row.getDuration("ASSN_REM_WORK"));
            assignment.setResponsePending(row.getBoolean("ASSN_RESPONSE_PENDING"));
            assignment.setStart(row.getDate("ASSN_START_DATE"));
            assignment.setStartVariance(MPDUtility.getAdjustedDuration(this.m_project, row.getInt("ASSN_START_VAR"), TimeUnit.DAYS));
            assignment.setTeamStatusPending(row.getBoolean("ASSN_TEAM_STATUS_PENDING"));
            assignment.setUniqueID(row.getInteger("ASSN_UID"));
            assignment.setUnits(row.getDouble("ASSN_UNITS") * 100.0);
            assignment.setUpdateNeeded(row.getBoolean("ASSN_UPDATE_NEEDED"));
            assignment.setWork(row.getDuration("ASSN_WORK"));
            assignment.setWorkContour(WorkContour.getInstance(row.getInt("ASSN_WORK_CONTOUR")));
            String notes = row.getString("ASSN_RTF_NOTES");
            if (notes != null) {
                assignment.setNotesObject(new RtfNotes(notes));
            }
            this.m_eventManager.fireAssignmentReadEvent(assignment);
        }
    }

    private void processAssignmentBaseline(Row row) {
        Integer id = row.getInteger("ASSN_UID");
        ResourceAssignment assignment = this.m_assignmentMap.get(id);
        if (assignment != null) {
            int index = row.getInt("AB_BASE_NUM");
            assignment.setBaselineStart(index, row.getDate("AB_BASE_START"));
            assignment.setBaselineFinish(index, row.getDate("AB_BASE_FINISH"));
            assignment.setBaselineWork(index, row.getDuration("AB_BASE_WORK"));
            assignment.setBaselineCost(index, row.getCurrency("AB_BASE_COST"));
        }
    }

    private void postProcessing() {
        ProjectConfig config = this.m_project.getProjectConfig();
        config.setAutoWBS(this.m_autoWBS);
        config.setAutoOutlineNumber(true);
        this.m_project.updateStructure();
        config.setAutoOutlineNumber(false);
        for (Task task : this.m_project.getTasks()) {
            task.setSummary(task.hasChildTasks());
        }
        config.updateUniqueCounters();
    }

    private Integer getNullOnValue(Integer value, int nullValue) {
        return NumberHelper.getInt(value) == nullValue ? null : value;
    }

    private Double getDefaultOnNull(Double value, Double defaultValue) {
        return value == null ? defaultValue : value;
    }

    public void setProjectID(Integer projectID) {
        this.m_projectID = projectID;
        this.m_projectKey = Collections.singletonMap("PROJ_ID", this.m_projectID);
    }

    protected abstract List<Row> getRows(String var1, Map<String, Integer> var2) throws MpdException;

    protected abstract void releaseResources();
}

