/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.explorer;

import com.jgoodies.binding.beans.PropertyAdapter;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.io.File;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.explorer.FileChooserController;
import net.sf.mpxj.explorer.FileChooserModel;
import net.sf.mpxj.explorer.FileChooserView;
import net.sf.mpxj.explorer.FileCleanerController;
import net.sf.mpxj.explorer.FileCleanerModel;
import net.sf.mpxj.explorer.FileCleanerView;
import net.sf.mpxj.explorer.FileSaverController;
import net.sf.mpxj.explorer.FileSaverModel;
import net.sf.mpxj.explorer.FileSaverView;
import net.sf.mpxj.explorer.ProjectFilePanel;
import net.sf.mpxj.reader.UniversalProjectReader;

public class ProjectExplorer {
    protected JFrame m_frame;
    private static final String[] READ_EXTENSIONS = new String[]{"cdpx", "cdpz", "exe", "fts", "gan", "gnt", "mdb", "mpd", "mpp", "mpx", "pc", "pep", "planner", "pmxml", "pod", "pp", "ppx", "prx", "schedule_grid", "sdef", "sp", "stx", "xer", "xml", "zip"};
    private static final String[] WRITE_EXTENSIONS = new String[]{"sdef", "sdef", "mpx", "mpx", "planner", "xml", "pmxml", "xml", "json", "json", "mspdi", "xml"};

    public static void main(String[] args) {
        EventQueue.invokeLater(() -> {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                ProjectExplorer window = new ProjectExplorer();
                window.m_frame.setVisible(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public ProjectExplorer() {
        this.initialize();
    }

    private void initialize() {
        this.m_frame = new JFrame();
        this.m_frame.setBounds(100, 100, 900, 451);
        this.m_frame.setDefaultCloseOperation(3);
        this.m_frame.getContentPane().setLayout(new GridLayout(1, 0, 0, 0));
        FileChooserModel fileChooserModel = new FileChooserModel();
        FileChooserController fileChooserController = new FileChooserController(fileChooserModel);
        FileChooserView fileChooserView = new FileChooserView(this.m_frame, fileChooserModel);
        fileChooserModel.setExtensions(READ_EXTENSIONS);
        FileChooserModel openAllFileChooserModel = new FileChooserModel();
        FileChooserController openAllFileChooserController = new FileChooserController(openAllFileChooserModel);
        FileChooserView openAllFileChooserView = new FileChooserView(this.m_frame, openAllFileChooserModel);
        openAllFileChooserModel.setExtensions(READ_EXTENSIONS);
        FileSaverModel fileSaverModel = new FileSaverModel();
        FileSaverController fileSaverController = new FileSaverController(fileSaverModel);
        FileSaverView fileSaverView = new FileSaverView(this.m_frame, fileSaverModel);
        fileSaverModel.setExtensions(WRITE_EXTENSIONS);
        FileCleanerModel fileCleanerModel = new FileCleanerModel();
        FileCleanerController fileCleanerController = new FileCleanerController(fileCleanerModel);
        FileCleanerView fileCleanerView = new FileCleanerView(this.m_frame, fileCleanerModel);
        JMenuBar menuBar = new JMenuBar();
        this.m_frame.setJMenuBar(menuBar);
        JMenu mnFile = new JMenu("File");
        menuBar.add(mnFile);
        JMenuItem mntmOpen = new JMenuItem("Open...");
        mnFile.add(mntmOpen);
        JMenuItem mntmOpenAll = new JMenuItem("Open All...");
        mnFile.add(mntmOpenAll);
        JMenuItem mntmSave = new JMenuItem("Save As...");
        mntmSave.setEnabled(false);
        mnFile.add(mntmSave);
        JMenuItem mntmClean = new JMenuItem("Clean...");
        mntmClean.setEnabled(false);
        mnFile.add(mntmClean);
        mntmOpen.addActionListener(e -> fileChooserController.openFileChooser());
        mntmOpenAll.addActionListener(e -> openAllFileChooserController.openFileChooser());
        mntmSave.addActionListener(e -> fileSaverController.openFileSaver());
        mntmClean.addActionListener(e -> fileCleanerController.openFileCleaner());
        JTabbedPane tabbedPane = new JTabbedPane(1);
        this.m_frame.getContentPane().add(tabbedPane);
        PropertyAdapter<FileChooserModel> openAdapter = new PropertyAdapter<FileChooserModel>(fileChooserModel, "file", true);
        openAdapter.addValueChangeListener(evt -> {
            try {
                File file = fileChooserModel.getFile();
                ProjectFile projectFile = new UniversalProjectReader().read(file);
                if (projectFile == null) {
                    throw new IllegalArgumentException("Unsupported file type");
                }
                tabbedPane.add(file.getName(), new ProjectFilePanel(file, projectFile));
                mntmSave.setEnabled(true);
                mntmClean.setEnabled(true);
            }
            catch (MPXJException ex) {
                throw new IllegalArgumentException("Failed to read file", ex);
            }
        });
        PropertyAdapter<FileChooserModel> openAllAdapter = new PropertyAdapter<FileChooserModel>(openAllFileChooserModel, "file", true);
        openAllAdapter.addValueChangeListener(evt -> {
            try {
                File file = openAllFileChooserModel.getFile();
                List<ProjectFile> projectFiles = new UniversalProjectReader().readAll(file);
                if (projectFiles.isEmpty()) {
                    throw new IllegalArgumentException("Unsupported file type");
                }
                int index = 1;
                for (ProjectFile projectFile : projectFiles) {
                    String name = projectFiles.size() == 1 ? file.getName() : file.getName() + " (" + index++ + ")";
                    tabbedPane.add(name, new ProjectFilePanel(file, projectFile));
                }
                mntmSave.setEnabled(true);
                mntmClean.setEnabled(true);
            }
            catch (MPXJException ex) {
                throw new IllegalArgumentException("Failed to read file", ex);
            }
        });
        PropertyAdapter<FileSaverModel> saveAdapter = new PropertyAdapter<FileSaverModel>(fileSaverModel, "file", true);
        saveAdapter.addValueChangeListener(evt -> {
            ProjectFilePanel panel = (ProjectFilePanel)tabbedPane.getSelectedComponent();
            panel.saveFile(fileSaverModel.getFile(), fileSaverModel.getType());
        });
        PropertyAdapter<FileCleanerModel> cleanAdapter = new PropertyAdapter<FileCleanerModel>(fileCleanerModel, "file", true);
        cleanAdapter.addValueChangeListener(evt -> {
            ProjectFilePanel panel = (ProjectFilePanel)tabbedPane.getSelectedComponent();
            panel.cleanFile(fileCleanerModel.getFile());
        });
    }
}

