/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.explorer;

import java.awt.GridLayout;
import java.io.File;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.tree.TreePath;
import net.sf.mpxj.explorer.HexDumpController;
import net.sf.mpxj.explorer.HexDumpModel;
import net.sf.mpxj.explorer.HexDumpView;
import net.sf.mpxj.explorer.PoiTreeController;
import net.sf.mpxj.explorer.PoiTreeModel;
import net.sf.mpxj.explorer.PoiTreeView;
import org.apache.poi.poifs.filesystem.DocumentEntry;

public class MppFilePanel
extends JPanel {
    protected final HexDumpController m_hexDumpController;

    public MppFilePanel(File file) {
        PoiTreeModel treeModel = new PoiTreeModel();
        PoiTreeController treeController = new PoiTreeController(treeModel);
        PoiTreeView treeView = new PoiTreeView(treeModel);
        treeView.setShowsRootHandles(true);
        HexDumpModel hexDumpModel = new HexDumpModel();
        this.m_hexDumpController = new HexDumpController(hexDumpModel);
        this.setLayout(new GridLayout(0, 1, 0, 0));
        HexDumpView hexDumpView = new HexDumpView(hexDumpModel);
        JSplitPane splitPane = new JSplitPane();
        splitPane.setDividerLocation(0.3);
        this.add(splitPane);
        JScrollPane scrollPane = new JScrollPane(treeView);
        splitPane.setLeftComponent(scrollPane);
        JTabbedPane tabbedPane = new JTabbedPane(1);
        splitPane.setRightComponent(tabbedPane);
        tabbedPane.add("Hex Dump", hexDumpView);
        treeView.addTreeSelectionListener(e -> {
            TreePath path = e.getPath();
            Object component = path.getLastPathComponent();
            if (component instanceof DocumentEntry) {
                this.m_hexDumpController.viewDocument((DocumentEntry)component);
            }
        });
        treeController.loadFile(file);
    }
}

