/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.util.Iterator;
import net.sf.mpxj.Day;
import net.sf.mpxj.DayType;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectConfig;
import net.sf.mpxj.ProjectEntityContainer;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.common.NumberHelper;

public class ProjectCalendarContainer
extends ProjectEntityContainer<ProjectCalendar> {
    public ProjectCalendarContainer(ProjectFile projectFile) {
        super(projectFile);
    }

    @Override
    public void removed(ProjectCalendar calendar) {
        calendar.getDerivedCalendars().forEach(c -> c.setParent(null));
        calendar.getResources().forEach(r -> r.setCalendar(null));
        calendar.getTasks().forEach(t -> t.setCalendar(null));
        calendar.setParent(null);
    }

    public ProjectCalendar add() {
        ProjectCalendar calendar = new ProjectCalendar(this.m_projectFile);
        this.add(calendar);
        return calendar;
    }

    public ProjectCalendar addDefaultBaseCalendar() {
        ProjectCalendar calendar = this.add();
        calendar.setName("Standard");
        calendar.addDefaultCalendarDays();
        calendar.addDefaultCalendarHours();
        return calendar;
    }

    public ProjectCalendar addDefaultDerivedCalendar() {
        ProjectCalendar calendar = this.add();
        calendar.setCalendarDayType(Day.SUNDAY, DayType.DEFAULT);
        calendar.setCalendarDayType(Day.MONDAY, DayType.DEFAULT);
        calendar.setCalendarDayType(Day.TUESDAY, DayType.DEFAULT);
        calendar.setCalendarDayType(Day.WEDNESDAY, DayType.DEFAULT);
        calendar.setCalendarDayType(Day.THURSDAY, DayType.DEFAULT);
        calendar.setCalendarDayType(Day.FRIDAY, DayType.DEFAULT);
        calendar.setCalendarDayType(Day.SATURDAY, DayType.DEFAULT);
        return calendar;
    }

    public ProjectCalendar findOrCreateDefaultCalendar() {
        ProjectCalendar result = this.getByName("Standard");
        if (result == null) {
            if (!this.isEmpty()) {
                result = (ProjectCalendar)this.get(0);
            } else {
                result = this.addDefaultBaseCalendar();
                if (NumberHelper.getInt(result.getUniqueID()) == 0) {
                    ProjectConfig config = this.m_projectFile.getProjectConfig();
                    config.updateCalendarUniqueCounter();
                    result.setUniqueID(config.getNextCalendarUniqueID());
                }
            }
        }
        return result;
    }

    public ProjectCalendar getByName(String calendarName) {
        ProjectCalendar calendar = null;
        if (calendarName != null && calendarName.length() != 0) {
            ProjectCalendar projectCalendar;
            String name;
            Iterator iterator = this.iterator();
            while (iterator.hasNext() && ((name = (calendar = (projectCalendar = (ProjectCalendar)iterator.next())).getName()) == null || !name.equalsIgnoreCase(calendarName))) {
                calendar = null;
            }
        }
        return calendar;
    }
}

