/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.util.Arrays;
import java.util.Date;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.sf.mpxj.Rate;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.common.DateHelper;
import net.sf.mpxj.common.NumberHelper;

public final class CostRateTableEntry
implements Comparable<CostRateTableEntry> {
    private final Date m_startDate;
    private final Date m_endDate;
    private final Number m_costPerUse;
    private final Rate[] m_rates = new Rate[5];
    public static final CostRateTableEntry DEFAULT_ENTRY = new CostRateTableEntry();
    public static final int MAX_RATES = 5;

    private CostRateTableEntry() {
        this(DateHelper.START_DATE_NA, DateHelper.END_DATE_NA, NumberHelper.DOUBLE_ZERO, new Rate[0]);
    }

    @Deprecated
    public CostRateTableEntry(Rate standardRate, TimeUnit standardRateFormat, Rate overtimeRate, TimeUnit overtimeRateFormat, Number costPerUse, Date startDate, Date endDate) {
        this(startDate, endDate, costPerUse, standardRate, overtimeRate);
    }

    public CostRateTableEntry(Date startDate, Date endDate, Number costPerUse, Rate ... rates) {
        this.m_startDate = startDate;
        this.m_endDate = endDate;
        this.m_costPerUse = costPerUse;
        Arrays.fill(this.m_rates, Rate.ZERO);
        System.arraycopy(rates, 0, this.m_rates, 0, rates.length);
    }

    public Date getStartDate() {
        return this.m_startDate;
    }

    public Date getEndDate() {
        return this.m_endDate;
    }

    public Rate getRate(int index) {
        return this.m_rates[index];
    }

    public Rate getStandardRate() {
        return this.getRate(0);
    }

    @Deprecated
    public TimeUnit getStandardRateFormat() {
        return this.getStandardRate().getUnits();
    }

    public Rate getOvertimeRate() {
        return this.getRate(1);
    }

    @Deprecated
    public TimeUnit getOvertimeRateFormat() {
        return this.getOvertimeRate().getUnits();
    }

    public Number getCostPerUse() {
        return this.m_costPerUse;
    }

    @Override
    public int compareTo(CostRateTableEntry o) {
        return DateHelper.compare(this.m_endDate, o.m_endDate);
    }

    public String toString() {
        String rates = Stream.of(this.m_rates).map(String::valueOf).collect(Collectors.joining(", "));
        return "[CostRateTableEntry startDate=" + this.m_startDate + " endDate=" + this.m_endDate + " costPerUse=" + this.m_costPerUse + " rates=" + rates + "]";
    }
}

