/*
 * Decompiled with CFR 0.152.
 */
package com.rtfparserkit.parser.standard;

import com.rtfparserkit.parser.IRtfListener;
import com.rtfparserkit.parser.standard.IParserEvent;
import com.rtfparserkit.parser.standard.IParserEventHandler;
import com.rtfparserkit.parser.standard.ParserEventType;
import com.rtfparserkit.parser.standard.StringEvent;
import java.util.ArrayDeque;
import java.util.Deque;

class DefaultEventHandler
implements IParserEventHandler {
    private static final int MAX_EVENTS = 5;
    private final IRtfListener listener;
    private final Deque<IParserEvent> events = new ArrayDeque<IParserEvent>();

    public DefaultEventHandler(IRtfListener listener) {
        this.listener = listener;
    }

    @Override
    public void handleEvent(IParserEvent event) {
        if (event.getType() == ParserEventType.DOCUMENT_END_EVENT) {
            this.flushEvents();
            event.fire(this.listener);
        } else {
            IParserEvent lastEvent = this.events.peekLast();
            if (lastEvent != null && lastEvent.getType() == ParserEventType.STRING_EVENT && event.getType() == ParserEventType.STRING_EVENT) {
                event = this.mergeStringEvents((StringEvent)event);
            }
            this.events.add(event);
            if (this.events.size() > 5) {
                this.events.removeFirst().fire(this.listener);
            }
        }
    }

    @Override
    public boolean isComplete() {
        return false;
    }

    @Override
    public IParserEvent getLastEvent() {
        return this.events.getLast();
    }

    @Override
    public void removeLastEvent() {
        this.events.removeLast();
    }

    private IParserEvent mergeStringEvents(StringEvent event) {
        StringEvent lastEvent = (StringEvent)this.events.removeLast();
        StringEvent newEvent = new StringEvent(lastEvent.getString() + event.getString());
        return newEvent;
    }

    private void flushEvents() {
        for (IParserEvent event : this.events) {
            event.fire(this.listener);
        }
        this.events.clear();
    }
}

