/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.beans;

import com.jgoodies.binding.beans.PropertyAccessor;
import com.jgoodies.binding.beans.PropertyNotFoundException;
import com.jgoodies.common.base.Preconditions;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;

public final class PropertyAccessors {
    private static PropertyAccessorProvider instance = new IntrospectionPropertyAccessorProvider();

    private PropertyAccessors() {
    }

    public static PropertyAccessorProvider getProvider() {
        return instance;
    }

    public static void setProvider(PropertyAccessorProvider provider) {
        Preconditions.checkNotNull(provider, "The provider must not be null.");
        instance = provider;
    }

    public static class IntrospectionPropertyAccessorProvider
    implements PropertyAccessorProvider {
        @Override
        public PropertyAccessor getAccessor(Class<?> beanClass, String propertyName, String getterName, String setterName) {
            PropertyDescriptor pd = IntrospectionPropertyAccessorProvider.getPropertyDescriptor(beanClass, propertyName, getterName, setterName);
            return new PropertyAccessor(propertyName, pd.getReadMethod(), pd.getWriteMethod());
        }

        private static PropertyDescriptor getPropertyDescriptor(Class<?> beanClass, String propertyName) throws IntrospectionException {
            BeanInfo info = Introspector.getBeanInfo(beanClass);
            for (PropertyDescriptor element : info.getPropertyDescriptors()) {
                if (!propertyName.equals(element.getName())) continue;
                return element;
            }
            throw new IntrospectionException("Property '" + propertyName + "' not found in bean " + beanClass);
        }

        private static PropertyDescriptor getPropertyDescriptor(Class<?> beanClass, String propertyName, String getterName, String setterName) {
            try {
                return getterName != null || setterName != null ? new PropertyDescriptor(propertyName, beanClass, getterName, setterName) : IntrospectionPropertyAccessorProvider.getPropertyDescriptor(beanClass, propertyName);
            }
            catch (IntrospectionException e) {
                throw new PropertyNotFoundException(propertyName, beanClass, (Throwable)e);
            }
        }
    }

    public static interface PropertyAccessorProvider {
        public PropertyAccessor getAccessor(Class<?> var1, String var2, String var3, String var4);
    }
}

